/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseArriSigSeqIter;
import edu.jas.gb.GroebnerBaseF5zSigSeqIter;
import edu.jas.gb.GroebnerBaseGGVSigSeqIter;
import edu.jas.gb.GroebnerBaseSeqIter;
import edu.jas.gb.GroebnerBaseSigSeqIter;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrderByName;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBaseSigSeqIterTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    List<GenPolynomial<BigRational>> L;
    List<GenPolynomial<BigRational>> G;
    List<GenPolynomial<BigRational>> Gp;
    PolynomialList<BigRational> F;
    GroebnerBaseAbstract<BigRational> bb;
    GroebnerBaseAbstract<BigRational> bbsig;
    GroebnerBaseAbstract<BigRational> bbggv;
    GroebnerBaseAbstract<BigRational> bbarri;
    GroebnerBaseAbstract<BigRational> bbf5z;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    int rl = 4;
    int kl = 3;
    int ll = 5;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBaseSigSeqIterTest.suite());
    }

    public GroebnerBaseSigSeqIterTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBaseSigSeqIterTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(9L);
        String[] stringArray = new String[]{"u", "x", "y", "z"};
        this.fac = new GenPolynomialRing<BigRational>(bigRational, stringArray, TermOrderByName.IGRLEX);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBaseSeqIter<BigRational>();
        this.bbsig = new GroebnerBaseSigSeqIter<BigRational>();
        this.bbggv = new GroebnerBaseGGVSigSeqIter<BigRational>();
        this.bbarri = new GroebnerBaseArriSigSeqIter<BigRational>();
        this.bbf5z = new GroebnerBaseF5zSigSeqIter<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.parse("x^4 + 4/5 x^2 - 12/25 u * x - 183/175");
        this.b = this.fac.parse("x^3 * y + 40/7 x^3 + 4/5 x * y - 12/25 u * y + 183/2450 u^2 + 32/7 x - 96/35 u");
        this.c = this.fac.parse("u^2 * x + 14 y + 80");
        this.d = this.fac.parse("y^2 - 5/4 x^2 - 1");
        this.e = this.fac.parse("z");
        int n = new Random().nextInt(4);
        switch (n) {
            case 0: {
                this.bb = this.bbf5z;
                break;
            }
            case 1: {
                this.bb = this.bbggv;
                break;
            }
            case 2: {
                this.bb = this.bbarri;
                break;
            }
        }
        this.L.add(this.a);
        this.L.add(this.b);
        this.L.add(this.c);
        this.L.add(this.d);
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSigSeqIterTest.assertTrue((String)("isGB( { a, b, c, d, e } ): " + this.L), (boolean)this.bb.isGB(this.L));
    }

    public void testRandomSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.univariate(0);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        int n = new Random().nextInt(4);
        switch (n) {
            case 0: {
                this.bb = this.bbf5z;
                break;
            }
            case 1: {
                this.bb = this.bbggv;
                break;
            }
            case 2: {
                this.bb = this.bbarri;
                break;
            }
        }
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSigSeqIterTest.assertTrue((String)("isGB( { a } ): " + this.L), (boolean)this.bb.isGB(this.L));
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSigSeqIterTest.assertTrue((String)("isGB( { a, b } ): " + this.L), (boolean)this.bb.isGB(this.L));
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSigSeqIterTest.assertTrue((String)("isGB( { a, b, c } ): " + this.L), (boolean)this.bb.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSigSeqIterTest.assertTrue((String)("isGB( { a, b, c, d } ): " + this.L), (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBaseSigSeqIterTest.assertTrue((String)("isGB( { a, b, c, d, e } ): " + this.L), (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7GBase() {
        String string = "(B,S,T,Z,P,W) L ( ( P W + 2 T Z - 11 B**3 ), ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( 99 W - 11 B S + 3 B**2 ), ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBaseSigSeqIterTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBaseSigSeqIterTest.fail((String)("" + iOException));
        }
        this.G = this.bb.GB(this.F.list);
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.F.list);
        l = System.currentTimeMillis() - l;
        GroebnerBaseSigSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseSigSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
        this.G = OrderedPolynomialList.sort(this.G);
        long l2 = System.currentTimeMillis();
        this.Gp = this.G;
        l2 = System.currentTimeMillis() - l2;
        GroebnerBaseSigSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseSigSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.Gp.size());
        this.Gp = OrderedPolynomialList.sort(this.Gp);
        GroebnerBaseSigSeqIterTest.assertEquals((String)"GB == GBp", this.G, this.Gp);
        this.Gp = this.bbf5z.GB(this.F.list);
        long l3 = System.currentTimeMillis();
        this.Gp = this.bbf5z.GB(this.F.list);
        l3 = System.currentTimeMillis() - l3;
        GroebnerBaseSigSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseSigSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.Gp.size());
        this.Gp = OrderedPolynomialList.sort(this.Gp);
        GroebnerBaseSigSeqIterTest.assertEquals((String)"GB == GBp", this.G, this.Gp);
        this.Gp = this.bbarri.GB(this.F.list);
        long l4 = System.currentTimeMillis();
        this.Gp = this.bbarri.GB(this.F.list);
        l4 = System.currentTimeMillis() - l4;
        GroebnerBaseSigSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseSigSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.Gp.size());
        this.Gp = OrderedPolynomialList.sort(this.Gp);
        GroebnerBaseSigSeqIterTest.assertEquals((String)"GB == GBp", this.G, this.Gp);
        this.Gp = this.bbggv.GB(this.F.list);
        long l5 = System.currentTimeMillis();
        this.Gp = this.bbggv.GB(this.F.list);
        l5 = System.currentTimeMillis() - l5;
        GroebnerBaseSigSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.Gp));
        GroebnerBaseSigSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.Gp.size());
        this.Gp = OrderedPolynomialList.sort(this.Gp);
        GroebnerBaseSigSeqIterTest.assertEquals((String)"GB == GBp", this.G, this.Gp);
        long l6 = l + l2 + l5 + l4 + l3;
        GroebnerBaseSigSeqIterTest.assertTrue((String)("times >= 0: " + l6), (l6 >= 0L ? 1 : 0) != 0);
        GroebnerBaseSigSeqIterTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(this.G));
        GroebnerBaseSigSeqIterTest.assertEquals((String)"#GB(Trinks7) == 6", (int)6, (int)this.G.size());
    }
}

