/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairList;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class LeftSolvableReducerSeqPair<C extends RingElem<C>>
implements Runnable {
    private final List<GenSolvablePolynomial<C>> G;
    private final CriticalPairList<C> pairlist;
    private final Terminator pool;
    private final SolvableReductionPar<C> sred;
    private static final Logger logger = LogManager.getLogger(LeftSolvableReducerSeqPair.class);
    private static final boolean debug = logger.isDebugEnabled();

    LeftSolvableReducerSeqPair(Terminator terminator, List<GenSolvablePolynomial<C>> list, CriticalPairList<C> criticalPairList) {
        this.pool = terminator;
        this.G = list;
        this.pairlist = criticalPairList;
        this.sred = new SolvableReductionPar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (this.pairlist.hasNext() || this.pool.hasJobs()) {
            List<GenSolvablePolynomial<C>> list;
            GenSolvablePolynomial genSolvablePolynomial;
            CriticalPair<C> criticalPair;
            while (!this.pairlist.hasNext()) {
                this.pairlist.update();
                this.pool.beIdle();
                bl = true;
                try {
                    if (++n2 % 10 == 0) {
                        logger.info(" reducer is sleeping");
                    } else {
                        logger.debug("r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (this.pool.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.pool.hasJobs()) break;
            if (bl) {
                this.pool.notIdle();
                bl = false;
            }
            if ((criticalPair = this.pairlist.getNext()) == null) {
                this.pairlist.update();
                continue;
            }
            if (debug) {
                logger.debug("pi = " + criticalPair.pi);
                logger.debug("pj = " + criticalPair.pj);
            }
            if ((genSolvablePolynomial = this.sred.leftSPolynomial((GenSolvablePolynomial)criticalPair.pi, (GenSolvablePolynomial)criticalPair.pj)).isZERO()) {
                this.pairlist.record(criticalPair, genSolvablePolynomial);
                continue;
            }
            if (debug) {
                logger.debug("ht(S) = " + genSolvablePolynomial.leadingExpVector());
            }
            GenPolynomial genPolynomial = this.sred.leftNormalform(this.G, genSolvablePolynomial);
            ++n;
            if (genPolynomial.isZERO()) {
                this.pairlist.record(criticalPair, genPolynomial);
                continue;
            }
            if (debug) {
                logger.debug("ht(H) = " + genPolynomial.leadingExpVector());
            }
            if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                this.pairlist.putOne();
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add((GenSolvablePolynomial<C>)genPolynomial);
                }
                this.pool.allIdle();
                return;
            }
            if (debug) {
                logger.debug("H = " + genPolynomial);
            }
            list = this.G;
            synchronized (list) {
                this.G.add((GenSolvablePolynomial<C>)genPolynomial);
            }
            this.pairlist.update(criticalPair, genPolynomial);
        }
        logger.info("terminated, done " + n + " reductions");
    }
}

