/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseParallel;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableReductionAbstract;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModSolvableGroebnerBaseTest
extends TestCase {
    private static final Logger logger = LogManager.getLogger(ModSolvableGroebnerBaseTest.class);
    int port = 4711;
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> pfac;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    TermOrder tord;
    GenSolvablePolynomial<BigRational> one;
    GenSolvablePolynomial<BigRational> zero;
    RelationTable<BigRational> table;
    List<List<GenSolvablePolynomial<BigRational>>> L;
    List<GenSolvablePolynomial<BigRational>> V;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    ModuleList<BigRational> M;
    ModuleList<BigRational> N;
    ModuleList<BigRational> K;
    ModuleList<BigRational> I;
    SolvableGroebnerBaseAbstract<BigRational> sbb;
    SolvableReductionAbstract<BigRational> sred;
    int rl = 3;
    int kl = 4;
    int ll = 3;
    int el = 2;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ModSolvableGroebnerBaseTest.suite());
        ComputerThreads.terminate();
    }

    public ModSolvableGroebnerBaseTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ModSolvableGroebnerBaseTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.tord = new TermOrder();
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, this.tord);
        this.sbb = Math.random() > 0.5 ? new SolvableGroebnerBaseSeq<BigRational>() : new SolvableGroebnerBaseParallel<BigRational>();
        this.sred = new SolvableReductionSeq<BigRational>();
        logger.info("test with " + this.sbb.getClass().getSimpleName());
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        do {
            this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.pfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.pfac.getONE();
        this.zero = this.pfac.getZERO();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.one = null;
        this.zero = null;
        this.sbb.terminate();
        this.sbb = null;
        this.sred = null;
    }

    public void testSequentialLeftModSolvableGB() {
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1) } )", (boolean)this.sbb.isLeftGB(this.M));
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1) } )", (boolean)this.sbb.isLeftGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1),(b,1,0) } )", (boolean)this.sbb.isLeftGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,),(b,),(c,) } )", (boolean)this.sbb.isLeftGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,b,c,d) } )", (boolean)this.sbb.isLeftGB(this.N));
    }

    public void testSequentialLeftModSolvableWeylGB() {
        int n = 4;
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, n, this.tord);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.pfac);
        this.table = this.pfac.table;
        do {
            this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.pfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.pfac.getONE();
        this.zero = this.pfac.getZERO();
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1) } )", (boolean)this.sbb.isLeftGB(this.M));
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1) } )", (boolean)this.sbb.isLeftGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,0,1),(b,1,0) } )", (boolean)this.sbb.isLeftGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,),(b,),(c,) } )", (boolean)this.sbb.isLeftGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isLeftGB( { (a,b,c,d) } )", (boolean)this.sbb.isLeftGB(this.N));
    }

    public void testSequentialTSModSolvableGB() {
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1) } )", (boolean)this.sbb.isTwosidedGB(this.M));
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1) } )", (boolean)this.sbb.isTwosidedGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1),(b,1,0) } )", (boolean)this.sbb.isTwosidedGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,),(b,),(c,) } )", (boolean)this.sbb.isTwosidedGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,b,c,d) } )", (boolean)this.sbb.isTwosidedGB(this.N));
    }

    public void testSequentialTSModSolvableWeylGB() {
        int n = 4;
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, n, this.tord);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.pfac);
        this.table = this.pfac.table;
        do {
            this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.pfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.pfac.getONE();
        this.zero = this.pfac.getZERO();
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1) } )", (this.sbb.isTwosidedGB(this.M) || !this.pfac.isCommutative() ? 1 : 0) != 0);
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1) } )", (boolean)this.sbb.isTwosidedGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,0,1),(b,1,0) } )", (boolean)this.sbb.isTwosidedGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,),(b,),(c,) } )", (boolean)this.sbb.isTwosidedGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isTwosidedGB( { (a,b,c,d) } )", (boolean)this.sbb.isTwosidedGB(this.N));
    }

    public void testSequentialRightModSolvableGB() {
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1) } )", (boolean)this.sbb.isRightGB(this.M));
        this.N = this.sbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1) } )", (boolean)this.sbb.isRightGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1),(b,1,0) } )", (boolean)this.sbb.isRightGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,),(b,),(c,) } )", (boolean)this.sbb.isRightGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,b,c,d) } )", (boolean)this.sbb.isRightGB(this.N));
    }

    public void testSequentialRightModSolvableWeylGB() {
        int n = 4;
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, n, this.tord);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.pfac);
        this.table = this.pfac.table;
        do {
            this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.pfac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.pfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
        this.one = this.pfac.getONE();
        this.zero = this.pfac.getZERO();
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add(this.zero);
        this.V.add(this.one);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1) } )", (boolean)this.sbb.isRightGB(this.M));
        this.N = this.sbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1) } )", (boolean)this.sbb.isRightGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add(this.one);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,0,1),(b,1,0) } )", (boolean)this.sbb.isRightGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,),(b,),(c,) } )", (boolean)this.sbb.isRightGB(this.N));
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add(this.zero);
        this.V.add(this.zero);
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.rightGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isRightGB( { (a,b,c,d) } )", (boolean)this.sbb.isRightGB(this.N));
    }

    public void testSequentialModTOPleftGB() {
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add((GenSolvablePolynomial<BigRational>)this.pfac.getZERO());
        this.V.add((GenSolvablePolynomial<BigRational>)this.pfac.getONE());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.sbb.isLeftGB(this.M));
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.sbb.isLeftGB(this.N));
        this.K = this.sbb.leftGB(this.M, true);
        ModSolvableGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.sbb.isLeftGB(this.K, true));
        ModSolvableGroebnerBaseTest.assertEquals((String)"N == K", this.N, this.K);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add((GenSolvablePolynomial<BigRational>)this.pfac.getONE());
        this.V.add((GenSolvablePolynomial<BigRational>)this.pfac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.leftGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1),(b,1,0) } )", (boolean)this.sbb.isLeftGB(this.N));
        this.K = this.sbb.leftGB(this.M, true);
        ModSolvableGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.sbb.isLeftGB(this.K, true));
        this.I = this.sred.leftNormalform(this.N, this.K);
        ModSolvableGroebnerBaseTest.assertTrue((String)"N.lnf(K) == (0)", (boolean)this.I.isZERO());
        this.I = this.sred.leftNormalform(this.K, this.N, true);
        ModSolvableGroebnerBaseTest.assertTrue((String)"K.lnf(N) == (0)", (boolean)this.I.isZERO());
    }

    public void testSequentialModTOPtwosidedGB() {
        this.L = new ArrayList<List<GenSolvablePolynomial<BigRational>>>();
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add((GenSolvablePolynomial<BigRational>)this.pfac.getZERO());
        this.V.add((GenSolvablePolynomial<BigRational>)this.pfac.getONE());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.sbb.isTwosidedGB(this.M));
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.sbb.isTwosidedGB(this.N));
        this.K = this.sbb.twosidedGB(this.M, true);
        ModSolvableGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.sbb.isTwosidedGB(this.K, true));
        ModSolvableGroebnerBaseTest.assertEquals((String)"N == K", this.N, this.K);
        this.V = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add((GenSolvablePolynomial<BigRational>)this.pfac.getONE());
        this.V.add((GenSolvablePolynomial<BigRational>)this.pfac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.pfac, this.L);
        this.N = this.sbb.twosidedGB(this.M);
        ModSolvableGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1),(b,1,0) } )", (boolean)this.sbb.isTwosidedGB(this.N));
        this.K = this.sbb.twosidedGB(this.M, true);
        ModSolvableGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.sbb.isTwosidedGB(this.K, true));
        this.I = this.sred.leftNormalform(this.N, this.K);
        ModSolvableGroebnerBaseTest.assertTrue((String)"N.lnf(K) == (0)", (boolean)this.I.isZERO());
        this.I = this.sred.leftNormalform(this.K, this.N, true);
        ModSolvableGroebnerBaseTest.assertTrue((String)"K.lnf(N) == (0)", (boolean)this.I.isZERO());
    }
}

