/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.ResPart;
import edu.jas.gbufd.ResPolPart;
import edu.jas.gbufd.SyzygyAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyzygySeq<C extends GcdRingElem<C>>
extends SyzygyAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SyzygySeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected GroebnerBaseAbstract<C> bb;

    public SyzygySeq(RingFactory<C> ringFactory) {
        this.bb = GBFactory.getImplementation(ringFactory);
    }

    @Override
    public List<ResPart<C>> resolution(ModuleList<C> moduleList) {
        ArrayList<ResPart<C>> arrayList = new ArrayList<ResPart<C>>();
        ModuleList<C> moduleList2 = moduleList;
        while (true) {
            ModuleList<C> moduleList3 = this.bb.GB(moduleList2);
            ModuleList<C> moduleList4 = this.zeroRelations(moduleList3);
            arrayList.add(new ResPart<C>(moduleList2, moduleList3, moduleList4));
            if (moduleList4 == null || moduleList4.list == null || moduleList4.list.size() == 0) break;
            moduleList2 = moduleList4;
        }
        return arrayList;
    }

    @Override
    public List resolution(PolynomialList<C> polynomialList) {
        List<GenPolynomial<C>> list = this.bb.GB(polynomialList.list);
        List<List<GenPolynomial<C>>> list2 = this.zeroRelations(list);
        PolynomialList polynomialList2 = new PolynomialList(polynomialList.ring, list);
        ModuleList moduleList = new ModuleList(polynomialList.ring, list2);
        List list3 = this.resolution(moduleList);
        list3.add(0, new ResPolPart<C>(polynomialList, polynomialList2, moduleList));
        return list3;
    }

    @Override
    public List resolutionArbitrary(PolynomialList<C> polynomialList) {
        PolynomialList polynomialList2 = null;
        List list = this.zeroRelationsArbitrary(polynomialList.list);
        ModuleList moduleList = new ModuleList(polynomialList.ring, list);
        List list2 = this.resolutionArbitrary(moduleList);
        list2.add(0, new ResPolPart<C>(polynomialList, polynomialList2, moduleList));
        return list2;
    }

    @Override
    public List<ResPart<C>> resolutionArbitrary(ModuleList<C> moduleList) {
        ArrayList<ResPart<C>> arrayList = new ArrayList<ResPart<C>>();
        ModuleList<C> moduleList2 = moduleList;
        ModuleList moduleList3 = null;
        while (true) {
            ModuleList<C> moduleList4 = this.zeroRelationsArbitrary(moduleList2);
            arrayList.add(new ResPart<C>(moduleList2, moduleList3, moduleList4));
            if (moduleList4 == null || moduleList4.list == null || moduleList4.list.size() == 0) break;
            moduleList2 = moduleList4;
        }
        return arrayList;
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelationsArbitrary(int n, List<GenPolynomial<C>> list) {
        List list2;
        List list3;
        Iterator iterator;
        if (list == null) {
            return new ArrayList<List<GenPolynomial<C>>>();
        }
        if (list.size() <= 1) {
            return this.zeroRelations(n, list);
        }
        int n2 = list.size();
        ExtendedGB<C> extendedGB = this.bb.extGB(list);
        if (debug) {
            logger.debug("exgb = " + extendedGB);
            if (!this.bb.isReductionMatrix(extendedGB)) {
                logger.error("is reduction matrix ? false");
            }
        }
        List list4 = extendedGB.G;
        List list5 = extendedGB.G2F;
        List list6 = extendedGB.F2G;
        List list7 = this.zeroRelations(n, list4);
        GenPolynomialRing genPolynomialRing = list4.get((int)0).ring;
        ModuleList moduleList = new ModuleList(genPolynomialRing, list7);
        if (debug) {
            logger.debug("syz = " + moduleList);
            if (!this.isZeroRelation(list7, list4)) {
                logger.error("is syzygy ? false");
            }
        }
        ArrayList<List<GenPolynomial<C>>> arrayList2 = new ArrayList<List<GenPolynomial<C>>>(list7.size());
        for (List object : list7) {
            Iterator iterator2 = object.iterator();
            iterator = list5.iterator();
            list3 = new ArrayList<AbelianGroupElem>(n2);
            for (int moduleList2 = 0; moduleList2 < n2; ++moduleList2) {
                list3.add(genPolynomialRing.getZERO());
            }
            while (iterator2.hasNext() && iterator.hasNext()) {
                GenPolynomial genPolynomial = iterator2.next();
                List list8 = (List)iterator.next();
                if (genPolynomial == null || list8 == null) continue;
                list2 = this.blas.scalarProduct(genPolynomial, list8);
                list3 = this.blas.vectorAdd(list3, list2);
            }
            if (iterator2.hasNext() || iterator.hasNext()) {
                logger.error("zeroRelationsArbitrary wrong sizes");
            }
            arrayList2.add(list3);
        }
        ArrayList arrayList3 = new ArrayList(n2);
        for (List list9 : list6) {
            iterator = list9.iterator();
            list3 = list5.iterator();
            List<AbelianGroupElem<Object>> list10 = new ArrayList<AbelianGroupElem>(n2);
            for (int i = 0; i < n2; ++i) {
                list10.add(genPolynomialRing.getZERO());
            }
            while (iterator.hasNext() && list3.hasNext()) {
                GenPolynomial genPolynomial = (GenPolynomial)iterator.next();
                list2 = (List)list3.next();
                if (genPolynomial == null || list2 == null) continue;
                List<GenPolynomial> list11 = this.blas.scalarProduct(list2, genPolynomial);
                list10 = this.blas.vectorAdd(list10, list11);
            }
            if (iterator.hasNext() || list3.hasNext()) {
                logger.error("zeroRelationsArbitrary wrong sizes");
            }
            arrayList3.add(list10);
        }
        int n3 = arrayList2.size();
        ArrayList arrayList = new ArrayList(n2);
        int n4 = 0;
        list3 = arrayList3.iterator();
        while (list3.hasNext()) {
            List list12 = (List)list3.next();
            ArrayList<GenPolynomial<GenPolynomial>> arrayList4 = new ArrayList<GenPolynomial<GenPolynomial>>(list12.size());
            int n5 = 0;
            for (GenPolynomial genPolynomial : list12) {
                AbelianGroupElem abelianGroupElem = null;
                if (n4 == n5) {
                    abelianGroupElem = ((GenPolynomial)genPolynomialRing.getONE()).subtract(genPolynomial);
                } else if (genPolynomial != null) {
                    abelianGroupElem = genPolynomial.negate();
                }
                arrayList4.add((GenPolynomial<GenPolynomial>)abelianGroupElem);
                ++n5;
            }
            arrayList.add(arrayList4);
            if (!this.blas.isZero(arrayList4)) {
                arrayList2.add(arrayList4);
            }
            ++n4;
        }
        if (debug) {
            list3 = new ModuleList(genPolynomialRing, arrayList);
            logger.debug("syz M2L = " + list3);
            ModuleList moduleList2 = new ModuleList(genPolynomialRing, arrayList2);
            logger.debug("syz sf = " + moduleList2);
            logger.debug("#syz " + n3 + ", " + arrayList2.size());
            if (!this.isZeroRelation(arrayList2, list)) {
                logger.error("is syz sf ? false");
            }
        }
        return arrayList2;
    }
}

