/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gbufd.GBFactory;
import edu.jas.integrate.ElementaryIntegration;
import edu.jas.integrate.LogIntegral;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.PolyUfdUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElementaryIntegrationCzichowski<C extends GcdRingElem<C>>
extends ElementaryIntegration<C> {
    private static final Logger logger = LogManager.getLogger(ElementaryIntegrationCzichowski.class);
    public final GroebnerBaseAbstract<C> red;

    public ElementaryIntegrationCzichowski(RingFactory<C> ringFactory) {
        super(ringFactory);
        this.red = GBFactory.getImplementation(ringFactory);
    }

    @Override
    public LogIntegral<C> integrateLogPart(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("P == null or P == 0");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials " + genPolynomialRing);
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients " + genPolynomialRing);
        }
        ArrayList<C> arrayList = new ArrayList<C>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (genPolynomial2.degree(0) <= 1L) {
            arrayList.add(genPolynomial.leadingBaseCoefficient());
            arrayList2.add(genPolynomial2);
            return new LogIntegral<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        String[] stringArray = new String[]{"t"};
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing.coFac, 1, genPolynomialRing.tord, stringArray);
        GenPolynomial genPolynomial4 = genPolynomialRing2.univariate(0);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing, genPolynomialRing2);
        GenPolynomial genPolynomial5 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial);
        GenPolynomial genPolynomial6 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial2);
        GenPolynomial genPolynomial7 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial3);
        GenPolynomialRing genPolynomialRing4 = genPolynomial6.ring;
        GenPolynomial genPolynomial8 = ((GenPolynomial)genPolynomialRing4.getONE()).multiply(genPolynomial4);
        GenPolynomial genPolynomial9 = genPolynomial5.subtract(genPolynomial8.multiply(genPolynomial7));
        GenPolynomialRing genPolynomialRing5 = genPolynomialRing.distribute();
        GenPolynomial genPolynomial10 = PolyUtil.distribute(genPolynomialRing5, genPolynomial9);
        GenPolynomial genPolynomial11 = PolyUtil.distribute(genPolynomialRing5, genPolynomial6);
        ArrayList arrayList5 = new ArrayList();
        arrayList5.add(genPolynomial10);
        arrayList5.add(genPolynomial11);
        List<GenPolynomial<C>> list = this.red.GB(arrayList5);
        Collections.sort(list);
        List list2 = PolyUtil.recursive(genPolynomialRing4, list);
        int n = 1;
        for (GenPolynomial genPolynomial12 : list2) {
            if (n == list2.size()) continue;
            GenPolynomial genPolynomial13 = this.ufd.recursiveContent(genPolynomial12);
            GenPolynomial genPolynomial14 = this.ufd.recursiveContent(list2.get(n));
            GenPolynomial genPolynomial15 = genPolynomial13.divide(genPolynomial14);
            GenPolynomial genPolynomial16 = this.ufd.baseRecursivePrimitivePart(list2.get(n));
            ++n;
            stringArray = genPolynomialRing.newVars("z_");
            genPolynomialRing = genPolynomialRing.copy();
            String[] stringArray2 = genPolynomialRing.setVars(stringArray);
            if (genPolynomial15.degreeMin() == 1L) {
                genPolynomial15 = genPolynomial15.divide(genPolynomial4);
            }
            genPolynomial15 = genPolynomialRing.copy(genPolynomial15);
            AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(genPolynomial15);
            logger.debug("afac = " + algebraicNumberRing.toScript());
            AlgebraicNumber algebraicNumber = algebraicNumberRing.getGenerator();
            GenPolynomialRing genPolynomialRing6 = new GenPolynomialRing(algebraicNumberRing, genPolynomial16.ring);
            GenPolynomial genPolynomial17 = PolyUtil.convertRecursiveToAlgebraicCoefficients(genPolynomialRing6, genPolynomial16);
            arrayList3.add(algebraicNumber);
            arrayList4.add(genPolynomial17);
        }
        return new LogIntegral<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
    }
}

