/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.Power;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AlgebraicNumberModTest
extends TestCase {
    long p;
    long qp;
    ModIntegerRing mpfac;
    AlgebraicNumberRing<ModInteger> fac;
    GenPolynomialRing<ModInteger> mfac;
    AlgebraicNumber<ModInteger> a;
    AlgebraicNumber<ModInteger> b;
    AlgebraicNumber<ModInteger> c;
    AlgebraicNumber<ModInteger> d;
    AlgebraicNumber<ModInteger> e;
    int rl;
    int kl;
    int ll;
    int el;
    float q;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AlgebraicNumberModTest.suite());
    }

    public AlgebraicNumberModTest(String string) {
        super(string);
        this.qp = this.p = 19L;
        this.rl = 1;
        this.kl = 10;
        this.el = this.ll = 10;
        this.q = 0.5f;
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(AlgebraicNumberModTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.mpfac = new ModIntegerRing(this.p, true);
        String[] stringArray = new String[]{"i"};
        this.mfac = new GenPolynomialRing<ModInteger>(this.mpfac, this.rl, stringArray);
        GenPolynomial<ModInteger> genPolynomial = this.mfac.univariate(0, 2L);
        genPolynomial = genPolynomial.sum((ModInteger)this.mfac.getONE());
        this.fac = new AlgebraicNumberRing<ModInteger>(genPolynomial, true);
        this.qp = 1L;
        int n = 0;
        while ((long)n < genPolynomial.degree(0)) {
            this.qp *= this.p;
            ++n;
        }
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        AlgebraicNumberModTest.assertTrue((String)"length( c ) = 1", (this.c.getVal().length() == 1 ? 1 : 0) != 0);
        AlgebraicNumberModTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        AlgebraicNumberModTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        AlgebraicNumberModTest.assertTrue((String)"length( d ) = 0", (this.d.getVal().length() == 0 ? 1 : 0) != 0);
        AlgebraicNumberModTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        AlgebraicNumberModTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.el);
            if (this.a.isZERO() || this.a.isONE()) continue;
            AlgebraicNumberModTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.getVal().length() >= 0 ? 1 : 0) != 0);
            AlgebraicNumberModTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            AlgebraicNumberModTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((ModInteger)((Object)this.b));
        this.d = this.c.subtract(this.b);
        AlgebraicNumberModTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum((ModInteger)((Object)this.b));
        this.d = this.b.sum((ModInteger)((Object)this.a));
        AlgebraicNumberModTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.c.sum((ModInteger)((Object)this.a.sum((ModInteger)((Object)this.b))));
        this.e = this.c.sum((ModInteger)((Object)this.a)).sum(this.b);
        AlgebraicNumberModTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((ModInteger)this.fac.getZERO());
        this.d = this.a.subtract((AlgebraicNumber<ModInteger>)this.fac.getZERO());
        AlgebraicNumberModTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((AlgebraicNumber)this.fac.getZERO()).sum(this.a);
        this.d = ((AlgebraicNumber)this.fac.getZERO()).subtract(this.a.negate());
        AlgebraicNumberModTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        AlgebraicNumberModTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        AlgebraicNumberModTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((ModInteger)((Object)this.a));
        this.d = this.a.multiply((ModInteger)((Object)this.b));
        AlgebraicNumberModTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        AlgebraicNumberModTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        AlgebraicNumberModTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        AlgebraicNumberModTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        AlgebraicNumberModTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((ModInteger)((Object)this.b.multiply((ModInteger)((Object)this.c))));
        this.e = this.a.multiply((ModInteger)((Object)this.b)).multiply(this.c);
        AlgebraicNumberModTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        AlgebraicNumberModTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((ModInteger)this.fac.getONE());
        this.d = ((AlgebraicNumber)this.fac.getONE()).multiply(this.a);
        AlgebraicNumberModTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.a.inverse();
        this.d = this.c.multiply((ModInteger)((Object)this.a));
        AlgebraicNumberModTest.assertEquals((String)"a*1/a = 1", (Object)this.fac.getONE(), this.d);
        try {
            this.a = ((AlgebraicNumber)this.fac.getZERO()).inverse();
        }
        catch (NotInvertibleException notInvertibleException) {
            return;
        }
        AlgebraicNumberModTest.fail((String)"0 invertible");
    }

    public void testDistributive() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((ModInteger)((Object)this.b.sum((ModInteger)((Object)this.c))));
        this.e = this.a.multiply((ModInteger)((Object)this.b)).sum((AlgebraicNumber<ModInteger>)this.a.multiply((ModInteger)((Object)this.c)));
        AlgebraicNumberModTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testCharPower() {
        this.a = this.fac.random(6);
        if (this.a.isZERO()) {
            return;
        }
        AlgebraicNumberModTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = Power.positivePower(this.a, this.qp);
        AlgebraicNumberModTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.a.subtract(this.b);
        AlgebraicNumberModTest.assertTrue((String)("isZERO( a^(p^n) - a ) " + this.c), (boolean)this.c.isZERO());
    }

    public void testEnumerator() {
        long l = 1L;
        for (int i = 0; i < (int)this.fac.modul.degree(0); ++i) {
            l *= this.p;
        }
        long l2 = 0L;
        HashSet<AlgebraicNumber<ModInteger>> hashSet = new HashSet<AlgebraicNumber<ModInteger>>(49);
        for (AlgebraicNumber<ModInteger> algebraicNumber : this.fac) {
            ++l2;
            hashSet.add(algebraicNumber);
        }
        AlgebraicNumberModTest.assertTrue((String)("#elems " + l + ", t = " + l2), (l == l2 ? 1 : 0) != 0);
        AlgebraicNumberModTest.assertTrue((String)("#elems " + l + ", t = " + hashSet.size()), (l == (long)hashSet.size() ? 1 : 0) != 0);
    }
}

