/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.QLRSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TableRelation;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenSolvablePolynomial<C extends RingElem<C>>
extends GenPolynomial<C> {
    private static final Logger logger = LogManager.getLogger(GenSolvablePolynomial.class);
    private static final boolean debug = false;
    public final GenSolvablePolynomialRing<C> ring;

    public GenSolvablePolynomial(GenSolvablePolynomialRing<C> genSolvablePolynomialRing) {
        super(genSolvablePolynomialRing);
        this.ring = genSolvablePolynomialRing;
    }

    public GenSolvablePolynomial(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, C c, ExpVector expVector) {
        this(genSolvablePolynomialRing);
        if (c != null && !c.isZERO()) {
            this.val.put(expVector, c);
        }
    }

    public GenSolvablePolynomial(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, C c) {
        this(genSolvablePolynomialRing, c, genSolvablePolynomialRing.evzero);
    }

    protected GenSolvablePolynomial(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, SortedMap<ExpVector, C> sortedMap) {
        this(genSolvablePolynomialRing);
        if (sortedMap.size() > 0) {
            ++GenPolynomialRing.creations;
            this.val.putAll(sortedMap);
        }
    }

    @Override
    public GenSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> copy() {
        return new GenSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GenSolvablePolynomial)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == genSolvablePolynomial.ring.nvar);
        if (this instanceof RecSolvablePolynomial && genSolvablePolynomial instanceof RecSolvablePolynomial) {
            logger.info("warn: wrong method dispatch in JRE Rec.multiply(Rec Bp) - trying to fix");
            RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)this;
            RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)genSolvablePolynomial;
            return recSolvablePolynomial.multiply(recSolvablePolynomial2);
        }
        if (this instanceof QLRSolvablePolynomial && genSolvablePolynomial instanceof QLRSolvablePolynomial) {
            logger.info("warn: wrong method dispatch in JRE QLR.multiply(QLR Bp) - trying to fix");
            QLRSolvablePolynomial qLRSolvablePolynomial = (QLRSolvablePolynomial)this;
            QLRSolvablePolynomial qLRSolvablePolynomial2 = (QLRSolvablePolynomial)genSolvablePolynomial;
            return qLRSolvablePolynomial.multiply(qLRSolvablePolynomial2);
        }
        boolean bl = this.ring.table.isEmpty();
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        ExpVector expVector = this.ring.evzero;
        GenPolynomial genPolynomial2 = null;
        GenPolynomial genPolynomial3 = null;
        SortedMap sortedMap = this.val;
        SortedMap sortedMap2 = genSolvablePolynomial.val;
        Set set = sortedMap2.entrySet();
        for (Map.Entry entry : sortedMap.entrySet()) {
            RingElem ringElem = (RingElem)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            int[] nArray = expVector2.dependencyOnVariables();
            int n = this.ring.nvar + 1;
            if (nArray.length > 0) {
                n = nArray[0];
            }
            int n2 = this.ring.nvar + 1 - n;
            for (Map.Entry entry2 : set) {
                ExpVector expVector3;
                RingElem ringElem2 = (RingElem)entry2.getValue();
                ExpVector expVector4 = (ExpVector)entry2.getKey();
                int[] nArray2 = expVector4.dependencyOnVariables();
                int n3 = 0;
                if (nArray2.length > 0) {
                    n3 = nArray2[nArray2.length - 1];
                }
                int n4 = this.ring.nvar + 1 - n3;
                GenSolvablePolynomial<RingElem<GenPolynomial>> genSolvablePolynomial2 = null;
                if (bl || n2 <= n4) {
                    expVector3 = expVector2.sum(expVector4);
                    genSolvablePolynomial2 = this.ring.valueOf(expVector3);
                } else {
                    expVector3 = expVector2.subst(n, 0L);
                    ExpVector expVector5 = expVector.subst(n, expVector2.getVal(n));
                    ExpVector expVector6 = expVector4.subst(n3, 0L);
                    ExpVector expVector7 = expVector.subst(n3, expVector4.getVal(n3));
                    TableRelation tableRelation = this.ring.table.lookup(expVector5, expVector7);
                    genSolvablePolynomial2 = tableRelation.p;
                    if (tableRelation.f != null) {
                        genPolynomial3 = this.ring.valueOf(tableRelation.f);
                        genSolvablePolynomial2 = genSolvablePolynomial2.multiply((RingElem)genPolynomial3);
                        ExpVector expVector8 = tableRelation.e == null ? expVector5 : expVector5.subtract(tableRelation.e);
                        this.ring.table.update(expVector8, expVector7, genSolvablePolynomial2);
                    }
                    if (tableRelation.e != null) {
                        genPolynomial2 = this.ring.valueOf(tableRelation.e);
                        genSolvablePolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiply((C)genSolvablePolynomial2);
                        this.ring.table.update(expVector5, expVector7, genSolvablePolynomial2);
                    }
                    if (!expVector6.isZERO()) {
                        genPolynomial3 = this.ring.valueOf(expVector6);
                        genSolvablePolynomial2 = genSolvablePolynomial2.multiply((RingElem<GenPolynomial>)genPolynomial3);
                    }
                    if (!expVector3.isZERO()) {
                        genPolynomial2 = this.ring.valueOf(expVector3);
                        genSolvablePolynomial2 = ((GenSolvablePolynomial)genPolynomial2).multiply((C)genSolvablePolynomial2);
                    }
                }
                genSolvablePolynomial2 = genSolvablePolynomial2.multiply(ringElem, ringElem2);
                genPolynomial.doAddTo(genSolvablePolynomial2);
            }
        }
        return genPolynomial;
    }

    public GenSolvablePolynomial<C> multiply(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial.isZERO() || genSolvablePolynomial2.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (genSolvablePolynomial.isONE()) {
            return this.multiply((C)genSolvablePolynomial2);
        }
        if (genSolvablePolynomial2.isONE()) {
            return genSolvablePolynomial.multiply(this);
        }
        return genSolvablePolynomial.multiply(this).multiply(genSolvablePolynomial2);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(C c) {
        GenPolynomial genPolynomial = this.ring.getZERO();
        if (c == null || c.isZERO()) {
            return genPolynomial;
        }
        if (this instanceof RecSolvablePolynomial && c instanceof GenSolvablePolynomial) {
            logger.info("warn: wrong method dispatch in JRE Rec.multiply(b) - trying to fix");
            RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)this;
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)c;
            return recSolvablePolynomial.recMultiply(genSolvablePolynomial);
        }
        if (this instanceof QLRSolvablePolynomial && c instanceof GenSolvablePolynomial) {
            logger.info("warn: wrong method dispatch in JRE QLR.multiply(Bp) - trying to fix");
            QLRSolvablePolynomial qLRSolvablePolynomial = (QLRSolvablePolynomial)this;
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)c;
            return qLRSolvablePolynomial.multiply((C)genSolvablePolynomial);
        }
        genPolynomial = ((GenSolvablePolynomial)genPolynomial).copy();
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem = (RingElem)entry.getValue();
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector, ringElem2);
        }
        return genPolynomial;
    }

    public GenSolvablePolynomial<C> multiply(C ringElem, C c) {
        GenPolynomial genPolynomial = this.ring.getZERO();
        if (ringElem == null || ringElem.isZERO()) {
            return genPolynomial;
        }
        if (c == null || c.isZERO()) {
            return genPolynomial;
        }
        if (this instanceof RecSolvablePolynomial && ringElem instanceof GenSolvablePolynomial && c instanceof GenSolvablePolynomial) {
            logger.info("warn: wrong method dispatch in JRE Rec.multiply(b,c) - trying to fix");
            RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)this;
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)ringElem;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)c;
            return recSolvablePolynomial.multiply((C)genSolvablePolynomial, (C)genSolvablePolynomial2);
        }
        if (this instanceof QLRSolvablePolynomial && ringElem instanceof GenSolvablePolynomial && c instanceof GenSolvablePolynomial) {
            logger.info("warn: wrong method dispatch in JRE QLR.multiply(b,c) - trying to fix");
            QLRSolvablePolynomial qLRSolvablePolynomial = (QLRSolvablePolynomial)this;
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)ringElem;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)c;
            return qLRSolvablePolynomial.multiply((C)genSolvablePolynomial, (C)genSolvablePolynomial3);
        }
        genPolynomial = ((GenSolvablePolynomial)genPolynomial).copy();
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = (RingElem)ringElem.multiply((RingElem)ringElem2).multiply(c);
            if (ringElem3.isZERO()) continue;
            sortedMap.put(expVector, ringElem3);
        }
        return genPolynomial;
    }

    @Override
    public GenSolvablePolynomial<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        Object c = this.ring.getONECoefficient();
        return this.multiply((RingElem)c, expVector);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(ExpVector expVector, ExpVector expVector2) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (expVector2 == null || expVector2.isZERO()) {
            return this;
        }
        Object c = this.ring.getONECoefficient();
        return this.multiply(c, expVector, c, expVector2);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(C c, ExpVector expVector) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        GenPolynomial genPolynomial = this.ring.valueOf((RingElem)c, expVector);
        return this.multiply((C)genPolynomial);
    }

    public GenSolvablePolynomial<C> multiply(C c, ExpVector expVector, C c2, ExpVector expVector2) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (c2 == null || c2.isZERO()) {
            return this.ring.getZERO();
        }
        GenPolynomial genPolynomial = this.ring.valueOf((RingElem)c, expVector);
        GenPolynomial genPolynomial2 = this.ring.valueOf((RingElem)c2, expVector2);
        return this.multiply(genPolynomial, genPolynomial2);
    }

    public GenSolvablePolynomial<C> multiplyLeft(C c, ExpVector expVector) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        GenPolynomial genPolynomial = this.ring.valueOf((RingElem)c, expVector);
        return ((GenSolvablePolynomial)genPolynomial).multiply((C)this);
    }

    @Override
    public GenSolvablePolynomial<C> multiplyLeft(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        Object c = this.ring.getONECoefficient();
        return this.multiplyLeft(c, expVector);
    }

    @Override
    public GenSolvablePolynomial<C> multiplyLeft(C ringElem) {
        GenPolynomial genPolynomial = this.ring.getZERO();
        if (ringElem == null || ringElem.isZERO()) {
            return genPolynomial;
        }
        genPolynomial = ((GenSolvablePolynomial)genPolynomial).copy();
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            RingElem ringElem3 = ringElem.multiply((RingElem)ringElem2);
            if (ringElem3.isZERO()) continue;
            sortedMap.put(expVector, ringElem3);
        }
        return genPolynomial;
    }

    @Override
    public GenSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, C> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft((RingElem)entry.getValue(), entry.getKey());
    }

    @Override
    public GenSolvablePolynomial<C> multiply(Map.Entry<ExpVector, C> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply((RingElem)entry.getValue(), entry.getKey());
    }

    @Override
    public GenSolvablePolynomial<C> subtractMultiple(C ringElem, GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (ringElem == null || ringElem.isZERO()) {
            return this;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genSolvablePolynomial.multiplyLeft((RingElem)ringElem.negate());
        }
        assert (this.ring.nvar == genSolvablePolynomial.ring.nvar);
        GenPolynomial genPolynomial = this.copy();
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        SortedMap sortedMap2 = genSolvablePolynomial.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector, ringElem2.negate());
        }
        return genPolynomial;
    }

    @Override
    public GenSolvablePolynomial<C> subtractMultiple(C ringElem, ExpVector expVector, GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (ringElem == null || ringElem.isZERO()) {
            return this;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genSolvablePolynomial.multiplyLeft((RingElem)ringElem.negate(), expVector);
        }
        assert (this.ring.nvar == genSolvablePolynomial.ring.nvar);
        GenPolynomial genPolynomial = this.copy();
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        GenSolvablePolynomial<ExpVector> genSolvablePolynomial2 = genSolvablePolynomial.multiplyLeft((RingElem)((Object)expVector));
        SortedMap sortedMap2 = genSolvablePolynomial2.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector2);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector2, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector2);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector2, ringElem2.negate());
        }
        return genPolynomial;
    }

    @Override
    public GenSolvablePolynomial<C> scaleSubtractMultiple(C c, C ringElem, GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (ringElem == null || genSolvablePolynomial == null) {
            return this.multiplyLeft((RingElem)c);
        }
        if (ringElem.isZERO() || genSolvablePolynomial.isZERO()) {
            return this.multiplyLeft((RingElem)c);
        }
        if (this.isZERO() || c == null || c.isZERO()) {
            return genSolvablePolynomial.multiplyLeft((RingElem)ringElem.negate());
        }
        if (c.isONE()) {
            return this.subtractMultiple((C)ringElem, genSolvablePolynomial);
        }
        assert (this.ring.nvar == genSolvablePolynomial.ring.nvar);
        GenPolynomial genPolynomial = this.multiplyLeft((RingElem)c);
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        SortedMap sortedMap2 = genSolvablePolynomial.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector, ringElem2.negate());
        }
        return genPolynomial;
    }

    @Override
    public GenSolvablePolynomial<C> scaleSubtractMultiple(C c, C ringElem, ExpVector expVector, GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (ringElem == null || genSolvablePolynomial == null) {
            return this.multiplyLeft((RingElem)c);
        }
        if (ringElem.isZERO() || genSolvablePolynomial.isZERO()) {
            return this.multiplyLeft((RingElem)c);
        }
        if (this.isZERO() || c == null || c.isZERO()) {
            return genSolvablePolynomial.multiplyLeft((RingElem)ringElem.negate(), expVector);
        }
        if (c.isONE()) {
            return this.subtractMultiple((C)ringElem, expVector, genSolvablePolynomial);
        }
        assert (this.ring.nvar == genSolvablePolynomial.ring.nvar);
        GenPolynomial genPolynomial = this.multiplyLeft((RingElem)c);
        SortedMap sortedMap = ((GenSolvablePolynomial)genPolynomial).val;
        GenSolvablePolynomial<ExpVector> genSolvablePolynomial2 = genSolvablePolynomial.multiplyLeft((RingElem)((Object)expVector));
        SortedMap sortedMap2 = genSolvablePolynomial2.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector2);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector2, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector2);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector2, ringElem2.negate());
        }
        return genPolynomial;
    }

    @Override
    public GenSolvablePolynomial<C> scaleSubtractMultiple(C c, ExpVector expVector, C ringElem, ExpVector expVector2, GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (ringElem == null || genSolvablePolynomial == null) {
            return this.multiplyLeft(c, expVector);
        }
        if (ringElem.isZERO() || genSolvablePolynomial.isZERO()) {
            return this.multiplyLeft(c, expVector);
        }
        if (this.isZERO() || c == null || c.isZERO()) {
            return genSolvablePolynomial.multiplyLeft((RingElem)ringElem.negate(), expVector2);
        }
        if (c.isONE() && expVector.isZERO()) {
            return this.subtractMultiple((C)ringElem, expVector2, genSolvablePolynomial);
        }
        assert (this.ring.nvar == genSolvablePolynomial.ring.nvar);
        GenSolvablePolynomial<C> genSolvablePolynomial2 = this.multiplyLeft(c, expVector);
        SortedMap sortedMap = genSolvablePolynomial2.val;
        GenSolvablePolynomial<ExpVector> genSolvablePolynomial3 = genSolvablePolynomial.multiplyLeft((RingElem)((Object)expVector2));
        SortedMap sortedMap2 = genSolvablePolynomial3.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector3 = (ExpVector)entry.getKey();
            RingElem ringElem2 = (RingElem)entry.getValue();
            ringElem2 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem3 = (RingElem)sortedMap.get(expVector3);
            if (ringElem3 != null) {
                if (!(ringElem3 = ringElem3.subtract(ringElem2)).isZERO()) {
                    sortedMap.put(expVector3, ringElem3);
                    continue;
                }
                sortedMap.remove(expVector3);
                continue;
            }
            if (ringElem2.isZERO()) continue;
            sortedMap.put(expVector3, ringElem2.negate());
        }
        return genSolvablePolynomial2;
    }

    @Override
    public GenSolvablePolynomial<C> monic() {
        if (this.isZERO()) {
            return this;
        }
        Object c = this.leadingBaseCoefficient();
        if (!c.isUnit()) {
            return (GenSolvablePolynomial)this.abs();
        }
        try {
            RingElem ringElem = (RingElem)c.inverse();
            return (GenSolvablePolynomial)this.multiplyLeft(ringElem).abs();
        }
        catch (NotInvertibleException notInvertibleException) {
            logger.info("monic not invertible " + c);
            return this;
        }
    }

    @Override
    public GenSolvablePolynomial<C> divide(GenSolvablePolynomial<C> genSolvablePolynomial) {
        return this.quotientRemainder(genSolvablePolynomial)[0];
    }

    @Override
    public GenSolvablePolynomial<C> remainder(GenSolvablePolynomial<C> genSolvablePolynomial) {
        return this.quotientRemainder(genSolvablePolynomial)[1];
    }

    public GenSolvablePolynomial<C>[] quotientRemainder(GenSolvablePolynomial<C> genSolvablePolynomial) {
        Object object;
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        Object c = genSolvablePolynomial.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbcf not invertible " + c);
        }
        RingElem ringElem = (RingElem)c.inverse();
        assert (this.ring.nvar == genSolvablePolynomial.ring.nvar);
        ExpVector expVector = genSolvablePolynomial.leadingExpVector();
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        GenPolynomial genPolynomial2 = this.copy();
        while (!genPolynomial2.isZERO() && (object = genPolynomial2.leadingExpVector()).multipleOf(expVector)) {
            RingElem ringElem2 = genPolynomial2.leadingBaseCoefficient();
            object = object.subtract(expVector);
            ringElem2 = ringElem2.multiply((RingElem)ringElem);
            genPolynomial = (GenSolvablePolynomial)genPolynomial.sum(ringElem2, (ExpVector)object);
            GenSolvablePolynomial<C> genSolvablePolynomial2 = genSolvablePolynomial.multiplyLeft(ringElem2, (ExpVector)object);
            if (!genSolvablePolynomial2.leadingBaseCoefficient().equals(genPolynomial2.leadingBaseCoefficient())) {
                throw new RuntimeException("something is wrong: r = " + genPolynomial2 + ", h = " + genSolvablePolynomial2);
            }
            genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.subtract(genSolvablePolynomial2);
        }
        object = new GenSolvablePolynomial[]{genPolynomial, genPolynomial2};
        return object;
    }

    @Override
    public GenSolvablePolynomial<C> rightDivide(GenSolvablePolynomial<C> genSolvablePolynomial) {
        return this.rightQuotientRemainder(genSolvablePolynomial)[0];
    }

    @Override
    public GenSolvablePolynomial<C> rightRemainder(GenSolvablePolynomial<C> genSolvablePolynomial) {
        return this.rightQuotientRemainder(genSolvablePolynomial)[1];
    }

    public GenSolvablePolynomial<C>[] rightQuotientRemainder(GenSolvablePolynomial<C> genSolvablePolynomial) {
        Object object;
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        Object c = genSolvablePolynomial.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbcf not invertible " + c);
        }
        RingElem ringElem = (RingElem)c.inverse();
        assert (this.ring.nvar == genSolvablePolynomial.ring.nvar);
        ExpVector expVector = genSolvablePolynomial.leadingExpVector();
        GenPolynomial genPolynomial = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        GenPolynomial genPolynomial2 = this.copy();
        while (!genPolynomial2.isZERO() && (object = genPolynomial2.leadingExpVector()).multipleOf(expVector)) {
            Object object2 = genPolynomial2.leadingBaseCoefficient();
            object = object.subtract(expVector);
            object2 = (RingElem)ringElem.multiply(object2);
            genPolynomial = (GenSolvablePolynomial)genPolynomial.sum(object2, (ExpVector)object);
            GenPolynomial genPolynomial3 = genSolvablePolynomial.multiply((RingElem)object2, (ExpVector)object);
            if (!genPolynomial3.leadingBaseCoefficient().equals(genPolynomial2.leadingBaseCoefficient())) {
                throw new RuntimeException("something is wrong: r = " + genPolynomial2 + ", h = " + genPolynomial3);
            }
            genPolynomial2 = (GenSolvablePolynomial)genPolynomial2.subtract(genPolynomial3);
        }
        object = new GenSolvablePolynomial[]{genPolynomial, genPolynomial2};
        return object;
    }

    public GenSolvablePolynomial<C> rightRecursivePolynomial() {
        if (this.isONE() || this.isZERO()) {
            return this;
        }
        if (!(this instanceof RecSolvablePolynomial)) {
            return this;
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = (RecSolvablePolynomialRing)this.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            return this;
        }
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)this;
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)recSolvablePolynomial.rightRecursivePolynomial();
        return recSolvablePolynomial2;
    }

    public GenSolvablePolynomial<C> evalAsRightRecursivePolynomial() {
        if (this.isONE() || this.isZERO()) {
            return this;
        }
        if (!(this instanceof RecSolvablePolynomial)) {
            return this;
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = (RecSolvablePolynomialRing)this.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            return this;
        }
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)this;
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)recSolvablePolynomial.evalAsRightRecursivePolynomial();
        return recSolvablePolynomial2;
    }

    public boolean isRightRecursivePolynomial(GenSolvablePolynomial<C> genSolvablePolynomial) {
        if (this.isZERO()) {
            return genSolvablePolynomial.isZERO();
        }
        if (this.isONE()) {
            return genSolvablePolynomial.isONE();
        }
        if (!(this instanceof RecSolvablePolynomial)) {
            return !(genSolvablePolynomial instanceof RecSolvablePolynomial);
        }
        if (!(genSolvablePolynomial instanceof RecSolvablePolynomial)) {
            return false;
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = (RecSolvablePolynomialRing)this.ring;
        if (recSolvablePolynomialRing.coeffTable.isEmpty()) {
            RecSolvablePolynomialRing recSolvablePolynomialRing2 = (RecSolvablePolynomialRing)genSolvablePolynomial.ring;
            return recSolvablePolynomialRing2.coeffTable.isEmpty();
        }
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)this;
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)genSolvablePolynomial;
        return recSolvablePolynomial.isRightRecursivePolynomial(recSolvablePolynomial2);
    }
}

