/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.ExpVectorLong;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TermOrderByNameTest
extends TestCase {
    ExpVector a;
    ExpVector b;
    ExpVector c;
    ExpVector d;
    TermOrder t;
    TermOrder s;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TermOrderByNameTest.suite());
    }

    public TermOrderByNameTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(TermOrderByNameTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.s = null;
        this.t = null;
    }

    protected void tearDown() {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.s = null;
        this.t = null;
    }

    public void testConstructor() {
        this.s = TermOrderByName.DEFAULT;
        this.t = TermOrderByName.DEFAULT;
        TermOrderByNameTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
        String string = this.t.toString();
        String string2 = this.s.toString();
        TermOrderByNameTest.assertEquals((String)"x = y", (String)string, (String)string2);
        this.t = TermOrderByName.Lexicographic;
        string = "REVILEX";
        string2 = this.t.toString();
        boolean bl = string2.startsWith(string);
        TermOrderByNameTest.assertTrue((String)("REVILEX(.): " + string2), (boolean)bl);
        this.s = TermOrderByName.DegreeLexicographic;
        this.t = TermOrderByName.DegreeLexicographic;
        TermOrderByNameTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
    }

    public void testConstructorSplit() {
        int n = 10;
        int n2 = 5;
        ExpVector expVector = ExpVectorLong.create(n);
        this.s = TermOrderByName.blockOrder(TermOrderByName.DegreeLexicographic, TermOrderByName.DegreeLexicographic, expVector, n2);
        this.t = TermOrderByName.blockOrder(TermOrderByName.DegreeLexicographic, TermOrderByName.DegreeLexicographic, expVector, n2);
        TermOrderByNameTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
        String string = this.t.toString();
        String string2 = this.s.toString();
        TermOrderByNameTest.assertEquals((String)"x = y", (String)string, (String)string2);
        this.s = TermOrderByName.blockOrder(TermOrderByName.DegreeLexicographic, TermOrderByName.Lexicographic, expVector, n2);
        this.t = TermOrderByName.blockOrder(TermOrderByName.DegreeLexicographic, TermOrderByName.Lexicographic, expVector, n2);
        TermOrderByNameTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
    }

    public void testConstructorWeight() {
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        this.s = TermOrderByName.weightOrder(lArrayArray);
        this.t = TermOrderByName.weightOrder(lArrayArray);
        TermOrderByNameTest.assertEquals((String)"t = s", (Object)this.t, (Object)this.s);
        String string = this.t.toString();
        String string2 = this.s.toString();
        TermOrderByNameTest.assertEquals((String)"x = y", (String)string, (String)string2);
        string = "W(";
        boolean bl = this.t.toString().startsWith(string);
        TermOrderByNameTest.assertTrue((String)"W(.)", (boolean)bl);
    }

    public void testCompareWeight() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        this.c = this.a.sum(this.b);
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L}};
        this.t = TermOrderByName.weightOrder(lArrayArray);
        int n = ExpVector.EVIWLC(lArrayArray, this.c, this.a);
        int n2 = ExpVector.EVIWLC(lArrayArray, this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 1", (int)1, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = 1", (int)1, (int)n2);
        n = ExpVector.EVIWLC(lArrayArray, this.a, this.c);
        n2 = ExpVector.EVIWLC(lArrayArray, this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x = -1", (int)-1, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = -1", (int)-1, (int)n2);
        n = ExpVector.EVIWLC(lArrayArray, this.a, this.a);
        n2 = ExpVector.EVIWLC(lArrayArray, this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 0", (int)0, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = 0", (int)0, (int)n2);
    }

    public void testCompareWeight2() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        this.c = this.a.sum(this.b);
        long[][] lArrayArray = new long[][]{{1L, 1L, 1L, 1L, 1L}, {1L, 1L, 1L, 1L, 1L}};
        this.t = TermOrderByName.weightOrder(lArrayArray);
        int n = ExpVector.EVIWLC(lArrayArray, this.c, this.a);
        int n2 = ExpVector.EVIWLC(lArrayArray, this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 1", (int)1, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = 1", (int)1, (int)n2);
        n = ExpVector.EVIWLC(lArrayArray, this.a, this.c);
        n2 = ExpVector.EVIWLC(lArrayArray, this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x = -1", (int)-1, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = -1", (int)-1, (int)n2);
        n = ExpVector.EVIWLC(lArrayArray, this.a, this.a);
        n2 = ExpVector.EVIWLC(lArrayArray, this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 0", (int)0, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = 0", (int)0, (int)n2);
    }

    public void testAscendComparator() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = TermOrderByName.DegreeLexicographic;
        int n = this.t.getAscendComparator().compare(this.c, this.a);
        int n2 = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 1", (int)1, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = 1", (int)1, (int)n2);
        n = this.t.getAscendComparator().compare(this.a, this.c);
        n2 = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x = -1", (int)-1, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = -1", (int)-1, (int)n2);
        n = this.t.getAscendComparator().compare(this.a, this.a);
        n2 = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 0", (int)0, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = 0", (int)0, (int)n2);
    }

    public void testAscendComparatorSplit() {
        float f = 0.9f;
        int n = 10;
        int n2 = 5;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = TermOrderByName.blockOrder(TermOrderByName.DegreeLexicographic, TermOrderByName.Lexicographic, this.c, n2);
        int n3 = this.t.getAscendComparator().compare(this.c, this.a);
        int n4 = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderByNameTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = this.t.getAscendComparator().compare(this.a, this.c);
        n4 = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderByNameTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = this.t.getAscendComparator().compare(this.a, this.a);
        n4 = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderByNameTest.assertEquals((String)"y = 0", (int)0, (int)n4);
    }

    public void testAscendComparatorWeightSplit() {
        float f = 0.9f;
        int n = 8;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        long[][] lArrayArray = new long[][]{{1L, 2L, 3L, 4L, 5L, 0L, 0L, 0L}, {0L, 0L, 0L, 0L, 0L, 1L, 2L, 3L}};
        this.t = TermOrderByName.weightOrder(lArrayArray);
        TermOrder termOrder = TermOrderByName.weightOrder(lArrayArray);
        TermOrderByNameTest.assertEquals((String)"t = t2", (Object)this.t, (Object)termOrder);
        int n2 = this.t.getAscendComparator().compare(this.c, this.a);
        int n3 = this.t.getAscendComparator().compare(this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 1", (int)1, (int)n2);
        TermOrderByNameTest.assertEquals((String)"y = 1", (int)1, (int)n3);
        int n4 = termOrder.getAscendComparator().compare(this.c, this.a);
        int n5 = termOrder.getAscendComparator().compare(this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x2 = 1", (int)1, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y2 = 1", (int)1, (int)n5);
        TermOrderByNameTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
        n2 = this.t.getAscendComparator().compare(this.a, this.c);
        n3 = this.t.getAscendComparator().compare(this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x = -1", (int)-1, (int)n2);
        TermOrderByNameTest.assertEquals((String)"y = -1", (int)-1, (int)n3);
        n4 = termOrder.getAscendComparator().compare(this.a, this.c);
        n5 = termOrder.getAscendComparator().compare(this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x2 = -1", (int)-1, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y2 = -1", (int)-1, (int)n5);
        TermOrderByNameTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
        n2 = this.t.getAscendComparator().compare(this.a, this.a);
        n3 = this.t.getAscendComparator().compare(this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 0", (int)0, (int)n2);
        TermOrderByNameTest.assertEquals((String)"y = 0", (int)0, (int)n3);
        n4 = termOrder.getAscendComparator().compare(this.a, this.a);
        n5 = termOrder.getAscendComparator().compare(this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x2 = 0", (int)0, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y2 = 0", (int)0, (int)n5);
        TermOrderByNameTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
    }

    public void testDescendComparator() {
        float f = 0.9f;
        this.a = ExpVector.random(5, 10L, f);
        this.b = ExpVector.random(5, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = TermOrderByName.DegreeLexicographic;
        int n = this.t.getDescendComparator().compare(this.c, this.a);
        int n2 = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x = -1", (int)-1, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = -1", (int)-1, (int)n2);
        n = this.t.getDescendComparator().compare(this.a, this.c);
        n2 = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x = 1", (int)1, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = 1", (int)1, (int)n2);
        n = this.t.getDescendComparator().compare(this.a, this.a);
        n2 = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 0", (int)0, (int)n);
        TermOrderByNameTest.assertEquals((String)"y = 0", (int)0, (int)n2);
    }

    public void testDescendComparatorSplit() {
        float f = 0.9f;
        int n = 10;
        int n2 = 5;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        this.t = TermOrderByName.blockOrder(TermOrderByName.DegreeLexicographic, TermOrderByName.Lexicographic, this.c, n2);
        int n3 = this.t.getDescendComparator().compare(this.c, this.a);
        int n4 = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x = -1", (int)-1, (int)n3);
        TermOrderByNameTest.assertEquals((String)"y = -1", (int)-1, (int)n4);
        n3 = this.t.getDescendComparator().compare(this.a, this.c);
        n4 = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x = 1", (int)1, (int)n3);
        TermOrderByNameTest.assertEquals((String)"y = 1", (int)1, (int)n4);
        n3 = this.t.getDescendComparator().compare(this.a, this.a);
        n4 = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 0", (int)0, (int)n3);
        TermOrderByNameTest.assertEquals((String)"y = 0", (int)0, (int)n4);
    }

    public void testDescendComparatorWeightSplit() {
        float f = 0.9f;
        int n = 8;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = this.a.sum(this.b);
        long[][] lArrayArray = new long[][]{{1L, 2L, 3L, 4L, 5L, 0L, 0L, 0L}, {0L, 0L, 0L, 0L, 0L, 1L, 2L, 3L}};
        this.t = TermOrderByName.weightOrder(lArrayArray);
        TermOrder termOrder = TermOrderByName.weightOrder(lArrayArray);
        TermOrderByNameTest.assertEquals((String)"t = t2", (Object)this.t, (Object)termOrder);
        int n2 = this.t.getDescendComparator().compare(this.c, this.a);
        int n3 = this.t.getDescendComparator().compare(this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x = -1", (int)-1, (int)n2);
        TermOrderByNameTest.assertEquals((String)"y = -1", (int)-1, (int)n3);
        int n4 = termOrder.getDescendComparator().compare(this.c, this.a);
        int n5 = termOrder.getDescendComparator().compare(this.c, this.b);
        TermOrderByNameTest.assertEquals((String)"x2 = -1", (int)-1, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y2 = -1", (int)-1, (int)n5);
        TermOrderByNameTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
        n2 = this.t.getDescendComparator().compare(this.a, this.c);
        n3 = this.t.getDescendComparator().compare(this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x = 1", (int)1, (int)n2);
        TermOrderByNameTest.assertEquals((String)"y = 1", (int)1, (int)n3);
        n4 = termOrder.getDescendComparator().compare(this.a, this.c);
        n5 = termOrder.getDescendComparator().compare(this.b, this.c);
        TermOrderByNameTest.assertEquals((String)"x2 = 1", (int)1, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y2 = 1", (int)1, (int)n5);
        TermOrderByNameTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
        n2 = this.t.getDescendComparator().compare(this.a, this.a);
        n3 = this.t.getDescendComparator().compare(this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x = 0", (int)0, (int)n2);
        TermOrderByNameTest.assertEquals((String)"y = 0", (int)0, (int)n3);
        n4 = termOrder.getDescendComparator().compare(this.a, this.a);
        n5 = termOrder.getDescendComparator().compare(this.b, this.b);
        TermOrderByNameTest.assertEquals((String)"x2 = 0", (int)0, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y2 = 0", (int)0, (int)n5);
        TermOrderByNameTest.assertEquals((String)"x = x2", (int)n2, (int)n4);
        TermOrderByNameTest.assertEquals((String)"y = y2", (int)n3, (int)n5);
    }

    public void testCompareExceptionSplit() {
        float f = 0.9f;
        int n = 10;
        int n2 = 5;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(n, 10L, f);
        this.c = ExpVector.random(2, 10L, f);
        TermOrder termOrder = TermOrderByName.REVITDG;
        int n3 = 0;
        try {
            this.t = TermOrderByName.blockOrder(termOrder, termOrder, this.c, n2);
            n3 = this.t.getDescendComparator().compare(this.a, this.b);
            TermOrderByNameTest.fail((String)("IllegalArgumentException " + n3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCompareExceptionWeigth() {
        float f = 0.9f;
        int n = 10;
        this.a = ExpVector.random(n, 10L, f);
        this.b = ExpVector.random(2, 10L, f);
        int n2 = 0;
        try {
            this.t = TermOrderByName.weightOrder((long[][])null);
            n2 = this.t.getDescendComparator().compare(this.a, this.b);
            TermOrderByNameTest.fail((String)("IllegalArgumentException " + n2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

