/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.List;

public class AlgebraicRoots<C extends GcdRingElem<C> & Rational>
implements Serializable {
    public final GenPolynomial<C> p;
    public final List<RealAlgebraicNumber<C>> real;
    public final GenPolynomial<Complex<C>> cp;
    public final List<ComplexAlgebraicNumber<C>> complex;

    protected AlgebraicRoots() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public AlgebraicRoots(GenPolynomial<C> genPolynomial, GenPolynomial<Complex<C>> genPolynomial2, List<RealAlgebraicNumber<C>> list, List<ComplexAlgebraicNumber<C>> list2) {
        this.p = genPolynomial;
        this.cp = genPolynomial2;
        this.real = list;
        this.complex = list2;
    }

    public String toString() {
        return "[" + this.p + ", real=" + this.real + ", complex=" + this.complex + "]";
    }

    public String toScript() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.p.toScript());
        if (!this.real.isEmpty()) {
            stringBuffer.append(", real=[");
            bl = true;
            for (RealAlgebraicNumber<C> gcdRingElem : this.real) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(gcdRingElem.toScript());
            }
            stringBuffer.append("]");
        }
        if (!this.complex.isEmpty()) {
            stringBuffer.append(", complex=[");
            bl = true;
            for (ComplexAlgebraicNumber complexAlgebraicNumber : this.complex) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(complexAlgebraicNumber.toScript());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toDecimalScript() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.p.toScript());
        if (!this.real.isEmpty()) {
            stringBuffer.append(", real=[");
            bl = true;
            for (RealAlgebraicNumber<C> gcdRingElem : this.real) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(gcdRingElem.ring.root.toDecimal().toScript());
            }
            stringBuffer.append("]");
        }
        if (!this.complex.isEmpty()) {
            stringBuffer.append(", complex=[");
            bl = true;
            for (ComplexAlgebraicNumber complexAlgebraicNumber : this.complex) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(complexAlgebraicNumber.ring.root.getDecimalCenter().toScript());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public AlgebraicRoots<C> copy() {
        return new AlgebraicRoots<C>(this.p, this.cp, this.real, this.complex);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlgebraicRoots)) {
            return false;
        }
        AlgebraicRoots algebraicRoots = null;
        try {
            algebraicRoots = (AlgebraicRoots)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.p.equals(algebraicRoots.p) && this.real.equals(algebraicRoots.real) && this.complex.equals(algebraicRoots.complex);
    }

    public int hashCode() {
        return (161 * this.p.hashCode() + 37) * this.real.hashCode() + this.complex.hashCode();
    }

    public AlgebraicNumberRing<C> getAlgebraicRing() {
        AlgebraicNumberRing<C> algebraicNumberRing = new AlgebraicNumberRing<C>(this.p);
        return algebraicNumberRing;
    }
}

