/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.AlgebraicRoots;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.ComplexRootsSturm;
import edu.jas.root.DecimalRoots;
import edu.jas.root.Interval;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.NoConvergenceException;
import edu.jas.root.PolyUtilRoot;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealRootsSturm;
import edu.jas.root.Rectangle;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class RootFactory {
    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<C> genPolynomial, RealAlgebraicNumber<C> realAlgebraicNumber) {
        ElemFactory elemFactory = realAlgebraicNumber.factory();
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(elemFactory, (GenPolynomialRing)genPolynomial.factory());
        GenPolynomial genPolynomial2 = PolyUtilRoot.convertToRealCoefficients(genPolynomialRing, genPolynomial);
        RealAlgebraicNumber<C> realAlgebraicNumber2 = PolyUtil.evaluateMain(elemFactory, genPolynomial2, realAlgebraicNumber);
        return realAlgebraicNumber2.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbers(GenPolynomial<C> genPolynomial) {
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        SquarefreeAbstract<GenPolynomial<C>> squarefreeAbstract = SquarefreeFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap<GenPolynomial<C>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial);
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            List list = realRootsSturm.realRoots(genPolynomial2);
            for (Interval interval : list) {
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(genPolynomial2, interval);
                RealAlgebraicNumber realAlgebraicNumber = realAlgebraicRing.getGenerator();
                long l = (Long)entry.getValue();
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(realAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbers(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        SquarefreeAbstract<GenPolynomial<C>> squarefreeAbstract = SquarefreeFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap<GenPolynomial<C>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial);
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            List list = realRootsSturm.realRoots(genPolynomial2, bigRational);
            for (Interval interval : list) {
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(genPolynomial2, interval);
                realAlgebraicRing.setEps(bigRational);
                RealAlgebraicNumber realAlgebraicNumber = realAlgebraicRing.getGenerator();
                long l = (Long)entry.getValue();
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(realAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersField(GenPolynomial<C> genPolynomial) {
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        FactorAbstract<C> factorAbstract = FactorFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap sortedMap = factorAbstract.baseFactors(genPolynomial);
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            List list = realRootsSturm.realRoots(genPolynomial2);
            for (Interval interval : list) {
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(genPolynomial2, interval, true);
                RealAlgebraicNumber realAlgebraicNumber = realAlgebraicRing.getGenerator();
                long l = (Long)entry.getValue();
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(realAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersField(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        FactorAbstract<C> factorAbstract = FactorFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap sortedMap = factorAbstract.baseFactors(genPolynomial);
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            List list = realRootsSturm.realRoots(genPolynomial2, bigRational);
            for (Interval interval : list) {
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(genPolynomial2, interval, true);
                realAlgebraicRing.setEps(bigRational);
                RealAlgebraicNumber realAlgebraicNumber = realAlgebraicRing.getGenerator();
                long l = (Long)entry.getValue();
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(realAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersIrred(GenPolynomial<C> genPolynomial) {
        RealRootsSturm<C> realRootsSturm = new RealRootsSturm<C>();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        List<Interval<C>> list = realRootsSturm.realRoots(genPolynomial);
        for (Interval<C> interval : list) {
            RealAlgebraicRing<C> realAlgebraicRing = new RealAlgebraicRing<C>(genPolynomial, interval, true);
            RealAlgebraicNumber<C> realAlgebraicNumber = realAlgebraicRing.getGenerator();
            arrayList.add(realAlgebraicNumber);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<RealAlgebraicNumber<C>> realAlgebraicNumbersIrred(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        RealRootsSturm<C> realRootsSturm = new RealRootsSturm<C>();
        ArrayList<RealAlgebraicNumber<C>> arrayList = new ArrayList<RealAlgebraicNumber<C>>();
        List<Interval<C>> list = realRootsSturm.realRoots(genPolynomial, bigRational);
        for (Interval<C> interval : list) {
            RealAlgebraicRing<C> realAlgebraicRing = new RealAlgebraicRing<C>(genPolynomial, interval, true);
            realAlgebraicRing.setEps(bigRational);
            RealAlgebraicNumber<C> realAlgebraicNumber = realAlgebraicRing.getGenerator();
            arrayList.add(realAlgebraicNumber);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<C> genPolynomial, ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        ElemFactory elemFactory = complexAlgebraicNumber.factory();
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(elemFactory, (GenPolynomialRing)genPolynomial.factory());
        GenPolynomial genPolynomial2 = PolyUtilRoot.convertToComplexCoefficients(genPolynomialRing, genPolynomial);
        ComplexAlgebraicNumber<C> complexAlgebraicNumber2 = PolyUtil.evaluateMain(elemFactory, genPolynomial2, complexAlgebraicNumber);
        return complexAlgebraicNumber2.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRootComplex(GenPolynomial<Complex<C>> genPolynomial, ComplexAlgebraicNumber<C> complexAlgebraicNumber) {
        ElemFactory elemFactory = complexAlgebraicNumber.factory();
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(elemFactory, (GenPolynomialRing)genPolynomial.factory());
        GenPolynomial genPolynomial2 = PolyUtilRoot.convertToComplexCoefficientsFromComplex(genPolynomialRing, genPolynomial);
        ComplexAlgebraicNumber<C> complexAlgebraicNumber2 = PolyUtil.evaluateMain(elemFactory, genPolynomial2, complexAlgebraicNumber);
        return complexAlgebraicNumber2.isZERO();
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRealRoot(GenPolynomial<C> genPolynomial, ComplexAlgebraicNumber<C> complexAlgebraicNumber, RealAlgebraicNumber<C> realAlgebraicNumber) {
        Interval<GcdRingElem> interval;
        RealRootsSturm<GcdRingElem> realRootsSturm;
        long l;
        GcdRingElem gcdRingElem;
        boolean bl;
        boolean bl2 = bl = RootFactory.isRoot(genPolynomial, complexAlgebraicNumber) && RootFactory.isRoot(genPolynomial, realAlgebraicNumber);
        if (!bl) {
            return bl;
        }
        Rectangle rectangle = complexAlgebraicNumber.ring.root;
        Interval<RingElem> interval2 = new Interval<RingElem>((RingElem)rectangle.getSW().getIm(), (RingElem)rectangle.getNE().getIm());
        bl = interval2.contains((RingElem)genPolynomial.ring.coFac.getZERO());
        if (!bl) {
            return bl;
        }
        Interval interval3 = new Interval(rectangle.getSW().getRe(), rectangle.getNE().getRe());
        Interval interval4 = realAlgebraicNumber.ring.root;
        if (((GcdRingElem)interval3.right).compareTo(interval4.left) < 0 || ((GcdRingElem)interval4.right).compareTo(interval3.left) < 0) {
            return false;
        }
        boolean bl3 = bl = interval3.contains(interval4) || interval4.contains(interval3);
        if (bl) {
            return bl;
        }
        GcdRingElem gcdRingElem2 = (GcdRingElem)interval3.left;
        if (gcdRingElem2.compareTo(interval4.left) > 0) {
            gcdRingElem2 = (GcdRingElem)interval4.left;
        }
        if ((gcdRingElem = (GcdRingElem)interval3.right).compareTo(interval4.right) < 0) {
            gcdRingElem = (GcdRingElem)interval4.right;
        }
        if ((l = (realRootsSturm = realAlgebraicNumber.ring.engine).realRootCount(interval = new Interval<GcdRingElem>(gcdRingElem2, gcdRingElem), genPolynomial)) != 1L) {
            return false;
        }
        ComplexRing complexRing = rectangle.getSW().ring;
        Complex<GcdRingElem> complex = new Complex<GcdRingElem>(complexRing, gcdRingElem2, (GcdRingElem)rectangle.getSW().getIm());
        Complex<GcdRingElem> complex2 = new Complex<GcdRingElem>(complexRing, gcdRingElem, (GcdRingElem)rectangle.getNE().getIm());
        Rectangle<GcdRingElem> rectangle2 = new Rectangle<GcdRingElem>(complex, complex2);
        ComplexRootsSturm<GcdRingElem> complexRootsSturm = complexAlgebraicNumber.ring.engine;
        GenPolynomial<Complex<C>> genPolynomial2 = PolyUtilRoot.complexFromAny(genPolynomial);
        try {
            l = complexRootsSturm.complexRootCount(rectangle2, genPolynomial2);
        }
        catch (InvalidBoundaryException invalidBoundaryException) {
            System.out.println("should not happen, rec = " + rectangle2 + ", p = " + genPolynomial2);
            invalidBoundaryException.printStackTrace();
            l = 0L;
        }
        return l == 1L;
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRealRoot(GenPolynomial<C> genPolynomial, Complex<BigDecimal> complex, BigDecimal bigDecimal, BigRational bigRational) {
        GenPolynomial genPolynomial2;
        BigDecimal bigDecimal2 = new BigDecimal(bigRational);
        if (complex.getIm().abs().compareTo(bigDecimal2) > 0) {
            return false;
        }
        if (complex.getRe().subtract(bigDecimal).abs().compareTo(bigDecimal2) > 0) {
            return false;
        }
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(bigDecimal2);
        GenPolynomialRing<BigDecimal> genPolynomialRing = new GenPolynomialRing<BigDecimal>(complexRing, genPolynomial2.ring);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(new ComplexRing(genPolynomial.ring.coFac), genPolynomial.ring);
        genPolynomial2 = PolyUtil.complexFromAny(genPolynomialRing2, genPolynomial);
        GenPolynomial<Complex<BigDecimal>> genPolynomial3 = PolyUtil.complexDecimalFromRational(genPolynomialRing, genPolynomial2);
        Complex<BigDecimal> complex2 = PolyUtil.evaluateMain(complexRing, genPolynomial3, complex);
        if (complex2.isZERO()) {
            return true;
        }
        System.out.println("z != 0: " + complex2);
        return false;
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> genPolynomial) {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(genPolynomial.ring.coFac);
        SquarefreeAbstract<GenPolynomial<Complex<C>>> squarefreeAbstract = SquarefreeFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial);
        ArrayList<ComplexAlgebraicNumber<C>> arrayList = new ArrayList<ComplexAlgebraicNumber<C>>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            List list = complexRootsSturm.complexRoots(genPolynomial2);
            for (Rectangle rectangle : list) {
                ComplexAlgebraicRing complexAlgebraicRing = new ComplexAlgebraicRing(genPolynomial2, rectangle);
                ComplexAlgebraicNumber complexAlgebraicNumber = complexAlgebraicRing.getGenerator();
                long l = (Long)entry.getValue();
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(complexAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> genPolynomial, BigRational bigRational) {
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(genPolynomial.ring.coFac);
        SquarefreeAbstract<GenPolynomial<Complex<C>>> squarefreeAbstract = SquarefreeFactory.getImplementation(genPolynomial.ring.coFac);
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial);
        ArrayList<ComplexAlgebraicNumber<C>> arrayList = new ArrayList<ComplexAlgebraicNumber<C>>();
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            List list = complexRootsSturm.complexRoots(genPolynomial2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = iterator.next();
                try {
                    rectangle2 = complexRootsSturm.complexRootRefinement(rectangle, genPolynomial2, bigRational);
                }
                catch (InvalidBoundaryException invalidBoundaryException) {
                    invalidBoundaryException.printStackTrace();
                }
                ComplexAlgebraicRing complexAlgebraicRing = new ComplexAlgebraicRing(genPolynomial2, rectangle2);
                complexAlgebraicRing.setEps(bigRational);
                ComplexAlgebraicNumber complexAlgebraicNumber = complexAlgebraicRing.getGenerator();
                long l = (Long)entry.getValue();
                int n = 0;
                while ((long)n < l) {
                    arrayList.add(complexAlgebraicNumber);
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbers(GenPolynomial<C> genPolynomial) {
        GenPolynomial<Complex<C>> genPolynomial2 = PolyUtilRoot.complexFromAny(genPolynomial);
        return RootFactory.complexAlgebraicNumbersComplex(genPolynomial2);
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> complexAlgebraicNumbers(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        GenPolynomial<Complex<C>> genPolynomial2 = PolyUtilRoot.complexFromAny(genPolynomial);
        return RootFactory.complexAlgebraicNumbersComplex(genPolynomial2, bigRational);
    }

    public static <C extends GcdRingElem<C> & Rational> List<ComplexAlgebraicNumber<C>> filterOutRealRoots(GenPolynomial<C> genPolynomial, List<ComplexAlgebraicNumber<C>> list, List<RealAlgebraicNumber<C>> list2) {
        if (list.isEmpty()) {
            return list;
        }
        if (list2.isEmpty()) {
            return list;
        }
        ArrayList<ComplexAlgebraicNumber<C>> arrayList = new ArrayList<ComplexAlgebraicNumber<C>>();
        if (list.size() == list2.size()) {
            return arrayList;
        }
        LinkedList<RealAlgebraicNumber<C>> linkedList = new LinkedList<RealAlgebraicNumber<C>>(list2);
        for (ComplexAlgebraicNumber<C> complexAlgebraicNumber : list) {
            RealAlgebraicNumber realAlgebraicNumber = null;
            for (RealAlgebraicNumber realAlgebraicNumber2 : linkedList) {
                if (!RootFactory.isRealRoot(genPolynomial, complexAlgebraicNumber, realAlgebraicNumber2)) continue;
                realAlgebraicNumber = realAlgebraicNumber2;
                break;
            }
            if (realAlgebraicNumber == null) {
                arrayList.add(complexAlgebraicNumber);
                continue;
            }
            linkedList.remove(realAlgebraicNumber);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<Complex<BigDecimal>> filterOutRealRoots(GenPolynomial<C> genPolynomial, List<Complex<BigDecimal>> list, List<BigDecimal> list2, BigRational bigRational) {
        if (list.isEmpty()) {
            return list;
        }
        if (list2.isEmpty()) {
            return list;
        }
        ArrayList<Complex<BigDecimal>> arrayList = new ArrayList<Complex<BigDecimal>>();
        if (list.size() == list2.size()) {
            return arrayList;
        }
        LinkedList<BigDecimal> linkedList = new LinkedList<BigDecimal>(list2);
        for (Complex<BigDecimal> complex : list) {
            BigDecimal bigDecimal = null;
            for (BigDecimal bigDecimal2 : linkedList) {
                if (!RootFactory.isRealRoot(genPolynomial, complex, bigDecimal2, bigRational)) continue;
                bigDecimal = bigDecimal2;
                break;
            }
            if (bigDecimal == null) {
                arrayList.add(complex);
                continue;
            }
            linkedList.remove(bigDecimal);
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> AlgebraicRoots<C> algebraicRoots(GenPolynomial<C> genPolynomial) {
        List<RealAlgebraicNumber<C>> list = RootFactory.realAlgebraicNumbers(genPolynomial);
        List<ComplexAlgebraicNumber<C>> list2 = RootFactory.complexAlgebraicNumbers(genPolynomial);
        GenPolynomial genPolynomial2 = null;
        if (!list2.isEmpty()) {
            genPolynomial2 = list2.get((int)0).ring.algebraic.modul;
        }
        list2 = RootFactory.filterOutRealRoots(genPolynomial, list2, list);
        AlgebraicRoots<C> algebraicRoots = new AlgebraicRoots<C>(genPolynomial, genPolynomial2, list, list2);
        return algebraicRoots;
    }

    public static <C extends GcdRingElem<C> & Rational> AlgebraicRoots<C> rootsOfUnity(AlgebraicRoots<C> algebraicRoots) {
        ArrayList arrayList = new ArrayList();
        for (RealAlgebraicNumber serializable2 : algebraicRoots.real) {
            if (!serializable2.isRootOfUnity()) continue;
            arrayList.add(serializable2);
        }
        ArrayList arrayList2 = new ArrayList();
        for (ComplexAlgebraicNumber complexAlgebraicNumber : algebraicRoots.complex) {
            if (!complexAlgebraicNumber.isRootOfUnity()) continue;
            arrayList2.add(complexAlgebraicNumber);
        }
        AlgebraicRoots algebraicRoots2 = new AlgebraicRoots(algebraicRoots.p, algebraicRoots.cp, arrayList, arrayList2);
        return algebraicRoots2;
    }

    public static <C extends GcdRingElem<C> & Rational> void rootRefine(AlgebraicRoots<C> algebraicRoots, BigRational bigRational) {
        for (RealAlgebraicNumber gcdRingElem : algebraicRoots.real) {
            gcdRingElem.ring.refineRoot(bigRational);
        }
        for (ComplexAlgebraicNumber complexAlgebraicNumber : algebraicRoots.complex) {
            complexAlgebraicNumber.ring.refineRoot(bigRational);
        }
    }

    public static <C extends GcdRingElem<C> & Rational> DecimalRoots<C> decimalRoots(GenPolynomial<C> genPolynomial, BigRational bigRational) {
        RealRootsSturm<C> realRootsSturm = new RealRootsSturm<C>();
        List<BigDecimal> list = realRootsSturm.approximateRoots(genPolynomial, bigRational);
        GenPolynomial<Complex<C>> genPolynomial2 = PolyUtilRoot.complexFromAny(genPolynomial);
        ComplexRootsSturm<C> complexRootsSturm = new ComplexRootsSturm<C>(genPolynomial2.ring.coFac);
        List<Complex<BigDecimal>> list2 = complexRootsSturm.approximateRoots(genPolynomial2, bigRational);
        list2 = RootFactory.filterOutRealRoots(genPolynomial, list2, list, bigRational);
        DecimalRoots<C> decimalRoots = new DecimalRoots<C>(genPolynomial, genPolynomial2, list, list2);
        return decimalRoots;
    }

    public static <C extends GcdRingElem<C> & Rational> DecimalRoots<C> decimalRoots(AlgebraicRoots<C> algebraicRoots, BigRational bigRational) {
        DecimalRoots noConvergenceException;
        RealRootsSturm realRootsSturm = new RealRootsSturm();
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>(algebraicRoots.real.size());
        for (RealAlgebraicNumber serializable2 : algebraicRoots.real) {
            try {
                noConvergenceException = realRootsSturm.approximateRoot(serializable2.ring.root, algebraicRoots.p, bigRational);
                arrayList.add((BigDecimal)((Object)noConvergenceException));
            }
            catch (NoConvergenceException noConvergenceException2) {
                System.out.println("should not happen: " + noConvergenceException2);
            }
        }
        ComplexRootsSturm complexRootsSturm = new ComplexRootsSturm(algebraicRoots.cp.ring.coFac);
        ArrayList<Complex<BigDecimal>> arrayList2 = new ArrayList<Complex<BigDecimal>>(algebraicRoots.complex.size());
        for (ComplexAlgebraicNumber complexAlgebraicNumber : algebraicRoots.complex) {
            try {
                Complex<BigDecimal> noConvergenceException3 = complexRootsSturm.approximateRoot(complexAlgebraicNumber.ring.root, algebraicRoots.cp, bigRational);
                arrayList2.add(noConvergenceException3);
            }
            catch (NoConvergenceException noConvergenceException4) {
                System.out.println("should not happen: " + noConvergenceException4);
            }
        }
        noConvergenceException = new DecimalRoots(algebraicRoots.p, algebraicRoots.cp, arrayList, arrayList2);
        return noConvergenceException;
    }
}

