/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.PrimeInteger;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.Power;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CycloUtil {
    private static final Logger logger = LogManager.getLogger(CycloUtil.class);

    public static GenPolynomial<BigInteger> cyclotomicPolynomial(GenPolynomialRing<BigInteger> genPolynomialRing, long l) {
        GenPolynomialRing<BigInteger> genPolynomialRing2 = genPolynomialRing;
        if (genPolynomialRing2 == null) {
            throw new IllegalArgumentException("ring must be non null");
        }
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing2.univariate(0).subtract((BigInteger)genPolynomialRing2.getONE());
        SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(l);
        logger.info("factors = " + sortedMap);
        for (Map.Entry<Long, Integer> entry : sortedMap.entrySet()) {
            long l2 = entry.getKey();
            int n = entry.getValue();
            GenPolynomial<BigInteger> genPolynomial2 = genPolynomial.inflate(l2);
            genPolynomial = genPolynomial2.divide(genPolynomial);
            genPolynomial = genPolynomial.inflate(Power.power(l2, n - 1));
        }
        return genPolynomial;
    }

    public static List<GenPolynomial<BigInteger>> cyclotomicDecompose(GenPolynomialRing<BigInteger> genPolynomialRing, long l) {
        GenPolynomialRing<BigInteger> genPolynomialRing2 = genPolynomialRing;
        if (genPolynomialRing2 == null) {
            throw new IllegalArgumentException("ring must be non null");
        }
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing2.univariate(0).subtract((BigInteger)genPolynomialRing2.getONE());
        ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>();
        arrayList.add(genPolynomial);
        SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(l);
        logger.info("factors = " + sortedMap);
        for (Map.Entry<Long, Integer> entry : sortedMap.entrySet()) {
            long l2 = entry.getKey();
            int n = entry.getValue();
            ArrayList iterable = new ArrayList();
            for (GenPolynomial genPolynomial2 : arrayList) {
                GenPolynomial genPolynomial3 = genPolynomial2.inflate(l2).divide(genPolynomial2);
                iterable.add(genPolynomial3);
            }
            arrayList.addAll(iterable);
            for (int i = 1; i < n; ++i) {
                ArrayList arrayList2 = new ArrayList();
                for (GenPolynomial genPolynomial4 : iterable) {
                    GenPolynomial genPolynomial5 = genPolynomial4.inflate(l2);
                    arrayList2.add(genPolynomial5);
                }
                iterable = arrayList2;
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    public static List<GenPolynomial<BigInteger>> cyclotomicFactors(GenPolynomial<BigInteger> genPolynomial) {
        ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>();
        long l = genPolynomial.degree();
        if (l <= 0L) {
            return arrayList;
        }
        BigInteger bigInteger = genPolynomial.leadingBaseCoefficient();
        BigInteger bigInteger2 = genPolynomial.trailingBaseCoefficient();
        if (!bigInteger.isONE() || !bigInteger2.isONE() && !bigInteger2.negate().isONE()) {
            return arrayList;
        }
        if (genPolynomial.length() != 2) {
            return arrayList;
        }
        GenPolynomialRing<BigInteger> genPolynomialRing = genPolynomial.ring;
        List<GenPolynomial<BigInteger>> list = CycloUtil.cyclotomicDecompose(genPolynomialRing, l);
        if (!bigInteger2.isONE()) {
            return list;
        }
        arrayList = new ArrayList();
        List<GenPolynomial<BigInteger>> list2 = CycloUtil.cyclotomicDecompose(genPolynomialRing, 2L * l);
        for (GenPolynomial<BigInteger> genPolynomial2 : list2) {
            if (list.contains(genPolynomial2)) continue;
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public static boolean isCyclotomicPolynomial(GenPolynomial<BigInteger> genPolynomial) {
        SquarefreeAbstract<BigInteger> squarefreeAbstract;
        long l = genPolynomial.degree();
        if (l <= 0L) {
            return false;
        }
        BigInteger bigInteger = genPolynomial.leadingBaseCoefficient();
        BigInteger bigInteger2 = genPolynomial.trailingBaseCoefficient();
        if (!bigInteger.isONE() || !bigInteger2.isONE() && !bigInteger2.negate().isONE()) {
            return false;
        }
        if (genPolynomial.length() == 2) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("not univariate polynomial");
        }
        Element<GenPolynomial<BigInteger>> element2 = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        GenPolynomial<Element> genPolynomial2 = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        long l2 = l % 2L;
        Object object = genPolynomial.iterator();
        while (object.hasNext()) {
            squarefreeAbstract = object.next();
            ExpVector element3 = ((Monomial)((Object)squarefreeAbstract)).e;
            long l3 = element3.getVal(0);
            ExpVector expVector = element3.subst(0, l3 / 2L);
            if (l3 % 2L == l2) {
                ((GenPolynomial)element2).doPutToMap(expVector, (GenPolynomial<BigInteger>)((Monomial)((Object)squarefreeAbstract)).c);
                continue;
            }
            genPolynomial2.doPutToMap(expVector, (Element)((Monomial)((Object)squarefreeAbstract)).c);
        }
        AbelianGroupElem abelianGroupElem = ((GenPolynomial)(element2 = ((GenPolynomial)element2).multiply((GenPolynomial<BigInteger>)element2))).subtract((genPolynomial2 = genPolynomial2.multiply((Element)genPolynomial2)).multiply((ExpVector)(object = ExpVector.create(1, 0, 1L)))).abs();
        if (((GenPolynomial)abelianGroupElem).equals(genPolynomial)) {
            return true;
        }
        element2 = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l4 = expVector.getVal(0);
            if (l4 % 2L == 1L) {
                ((GenPolynomial)element2).doPutToMap(expVector, (GenPolynomial<BigInteger>)((Object)((BigInteger)monomial.c).negate()));
                continue;
            }
            ((GenPolynomial)element2).doPutToMap(expVector, (GenPolynomial<BigInteger>)monomial.c);
        }
        if (((GenPolynomial)abelianGroupElem).equals(element2 = ((GenPolynomial)element2).abs()) && CycloUtil.isCyclotomicPolynomial(element2)) {
            return true;
        }
        squarefreeAbstract = SquarefreeFactory.getImplementation(bigInteger);
        GenPolynomial<BigInteger> genPolynomial3 = squarefreeAbstract.squarefreePart((GenPolynomial<BigInteger>)abelianGroupElem);
        return genPolynomial3.multiply((BigInteger)((Object)genPolynomial3)).equals(abelianGroupElem) && CycloUtil.isCyclotomicPolynomial(genPolynomial3);
    }
}

