/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactorFraction<C extends GcdRingElem<C>, D extends GcdRingElem<D> & QuotPair<GenPolynomial<C>>> {
    private static final Logger logger = LogManager.getLogger(FactorFraction.class);
    protected final QuotPairFactory<GenPolynomial<C>, D> qfac;
    protected final FactorAbstract<C> nengine;

    protected FactorFraction() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorFraction(QuotPairFactory<GenPolynomial<C>, D> quotPairFactory) {
        this(quotPairFactory, FactorFactory.getImplementation(((GenPolynomialRing)quotPairFactory.pairFactory()).coFac));
    }

    public FactorFraction(QuotPairFactory<GenPolynomial<C>, D> quotPairFactory, FactorAbstract<C> factorAbstract) {
        this.qfac = quotPairFactory;
        this.nengine = factorAbstract;
        logger.info("qfac.fac: " + this.qfac.pairFactory().toScript());
    }

    public String toString() {
        return this.getClass().getName();
    }

    public boolean isIrreducible(D d) {
        SortedMap<D, Long> sortedMap = this.factors(d);
        for (Comparable<Long> comparable : sortedMap.values()) {
            if (comparable != null && comparable == 1L) continue;
            return false;
        }
        if (sortedMap.size() <= 1) {
            return true;
        }
        if (sortedMap.size() == 2) {
            Comparable<Long> comparable;
            ArrayList<D> arrayList = new ArrayList<D>(sortedMap.keySet());
            comparable = (GcdRingElem)arrayList.get(0);
            GcdRingElem gcdRingElem = (GcdRingElem)arrayList.get(1);
            return ((GenPolynomial)((QuotPair)((Object)comparable)).numerator()).isONE() && ((GenPolynomial)((QuotPair)((Object)gcdRingElem)).denominator()).isONE() || ((GenPolynomial)((QuotPair)((Object)gcdRingElem)).numerator()).isONE() && ((GenPolynomial)((QuotPair)((Object)comparable)).denominator()).isONE();
        }
        if (sortedMap.size() > 2) {
            return false;
        }
        return false;
    }

    public boolean isReducible(D d) {
        return !this.isIrreducible(d);
    }

    public SortedMap<D, Long> factors(D d) {
        GcdRingElem gcdRingElem;
        SortedMap<GenPolynomial<C>, Long> sortedMap;
        TreeMap<Object, Long> treeMap = new TreeMap<Object, Long>();
        if (d == null) {
            return treeMap;
        }
        GenPolynomial genPolynomial = (GenPolynomial)((QuotPair)d).numerator();
        GenPolynomial genPolynomial2 = (GenPolynomial)((QuotPair)d).denominator();
        if (genPolynomial.isZERO() || genPolynomial2.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isONE() && genPolynomial2.isONE()) {
            treeMap.put(d, 1L);
            return treeMap;
        }
        GenPolynomial genPolynomial3 = (GenPolynomial)this.qfac.pairFactory().getONE();
        if (!genPolynomial.isONE()) {
            sortedMap = this.nengine.factors(genPolynomial);
            for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
                gcdRingElem = (GcdRingElem)this.qfac.create((GenPolynomial<GenPolynomial>)entry.getKey(), genPolynomial3);
                treeMap.put(gcdRingElem, entry.getValue());
            }
        }
        if (!genPolynomial2.isONE()) {
            sortedMap = this.nengine.factors(genPolynomial2);
            for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
                gcdRingElem = (GcdRingElem)this.qfac.create(genPolynomial3, (GenPolynomial<RingElem>)entry.getKey());
                treeMap.put(gcdRingElem, entry.getValue());
            }
        }
        return treeMap;
    }

    public boolean isFactorization(D d, SortedMap<D, Long> sortedMap) {
        boolean bl;
        if (d == null || sortedMap == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (d.isZERO() && sortedMap.size() == 0) {
            return true;
        }
        AbelianGroupElem abelianGroupElem = null;
        for (Map.Entry<D, Long> entry : sortedMap.entrySet()) {
            GcdRingElem gcdRingElem = (GcdRingElem)entry.getKey();
            Long l = entry.getValue();
            long l2 = l;
            GcdRingElem gcdRingElem2 = (GcdRingElem)gcdRingElem.power(l2);
            if (abelianGroupElem == null) {
                abelianGroupElem = gcdRingElem2;
                continue;
            }
            abelianGroupElem = abelianGroupElem.multiply(gcdRingElem2);
        }
        boolean bl2 = bl = d.equals(abelianGroupElem) || d.equals(abelianGroupElem.negate());
        if (!bl) {
            System.out.println("\nfactorization(map): " + bl);
            System.out.println("F = " + sortedMap);
            System.out.println("P = " + d);
            System.out.println("t = " + abelianGroupElem);
        }
        return bl;
    }
}

