/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.PrimeInteger;
import edu.jas.arith.PrimeList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrderByName;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.CycloUtil;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselApprox;
import edu.jas.ufd.HenselMultUtil;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import edu.jas.ufd.TrialParts;
import edu.jas.util.KsubSet;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactorInteger<MOD extends GcdRingElem<MOD> & Modular>
extends FactorAbstract<edu.jas.arith.BigInteger> {
    private static final Logger logger = LogManager.getLogger(FactorInteger.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final FactorAbstract<MOD> mfactor;
    protected final GreatestCommonDivisorAbstract<MOD> mengine;

    public FactorInteger() {
        this(edu.jas.arith.BigInteger.ONE);
    }

    public FactorInteger(RingFactory<edu.jas.arith.BigInteger> ringFactory) {
        super(ringFactory);
        ModularRingFactory modularRingFactory = new ModLongRing(13L, true);
        this.mfactor = FactorFactory.getImplementation(modularRingFactory);
        this.mengine = GCDFactory.getImplementation(modularRingFactory);
    }

    @Override
    public boolean isIrreducible(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        if (genPolynomial.ring.nvar == 1 && this.isIrreducibleEisenstein(genPolynomial)) {
            return true;
        }
        return super.isIrreducible(genPolynomial);
    }

    public boolean isIrreducibleEisenstein(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        if (genPolynomial.ring.nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (genPolynomial.degree(0) <= 1L) {
            return true;
        }
        edu.jas.arith.BigInteger bigInteger = this.engine.baseContent(genPolynomial.reductum());
        if (bigInteger.isZERO() || bigInteger.isONE()) {
            return false;
        }
        if (bigInteger.compareTo(edu.jas.arith.BigInteger.valueOf(PrimeInteger.BETA)) >= 0) {
            return false;
        }
        long l = bigInteger.getVal().longValue();
        edu.jas.arith.BigInteger bigInteger2 = genPolynomial.leadingBaseCoefficient().abs();
        edu.jas.arith.BigInteger bigInteger3 = genPolynomial.trailingBaseCoefficient().abs();
        SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(l);
        for (Long l2 : sortedMap.keySet()) {
            edu.jas.arith.BigInteger bigInteger4 = edu.jas.arith.BigInteger.valueOf(l2);
            if (bigInteger2.remainder(bigInteger4).isZERO() || bigInteger3.remainder((edu.jas.arith.BigInteger)bigInteger4.power(2L)).isZERO()) continue;
            logger.info("isIrreducibleEisenstein: fac = " + sortedMap + ", lc = " + bigInteger2 + ", tc = " + bigInteger3);
            return true;
        }
        return false;
    }

    @Override
    public List<GenPolynomial<edu.jas.arith.BigInteger>> baseFactorsSquarefree(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        List<GenPolynomial<Object>> list;
        block32: {
            Iterable<Element<ExpVector>> iterable;
            Serializable serializable;
            int n;
            if (genPolynomial == null) {
                throw new IllegalArgumentException(this.getClass().getName() + " P == null");
            }
            list = new ArrayList();
            if (genPolynomial.isZERO()) {
                return list;
            }
            if (genPolynomial.isONE()) {
                list.add(genPolynomial);
                return list;
            }
            GenPolynomialRing genPolynomialRing = genPolynomial.ring;
            if (genPolynomialRing.nvar > 1) {
                throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
            }
            if (!this.engine.baseContent(genPolynomial).isONE()) {
                throw new IllegalArgumentException(this.getClass().getName() + " P not primitive");
            }
            if (genPolynomial.degree(0) <= 1L) {
                list.add(genPolynomial);
                return this.normalizeFactorization(list);
            }
            if (this.isIrreducibleEisenstein(genPolynomial)) {
                list.add(genPolynomial);
                return this.normalizeFactorization(list);
            }
            list = CycloUtil.cyclotomicFactors(genPolynomial);
            if (list.size() > 0) {
                logger.info("cyclotomicFactors: #factors = " + list.size());
                return this.normalizeFactorization(list);
            }
            edu.jas.arith.BigInteger bigInteger = genPolynomial.maxNorm();
            edu.jas.arith.BigInteger bigInteger2 = genPolynomial.leadingBaseCoefficient();
            ExpVector expVector = genPolynomial.degreeVector();
            int n2 = (int)genPolynomial.degree(0);
            edu.jas.arith.BigInteger bigInteger3 = bigInteger.multiply(PolyUtil.factorBound(expVector));
            bigInteger3 = bigInteger3.multiply(bigInteger2.abs().multiply(bigInteger2.fromInteger(8L)));
            PrimeList primeList = new PrimeList(PrimeList.Range.small);
            int n3 = 30;
            Iterable<ModLong> iterable2 = null;
            GenPolynomial<MonoidElem> genPolynomial2 = null;
            GenPolynomialRing<ModLong> genPolynomialRing2 = null;
            int n4 = 5;
            if (n2 > 100) {
                n4 += 2;
            }
            List[] listArray = new List[n4];
            List[] listArray2 = new List[n4];
            edu.jas.arith.BigInteger[] bigIntegerArray = new edu.jas.arith.BigInteger[n4];
            List list2 = null;
            Object var19_19 = null;
            int n5 = 0;
            if (debug) {
                logger.debug("an  = " + bigInteger);
                logger.debug("ac  = " + bigInteger2);
                logger.debug("M   = " + bigInteger3);
                logger.info("degv = " + expVector);
            }
            Iterator<BigInteger> iterator = primeList.iterator();
            iterator.next();
            iterator.next();
            MonoidElem monoidElem = null;
            for (n = 0; n < n4; ++n) {
                if (n == n4 - 1) {
                    primeList = new PrimeList(PrimeList.Range.medium);
                    iterator = primeList.iterator();
                }
                while (iterator.hasNext()) {
                    serializable = iterator.next();
                    if (++n5 >= n3) {
                        logger.error("prime list exhausted, pn = " + n3);
                        throw new ArithmeticException("prime list exhausted");
                    }
                    iterable2 = ModLongRing.MAX_LONG.compareTo((BigInteger)serializable) > 0 ? new ModLongRing((BigInteger)serializable, true) : new ModIntegerRing((BigInteger)serializable, true);
                    logger.info("prime = " + iterable2);
                    monoidElem = (GcdRingElem)iterable2.fromInteger(bigInteger2.getVal());
                    if (monoidElem.isZERO()) {
                        logger.info("unlucky prime (nf) = " + serializable);
                        continue;
                    }
                    genPolynomialRing2 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable2), genPolynomialRing);
                    genPolynomial2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
                    if (!genPolynomial2.degreeVector().equals(expVector)) {
                        logger.info("unlucky prime (deg) = " + serializable);
                        continue;
                    }
                    GenPolynomial<MonoidElem> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
                    if (genPolynomial3.isZERO()) {
                        logger.info("unlucky prime (a')= " + serializable);
                        continue;
                    }
                    iterable = this.mengine.baseGcd(genPolynomial2, genPolynomial3);
                    if (!((GenPolynomial)iterable).isONE()) continue;
                    logger.info("**lucky prime = " + serializable);
                    break;
                }
                if (!monoidElem.isONE()) {
                    genPolynomial2 = genPolynomial2.divide(monoidElem);
                }
                list2 = this.mfactor.baseFactorsSquarefree(genPolynomial2);
                if (logger.isInfoEnabled()) {
                    logger.info("modlist  = " + list2);
                }
                if (list2.size() <= 1) {
                    list.add(genPolynomial);
                    return list;
                }
                if (!monoidElem.isONE()) {
                    serializable = genPolynomialRing2.getONE();
                    serializable = ((GenPolynomial)serializable).multiply(monoidElem);
                    list2.add(0, (GenPolynomial<MonoidElem>)serializable);
                }
                listArray[n] = list2;
                bigIntegerArray[n] = iterable2.getIntegerModul();
            }
            n = Integer.MAX_VALUE;
            serializable = null;
            for (int i = 0; i < n4; ++i) {
                iterable = PolyUtil.leadingExpVector(listArray[i]);
                BitSet bitSet = this.factorDegrees((List<ExpVector>)iterable, n2);
                if (serializable == null) {
                    serializable = bitSet;
                } else {
                    ((BitSet)serializable).and(bitSet);
                }
                int n6 = listArray[i].size();
                logger.info("mod(" + bigIntegerArray[i] + ") #s = " + n6 + ", D = " + bitSet);
                if (n6 >= n) continue;
                n = n6;
                list2 = listArray[i];
            }
            logger.info("min = " + n + ", AD = " + serializable);
            if (list2.size() <= 1) {
                logger.info("mlist.size() = 1");
                list.add(genPolynomial);
                return list;
            }
            if (((BitSet)serializable).cardinality() <= 2) {
                logger.info("degree set cardinality = " + ((BitSet)serializable).cardinality());
                list.add(genPolynomial);
                return list;
            }
            if (debug) {
                logger.info("lifting shortest from " + list2);
            }
            if (genPolynomial.leadingBaseCoefficient().isONE()) {
                long l = System.currentTimeMillis();
                try {
                    list2 = PolyUtil.monic(list2);
                    list = this.searchFactorsMonic(genPolynomial, bigInteger3, list2, (BitSet)serializable);
                    l = System.currentTimeMillis() - l;
                    listArray2[0] = list;
                    if (!debug) break block32;
                    l = System.currentTimeMillis();
                    List<GenPolynomial<edu.jas.arith.BigInteger>> list3 = this.searchFactorsNonMonic(genPolynomial, bigInteger3, list2, (BitSet)serializable);
                    l = System.currentTimeMillis() - l;
                    System.out.println("non monic time = " + l);
                    if (!list.equals(list3)) {
                        System.out.println("monic factors     = " + listArray2[0]);
                        System.out.println("non monic factors = " + list3);
                    }
                }
                catch (RuntimeException runtimeException) {
                    l = System.currentTimeMillis();
                    list = this.searchFactorsNonMonic(genPolynomial, bigInteger3, list2, (BitSet)serializable);
                    l = System.currentTimeMillis() - l;
                }
            } else {
                long l = System.currentTimeMillis();
                list = this.searchFactorsNonMonic(genPolynomial, bigInteger3, list2, (BitSet)serializable);
                l = System.currentTimeMillis() - l;
            }
        }
        return this.normalizeFactorization(list);
    }

    public BitSet factorDegrees(List<ExpVector> list, int n) {
        BitSet bitSet = new BitSet(n + 1);
        bitSet.set(0);
        for (ExpVector expVector : list) {
            int n2 = (int)expVector.getVal(0);
            BitSet bitSet2 = new BitSet(n + 1);
            for (int i = 0; i < n + 1 - n2; ++i) {
                bitSet2.set(n2 + i, bitSet.get(i));
            }
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    public static <C extends RingElem<C>> long degreeSum(List<GenPolynomial<C>> list) {
        long l = 0L;
        for (GenPolynomial<C> genPolynomial : list) {
            ExpVector expVector = genPolynomial.leadingExpVector();
            long l2 = expVector.getVal(0);
            l += l2;
        }
        return l;
    }

    List<GenPolynomial<edu.jas.arith.BigInteger>> searchFactorsMonic(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial, edu.jas.arith.BigInteger bigInteger, List<GenPolynomial<MOD>> list, BitSet bitSet) {
        List<GenPolynomial<Object>> list2;
        if (genPolynomial == null || genPolynomial.isZERO() || list == null || list.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList arrayList = new ArrayList(list.size());
        List<GenPolynomial<MOD>> list3 = list;
        GenPolynomial<MOD> genPolynomial2 = list3.get(0);
        if (genPolynomial2.isConstant()) {
            list3.remove(genPolynomial2);
            if (list3.size() <= 1) {
                arrayList.add(genPolynomial);
                return arrayList;
            }
        }
        ModularRingFactory modularRingFactory = (ModularRingFactory)genPolynomial2.ring.coFac;
        edu.jas.arith.BigInteger bigInteger2 = modularRingFactory.getIntegerModul();
        long l = 1L;
        edu.jas.arith.BigInteger bigInteger3 = bigInteger2;
        while (bigInteger3.compareTo(bigInteger) < 0) {
            ++l;
            bigInteger3 = bigInteger3.multiply(bigInteger2);
        }
        logger.info("p^k = " + bigInteger2 + "^" + l);
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial3 = genPolynomial;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial4 = genPolynomial;
        try {
            list2 = HenselUtil.liftHenselMonic(genPolynomial3, list3, l);
        }
        catch (NoLiftingException noLiftingException) {
            throw new RuntimeException(noLiftingException);
        }
        if (logger.isInfoEnabled()) {
            logger.info("lifted modlist = " + list2);
        }
        GenPolynomialRing genPolynomialRing2 = list2.get((int)0).ring;
        int n = (list2.size() + 1) / 2;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial5 = genPolynomial3;
        long l2 = (genPolynomial5.degree(0) + 1L) / 2L;
        block3: for (int i = 1; i <= n; ++i) {
            KsubSet<GenPolynomial<MOD>> ksubSet = new KsubSet<GenPolynomial<MOD>>(list2, i);
            for (List list4 : ksubSet) {
                if (!bitSet.get((int)FactorInteger.degreeSum(list4))) {
                    logger.info("skipped by degree set " + bitSet + ", deg = " + FactorInteger.degreeSum(list4));
                    continue;
                }
                GenPolynomial genPolynomial6 = Power.multiply(genPolynomialRing2, list4);
                if (genPolynomial6.degree(0) > l2) {
                    logger.info("degree " + genPolynomial6.degree(0) + " > deg " + l2);
                }
                GenPolynomial<edu.jas.arith.BigInteger> genPolynomial7 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial6);
                if (!PolyUtil.baseSparsePseudoRemainder(genPolynomial5, genPolynomial7 = this.engine.basePrimitivePart(genPolynomial7)).isZERO()) continue;
                logger.info("successful trial = " + genPolynomial7);
                arrayList.add(genPolynomial7);
                genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial5, genPolynomial7);
                list2 = FactorInteger.removeOnce(list2, list4);
                logger.info("new lift= " + list2);
                n = (list2.size() + 1) / 2;
                i = 0;
                continue block3;
            }
        }
        if (!genPolynomial5.isONE() && !genPolynomial5.equals(genPolynomial4)) {
            logger.info("rest u = " + genPolynomial5);
            arrayList.add(genPolynomial5);
        }
        if (arrayList.size() == 0) {
            logger.info("irred u = " + genPolynomial5);
            arrayList.add(genPolynomial3);
        }
        return this.normalizeFactorization(arrayList);
    }

    List<GenPolynomial<edu.jas.arith.BigInteger>> searchFactorsNonMonic(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial, edu.jas.arith.BigInteger bigInteger, List<GenPolynomial<MOD>> list, BitSet bitSet) {
        if (genPolynomial == null || genPolynomial.isZERO() || list == null || list.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList arrayList = new ArrayList(list.size());
        List<GenPolynomial<Object>> list2 = list;
        GcdRingElem gcdRingElem = null;
        GenPolynomial<MOD> genPolynomial2 = list2.get(0);
        if (genPolynomial2.isConstant()) {
            gcdRingElem = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
            list2.remove(genPolynomial2);
            if (list2.size() <= 1) {
                arrayList.add(genPolynomial);
                return arrayList;
            }
        } else {
            gcdRingElem = (GcdRingElem)genPolynomial2.ring.coFac.getONE();
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        GenPolynomial<GcdRingElem> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial4 = genPolynomial;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial5 = genPolynomial;
        int n = (list2.size() + 1) / 2;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial6 = genPolynomial4;
        long l = (genPolynomial6.degree(0) + 1L) / 2L;
        GenPolynomial<GcdRingElem> genPolynomial7 = genPolynomial3;
        HenselApprox<GcdRingElem> henselApprox = null;
        block2: for (int i = 1; i <= n; ++i) {
            KsubSet<GenPolynomial<MOD>> ksubSet = new KsubSet<GenPolynomial<MOD>>(list2, i);
            for (List list3 : ksubSet) {
                GenPolynomial<Object> genPolynomial8;
                if (!bitSet.get((int)FactorInteger.degreeSum(list3))) {
                    logger.info("skipped by degree set " + bitSet + ", deg = " + FactorInteger.degreeSum(list3));
                    continue;
                }
                GenPolynomial genPolynomial9 = ((GenPolynomial)genPolynomialRing2.getONE()).multiply(gcdRingElem);
                for (int j = 0; j < list3.size(); ++j) {
                    genPolynomial8 = list3.get(j);
                    genPolynomial9 = genPolynomial9.multiply(genPolynomial8);
                }
                if (genPolynomial9.degree(0) > l) {
                    logger.info("degree > deg " + l + ", degree = " + genPolynomial9.degree(0));
                }
                GenPolynomial<GcdRingElem> genPolynomial10 = genPolynomial7.divide(genPolynomial9);
                try {
                    henselApprox = HenselUtil.liftHenselQuadratic(genPolynomial4, bigInteger, genPolynomial9, genPolynomial10);
                }
                catch (NoLiftingException noLiftingException) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.info("no liftable factors " + noLiftingException);
                    continue;
                }
                genPolynomial8 = henselApprox.A;
                GenPolynomial<edu.jas.arith.BigInteger> genPolynomial11 = henselApprox.B;
                if (logger.isDebugEnabled()) {
                    logger.info("       modlist = " + genPolynomial9 + ", cofactor " + genPolynomial10);
                    logger.info("lifted intlist = " + genPolynomial8 + ", cofactor " + genPolynomial11);
                }
                if (!PolyUtil.baseSparsePseudoRemainder(genPolynomial6, genPolynomial8 = this.engine.basePrimitivePart(genPolynomial8)).isZERO()) continue;
                logger.info("successful trial = " + genPolynomial8);
                arrayList.add(genPolynomial8);
                genPolynomial4 = genPolynomial6 = genPolynomial11;
                genPolynomial7 = genPolynomial10;
                list2 = FactorInteger.removeOnce(list2, list3);
                logger.info("new mlist= " + list2);
                n = (list2.size() + 1) / 2;
                i = 0;
                continue block2;
            }
        }
        if (!genPolynomial6.isONE() && !genPolynomial6.equals(genPolynomial5)) {
            logger.info("rest u = " + genPolynomial6);
            arrayList.add(genPolynomial6);
        }
        if (arrayList.size() == 0) {
            logger.info("irred u = " + genPolynomial4);
            arrayList.add(genPolynomial4);
        }
        return this.normalizeFactorization(arrayList);
    }

    @Override
    public List<GenPolynomial<edu.jas.arith.BigInteger>> factorsSquarefree(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        GenPolynomial genPolynomial2 = genPolynomial;
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseFactorsSquarefree(genPolynomial2);
        }
        boolean bl = true;
        if (genPolynomialRing.tord.equals(TermOrderByName.INVLEX)) {
            bl = false;
        } else {
            genPolynomialRing = new GenPolynomialRing(genPolynomialRing, TermOrderByName.INVLEX);
            genPolynomial2 = genPolynomialRing.copy(genPolynomial2);
            logger.warn("invlexed polynomial: " + genPolynomial2 + ", from ring " + genPolynomial.ring);
        }
        OptimizedPolynomialList optimizedPolynomialList = null;
        List<Integer> list = null;
        Serializable serializable = new ArrayList(1);
        serializable.add(genPolynomial2);
        optimizedPolynomialList = TermOrderOptimization.optimizeTermOrder(genPolynomialRing, serializable);
        if (!TermOrderOptimization.isIdentityPermutation(optimizedPolynomialList.perm)) {
            list = TermOrderOptimization.inversePermutation(optimizedPolynomialList.perm);
            genPolynomial2 = (GenPolynomial)optimizedPolynomialList.list.get(0);
            logger.info("optimized polynomial: " + genPolynomial2);
            logger.warn("optimized ring: " + optimizedPolynomialList.ring + ", original ring: " + genPolynomialRing);
        }
        serializable = genPolynomial2.degreeVector();
        int[] nArray = ((ExpVector)serializable).dependencyOnVariables();
        List<GenPolynomial<edu.jas.arith.BigInteger>> list2 = null;
        if (((ExpVector)serializable).length() == nArray.length) {
            try {
                logger.info("try factorsSquarefreeHensel: " + genPolynomial2);
                list2 = this.factorsSquarefreeHensel(genPolynomial2);
            }
            catch (Exception exception) {
                logger.info("exception " + exception);
            }
        } else {
            GenPolynomial<edu.jas.arith.BigInteger> genPolynomial3 = PolyUtil.removeUnusedUpperVariables(genPolynomial2);
            try {
                logger.info("try factorsSquarefreeHensel: " + genPolynomial3);
                list2 = this.factorsSquarefreeHensel(genPolynomial3);
                ArrayList<GenPolynomial<edu.jas.arith.BigInteger>> arrayList = new ArrayList<GenPolynomial<edu.jas.arith.BigInteger>>(list2.size());
                GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
                for (GenPolynomial<edu.jas.arith.BigInteger> genPolynomial4 : list2) {
                    GenPolynomial<edu.jas.arith.BigInteger> genPolynomial5 = genPolynomial4.extend(genPolynomialRing2, 0, 0L);
                    arrayList.add(genPolynomial5);
                }
                list2 = arrayList;
            }
            catch (Exception exception) {
                logger.info("exception " + exception);
            }
        }
        if (list2 == null) {
            logger.warn("factorsSquarefreeHensel not applicable or failed, reverting to Kronecker for: " + genPolynomial2);
            list2 = super.factorsSquarefree(genPolynomial2);
        }
        if (list != null) {
            list2 = TermOrderOptimization.permutation(list, genPolynomialRing, list2);
            logger.warn("de-optimized polynomials: " + list2);
        }
        if (bl) {
            list2 = genPolynomial.ring.copy(list2);
            logger.warn("de-invlexed polynomials: " + list2);
        }
        list2 = this.normalizeFactorization(list2);
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public List<GenPolynomial<edu.jas.arith.BigInteger>> factorsSquarefreeHensel(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        List<GenPolynomial<ModLong>> list;
        void var52_89;
        GcdRingElem<edu.jas.arith.BigInteger> gcdRingElem;
        Iterable<ModLong> iterable;
        Comparable<BigInteger> comparable;
        Iterable iterable2;
        GenPolynomial genPolynomial2;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing<edu.jas.arith.BigInteger> genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar == 1) {
            return this.baseFactorsSquarefree(genPolynomial);
        }
        List<GenPolynomial<edu.jas.arith.BigInteger>> list2 = new ArrayList<GenPolynomial<edu.jas.arith.BigInteger>>();
        if (genPolynomial.isZERO()) {
            return list2;
        }
        if (genPolynomial.degreeVector().totalDeg() <= 1L) {
            list2.add(genPolynomial);
            return list2;
        }
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial3 = genPolynomial;
        edu.jas.arith.BigInteger bigInteger = genPolynomial3.leadingBaseCoefficient();
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(genPolynomialRing.nvar - 1);
        GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing2, genPolynomial3);
        GenPolynomial genPolynomial5 = PolyUtil.switchVariables(genPolynomial4);
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial6 = this.engine.recursiveContent(genPolynomial5);
        List<GenPolynomial<edu.jas.arith.BigInteger>> list3 = null;
        if (!genPolynomial6.isONE()) {
            genPolynomial5 = PolyUtil.recursiveDivide(genPolynomial5, genPolynomial6);
            genPolynomial2 = genPolynomial6.extendLower(genPolynomialRing, 0, 0L);
            genPolynomial3 = PolyUtil.basePseudoDivide(genPolynomial3, genPolynomial2);
            logger.info("recursive content = " + genPolynomial6 + ", new P = " + genPolynomial3);
            list3 = this.factorsSquarefree(genPolynomial6);
            ArrayList<GenPolynomial<edu.jas.arith.BigInteger>> arrayList = new ArrayList<GenPolynomial<edu.jas.arith.BigInteger>>(list3.size());
            for (GenPolynomial iterable32 : list3) {
                iterable2 = iterable32.extendLower(genPolynomialRing, 0, 0L);
                arrayList.add((GenPolynomial<edu.jas.arith.BigInteger>)iterable2);
            }
            list3 = arrayList;
            logger.info("cfactors = " + list3);
        }
        genPolynomial2 = genPolynomial5.leadingBaseCoefficient();
        logger.info("leading coeffcient = " + genPolynomial2);
        boolean bl = false;
        if (genPolynomial2.isConstant()) {
            bl = true;
        }
        SortedMap sortedMap = this.factors(genPolynomial2);
        ArrayList arrayList = new ArrayList(sortedMap.keySet());
        logger.info("leading coefficient factors = " + arrayList);
        iterable2 = genPolynomialRing;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial7 = genPolynomial3;
        GenPolynomialRing genPolynomialRing3 = genPolynomial2.ring;
        List<GenPolynomial<Object>> list4 = arrayList;
        List<GenPolynomial<Object>> list5 = null;
        List<edu.jas.arith.BigInteger> list6 = null;
        ArrayList<edu.jas.arith.BigInteger> arrayList2 = new ArrayList<edu.jas.arith.BigInteger>();
        GcdRingElem<edu.jas.arith.BigInteger> gcdRingElem2 = null;
        edu.jas.arith.BigInteger bigInteger2 = null;
        edu.jas.arith.BigInteger bigInteger3 = null;
        List<GenPolynomial<edu.jas.arith.BigInteger>> list7 = null;
        ArrayList<TrialParts> arrayList3 = new ArrayList<TrialParts>();
        List<GenPolynomial<edu.jas.arith.BigInteger>> list8 = null;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial8 = null;
        ArrayList<Comparable<Comparable<BigInteger>>> arrayList4 = null;
        ArrayList<Object> arrayList5 = null;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial9 = null;
        List<Object> list9 = null;
        long l = 0L;
        ArrayList<Long> arrayList6 = new ArrayList<Long>(genPolynomialRing.nvar + 1);
        for (int i = 0; i <= genPolynomialRing.nvar; ++i) {
            arrayList6.add(l++);
        }
        l = (Long)arrayList6.get(0);
        int n = 0;
        double d = 1.001;
        boolean bl2 = true;
        boolean bl3 = true;
        while (bl3) {
            RingElem<edu.jas.arith.BigInteger> ringElem;
            int n2;
            int list92;
            if (Math.abs(l) > 371L) {
                logger.warn("found         points   : V = " + list9 + ", dei = " + arrayList2);
                logger.warn("no evaluation point for: P = " + genPolynomial + ", prr = " + genPolynomial5 + ", lprr = " + genPolynomial2 + ", lfacs = " + arrayList);
                throw new RuntimeException("no evaluation point found after " + Math.abs(l) + " iterations");
            }
            if (Math.abs(l) % 100L <= 3L) {
                d *= 1.001592653589793;
            }
            bl3 = false;
            list9 = new ArrayList();
            iterable2 = genPolynomialRing;
            genPolynomial7 = genPolynomial3;
            genPolynomialRing3 = genPolynomial2.ring;
            list4 = arrayList;
            list5 = null;
            list6 = null;
            gcdRingElem2 = null;
            bigInteger3 = null;
            long n6 = 0L;
            for (list92 = genPolynomialRing.nvar; list92 > 1; --list92) {
                long l2 = genPolynomial7.degree(((GenPolynomialRing)iterable2).nvar - 2);
                iterable2 = ((GenPolynomialRing)iterable2).contract(1);
                genPolynomialRing3 = genPolynomialRing3.contract(1);
                n6 = (Long)arrayList6.get(list92);
                n2 = 1;
                ringElem = null;
                GenPolynomial<edu.jas.arith.BigInteger> genPolynomial10 = null;
                while (n2 != 0) {
                    logger.info("vi(" + list92 + ") = " + n6);
                    ringElem = new edu.jas.arith.BigInteger(n6);
                    genPolynomial10 = PolyUtil.evaluateMain(iterable2, genPolynomial7, ringElem);
                    if (l2 == genPolynomial10.degree(((GenPolynomialRing)iterable2).nvar - 1)) {
                        logger.info("pep = " + genPolynomial10);
                        if (this.sengine.isSquarefree(genPolynomial10)) {
                            n2 = 0;
                        } else {
                            logger.info("pep not squarefree ");
                        }
                    }
                    if (n6 > 0L) {
                        n6 = -n6;
                        continue;
                    }
                    n6 = 1L - n6;
                }
                if (genPolynomialRing3.nvar >= 1) {
                    list5 = PolyUtil.evaluateMain(genPolynomialRing3, list4, ringElem);
                } else {
                    list6 = PolyUtil.evaluateMain(genPolynomialRing3.coFac, list4, ringElem);
                }
                int n3 = (int)Math.round(d + 0.52 * Math.random());
                if (n6 > 0L) {
                    arrayList6.set(list92, n6 + (long)n3);
                    l = n6 + (long)n3;
                } else {
                    arrayList6.set(list92, n6 - (long)n3);
                    l = n6 - (long)n3;
                }
                HashSet<Long> hashSet = new HashSet<Long>(arrayList6);
                while (hashSet.size() != arrayList6.size()) {
                    long l3 = (Long)arrayList6.get(list92);
                    l3 = l3 > 0L ? ++l3 : --l3;
                    arrayList6.set(list92, l3);
                    hashSet.clear();
                    hashSet.addAll(arrayList6);
                    l = l3;
                }
                list9.add(ringElem);
                genPolynomial7 = genPolynomial10;
                list4 = list5;
            }
            bigInteger2 = this.engine.baseContent(genPolynomial7);
            bl2 = bigInteger2.isONE();
            bigInteger3 = (edu.jas.arith.BigInteger)genPolynomialRing3.coFac.getONE();
            gcdRingElem2 = (edu.jas.arith.BigInteger)genPolynomial7.ring.coFac.getONE();
            if (!bl) {
                gcdRingElem2 = n > 50 ? (edu.jas.arith.BigInteger)genPolynomial7.ring.coFac.getONE() : bigInteger2;
                if (((GenPolynomial)arrayList.get(0)).isConstant()) {
                    bigInteger3 = list6.remove(0);
                }
                arrayList2 = new ArrayList();
                arrayList2.add(gcdRingElem2.multiply(bigInteger3).abs());
                list92 = 1;
                for (edu.jas.arith.BigInteger bigInteger4 : list6) {
                    if (bigInteger4.isZERO()) {
                        logger.info("condition (0) not met for cei = " + list6);
                        bl3 = true;
                        break;
                    }
                    ringElem = bigInteger4.abs();
                    for (n2 = list92 - 1; n2 >= 0; --n2) {
                        edu.jas.arith.BigInteger bigInteger5 = (edu.jas.arith.BigInteger)arrayList2.get(n2);
                        while (!bigInteger5.isONE()) {
                            bigInteger5 = bigInteger5.gcd((edu.jas.arith.BigInteger)ringElem);
                            ringElem = ((edu.jas.arith.BigInteger)ringElem).divide(bigInteger5);
                        }
                    }
                    arrayList2.add((edu.jas.arith.BigInteger)ringElem);
                    if (((edu.jas.arith.BigInteger)ringElem).isONE()) {
                        logger.info("condition (1) not met for dei = " + arrayList2 + ", cei = " + list6);
                        if (!this.testSeparate(list6, bigInteger2) && ++n > 50) {
                            logger.info("too many inseparable evaluation points: " + n + ", removing " + bigInteger2);
                        }
                        bl3 = true;
                        break;
                    }
                    ++list92;
                }
            }
            if (bl3) continue;
            logger.info("evaluation points  = " + list9 + ", dei = " + arrayList2);
            logger.info("univariate polynomial = " + genPolynomial7 + ", pecw = " + bigInteger2);
            list7 = this.baseFactorsSquarefree(genPolynomial7.divide(bigInteger2));
            if (!bigInteger2.isONE()) {
                list7.add(0, ((GenPolynomial)((GenPolynomialRing)iterable2).getONE()).multiply(bigInteger2));
            }
            if (list7.size() <= 1) {
                logger.info("irreducible univariate polynomial");
                list2.add(genPolynomial3);
                if (list3 != null) {
                    list3.addAll(list2);
                    list2 = list3;
                }
                return list2;
            }
            logger.info("univariate factors = " + list7);
            list8 = new ArrayList<GenPolynomial<edu.jas.arith.BigInteger>>();
            genPolynomial8 = genPolynomial2.ring.getONE();
            for (list92 = 0; list92 < list7.size(); ++list92) {
                list8.add((GenPolynomial<edu.jas.arith.BigInteger>)genPolynomial2.ring.getONE());
            }
            if (!bl || !bigInteger2.isONE()) {
                if (arrayList.size() > 0 && ((GenPolynomial)arrayList.get(0)).isConstant()) {
                    arrayList.remove(0);
                }
                for (list92 = list7.size() - 1; list92 >= 0; --list92) {
                    void var48_60;
                    GenPolynomial<edu.jas.arith.BigInteger> list10 = list7.get(list92);
                    edu.jas.arith.BigInteger bigInteger7 = list10.leadingBaseCoefficient();
                    bigInteger7 = bigInteger7.multiply((edu.jas.arith.BigInteger)gcdRingElem2);
                    ringElem = list8.get(list92);
                    n2 = 0;
                    for (edu.jas.arith.BigInteger bigInteger8 : list6) {
                        if (bigInteger8.abs().isONE()) {
                            System.out.println("ppl = " + var48_60 + ", ci = " + bigInteger8 + ", lfp = " + ringElem + ", lfacs.get(ii) = " + arrayList.get(n2));
                            bl3 = true;
                            throw new RuntimeException("something is wrong, ci is a unit");
                        }
                        while (var48_60.remainder(bigInteger8).isZERO() && arrayList.size() > n2) {
                            edu.jas.arith.BigInteger bigInteger9 = var48_60.divide(bigInteger8);
                            ringElem = ((GenPolynomial)ringElem).multiply((edu.jas.arith.BigInteger)((Object)((GenPolynomial)arrayList.get(n2))));
                        }
                        ++n2;
                    }
                    ringElem = ((GenPolynomial)ringElem).multiply((edu.jas.arith.BigInteger)var48_60);
                    list8.set(list92, (GenPolynomial<edu.jas.arith.BigInteger>)ringElem);
                }
                gcdRingElem2 = bigInteger2;
                genPolynomial8 = Power.multiply(genPolynomial2.ring, list8);
                if (!genPolynomial2.degreeVector().equals(genPolynomial8.degreeVector())) {
                    logger.info("deg(lprr) != deg(lpx): lprr = " + genPolynomial2 + ", lpx = " + genPolynomial8);
                    bl3 = true;
                    continue;
                }
                if (!gcdRingElem2.isONE()) {
                    void var48_65;
                    void var48_63;
                    List<GenPolynomial<RingElem<edu.jas.arith.BigInteger>>> trialParts = list8;
                    List<RingElem<edu.jas.arith.BigInteger>> trialParts2 = null;
                    genPolynomialRing3 = genPolynomial2.ring;
                    int n4 = genPolynomial2.ring.nvar;
                    while (var48_63 > 0) {
                        genPolynomialRing3 = genPolynomialRing3.contract(1);
                        ringElem = (edu.jas.arith.BigInteger)list9.get(genPolynomial2.ring.nvar - var48_63);
                        if (genPolynomialRing3.nvar >= 1) {
                            trialParts = PolyUtil.evaluateMain(genPolynomialRing3, trialParts, ringElem);
                        } else {
                            trialParts2 = PolyUtil.evaluateMain(genPolynomialRing3.coFac, trialParts, ringElem);
                        }
                        --var48_63;
                    }
                    arrayList4 = new ArrayList<Comparable<Comparable<BigInteger>>>(list8.size());
                    arrayList5 = new ArrayList<Object>(list8.size());
                    boolean bl4 = false;
                    while (var48_65 < list8.size()) {
                        ringElem = list7.get((int)var48_65);
                        edu.jas.arith.BigInteger bigInteger10 = (edu.jas.arith.BigInteger)((GenPolynomial)ringElem).leadingBaseCoefficient();
                        edu.jas.arith.BigInteger bigInteger11 = (edu.jas.arith.BigInteger)trialParts2.get((int)var48_65);
                        edu.jas.arith.BigInteger bigInteger12 = bigInteger10.gcd(bigInteger11).abs();
                        edu.jas.arith.BigInteger bigInteger13 = bigInteger10.divide(bigInteger12);
                        edu.jas.arith.BigInteger bigInteger14 = bigInteger11.divide(bigInteger12);
                        comparable = list8.get((int)var48_65);
                        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial11 = ((GenPolynomial)comparable).multiply(bigInteger13);
                        iterable = ((GenPolynomial)ringElem).multiply(bigInteger14);
                        if (gcdRingElem2.isONE()) {
                            arrayList4.add(comparable);
                            arrayList5.add(ringElem);
                        } else {
                            arrayList4.add(genPolynomial11);
                            arrayList5.add(iterable);
                            gcdRingElem = gcdRingElem2.divide(bigInteger14);
                            gcdRingElem2 = gcdRingElem;
                        }
                        ++var48_65;
                    }
                    if (!list8.equals(arrayList4) || !arrayList5.equals(list7)) {
                        logger.debug("!lf.equals(ln) || !un.equals(ufactors)");
                    }
                    if (!gcdRingElem2.isONE()) {
                        void var48_67;
                        arrayList4 = new ArrayList(list8.size());
                        arrayList5 = new ArrayList(list8.size());
                        genPolynomial9 = genPolynomial7;
                        boolean bl5 = false;
                        while (var48_67 < list8.size()) {
                            ringElem = list7.get((int)var48_67);
                            GenPolynomial<edu.jas.arith.BigInteger> genPolynomial12 = list8.get((int)var48_67);
                            if (!((GenPolynomial)ringElem).isConstant()) {
                                ringElem = ((GenPolynomial)ringElem).multiply(gcdRingElem2);
                            }
                            genPolynomial12 = genPolynomial12.multiply((edu.jas.arith.BigInteger)gcdRingElem2);
                            if (var48_67 != false) {
                                genPolynomial9 = genPolynomial9.multiply((edu.jas.arith.BigInteger)gcdRingElem2);
                            }
                            arrayList5.add(ringElem);
                            arrayList4.add(genPolynomial12);
                            ++var48_67;
                        }
                        if (genPolynomial9.equals(Power.multiply(genPolynomial7.ring, arrayList5))) {
                            bl2 = false;
                        }
                    }
                }
                logger.info("distributed factors of leading coefficient = " + list8);
                genPolynomial8 = Power.multiply(genPolynomial2.ring, list8);
                if (!((GenPolynomial)genPolynomial2.abs()).equals(genPolynomial8.abs()) && !genPolynomial2.degreeVector().equals(genPolynomial8.degreeVector())) {
                    logger.info("lprr != lpx: lprr = " + genPolynomial2 + ", lpx = " + genPolynomial8);
                    bl3 = true;
                }
            }
            if (bl3) continue;
            TrialParts genPolynomialRing4 = null;
            genPolynomialRing4 = bl2 ? new TrialParts(list9, genPolynomial7, list7, list6, list8) : new TrialParts(list9, genPolynomial9, arrayList5, list6, arrayList4);
            if (genPolynomialRing4.univPoly != null && genPolynomialRing4.ldcfEval.size() != 0) {
                arrayList3.add(genPolynomialRing4);
            }
            if (arrayList3.size() >= 4) continue;
            bl3 = true;
        }
        logger.warn("end notLucky loop, trial parts = " + arrayList3.size());
        int n5 = Integer.MAX_VALUE;
        TrialParts trialParts = null;
        for (TrialParts trialParts3 : arrayList3) {
            if (trialParts3.univFactors.size() >= n5) continue;
            n5 = trialParts3.univFactors.size();
            trialParts = trialParts3;
        }
        for (TrialParts primeList : arrayList3) {
            if (primeList.univFactors.size() != n5 || primeList.univFactors.get(0).isConstant()) continue;
            logger.info("tp.univFactors = " + primeList.univFactors);
            trialParts = primeList;
            break;
        }
        list9 = trialParts.evalPoints;
        genPolynomial7 = trialParts.univPoly;
        list7 = trialParts.univFactors;
        list6 = trialParts.ldcfEval;
        list8 = trialParts.ldcfFactors;
        logger.info("iterations    = " + Math.abs(l));
        logger.info("minimal trial = " + trialParts);
        GenPolynomialRing genPolynomialRing4 = genPolynomial7.ring;
        PrimeList primeList = new PrimeList(PrimeList.Range.medium);
        Iterator<BigInteger> iterator = primeList.iterator();
        int n6 = 50;
        edu.jas.arith.BigInteger bigInteger15 = genPolynomial7.leadingBaseCoefficient();
        GenPolynomial<ModLong> genPolynomial13 = null;
        Object var52_88 = null;
        GenPolynomialRing<ModLong> genPolynomialRing5 = null;
        for (int i = 0; i < 11; ++i) {
            void var48_69;
            comparable = null;
            if (i == 0) {
                primeList = new PrimeList(PrimeList.Range.medium);
                Iterator<BigInteger> iterator2 = primeList.iterator();
            }
            if (i == 5) {
                primeList = new PrimeList(PrimeList.Range.small);
                Iterator<BigInteger> iterator3 = primeList.iterator();
                comparable = iterator3.next();
                comparable = iterator3.next();
                comparable = iterator3.next();
                comparable = iterator3.next();
            }
            if (i == 7) {
                primeList = new PrimeList(PrimeList.Range.large);
                Iterator<BigInteger> iterator4 = primeList.iterator();
            }
            int n7 = 0;
            while (n7 < n6 && var48_69.hasNext()) {
                comparable = (BigInteger)var48_69.next();
                logger.info("prime = " + comparable);
                iterable = null;
                iterable = ModLongRing.MAX_LONG.compareTo((BigInteger)comparable) > 0 ? new ModLongRing((BigInteger)comparable, true) : new ModIntegerRing((BigInteger)comparable, true);
                gcdRingElem = (GcdRingElem)iterable.fromInteger(bigInteger15.getVal());
                if (gcdRingElem.isZERO() || !this.mfactor.isSquarefree(genPolynomial13 = PolyUtil.fromIntegerCoefficients(genPolynomialRing5 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable), genPolynomialRing4), genPolynomial7))) continue;
                Iterable<ModLong> iterable3 = iterable;
                break;
            }
            if (var52_89 != null) break;
        }
        if (var52_89 == null) {
            throw new RuntimeException("giving up on Hensel preparation, no lucky prime found");
        }
        logger.info("lucky prime = " + var52_89.getIntegerModul());
        if (logger.isDebugEnabled()) {
            logger.debug("univariate modulo p: = " + genPolynomial13);
        }
        edu.jas.arith.BigInteger bigInteger16 = genPolynomial3.maxNorm();
        comparable = bigInteger16.multiply(bigInteger.abs()).multiply(new edu.jas.arith.BigInteger(2L));
        long l4 = Power.logarithm(var52_89.getIntegerModul(), comparable) + 1L;
        gcdRingElem = (edu.jas.arith.BigInteger)var52_89.getIntegerModul().power(l4);
        Iterable<ModLong> iterable4 = ModLongRing.MAX_LONG.compareTo(((edu.jas.arith.BigInteger)gcdRingElem).getVal()) > 0 ? new ModLongRing(((edu.jas.arith.BigInteger)gcdRingElem).getVal()) : new ModIntegerRing(((edu.jas.arith.BigInteger)gcdRingElem).getVal());
        GenPolynomialRing<ModLong> genPolynomialRing6 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable4), genPolynomialRing4);
        List list10 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, list7);
        GenPolynomial<ModLong> genPolynomial14 = PolyUtil.fromIntegerCoefficients(genPolynomialRing6, genPolynomial7);
        if (debug && !this.mfactor.isFactorization(genPolynomial14, list10)) {
            System.out.println("muqfactors = " + list10);
            System.out.println("peqq       = " + genPolynomial14);
            throw new RuntimeException("something is wrong, no modular p^k factorization");
        }
        logger.info("univariate modulo p^k: " + genPolynomial14 + " = " + list10);
        GenPolynomialRing<ModLong> genPolynomialRing7 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable4), genPolynomial3.ring);
        GenPolynomial<ModLong> genPolynomial15 = PolyUtil.fromIntegerCoefficients(genPolynomialRing7, genPolynomial3);
        logger.info("multivariate modulo p^k: " + genPolynomial15);
        try {
            list = HenselMultUtil.liftHensel(genPolynomial3, genPolynomial15, list10, list9, l4, list8);
            logger.info("mlift = " + list);
        }
        catch (NoLiftingException noLiftingException) {
            throw new RuntimeException(noLiftingException);
        }
        catch (ArithmeticException arithmeticException) {
            throw arithmeticException;
        }
        if (list.size() <= 1) {
            logger.info("modular lift size == 1: " + list);
            list2.add(genPolynomial3);
            if (list3 != null) {
                list3.addAll(list2);
                list2 = list3;
            }
            return list2;
        }
        GenPolynomialRing genPolynomialRing8 = list.get((int)0).ring;
        int n8 = (list.size() + 1) / 2;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial16 = genPolynomial;
        long l5 = (genPolynomial16.degree() + 1L) / 2L;
        GenPolynomial<edu.jas.arith.BigInteger> genPolynomial17 = genPolynomial3;
        block23: for (int i = 1; i <= n8; ++i) {
            KsubSet<GenPolynomial<ModLong>> ksubSet = new KsubSet<GenPolynomial<ModLong>>(list, i);
            for (List<GenPolynomial<ModLong>> list11 : ksubSet) {
                GenPolynomial<ModLong> genPolynomial18 = Power.multiply(genPolynomialRing8, list11);
                if (genPolynomial18.degree() > l5) {
                    logger.info("degree > deg " + l5 + ", degree = " + genPolynomial18.degree());
                }
                GenPolynomial<edu.jas.arith.BigInteger> genPolynomial19 = PolyUtil.integerFromModularCoefficients(genPolynomialRing, genPolynomial18);
                genPolynomial19 = this.engine.basePrimitivePart(genPolynomial19);
                if (debug) {
                    logger.info("trial    = " + genPolynomial19);
                }
                if (!PolyUtil.baseSparsePseudoRemainder(genPolynomial17, genPolynomial19).isZERO()) continue;
                logger.info("successful trial = " + genPolynomial19);
                list2.add(genPolynomial19);
                genPolynomial17 = PolyUtil.basePseudoDivide(genPolynomial17, genPolynomial19);
                list = FactorInteger.removeOnce(list, list11);
                logger.info("new mlift= " + list);
                if (list.size() > 1) {
                    n8 = (list.size() + 1) / 2;
                    i = 0;
                    continue block23;
                }
                logger.info("last factor = " + genPolynomial17);
                list2.add(genPolynomial17);
                if (list3 != null) {
                    list3.addAll(list2);
                    list2 = list3;
                }
                return this.normalizeFactorization(list2);
            }
        }
        if (!genPolynomial17.isONE() && !genPolynomial17.equals(genPolynomial3)) {
            logger.info("rest factor = " + genPolynomial17);
            list2.add(genPolynomial17);
        }
        if (list2.size() == 0) {
            logger.info("irreducible P = " + genPolynomial);
            list2.add(genPolynomial3);
        }
        if (list3 != null) {
            list3.addAll(list2);
            list2 = list3;
        }
        return this.normalizeFactorization(list2);
    }

    boolean testSeparate(List<edu.jas.arith.BigInteger> list, edu.jas.arith.BigInteger bigInteger) {
        int n = 0;
        for (edu.jas.arith.BigInteger bigInteger2 : list) {
            edu.jas.arith.BigInteger bigInteger3 = bigInteger2.gcd(bigInteger).abs();
            if (bigInteger3.isONE()) continue;
            ++n;
        }
        return n <= 1;
    }

    boolean isNearlySquarefree(GenPolynomial<edu.jas.arith.BigInteger> genPolynomial) {
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar >= 0) {
            return this.sengine.isSquarefree(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial<GenPolynomial<Object>> genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        GenPolynomial genPolynomial3 = PolyUtil.recursiveDeriviative(genPolynomial2);
        System.out.println("Pr = " + genPolynomial2);
        System.out.println("Ps = " + genPolynomial3);
        GenPolynomial genPolynomial4 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial3);
        System.out.println("g_m = " + genPolynomial4);
        if (!genPolynomial4.isONE()) {
            return false;
        }
        genPolynomialRing2 = genPolynomialRing.recursive(genPolynomialRing.nvar - 1);
        genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        genPolynomial2 = PolyUtil.switchVariables(genPolynomial2);
        genPolynomial3 = PolyUtil.recursiveDeriviative(genPolynomial2);
        System.out.println("Pr = " + genPolynomial2);
        System.out.println("Ps = " + genPolynomial3);
        genPolynomial4 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial3);
        System.out.println("g_1 = " + genPolynomial4);
        return genPolynomial4.isONE();
    }
}

