/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.Element;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.FactorInteger;
import java.util.List;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorIntegerTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 5;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorIntegerTest.suite());
    }

    public FactorIntegerTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorIntegerTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testIntegerMonicFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(4L);
        BigInteger bigInteger2 = bigInteger.getONE();
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 1, termOrder, new String[]{"x"});
        FactorInteger factorInteger = new FactorInteger();
        for (int i = 1; i < 3; ++i) {
            SortedMap<GenPolynomial<GenPolynomial<BigInteger>>, Long> sortedMap;
            int n = 0;
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial = null;
            GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl * 2, this.ll * i, this.el * (i + 1), this.q);
            GenPolynomial<BigInteger> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll * i, this.el * (i + 2), this.q);
            if (genPolynomial2.isZERO() || genPolynomial3.isZERO()) continue;
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if (!genPolynomial3.leadingBaseCoefficient().isUnit()) {
                sortedMap = genPolynomial3.leadingExpVector();
                genPolynomial3.doPutToMap((ExpVector)((Object)sortedMap), bigInteger2);
            }
            if (!genPolynomial2.leadingBaseCoefficient().isUnit()) {
                sortedMap = genPolynomial2.leadingExpVector();
                genPolynomial2.doPutToMap((ExpVector)((Object)sortedMap), bigInteger2);
            }
            if ((genPolynomial = genPolynomial3.multiply((BigInteger)((Object)genPolynomial2))).isConstant()) continue;
            sortedMap = factorInteger.baseFactors(genPolynomial);
            if (sortedMap.size() >= n) {
                FactorIntegerTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorIntegerTest.assertTrue((String)("#facs < " + n + ", " + genPolynomial2 + " * " + genPolynomial3), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorInteger.isFactorization(genPolynomial, sortedMap);
            FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testIntegerFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(4L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 1, termOrder);
        FactorInteger factorInteger = new FactorInteger();
        for (int i = 1; i < 2; ++i) {
            int n = 0;
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial = null;
            GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl * 2, this.ll * i, this.el * (i + 1), this.q);
            GenPolynomial<BigInteger> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll * i, this.el * (i + 2), this.q);
            if (genPolynomial2.isZERO() || genPolynomial3.isZERO()) continue;
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial = genPolynomial3.multiply((BigInteger)((Object)genPolynomial2))).isConstant()) continue;
            SortedMap sortedMap = factorInteger.baseFactors(genPolynomial);
            if (sortedMap.size() >= n) {
                FactorIntegerTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorIntegerTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorInteger.isFactorization(genPolynomial, sortedMap);
            FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testIntegerFactorizationIrred() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(4L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 1, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        for (int i = 1; i < 2; ++i) {
            int n = 0;
            Element element = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            element = genPolynomialRing.parse("( x^8 - 40 x^6 + 352 x^4 - 960 x^2 + 576 )");
            if (((GenPolynomial)element).isConstant()) continue;
            SortedMap sortedMap = factorInteger.baseFactors(element);
            if (sortedMap.size() >= 1) {
                FactorIntegerTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= 1 ? 1 : 0) != 0);
            }
            boolean bl = factorInteger.isFactorization(element, sortedMap);
            FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testBivariateIntegerFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 2, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        for (int i = 1; i < 2; ++i) {
            Element<GenPolynomial<GenPolynomial<BigInteger>>> element = genPolynomialRing.random(this.kl, 3, this.el, this.q / 2.0f);
            Element element2 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            Element element3 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            element = genPolynomialRing.parse(" ( x y^2 - 1 ) ");
            element2 = genPolynomialRing.parse(" ( 2 x y + 1 ) ");
            element3 = genPolynomialRing.parse(" ( y^4 + 3 x )");
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial = ((GenPolynomial)element).multiply(element2).multiply((GenPolynomial<BigInteger>)element3);
            List list = factorInteger.factorsSquarefreeHensel(genPolynomial);
            boolean bl = factorInteger.isFactorization(genPolynomial, list);
            FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
            FactorIntegerTest.assertTrue((String)("#facs < 3, sm = " + list), (list.size() >= 3 ? 1 : 0) != 0);
        }
    }

    public void ytestTrivariateIntegerFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        for (int i = 1; i < 2; ++i) {
            Element<GenPolynomial<GenPolynomial<BigInteger>>> element = genPolynomialRing.random(this.kl, 3, this.el, this.q / 2.0f);
            Element element2 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            Element element3 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            element = genPolynomialRing.parse(" ( 5 x y^2 - 1 ) ");
            element2 = genPolynomialRing.parse(" ( 2 x y z^2 + 1 ) ");
            element3 = genPolynomialRing.parse(" ( y^3 z + 3 x )");
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial = ((GenPolynomial)element).multiply(element2).multiply((GenPolynomial<BigInteger>)element3);
            List list = factorInteger.factorsSquarefreeHensel(genPolynomial);
            boolean bl = factorInteger.isFactorization(genPolynomial, list);
            FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
            FactorIntegerTest.assertTrue((String)("#facs < 3, sm = " + list), (list.size() >= 3 ? 1 : 0) != 0);
        }
    }

    public void ytestQuadvariateIntegerFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z", "w"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        for (int i = 1; i < 2; ++i) {
            Element<GenPolynomial<GenPolynomial<BigInteger>>> element = genPolynomialRing.random(this.kl, 3, this.el, this.q / 2.0f);
            Element element2 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            Element element3 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            element = genPolynomialRing.parse(" ( 5 x y^2 - 1 ) ");
            element2 = genPolynomialRing.parse(" ( 2 x z^2 + w^2 y ) ");
            element3 = genPolynomialRing.parse(" ( y^3 z + 7 x )");
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial = ((GenPolynomial)element).multiply(element2).multiply((GenPolynomial<BigInteger>)element3);
            List list = factorInteger.factorsSquarefreeHensel(genPolynomial);
            boolean bl = factorInteger.isFactorization(genPolynomial, list);
            FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
            FactorIntegerTest.assertTrue((String)("#facs < 3, sm = " + list), (list.size() >= 3 ? 1 : 0) != 0);
        }
    }

    public void testMultivariateIntegerFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        for (int i = 1; i < 2; ++i) {
            Element<GenPolynomial<GenPolynomial<BigInteger>>> element = genPolynomialRing.random(this.kl, 3, this.el, this.q / 2.0f);
            Element element2 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            element = genPolynomialRing.parse("( z - y )");
            element2 = genPolynomialRing.parse("( z + x )");
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial = ((GenPolynomial)element).multiply(element2);
            SortedMap sortedMap = factorInteger.factors(genPolynomial);
            boolean bl = factorInteger.isFactorization(genPolynomial, sortedMap);
            FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
            FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + sortedMap), (sortedMap.size() >= 2 ? 1 : 0) != 0);
        }
    }

    public void testIntegerFactorizationEx1() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" (z + x y + 10) ");
        Element element2 = genPolynomialRing.parse(" (x z + y + 30) ");
        Element element3 = genPolynomialRing.parse(" (y z + x + 20) ");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2).multiply(element3);
        List list = factorInteger.factorsSquarefree((GenPolynomial<BigInteger>)genPolynomial);
        boolean bl = factorInteger.isFactorization(genPolynomial, list);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 3, sm = " + list), (list.size() >= 3 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationEx2() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" (x^3 (z + y) + z - 11) ");
        Element element2 = genPolynomialRing.parse(" (x^2 (z^2 + y^2) + y + 90) ");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2);
        List list = factorInteger.factorsSquarefree((GenPolynomial<BigInteger>)genPolynomial);
        boolean bl = factorInteger.isFactorization(genPolynomial, list);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + list), (list.size() >= 2 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationEx3() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" (y z^3 + x y z + y^2 + x^3) ");
        Element element2 = genPolynomialRing.parse(" (x (z^4 + 1) + z + x^3 y^2) ");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2);
        List list = factorInteger.factorsSquarefree((GenPolynomial<BigInteger>)genPolynomial);
        boolean bl = factorInteger.isFactorization(genPolynomial, list);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + list), (list.size() >= 2 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationEx4() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" ( z^2 - x^3 y + 3 ) ");
        Element element2 = genPolynomialRing.parse(" (z^2 + x y^3) ");
        Element element3 = genPolynomialRing.parse(" (z^2 + x^3 y^4) ");
        Element element4 = genPolynomialRing.parse(" (y^4 z^2 + x^2 z + 5) ");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2).multiply(element3).multiply(element4);
        List list = factorInteger.factorsSquarefree((GenPolynomial<BigInteger>)genPolynomial);
        boolean bl = factorInteger.isFactorization(genPolynomial, list);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 4, sm = " + list), (list.size() >= 4 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationEx5() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z", "u"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" (z^2 + x^3 y^4 + u^2) ");
        Element element2 = genPolynomialRing.parse(" ( (y^2 + x ) z^2 + 3 u^2 x^3 y^4 z + 19 y^2 )");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2);
        List list = factorInteger.factorsSquarefree((GenPolynomial<BigInteger>)genPolynomial);
        boolean bl = factorInteger.isFactorization(genPolynomial, list);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + list), (list.size() >= 2 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationEx6() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z", "w"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" (w z^2 - x y^1 z^1 - w x^5 y^2 - w x^3 y) ");
        Element element2 = genPolynomialRing.parse(" (- x^5 z^2 + y z + x^2 y^1) ");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2);
        List list = factorInteger.factorsSquarefree((GenPolynomial<BigInteger>)genPolynomial);
        boolean bl = factorInteger.isFactorization(genPolynomial, list);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + list), (list.size() >= 2 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationEx7() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" ( (z + y^2 + x - 3 )^3 ) ");
        Element element2 = genPolynomialRing.parse(" ( (z + y + x^2 - 2 )^2 ) ");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2);
        SortedMap sortedMap = factorInteger.factors(genPolynomial);
        boolean bl = factorInteger.isFactorization(genPolynomial, sortedMap);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + sortedMap), (sortedMap.size() >= 2 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationHk() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"t", "x"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" ( 3 x^4 - ( 7 t + 2  ) x^2 + ( 4 t^2 + 2 t ) ) ");
        SortedMap sortedMap = factorInteger.factors(element);
        boolean bl = factorInteger.isFactorization(element, sortedMap);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + sortedMap), (sortedMap.size() >= 2 ? 1 : 0) != 0);
    }

    public void testBivarIntegerFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"x", "y"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorInteger factorInteger = new FactorInteger();
        Element element = genPolynomialRing.parse(" ( (5*y+2*x)*(5*y-2*x) ) ");
        SortedMap sortedMap = factorInteger.factors(element);
        System.out.println("sm = " + sortedMap + ", a = " + element + ", pfac = " + genPolynomialRing.toScript());
        boolean bl = factorInteger.isFactorization(element, sortedMap);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + sortedMap), (sortedMap.size() >= 2 ? 1 : 0) != 0);
        element = genPolynomialRing.parse(" ( (y-4*x)*(y-x) ) ");
        sortedMap = factorInteger.factors(element);
        System.out.println("sm = " + sortedMap + ", a = " + element + ", pfac = " + genPolynomialRing.toScript());
        bl = factorInteger.isFactorization(element, sortedMap);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm = " + sortedMap), (sortedMap.size() >= 2 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationProd() {
        TermOrder termOrder = TermOrderByName.INVLEX;
        BigInteger bigInteger = new BigInteger(1L);
        String[] stringArray = new String[]{"a", "b", "c", "d", "x"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(bigInteger);
        FactorIntegerTest.assertTrue((String)("fac :: FactorInteger: " + factorAbstract), (boolean)(factorAbstract instanceof FactorInteger));
        Element element = genPolynomialRing.parse("a+b*x");
        Element element2 = genPolynomialRing.parse("c+d*x");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2);
        SortedMap sortedMap = factorAbstract.factors(genPolynomial);
        boolean bl = factorAbstract.isFactorization(genPolynomial, sortedMap);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm: " + sortedMap), (sortedMap.size() >= 2 ? 1 : 0) != 0);
    }

    public void testIntegerFactorizationLoop() {
        TermOrder termOrder = TermOrderByName.IGRLEX;
        BigInteger bigInteger = BigInteger.ONE;
        String[] stringArray = new String[]{"a", "c", "d", "e", "x"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray.length, termOrder, stringArray);
        FactorAbstract<BigInteger> factorAbstract = FactorFactory.getImplementation(bigInteger);
        FactorIntegerTest.assertTrue((String)("fac :: FactorInteger: " + factorAbstract), (boolean)(factorAbstract instanceof FactorInteger));
        Element element = genPolynomialRing.parse("e * x + d");
        Element element2 = genPolynomialRing.parse("c * d * x + a * e");
        GenPolynomial<Element> genPolynomial = ((GenPolynomial)element).multiply(element2);
        SortedMap sortedMap = factorAbstract.factors(genPolynomial);
        boolean bl = factorAbstract.isFactorization(genPolynomial, sortedMap);
        FactorIntegerTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        FactorIntegerTest.assertTrue((String)("#facs < 2, sm: " + sortedMap), (sortedMap.size() >= 2 ? 1 : 0) != 0);
    }
}

