/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFiniteFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteAlgebraicFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SquarefreeFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SquarefreeFieldCharP.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final RingFactory<C> coFac;
    protected final AlgebraicNumberRing<C> aCoFac;
    protected final QuotientRing<C> qCoFac;

    public SquarefreeFieldCharP(RingFactory<C> ringFactory) {
        super(GCDFactory.getProxy(ringFactory));
        if (!ringFactory.isField()) {
            logger.warn("fac should be a field: " + ringFactory.toScript());
        }
        if (ringFactory.characteristic().signum() == 0) {
            throw new IllegalArgumentException("characterisic(fac) must be non-zero");
        }
        this.coFac = ringFactory;
        RingFactory<C> ringFactory2 = this.coFac;
        if (ringFactory2 instanceof AlgebraicNumberRing) {
            this.aCoFac = (AlgebraicNumberRing)ringFactory2;
            this.qCoFac = null;
        } else {
            this.aCoFac = null;
            this.qCoFac = ringFactory2 instanceof QuotientRing ? (QuotientRing)ringFactory2 : null;
        }
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.engine + " over " + this.coFac;
    }

    @Override
    public GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = genPolynomialRing.getONE();
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.baseSquarefreeFactors(genPolynomial);
        for (GenPolynomial<C> genPolynomial3 : sortedMap.keySet()) {
            genPolynomial2 = genPolynomial2.multiply(genPolynomial3);
        }
        genPolynomial2 = genPolynomial2.monic();
        return genPolynomial2;
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> genPolynomial) {
        AbelianGroupElem abelianGroupElem;
        Comparable comparable;
        GenPolynomial<Object> genPolynomial2;
        SortedMap<GcdRingElem, Long> sortedMap;
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomial.isConstant()) {
            GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
            SortedMap<GcdRingElem, Long> sortedMap2 = this.squarefreeFactors(gcdRingElem);
            if (sortedMap2 != null && sortedMap2.size() > 0) {
                for (Map.Entry<GcdRingElem, Long> entry : sortedMap2.entrySet()) {
                    GcdRingElem gcdRingElem2 = entry.getKey();
                    if (gcdRingElem2.isONE()) continue;
                    GenPolynomial<GcdRingElem> genPolynomial3 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem2);
                    Long l = entry.getValue();
                    treeMap.put(genPolynomial3, l);
                }
            } else {
                treeMap.put(genPolynomial, 1L);
            }
            return treeMap;
        }
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
        if (!gcdRingElem.isONE()) {
            genPolynomial = genPolynomial.divide((Object)gcdRingElem);
            sortedMap = this.squarefreeFactors(gcdRingElem);
            if (sortedMap != null && sortedMap.size() > 0) {
                for (Map.Entry entry : sortedMap.entrySet()) {
                    GcdRingElem gcdRingElem3 = (GcdRingElem)entry.getKey();
                    if (gcdRingElem3.isONE()) continue;
                    genPolynomial2 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem3);
                    comparable = (Long)entry.getValue();
                    treeMap.put(genPolynomial2, (Long)comparable);
                }
            } else {
                abelianGroupElem = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem);
                treeMap.put((GenPolynomial<C>)abelianGroupElem, 1L);
            }
            gcdRingElem = (GcdRingElem)genPolynomialRing.coFac.getONE();
        }
        if (!((ExpVector)((Object)(sortedMap = genPolynomial.trailingExpVector()))).isZERO()) {
            abelianGroupElem = genPolynomialRing.valueOf((ExpVector)((Object)sortedMap));
            if (logger.isInfoEnabled()) {
                logger.info("trailing term = " + abelianGroupElem);
            }
            genPolynomial = PolyUtil.basePseudoDivide(genPolynomial, abelianGroupElem);
            long l = ((ExpVector)((Object)sortedMap)).getVal(0);
            sortedMap = ((ExpVector)((Object)sortedMap)).subst(0, 1L);
            abelianGroupElem = genPolynomialRing.valueOf((ExpVector)((Object)sortedMap));
            if (logger.isInfoEnabled()) {
                logger.info("tr, ep = " + abelianGroupElem + ", " + l);
            }
            treeMap.put((GenPolynomial<C>)abelianGroupElem, l);
            if (genPolynomial.length() == 1) {
                return treeMap;
            }
        }
        abelianGroupElem = genPolynomial;
        long l = 1L;
        comparable = null;
        GenPolynomial genPolynomial4 = null;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = true;
        while (true) {
            if (bl) {
                if (abelianGroupElem.isConstant() || abelianGroupElem.isZERO()) break;
                genPolynomial2 = PolyUtil.baseDeriviative(abelianGroupElem);
                comparable = this.engine.baseGcd(abelianGroupElem, genPolynomial2);
                comparable = comparable.monic();
                genPolynomial4 = PolyUtil.basePseudoDivide(abelianGroupElem, comparable);
                l2 = 0L;
                l3 = 0L;
                bl = false;
            }
            if (genPolynomial4.isConstant()) {
                l3 = genPolynomialRing.characteristic().longValue();
                abelianGroupElem = this.baseRootCharacteristic((GenPolynomial<C>)comparable);
                logger.info("char root: T0 = " + abelianGroupElem + ", T = " + comparable);
                if (abelianGroupElem == null) {
                    abelianGroupElem = genPolynomialRing.getZERO();
                }
                l *= l3;
                bl = true;
                continue;
            }
            if (l3 != 0L && ++l2 % l3 == 0L) {
                comparable = PolyUtil.basePseudoDivide(comparable, genPolynomial4);
                System.out.println("k = " + l2);
                ++l2;
            }
            GenPolynomial genPolynomial5 = this.engine.baseGcd(comparable, genPolynomial4);
            genPolynomial5 = genPolynomial5.monic();
            GenPolynomial genPolynomial6 = PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial5);
            genPolynomial4 = genPolynomial5;
            comparable = PolyUtil.basePseudoDivide(comparable, genPolynomial4);
            if (genPolynomial6.degree(0) <= 0L) continue;
            if (gcdRingElem.isONE() && !((GcdRingElem)genPolynomial6.leadingBaseCoefficient()).isONE()) {
                genPolynomial6 = genPolynomial6.monic();
            }
            logger.info("z, k = " + genPolynomial6 + ", " + l2);
            treeMap.put(genPolynomial6, l * l2);
        }
        logger.info("exit char root: T0 = " + abelianGroupElem + ", T = " + comparable);
        return treeMap;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial2 = genPolynomialRing.getONE();
        SortedMap<GenPolynomial<GenPolynomial<C>>, Long> sortedMap = this.recursiveUnivariateSquarefreeFactors(genPolynomial);
        if (logger.isWarnEnabled()) {
            logger.info("sqfPart, better use sqfFactors, factors = " + sortedMap);
        }
        for (GenPolynomial<GenPolynomial<C>> genPolynomial3 : sortedMap.keySet()) {
            genPolynomial2 = genPolynomial2.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial3);
        }
        genPolynomial2 = PolyUtil.monic(genPolynomial2);
        return genPolynomial2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        void var9_14;
        Comparable<Long> comparable;
        Object object2;
        Object object3;
        GenPolynomial genPolynomial2;
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> treeMap = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        GcdRingElem gcdRingElem = (GcdRingElem)((Object)genPolynomial.leadingBaseCoefficient().leadingBaseCoefficient());
        if (!gcdRingElem.isONE()) {
            genPolynomial2 = ((GenPolynomial)genPolynomialRing2.getONE()).multiply(gcdRingElem);
            object3 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial2);
            treeMap.put((GenPolynomial<GenPolynomial<C>>)object3, 1L);
            object2 = (GcdRingElem)gcdRingElem.inverse();
            genPolynomial = genPolynomial.multiply((GenPolynomial<GenPolynomial<GcdRingElem>>)((GenPolynomial)genPolynomialRing2.getONE()).multiply(object2));
            gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient().leadingBaseCoefficient();
            if (debug) {
                logger.debug("new ldbcf: " + gcdRingElem);
            }
        }
        genPolynomial2 = this.engine.recursiveContent(genPolynomial);
        if (logger.isInfoEnabled()) {
            logger.info("Pc = " + genPolynomial2);
        }
        if (!(genPolynomial2 = genPolynomial2.monic()).isONE()) {
            genPolynomial = PolyUtil.coefficientPseudoDivide(genPolynomial, genPolynomial2);
        }
        object3 = this.squarefreeFactors((C)genPolynomial2);
        if (logger.isInfoEnabled()) {
            logger.info("rsf = " + object3);
        }
        for (Map.Entry object4 : object3.entrySet()) {
            GenPolynomial genPolynomial3 = (GenPolynomial)object4.getKey();
            if (genPolynomial3.isONE()) continue;
            GenPolynomial<GenPolynomial> genPolynomial4 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial3);
            comparable = (Long)object4.getValue();
            treeMap.put((GenPolynomial<GenPolynomial<C>>)genPolynomial4, (Long)comparable);
        }
        object2 = genPolynomial.trailingExpVector();
        if (!((ExpVector)object2).isZERO()) {
            GenPolynomial genPolynomial5 = genPolynomialRing.valueOf((ExpVector)object2);
            if (logger.isInfoEnabled()) {
                logger.info("trailing term = " + genPolynomial5);
            }
            genPolynomial = PolyUtil.recursivePseudoDivide(genPolynomial, genPolynomial5);
            long l = ((ExpVector)object2).getVal(0);
            object2 = ((ExpVector)object2).subst(0, 1L);
            GenPolynomial genPolynomial6 = genPolynomialRing.valueOf((ExpVector)object2);
            treeMap.put(genPolynomial6, l);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>> genPolynomial7 = genPolynomial;
        long l = 1L;
        GenPolynomial genPolynomial8 = null;
        GenPolynomial genPolynomial9 = null;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = true;
        while (true) {
            if (bl) {
                if (var9_14.isConstant() || var9_14.isZERO()) break;
                comparable = PolyUtil.recursiveDeriviative(var9_14);
                genPolynomial8 = this.engine.recursiveUnivariateGcd(var9_14, comparable);
                genPolynomial8 = PolyUtil.monic(genPolynomial8);
                genPolynomial9 = PolyUtil.recursivePseudoDivide(var9_14, genPolynomial8);
                l2 = 0L;
                l3 = 0L;
                bl = false;
            }
            if (genPolynomial9.isConstant()) {
                l3 = genPolynomialRing.characteristic().longValue();
                GenPolynomial<GenPolynomial<C>> genPolynomial10 = this.recursiveUnivariateRootCharacteristic(genPolynomial8);
                logger.info("char root: T0r = " + genPolynomial10 + ", Tr = " + genPolynomial8);
                if (genPolynomial10 == null) {
                    AbelianGroupElem abelianGroupElem = genPolynomialRing.getZERO();
                }
                l *= l3;
                bl = true;
            }
            if (l3 != 0L && ++l2 % l3 == 0L) {
                genPolynomial8 = PolyUtil.recursivePseudoDivide(genPolynomial8, genPolynomial9);
                System.out.println("k = " + l2);
                ++l2;
            }
            GenPolynomial genPolynomial11 = this.engine.recursiveUnivariateGcd(genPolynomial8, genPolynomial9);
            genPolynomial11 = PolyUtil.monic(genPolynomial11);
            GenPolynomial genPolynomial12 = PolyUtil.recursivePseudoDivide(genPolynomial9, genPolynomial11);
            genPolynomial9 = genPolynomial11;
            genPolynomial8 = PolyUtil.recursivePseudoDivide(genPolynomial8, genPolynomial9);
            if (genPolynomial12.isONE() || genPolynomial12.isZERO()) continue;
            genPolynomial12 = PolyUtil.monic(genPolynomial12);
            logger.info("z,put = " + genPolynomial12);
            treeMap.put(genPolynomial12, l * l2);
        }
        logger.info("exit char root: T0 = " + var9_14 + ", T = " + genPolynomial8);
        if (treeMap.size() == 0) {
            treeMap.put((GenPolynomial<GenPolynomial<C>>)genPolynomialRing.getONE(), 1L);
        }
        return treeMap;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseSquarefreePart(genPolynomial);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = genPolynomialRing.getONE();
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.squarefreeFactors((C)genPolynomial);
        if (logger.isWarnEnabled()) {
            logger.info("sqfPart, better use sqfFactors, factors = " + sortedMap);
        }
        for (GenPolynomial<C> genPolynomial3 : sortedMap.keySet()) {
            if (genPolynomial3.isConstant()) continue;
            genPolynomial2 = genPolynomial2.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
        }
        return genPolynomial2.monic();
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseSquarefreeFactors(genPolynomial);
        }
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>();
        if (genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isONE()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        SortedMap sortedMap = this.recursiveUnivariateSquarefreeFactors(genPolynomial2);
        for (Map.Entry entry : sortedMap.entrySet()) {
            Long l = entry.getValue();
            GenPolynomial genPolynomial3 = entry.getKey();
            GenPolynomial genPolynomial4 = PolyUtil.distribute(genPolynomialRing, genPolynomial3);
            treeMap.put(genPolynomial4, l);
        }
        return treeMap;
    }

    @Override
    public SortedMap<C, Long> squarefreeFactors(C c) {
        if (c == null) {
            return null;
        }
        TreeMap<Object, Long> treeMap = new TreeMap<Object, Long>();
        RingFactory ringFactory = (RingFactory)c.factory();
        if (this.aCoFac != null) {
            AlgebraicNumber algebraicNumber = (AlgebraicNumber)c;
            if (ringFactory.isFinite()) {
                SquarefreeFiniteFieldCharP squarefreeFiniteFieldCharP = (SquarefreeFiniteFieldCharP)SquarefreeFactory.getImplementation(ringFactory);
                SortedMap<C, Long> sortedMap = squarefreeFiniteFieldCharP.rootCharacteristic(c);
                logger.info("rfactors,finite = " + sortedMap);
                treeMap.putAll(sortedMap);
            } else {
                SquarefreeInfiniteAlgebraicFieldCharP squarefreeInfiniteAlgebraicFieldCharP = (SquarefreeInfiniteAlgebraicFieldCharP)SquarefreeFactory.getImplementation(ringFactory);
                SortedMap sortedMap = squarefreeInfiniteAlgebraicFieldCharP.squarefreeFactors(algebraicNumber);
                logger.info("rfactors,infinite,algeb = " + sortedMap);
                for (Map.Entry entry : sortedMap.entrySet()) {
                    AlgebraicNumber algebraicNumber2 = entry.getKey();
                    if (algebraicNumber2.isONE()) continue;
                    GcdRingElem gcdRingElem = algebraicNumber2;
                    Long l = entry.getValue();
                    treeMap.put(gcdRingElem, l);
                }
            }
        } else if (this.qCoFac != null) {
            Quotient quotient = (Quotient)c;
            SquarefreeInfiniteFieldCharP squarefreeInfiniteFieldCharP = (SquarefreeInfiniteFieldCharP)SquarefreeFactory.getImplementation(ringFactory);
            SortedMap sortedMap = squarefreeInfiniteFieldCharP.squarefreeFactors(quotient);
            logger.info("rfactors,infinite = " + sortedMap);
            for (Map.Entry entry : sortedMap.entrySet()) {
                Quotient quotient2 = entry.getKey();
                if (quotient2.isONE()) continue;
                GcdRingElem gcdRingElem = quotient2;
                Long l = entry.getValue();
                treeMap.put(gcdRingElem, l);
            }
        } else if (ringFactory.isFinite()) {
            SquarefreeFiniteFieldCharP squarefreeFiniteFieldCharP = (SquarefreeFiniteFieldCharP)SquarefreeFactory.getImplementation(ringFactory);
            SortedMap<C, Long> sortedMap = squarefreeFiniteFieldCharP.rootCharacteristic(c);
            logger.info("rfactors,finite = " + sortedMap);
            treeMap.putAll(sortedMap);
        } else {
            logger.warn("case " + ringFactory + " not implemented");
        }
        return treeMap;
    }

    public abstract GenPolynomial<C> baseRootCharacteristic(GenPolynomial<C> var1);

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<C>> var1);

    public boolean isCharRoot(GenPolynomial<C> genPolynomial, SortedMap<GenPolynomial<C>, Long> sortedMap) {
        boolean bl;
        if (genPolynomial == null || sortedMap == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (genPolynomial.isZERO() && sortedMap.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial> genPolynomial2 = genPolynomial.ring.getONE();
        long l = genPolynomial.ring.characteristic().longValue();
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<C> genPolynomial3 = entry.getKey();
            Long l2 = entry.getValue();
            long l3 = l2;
            GenPolynomial genPolynomial4 = (GenPolynomial)genPolynomial3.power(l3);
            if (!genPolynomial3.isConstant()) {
                genPolynomial4 = (GenPolynomial)genPolynomial4.power(l);
            }
            genPolynomial2 = genPolynomial2.multiply(genPolynomial4);
        }
        boolean bl2 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
        if (!bl) {
            System.out.println("\nfactorization(map): " + bl);
            System.out.println("P = " + genPolynomial);
            System.out.println("t = " + genPolynomial2);
            genPolynomial = genPolynomial.monic();
            genPolynomial2 = genPolynomial2.monic();
            boolean bl3 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
            if (bl) {
                return bl;
            }
            System.out.println("\nfactorization(map): " + bl);
            System.out.println("P = " + genPolynomial);
            System.out.println("t = " + genPolynomial2);
        }
        return bl;
    }

    public boolean isRecursiveCharRoot(GenPolynomial<GenPolynomial<C>> genPolynomial, SortedMap<GenPolynomial<GenPolynomial<C>>, Long> sortedMap) {
        boolean bl;
        if (genPolynomial == null || sortedMap == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (genPolynomial.isZERO() && sortedMap.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial> genPolynomial2 = genPolynomial.ring.getONE();
        long l = genPolynomial.ring.characteristic().longValue();
        for (Map.Entry<GenPolynomial<GenPolynomial<C>>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<GenPolynomial<C>> genPolynomial3 = entry.getKey();
            Long l2 = entry.getValue();
            long l3 = l2;
            GenPolynomial genPolynomial4 = (GenPolynomial)genPolynomial3.power(l3);
            if (!genPolynomial3.isConstant()) {
                genPolynomial4 = (GenPolynomial)genPolynomial4.power(l);
            }
            genPolynomial2 = genPolynomial2.multiply(genPolynomial4);
        }
        boolean bl2 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
        if (!bl) {
            System.out.println("\nfactorization(map): " + bl);
            System.out.println("P = " + genPolynomial);
            System.out.println("t = " + genPolynomial2);
            genPolynomial = genPolynomial.monic();
            genPolynomial2 = genPolynomial2.monic();
            boolean bl3 = bl = genPolynomial.equals(genPolynomial2) || genPolynomial.equals(genPolynomial2.negate());
            if (bl) {
                return bl;
            }
            System.out.println("\nfactorization(map): " + bl);
            System.out.println("P = " + genPolynomial);
            System.out.println("t = " + genPolynomial2);
        }
        return bl;
    }

    public boolean isRecursiveCharRoot(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        boolean bl;
        if (genPolynomial == null || genPolynomial2 == null) {
            throw new IllegalArgumentException("P and r may not be null");
        }
        if (genPolynomial.isZERO() && genPolynomial2.isZERO()) {
            return true;
        }
        long l = genPolynomial.ring.characteristic().longValue();
        GenPolynomial genPolynomial3 = (GenPolynomial)genPolynomial2.power(l);
        boolean bl2 = bl = genPolynomial.equals(genPolynomial3) || genPolynomial.equals(genPolynomial3.negate());
        if (!bl) {
            System.out.println("\nisCharRoot: " + bl);
            System.out.println("P = " + genPolynomial);
            System.out.println("t = " + genPolynomial3);
            genPolynomial = genPolynomial.monic();
            genPolynomial3 = genPolynomial3.monic();
            boolean bl3 = bl = genPolynomial.equals(genPolynomial3) || genPolynomial.equals(genPolynomial3.negate());
            if (bl) {
                return bl;
            }
            System.out.println("\nisCharRoot: " + bl);
            System.out.println("P = " + genPolynomial);
            System.out.println("t = " + genPolynomial3);
        }
        return bl;
    }
}

