/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.SocketChannel;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutableChannels {
    private static final Logger logger = LogManager.getLogger(ExecutableChannels.class);
    protected static final int DEFAULT_PORT = 7114;
    protected static final String DEFAULT_MFILE = "examples/machines.test";
    protected final ChannelFactory cf = new ChannelFactory();
    protected SocketChannel[] channels = null;
    protected String[] servers = null;
    protected int[] ports = null;

    protected ExecutableChannels() {
        this.cf.init();
    }

    public ExecutableChannels(String[] stringArray) {
        this();
        if (stringArray == null) {
            return;
        }
        this.servers = new String[stringArray.length];
        this.ports = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.setServerPort(i, stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableChannels(String string) throws FileNotFoundException {
        this();
        if (string == null || string.length() == 0) {
            string = DEFAULT_MFILE;
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), Charset.forName("UTF8"));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            while (bufferedReader.ready()) {
                string2 = bufferedReader.readLine();
                if (string2 == null) {
                    break;
                }
                int n = string2.indexOf("#");
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                if ((string2 = string2.trim()).length() == 0) continue;
                arrayList.add(string2);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        logger.debug("list.size() in " + string + " = " + arrayList.size());
        if (arrayList.size() == 0) {
            return;
        }
        this.servers = new String[arrayList.size()];
        this.ports = new int[arrayList.size()];
        for (int i = 0; i < this.servers.length; ++i) {
            this.setServerPort(i, (String)arrayList.get(i));
        }
    }

    protected void setServerPort(int n, String string) {
        int n2 = string.indexOf(":");
        this.ports[n] = 7114;
        if (n2 < 0) {
            this.servers[n] = string;
        } else {
            this.servers[n] = string.substring(0, n2);
            String string2 = string.substring(n2 + 1, string.length());
            try {
                this.ports[n] = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("ExecutableChannels(");
        if (this.servers != null) {
            for (n = 0; n < this.servers.length; ++n) {
                stringBuffer.append(this.servers[n] + ":" + this.ports[n]);
                if (n >= this.servers.length - 1) continue;
                stringBuffer.append(" ");
            }
        }
        if (this.channels != null) {
            stringBuffer.append(" channels = ");
            for (n = 0; n < this.channels.length; ++n) {
                stringBuffer.append(this.channels[n]);
                if (n >= this.channels.length - 1) continue;
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int numServers() {
        if (this.servers != null) {
            return this.servers.length;
        }
        return -1;
    }

    public String getMasterHost() {
        if (this.servers != null && this.servers.length > 0) {
            return this.servers[0];
        }
        return null;
    }

    public int getMasterPort() {
        if (this.ports != null && this.ports.length > 0) {
            return this.ports[0];
        }
        return 0;
    }

    public int numChannels() {
        if (this.channels != null) {
            return this.channels.length;
        }
        return -1;
    }

    public void open() throws IOException {
        logger.debug("opening " + this.servers.length + " channels");
        if (this.servers.length <= 1) {
            throw new IOException("to few servers");
        }
        this.channels = new SocketChannel[this.servers.length - 1];
        for (int i = 1; i < this.servers.length; ++i) {
            this.channels[i - 1] = this.cf.getChannel(this.servers[i], this.ports[i]);
        }
    }

    public void open(int n) throws IOException {
        logger.debug("opening " + n + " channels");
        if (this.servers.length <= 1) {
            throw new IOException("to few servers");
        }
        this.channels = new SocketChannel[n];
        int n2 = 1;
        for (int i = 0; i < this.channels.length; ++i) {
            if (n2 >= this.servers.length) {
                n2 = 1;
            }
            this.channels[i] = this.cf.getChannel(this.servers[n2], this.ports[n2]);
            ++n2;
        }
    }

    public void close() {
        logger.debug("closing ExecutableChannels");
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.channels != null) {
            for (int i = 0; i < this.channels.length; ++i) {
                if (this.channels[i] == null) continue;
                try {
                    this.channels[i].send("Stop");
                }
                catch (IOException iOException) {
                    if (logger.isDebugEnabled()) {
                        iOException.printStackTrace();
                    }
                }
                finally {
                    this.channels[i].close();
                }
                this.channels[i] = null;
            }
            this.channels = null;
        }
        logger.debug("ExecuteChannels closed");
    }

    public SocketChannel getChannel(int n) {
        if (this.channels != null && 0 <= n && n < this.channels.length) {
            return this.channels[n];
        }
        return null;
    }

    SocketChannel[] getChannels() {
        return this.channels;
    }

    public void send(int n, Object object) throws IOException {
        if (this.channels != null && 0 <= n && n < this.channels.length) {
            this.channels[n].send(object);
        }
    }

    public Object receive(int n) throws IOException, ClassNotFoundException {
        if (this.channels != null && 0 <= n && n < this.channels.length) {
            return this.channels[n].receive();
        }
        return null;
    }
}

