/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.kern.PrettyPrint;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.ModulElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenVectorModul;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenVector<C extends RingElem<C>>
implements ModulElem<GenVector<C>, C> {
    private static final Logger logger = LogManager.getLogger(GenVector.class);
    public final GenVectorModul<C> modul;
    public final List<C> val;

    public GenVector(GenVectorModul<C> genVectorModul) {
        this(genVectorModul, ((GenVector)genVectorModul.getZERO()).val);
    }

    public GenVector(GenVectorModul<C> genVectorModul, List<C> list) {
        if (genVectorModul == null || list == null) {
            throw new IllegalArgumentException("Empty m or v not allowed, m = " + genVectorModul + ", v = " + list);
        }
        this.modul = genVectorModul;
        this.val = list;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        boolean bl = true;
        for (RingElem ringElem : this.val) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ringElem.toString());
        }
        stringBuffer.append(" ]");
        if (!PrettyPrint.isTrue()) {
            stringBuffer.append(" :: " + this.modul.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( ");
        boolean bl = true;
        for (RingElem ringElem : this.val) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ringElem.toScript());
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenVectorModul)this.factory()).toScript();
    }

    @Override
    public GenVectorModul<C> factory() {
        return this.modul;
    }

    @Override
    public GenVector<C> copy() {
        ArrayList<C> arrayList = new ArrayList<C>(this.val);
        return new GenVector<C>(this.modul, arrayList);
    }

    @Override
    public boolean isZERO() {
        return 0 == this.compareTo((GenVector<C>)this.modul.getZERO());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GenVector)) {
            return false;
        }
        GenVector genVector = (GenVector)object;
        if (!this.modul.equals(genVector.modul)) {
            return false;
        }
        return this.val.equals(genVector.val);
    }

    @Override
    public int hashCode() {
        return 37 * this.val.hashCode() + this.modul.hashCode();
    }

    @Override
    public int compareTo(GenVector<C> genVector) {
        if (!this.modul.equals(genVector.modul)) {
            return -1;
        }
        List<C> list = genVector.val;
        int n = 0;
        for (RingElem ringElem : this.val) {
            int n2 = ringElem.compareTo((Element)list.get(n++));
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public int signum() {
        return this.compareTo((GenVector<C>)this.modul.getZERO());
    }

    @Override
    public GenVector<C> sum(GenVector<C> genVector) {
        List<C> list = genVector.val;
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        int n = 0;
        for (RingElem ringElem : this.val) {
            RingElem ringElem2 = (RingElem)ringElem.sum((AbelianGroupElem)list.get(n++));
            arrayList.add(ringElem2);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    @Override
    public GenVector<C> subtract(GenVector<C> genVector) {
        List<C> list = genVector.val;
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        int n = 0;
        for (RingElem ringElem : this.val) {
            RingElem ringElem2 = (RingElem)ringElem.subtract((AbelianGroupElem)list.get(n++));
            arrayList.add(ringElem2);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    @Override
    public GenVector<C> negate() {
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        for (RingElem ringElem : this.val) {
            RingElem ringElem2 = (RingElem)ringElem.negate();
            arrayList.add(ringElem2);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    @Override
    public GenVector<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenVector<C> scalarMultiply(C c) {
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        for (RingElem ringElem : this.val) {
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            arrayList.add(ringElem2);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    public GenVector<C> leftScalarMultiply(C ringElem) {
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        for (RingElem ringElem2 : this.val) {
            RingElem ringElem3 = ringElem.multiply((RingElem)ringElem2);
            arrayList.add(ringElem3);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    @Override
    public GenVector<C> linearCombination(C c, GenVector<C> genVector, C c2) {
        List<C> list = genVector.val;
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        int n = 0;
        for (RingElem ringElem : this.val) {
            RingElem ringElem2 = (RingElem)ringElem.multiply(c);
            RingElem ringElem3 = (RingElem)((RingElem)list.get(n++)).multiply(c2);
            RingElem ringElem4 = ringElem2.sum(ringElem3);
            arrayList.add(ringElem4);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    @Override
    public GenVector<C> linearCombination(GenVector<C> genVector, C c) {
        List<C> list = genVector.val;
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        int n = 0;
        for (RingElem ringElem : this.val) {
            RingElem ringElem2 = (RingElem)((RingElem)list.get(n++)).multiply(c);
            RingElem ringElem3 = ringElem.sum(ringElem2);
            arrayList.add(ringElem3);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    @Override
    public GenVector<C> linearCombination(C monoidElem, GenVector<C> genVector) {
        List<C> list = genVector.val;
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        int n = 0;
        for (RingElem ringElem : this.val) {
            RingElem ringElem2 = (RingElem)monoidElem.multiply((MonoidElem)((MonoidElem)list.get(n++)));
            RingElem ringElem3 = ringElem.sum(ringElem2);
            arrayList.add(ringElem3);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    public GenVector<C> leftLinearCombination(C ringElem, C monoidElem, GenVector<C> genVector) {
        List<C> list = genVector.val;
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.modul.cols);
        int n = 0;
        for (RingElem ringElem2 : this.val) {
            RingElem ringElem3 = ringElem.multiply((RingElem)ringElem2);
            RingElem ringElem4 = (RingElem)monoidElem.multiply((MonoidElem)((MonoidElem)list.get(n++)));
            RingElem ringElem5 = ringElem3.sum(ringElem4);
            arrayList.add(ringElem5);
        }
        return new GenVector<C>(this.modul, arrayList);
    }

    @Override
    public C scalarProduct(GenVector<C> genVector) {
        RingElem ringElem = (RingElem)this.modul.coFac.getZERO();
        List<C> list = genVector.val;
        int n = 0;
        for (RingElem ringElem2 : this.val) {
            RingElem ringElem3 = (RingElem)ringElem2.multiply((MonoidElem)list.get(n++));
            ringElem = ringElem.sum(ringElem3);
        }
        return (C)ringElem;
    }

    @Override
    public GenVector<C> scalarProduct(List<GenVector<C>> list) {
        GenVector<RingElem> genVector = this.modul.getZERO();
        int n = 0;
        for (RingElem ringElem : this.val) {
            GenVector<RingElem> genVector2 = list.get(n++);
            GenVector<RingElem> genVector3 = genVector2.leftScalarMultiply(ringElem);
            genVector = genVector.sum(genVector3);
        }
        return genVector;
    }

    public GenVector<C> rightScalarProduct(List<GenVector<C>> list) {
        GenVector<C> genVector = this.modul.getZERO();
        int n = 0;
        for (RingElem ringElem : this.val) {
            GenVector<C> genVector2 = list.get(n++);
            ModulElem modulElem = genVector2.scalarMultiply(ringElem);
            genVector = genVector.sum((GenVector<C>)modulElem);
        }
        return genVector;
    }
}

