/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.Residue;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResidueRing<C extends GcdRingElem<C>>
implements RingFactory<Residue<C>> {
    private static final Logger logger = LogManager.getLogger(ResidueRing.class);
    protected final GreatestCommonDivisor<C> engine;
    public final Ideal<C> ideal;
    public final GenPolynomialRing<C> ring;
    protected int isField = -1;

    public ResidueRing(Ideal<C> ideal) {
        this(ideal, false);
    }

    public ResidueRing(Ideal<C> ideal, boolean bl) {
        this.ideal = ideal.GB();
        this.ring = this.ideal.list.ring;
        this.engine = GCDFactory.getProxy(this.ring.coFac);
        if (bl) {
            this.isField = 1;
            return;
        }
        if (this.ideal.isONE()) {
            logger.warn("ideal is one, so all residues are 0");
        }
    }

    @Override
    public boolean isFinite() {
        return this.ideal.commonZeroTest() <= 0 && this.ring.coFac.isFinite();
    }

    @Override
    public Residue<C> copy(Residue<C> residue) {
        if (residue == null) {
            return this.getZERO();
        }
        Residue residue2 = new Residue(this, residue.val);
        return residue2;
    }

    @Override
    public Residue<C> getZERO() {
        return new Residue(this, this.ring.getZERO());
    }

    @Override
    public Residue<C> getONE() {
        Residue residue = new Residue(this, this.ring.getONE());
        if (residue.isZERO()) {
            logger.warn("ideal is one, so all residues are 0");
        }
        return residue;
    }

    @Override
    public List<Residue<C>> generators() {
        List<GenPolynomial<C>> list = this.ring.generators();
        ArrayList<Residue<C>> arrayList = new ArrayList<Residue<C>>(list.size());
        TreeSet<Residue<C>> treeSet = new TreeSet<Residue<C>>();
        ArrayList arrayList2 = new ArrayList(list.size());
        Ideal<C> ideal = new Ideal<C>(this.ring, arrayList2);
        ResidueRing<C> residueRing = new ResidueRing<C>(ideal);
        for (GenPolynomial<C> genPolynomial : list) {
            Residue<C> residue;
            Residue<C> residue2 = new Residue<C>(this, genPolynomial);
            if (residue2.isZERO() || !residue2.isONE() && residue2.val.isConstant() || (residue = new Residue<C>(residueRing, residue2.val)).isZERO() || !residue.isONE() && residue.val.isConstant() || (residue2 = new Residue(this, residue.val)).isZERO()) continue;
            if (!(residue2 = residue2.monic()).isONE() && !residue2.val.isConstant()) {
                arrayList2.add(residue2.val);
                ideal = new Ideal<C>(this.ring, arrayList2);
                residueRing = new ResidueRing<C>(ideal);
            }
            treeSet.add(residue2);
        }
        arrayList.addAll(treeSet);
        return arrayList;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Residue<C> fromInteger(BigInteger bigInteger) {
        return new Residue(this, this.ring.fromInteger(bigInteger));
    }

    @Override
    public Residue<C> fromInteger(long l) {
        return new Residue(this, this.ring.fromInteger(l));
    }

    public String toString() {
        return "ResidueRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "RC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ResidueRing)) {
            return false;
        }
        ResidueRing residueRing = null;
        try {
            residueRing = (ResidueRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (residueRing == null) {
            return false;
        }
        if (!this.ring.equals(residueRing.ring)) {
            return false;
        }
        return this.ideal.equals(residueRing.ideal);
    }

    public int hashCode() {
        int n = this.ideal.hashCode();
        return n;
    }

    @Override
    public Residue<C> random(int n) {
        GenPolynomial genPolynomial = ((GenPolynomial)this.ring.random(n)).monic();
        return new Residue(this, genPolynomial);
    }

    public Residue<C> random(int n, int n2, int n3, float f) {
        GenPolynomial<C> genPolynomial = this.ring.random(n, n2, n3, f).monic();
        return new Residue<C>(this, genPolynomial);
    }

    @Override
    public Residue<C> random(int n, Random random) {
        GenPolynomial genPolynomial = ((GenPolynomial)this.ring.random(n, random)).monic();
        return new Residue(this, genPolynomial);
    }

    @Override
    public Residue<C> parse(String string) {
        Element element = this.ring.parse(string);
        return new Residue(this, element);
    }

    @Override
    public Residue<C> parse(Reader reader) {
        Element element = this.ring.parse(reader);
        return new Residue(this, element);
    }
}

