/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorFake;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PreemptingException;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGCDParallelProxy<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SGCDParallelProxy.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final GreatestCommonDivisorAbstract<C> e0;
    public final GreatestCommonDivisorAbstract<C> e1;
    public final GreatestCommonDivisorAbstract<C> e2;
    protected transient ExecutorService pool;

    public SGCDParallelProxy(RingFactory<C> ringFactory, GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract, GreatestCommonDivisorAbstract<C> greatestCommonDivisorAbstract2) {
        super(ringFactory);
        this.e0 = new GreatestCommonDivisorFake<C>(ringFactory);
        this.e1 = greatestCommonDivisorAbstract;
        this.e2 = greatestCommonDivisorAbstract2;
        this.pool = ComputerThreads.getPool();
    }

    @Override
    public String toString() {
        return "SGCDParallelProxy[ " + this.e1.getClass().getName() + ", " + this.e2.getClass().getName() + " ]";
    }

    @Override
    public GenSolvablePolynomial<C> leftBaseGcd(final GenSolvablePolynomial<C> genSolvablePolynomial, final GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial.ring.getONE();
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenSolvablePolynomial<C>>(){

            @Override
            public GenSolvablePolynomial<C> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e1.leftBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e1 {}", (Object)SGCDParallelProxy.this.e1.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e1 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenSolvablePolynomial<C>>(){

            @Override
            public GenSolvablePolynomial<C> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e2.leftBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e2 {}", (Object)SGCDParallelProxy.this.e2.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e2 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e2 " + exception);
                }
            }
        });
        try {
            genSolvablePolynomial3 = ComputerThreads.getTimeout() < 0L ? (GenSolvablePolynomial)this.pool.invokeAny(arrayList) : (GenSolvablePolynomial)this.pool.invokeAny(arrayList, ComputerThreads.getTimeout(), ComputerThreads.getTimeUnit());
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException after {} {}", (Object)ComputerThreads.getTimeout(), (Object)ComputerThreads.getTimeUnit());
            genSolvablePolynomial3 = this.e0.leftBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        return genSolvablePolynomial3;
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> leftRecursiveUnivariateGcd(final GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, final GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial.ring.getONE();
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenSolvablePolynomial<GenPolynomial<C>>>(){

            @Override
            public GenSolvablePolynomial<GenPolynomial<C>> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e1.leftRecursiveUnivariateGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e1 {}", (Object)SGCDParallelProxy.this.e1.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e1 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenSolvablePolynomial<GenPolynomial<C>>>(){

            @Override
            public GenSolvablePolynomial<GenPolynomial<C>> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e2.leftRecursiveUnivariateGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e2 {}", (Object)SGCDParallelProxy.this.e2.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e2 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e2 " + exception);
                }
            }
        });
        try {
            genSolvablePolynomial3 = ComputerThreads.getTimeout() < 0L ? (GenSolvablePolynomial)this.pool.invokeAny(arrayList) : (GenSolvablePolynomial)this.pool.invokeAny(arrayList, ComputerThreads.getTimeout(), ComputerThreads.getTimeUnit());
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException after {} {}", (Object)ComputerThreads.getTimeout(), (Object)ComputerThreads.getTimeUnit());
            genSolvablePolynomial3 = this.e0.leftRecursiveUnivariateGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        return genSolvablePolynomial3;
    }

    @Override
    public GenSolvablePolynomial<C> leftGcd(final GenSolvablePolynomial<C> genSolvablePolynomial, final GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial.ring.getONE();
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenSolvablePolynomial<C>>(){

            @Override
            public GenSolvablePolynomial<C> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e1.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e1 {}", (Object)SGCDParallelProxy.this.e1.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e1 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenSolvablePolynomial<C>>(){

            @Override
            public GenSolvablePolynomial<C> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e2.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e2 {}", (Object)SGCDParallelProxy.this.e2.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e2 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e2 " + exception);
                }
            }
        });
        try {
            genSolvablePolynomial3 = ComputerThreads.getTimeout() < 0L ? (GenSolvablePolynomial)this.pool.invokeAny(arrayList) : (GenSolvablePolynomial)this.pool.invokeAny(arrayList, ComputerThreads.getTimeout(), ComputerThreads.getTimeUnit());
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException after {} {}", (Object)ComputerThreads.getTimeout(), (Object)ComputerThreads.getTimeUnit());
            genSolvablePolynomial3 = this.e0.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        return genSolvablePolynomial3;
    }

    @Override
    public GenSolvablePolynomial<C> rightBaseGcd(final GenSolvablePolynomial<C> genSolvablePolynomial, final GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial.ring.getONE();
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenSolvablePolynomial<C>>(){

            @Override
            public GenSolvablePolynomial<C> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e1.rightBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e1 {}", (Object)SGCDParallelProxy.this.e1.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e1 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenSolvablePolynomial<C>>(){

            @Override
            public GenSolvablePolynomial<C> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e2.rightBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e2 {}", (Object)SGCDParallelProxy.this.e2.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e2 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e2 " + exception);
                }
            }
        });
        try {
            genSolvablePolynomial3 = ComputerThreads.getTimeout() < 0L ? (GenSolvablePolynomial)this.pool.invokeAny(arrayList) : (GenSolvablePolynomial)this.pool.invokeAny(arrayList, ComputerThreads.getTimeout(), ComputerThreads.getTimeUnit());
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException after {} {}", (Object)ComputerThreads.getTimeout(), (Object)ComputerThreads.getTimeUnit());
            genSolvablePolynomial3 = this.e0.rightBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        return genSolvablePolynomial3;
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> rightRecursiveUnivariateGcd(final GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, final GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial.ring.getONE();
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenSolvablePolynomial<GenPolynomial<C>>>(){

            @Override
            public GenSolvablePolynomial<GenPolynomial<C>> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e1.rightRecursiveUnivariateGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e1 {}", (Object)SGCDParallelProxy.this.e1.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e1 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenSolvablePolynomial<GenPolynomial<C>>>(){

            @Override
            public GenSolvablePolynomial<GenPolynomial<C>> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e2.rightRecursiveUnivariateGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e2 {}", (Object)SGCDParallelProxy.this.e2.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e2 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e2 " + exception);
                }
            }
        });
        try {
            genSolvablePolynomial3 = ComputerThreads.getTimeout() < 0L ? (GenSolvablePolynomial)this.pool.invokeAny(arrayList) : (GenSolvablePolynomial)this.pool.invokeAny(arrayList, ComputerThreads.getTimeout(), ComputerThreads.getTimeUnit());
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException after {} {}", (Object)ComputerThreads.getTimeout(), (Object)ComputerThreads.getTimeUnit());
            genSolvablePolynomial3 = this.e0.rightRecursiveUnivariateGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        return genSolvablePolynomial3;
    }

    @Override
    public GenSolvablePolynomial<C> rightGcd(final GenSolvablePolynomial<C> genSolvablePolynomial, final GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (debug && ComputerThreads.NO_THREADS) {
            throw new RuntimeException("this should not happen");
        }
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial.ring.getONE();
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<GenSolvablePolynomial<C>>(){

            @Override
            public GenSolvablePolynomial<C> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e1.rightGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e1 {}", (Object)SGCDParallelProxy.this.e1.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e1 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e1 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<GenSolvablePolynomial<C>>(){

            @Override
            public GenSolvablePolynomial<C> call() {
                try {
                    GenSolvablePolynomial genSolvablePolynomial3 = SGCDParallelProxy.this.e2.rightGcd(genSolvablePolynomial, genSolvablePolynomial2);
                    if (debug) {
                        logger.info("SGCDParallelProxy done e2 {}", (Object)SGCDParallelProxy.this.e2.getClass().getName());
                    }
                    return genSolvablePolynomial3;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGCDParallelProxy e2 pre " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGCDParallelProxy e2 {}", (Throwable)exception);
                    logger.info("SGCDParallelProxy P = {}", (Object)genSolvablePolynomial);
                    logger.info("SGCDParallelProxy S = {}", (Object)genSolvablePolynomial2);
                    throw new RuntimeException("SGCDParallelProxy e2 " + exception);
                }
            }
        });
        try {
            genSolvablePolynomial3 = ComputerThreads.getTimeout() < 0L ? (GenSolvablePolynomial)this.pool.invokeAny(arrayList) : (GenSolvablePolynomial)this.pool.invokeAny(arrayList, ComputerThreads.getTimeout(), ComputerThreads.getTimeUnit());
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException after {} {}", (Object)ComputerThreads.getTimeout(), (Object)ComputerThreads.getTimeUnit());
            genSolvablePolynomial3 = this.e0.rightGcd(genSolvablePolynomial, genSolvablePolynomial2);
        }
        return genSolvablePolynomial3;
    }
}

