/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.DReduction;
import edu.jas.gb.DReductionSeq;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedDPairlist;
import edu.jas.gb.Pair;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DGroebnerBaseSeq<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(DGroebnerBaseSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected DReduction<C> dred;

    public DGroebnerBaseSeq() {
        this(new DReductionSeq());
    }

    public DGroebnerBaseSeq(DReduction<C> dReduction) {
        super(dReduction);
        this.dred = dReduction;
        assert (this.dred == this.red);
    }

    @Override
    public boolean isGB(int n, List<GenPolynomial<C>> list) {
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenPolynomial<C> genPolynomial2 = list.get(j);
                if (!this.red.moduleCriterion(n, genPolynomial, genPolynomial2)) continue;
                GenPolynomial<C> genPolynomial3 = this.dred.GPolynomial(genPolynomial, genPolynomial2);
                if (!genPolynomial3.isZERO()) {
                    genPolynomial3 = this.red.normalform(list, genPolynomial3);
                }
                if (!genPolynomial3.isZERO()) {
                    System.out.println("d-pol(" + i + "," + j + ") != 0: " + genPolynomial3);
                    return false;
                }
                if (!this.red.criterion4(genPolynomial, genPolynomial2)) continue;
                GenPolynomial<C> genPolynomial4 = this.red.SPolynomial(genPolynomial, genPolynomial2);
                if (!genPolynomial4.isZERO()) {
                    genPolynomial4 = this.red.normalform(list, genPolynomial4);
                }
                if (genPolynomial4.isZERO()) continue;
                System.out.println("s-pol(" + i + "," + j + ") != 0: " + genPolynomial4);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        OrderedDPairlist<C> orderedDPairlist = new OrderedDPairlist<C>(n, genPolynomialRing);
        orderedDPairlist.put(list2);
        while (orderedDPairlist.hasNext()) {
            GenPolynomial<C> genPolynomial;
            Pair pair = orderedDPairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial genPolynomial2 = pair.pi;
            GenPolynomial genPolynomial3 = pair.pj;
            logger.debug("pi    = {}", (Object)genPolynomial2);
            logger.debug("pj    = {}", (Object)genPolynomial3);
            GenPolynomial<C> genPolynomial4 = this.dred.GPolynomial(genPolynomial2, genPolynomial3);
            if (!genPolynomial4.isZERO() && !this.red.isTopReducible(list2, genPolynomial4)) {
                genPolynomial = this.red.normalform(list2, genPolynomial4);
                if (genPolynomial.isONE()) {
                    list2.clear();
                    list2.add(genPolynomial);
                    return list2;
                }
                if (!genPolynomial.isZERO()) {
                    logger.info("Dred = {}", genPolynomial);
                    list2.add(genPolynomial);
                    orderedDPairlist.put(genPolynomial);
                }
            }
            if (!pair.getUseCriterion3() || !pair.getUseCriterion4()) continue;
            GenPolynomial genPolynomial5 = this.red.SPolynomial(genPolynomial2, genPolynomial3);
            if (genPolynomial5.isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(S) = {}", (Object)genPolynomial5.leadingExpVector());
            }
            if ((genPolynomial = this.red.normalform(list2, genPolynomial5)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(H) = {}", (Object)genPolynomial.leadingExpVector());
            }
            if (genPolynomial.isONE()) {
                list2.clear();
                list2.add(genPolynomial);
                return list2;
            }
            logger.debug("H = {}", genPolynomial);
            if (genPolynomial.isZERO()) continue;
            logger.info("Sred = {}", genPolynomial);
            list2.add(genPolynomial);
            orderedDPairlist.put(genPolynomial);
        }
        logger.debug("#sequential list = {}", (Object)list2.size());
        list2 = this.minimalGB(list2);
        logger.info("{}", orderedDPairlist);
        return list2;
    }
}

