/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Reducer<C extends RingElem<C>>
implements Runnable {
    private final List<GenPolynomial<C>> G;
    private final PairList<C> pairlist;
    private final Terminator fin;
    private final ReductionPar<C> red;
    private static final Logger logger = LogManager.getLogger(Reducer.class);

    Reducer(Terminator terminator, List<GenPolynomial<C>> list, PairList<C> pairList) {
        this.fin = terminator;
        this.fin.initIdle(1);
        this.G = list;
        this.pairlist = pairList;
        this.red = new ReductionPar();
    }

    public String toString() {
        return "Reducer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        int n2 = 0;
        while (this.pairlist.hasNext() || this.fin.hasJobs()) {
            List<GenPolynomial<C>> list;
            GenPolynomial genPolynomial;
            while (!this.pairlist.hasNext()) {
                try {
                    if (++n2 % 10 == 0) {
                        logger.info(" reducer is sleeping");
                    } else {
                        logger.debug("r");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.fin.allIdle();
                    logger.info("shutdown {} after: {}", (Object)this.fin, (Object)interruptedException);
                    break;
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.fin.allIdle();
                    logger.info("shutdown after .isInterrupted(): {}", (Object)this.fin);
                    break;
                }
                if (this.fin.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.fin.hasJobs()) break;
            this.fin.notIdle();
            Pair<C> pair = this.pairlist.removeNext();
            if (Thread.currentThread().isInterrupted()) {
                this.fin.initIdle(1);
                throw new RuntimeException("interrupt after removeNext");
            }
            if (pair == null) {
                this.fin.initIdle(1);
                continue;
            }
            GenPolynomial genPolynomial2 = pair.pi;
            GenPolynomial genPolynomial3 = pair.pj;
            if (logger.isDebugEnabled()) {
                logger.debug("pi    = {}", (Object)genPolynomial2);
                logger.debug("pj    = {}", (Object)genPolynomial3);
            }
            if ((genPolynomial = this.red.SPolynomial(genPolynomial2, genPolynomial3)).isZERO()) {
                pair.setZero();
                this.fin.initIdle(1);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(S) = {}", (Object)genPolynomial.leadingExpVector());
            }
            GenPolynomial<C> genPolynomial4 = this.red.normalform(this.G, genPolynomial);
            ++n;
            if (genPolynomial4.isZERO()) {
                pair.setZero();
                this.fin.initIdle(1);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.info("ht(H) = {}", (Object)genPolynomial4.leadingExpVector());
            }
            if ((genPolynomial4 = genPolynomial4.monic()).isONE()) {
                this.pairlist.put(genPolynomial4);
                list = this.G;
                synchronized (list) {
                    this.G.clear();
                    this.G.add(genPolynomial4);
                }
                this.fin.allIdle();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("H = {}", genPolynomial4);
            }
            list = this.G;
            synchronized (list) {
                this.G.add(genPolynomial4);
            }
            this.pairlist.put(genPolynomial4);
            this.fin.initIdle(1);
        }
        this.fin.allIdle();
        logger.info("terminated, done {} reductions", (Object)n);
    }
}

