/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairList;
import edu.jas.gb.GBSPTransportMess;
import edu.jas.gb.GBSPTransportMessEnd;
import edu.jas.gb.GBSPTransportMessPairIndex;
import edu.jas.gb.GBSPTransportMessPoly;
import edu.jas.gb.GBSPTransportMessReq;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ReducerServerSeqPair<C extends RingElem<C>>
implements Runnable {
    private final Terminator pool;
    private final ChannelFactory cf;
    private SocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final CriticalPairList<C> pairlist;
    private static final Logger logger = LogManager.getLogger(ReducerServerSeqPair.class);

    ReducerServerSeqPair(Terminator terminator, ChannelFactory channelFactory, DistHashTable<Integer, GenPolynomial<C>> distHashTable, CriticalPairList<C> criticalPairList) {
        this.pool = terminator;
        this.cf = channelFactory;
        this.theList = distHashTable;
        this.pairlist = criticalPairList;
    }

    @Override
    public void run() {
        block36: {
            logger.debug("reducer server running");
            try {
                this.pairChannel = this.cf.getChannel();
            }
            catch (InterruptedException interruptedException) {
                logger.debug("get pair channel interrupted");
                interruptedException.printStackTrace();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("pairChannel = {}", (Object)this.pairChannel);
            }
            GenPolynomial genPolynomial = null;
            boolean bl = false;
            boolean bl2 = true;
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            while (bl2) {
                logger.debug("receive request");
                Object object = null;
                try {
                    object = this.pairChannel.receive();
                }
                catch (IOException iOException) {
                    bl2 = false;
                    iOException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl2 = false;
                    classNotFoundException.printStackTrace();
                }
                if (object == null) {
                    bl2 = false;
                    break;
                }
                if (!(object instanceof GBSPTransportMessReq)) {
                    bl2 = false;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("find pair");
                    logger.debug("pool.hasJobs() {} pairlist.hasNext() {}", (Object)this.pool.hasJobs(), (Object)this.pairlist.hasNext());
                }
                while (!this.pairlist.hasNext()) {
                    this.pairlist.update();
                    if (!bl) {
                        this.pool.beIdle();
                        bl = true;
                    }
                    if (!this.pool.hasJobs() && !this.pairlist.hasNext()) {
                        bl2 = false;
                        break;
                    }
                    try {
                        if (++n3 % 10 == 0) {
                            logger.info(" reducer is sleeping");
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = false;
                        break;
                    }
                }
                if (!this.pairlist.hasNext() && !this.pool.hasJobs()) {
                    bl2 = false;
                    break;
                }
                if (bl) {
                    bl = false;
                    this.pool.notIdle();
                }
                CriticalPair<C> criticalPair = this.pairlist.getNext();
                if (logger.isDebugEnabled()) {
                    logger.debug("send pair = {}", criticalPair);
                    logger.info("theList keys {}", this.theList.keySet());
                }
                if (logger.isDebugEnabled()) {
                    logger.info("inWork {}", this.pairlist.inWork());
                }
                GBSPTransportMess gBSPTransportMess = null;
                gBSPTransportMess = criticalPair != null ? new GBSPTransportMessPairIndex(criticalPair) : new GBSPTransportMess();
                try {
                    this.pairChannel.send(gBSPTransportMess);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl2 = false;
                    break;
                }
                this.pairlist.update();
                Object object2 = null;
                try {
                    object2 = this.pairChannel.receive();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl2 = false;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    bl2 = false;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.info("received H polynomial rh = {}", object2);
                }
                if (object2 == null) {
                    if (criticalPair != null) {
                        n = this.pairlist.record(criticalPair, null);
                    }
                    this.pairlist.update();
                    continue;
                }
                if (object2 instanceof GBSPTransportMessPoly) {
                    ++n2;
                    genPolynomial = ((GBSPTransportMessPoly)object2).pol;
                    if (genPolynomial == null) {
                        if (criticalPair != null) {
                            n = this.pairlist.record(criticalPair, null);
                        }
                        this.pairlist.update();
                        continue;
                    }
                    if (genPolynomial.isZERO()) {
                        n = this.pairlist.record(criticalPair, genPolynomial);
                        continue;
                    }
                    if (genPolynomial.isONE()) {
                        this.pairlist.putOne();
                        this.theList.put(0, genPolynomial);
                        bl2 = false;
                        continue;
                    }
                    n = this.pairlist.record(criticalPair, genPolynomial);
                    this.theList.put(n, genPolynomial);
                    continue;
                }
                if (criticalPair != null) {
                    n = this.pairlist.record(criticalPair, null);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("invalid message {}", object2);
            }
            logger.info("terminated, done {} reductions", (Object)n2);
            logger.debug("send end");
            try {
                this.pairChannel.send(new GBSPTransportMessEnd());
            }
            catch (IOException iOException) {
                if (!logger.isDebugEnabled()) break block36;
                iOException.printStackTrace();
            }
        }
        this.pool.beIdle();
        this.pairChannel.close();
    }
}

