/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.SGBProxy;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseParallel;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SGBProxyTest
extends TestCase {
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    List<GenSolvablePolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    GenSolvablePolynomialRing<BigRational> ring;
    SolvableGroebnerBaseAbstract<BigRational> sbb;
    BigRational cfac;
    TermOrder tord;
    RelationTable<BigRational> table;
    int rl = 4;
    int kl = 10;
    int ll = 4;
    int el = 2;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SGBProxyTest.suite());
        ComputerThreads.terminate();
    }

    public SGBProxyTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SGBProxyTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(9L);
        this.tord = new TermOrder();
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, this.tord);
        this.table = this.ring.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        int n = ComputerThreads.N_CPUS - 1;
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        SolvableGroebnerBaseParallel solvableGroebnerBaseParallel = new SolvableGroebnerBaseParallel(n);
        this.sbb = new SGBProxy<BigRational>(solvableGroebnerBaseSeq, solvableGroebnerBaseParallel);
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ring = null;
        this.tord = null;
        this.table = null;
        this.cfac = null;
        this.sbb.terminate();
        this.sbb = null;
    }

    public void testProxyGBase() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testWeylProxyGBase() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SGBProxyTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testProxyTSGBase() {
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }

    public void testWeylProxyTSGBase() {
        int n = 4;
        this.ring = new GenSolvablePolynomialRing<BigRational>(this.cfac, n);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.ring);
        this.table = this.ring.table;
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        this.L = new ArrayList<GenSolvablePolynomial<BigRational>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SGBProxyTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }
}

