/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.LeftSolvableReducer;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableMiReducer;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.gb.TwosidedSolvableReducer;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolvableGroebnerBaseParallel<C extends RingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SolvableGroebnerBaseParallel.class);
    protected final int threads;
    protected final transient ExecutorService pool;

    public SolvableGroebnerBaseParallel() {
        this(2);
    }

    public SolvableGroebnerBaseParallel(int n) {
        this(n, Executors.newFixedThreadPool(n));
    }

    public SolvableGroebnerBaseParallel(int n, ExecutorService executorService) {
        this(n, executorService, new SolvableReductionPar());
    }

    public SolvableGroebnerBaseParallel(int n, SolvableReduction<C> solvableReduction) {
        this(n, Executors.newFixedThreadPool(n), solvableReduction);
    }

    public SolvableGroebnerBaseParallel(int n, PairList<C> pairList) {
        this(n, Executors.newFixedThreadPool(n), new SolvableReductionPar(), pairList);
    }

    public SolvableGroebnerBaseParallel(int n, SolvableReduction<C> solvableReduction, PairList<C> pairList) {
        this(n, Executors.newFixedThreadPool(n), solvableReduction, pairList);
    }

    public SolvableGroebnerBaseParallel(int n, ExecutorService executorService, SolvableReduction<C> solvableReduction) {
        this(n, executorService, solvableReduction, new OrderedPairlist());
    }

    public SolvableGroebnerBaseParallel(int n, ExecutorService executorService, SolvableReduction<C> solvableReduction, PairList<C> pairList) {
        super(solvableReduction, pairList);
        if (!(solvableReduction instanceof SolvableReductionPar)) {
            logger.warn("parallel GB should use parallel aware reduction");
        }
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.pool = executorService;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.shutdown();
        try {
            while (!this.pool.isTerminated()) {
                boolean bl = this.pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        logger.info("{}", (Object)this.pool);
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int n = this.pool.shutdownNow().size();
        logger.info("{}", (Object)this.pool);
        return n;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int n, List<GenSolvablePolynomial<C>> list) {
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(PolyUtil.monic(PolynomialList.castToList(list2)))).size() <= 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (!genSolvablePolynomialRing.coFac.isField() && genSolvablePolynomialRing.coFac.isCommutative()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        logger.info("start {}", pairList);
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            LeftSolvableReducer<C> leftSolvableReducer = new LeftSolvableReducer<C>(terminator, list2, pairList);
            this.pool.execute(leftSolvableReducer);
        }
        terminator.waitDone();
        logger.debug("#parallel list = {}", (Object)list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("end   {}", pairList);
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        ListIterator<GenSolvablePolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genSolvablePolynomial = listIterator.next();
            if (genSolvablePolynomial.length() == 0) continue;
            arrayList.add(genSolvablePolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenSolvablePolynomial<Object> genSolvablePolynomial2;
            genSolvablePolynomial = arrayList.remove(0);
            ExpVector expVector2 = genSolvablePolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                expVector = genSolvablePolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                expVector = genSolvablePolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genSolvablePolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        SolvableMiReducer[] solvableMiReducerArray = new SolvableMiReducer[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genSolvablePolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            solvableMiReducerArray[n] = new SolvableMiReducer(arrayList3, genSolvablePolynomial);
            this.pool.execute(solvableMiReducerArray[n]);
            ++n;
            arrayList2.add(genSolvablePolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < solvableMiReducerArray.length; ++n) {
            genSolvablePolynomial = solvableMiReducerArray[n].getNF();
            arrayList2.add(genSolvablePolynomial);
        }
        return arrayList2;
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(int n, List<GenSolvablePolynomial<C>> list) {
        throw new UnsupportedOperationException("parallel extLeftGB not implemented");
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int n, List<GenSolvablePolynomial<C>> list) {
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(PolyUtil.monic(PolynomialList.castToList(list2)))).size() < 1) {
            return list2;
        }
        if (list2.size() <= 1 && list2.get(0).isONE()) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (!genSolvablePolynomialRing.coFac.isField() && genSolvablePolynomialRing.coFac.isCommutative()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        List list3 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators(n));
        logger.info("right multipliers = {}", list3);
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list2.size() * (1 + list3.size()));
        arrayList.addAll(list2);
        for (int i = 0; i < arrayList.size(); ++i) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)arrayList.get(i);
            for (int j = 0; j < list3.size(); ++j) {
                GenSolvablePolynomial genSolvablePolynomial2 = list3.get(j);
                if (genSolvablePolynomial2.isONE()) continue;
                GenPolynomial genPolynomial = genSolvablePolynomial.multiply(genSolvablePolynomial2);
                if ((genPolynomial = this.sred.leftNormalform(arrayList, genPolynomial)).isZERO()) continue;
                if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                    list2.clear();
                    list2.add((GenSolvablePolynomial<C>)genPolynomial);
                    return list2;
                }
                arrayList.add((GenSolvablePolynomial<C>)genPolynomial);
            }
        }
        list2 = arrayList;
        if (list2.size() <= 1) {
            return list2;
        }
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        logger.info("start {}", pairList);
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            TwosidedSolvableReducer twosidedSolvableReducer = new TwosidedSolvableReducer(terminator, n, list3, list2, pairList);
            this.pool.execute(twosidedSolvableReducer);
        }
        terminator.waitDone();
        logger.debug("#parallel list = {}", (Object)list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("end   {}", pairList);
        return list2;
    }
}

