/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPairList;
import edu.jas.gb.LeftSolvableReducerSeqPair;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableMiReducerSeqPair;
import edu.jas.gb.SolvableReduction;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.gb.TwosidedSolvableReducerSeqPair;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolvableGroebnerBaseSeqPairParallel<C extends RingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SolvableGroebnerBaseSeqPairParallel.class);
    protected final int threads;
    protected final transient ExecutorService pool;

    public SolvableGroebnerBaseSeqPairParallel() {
        this(2);
    }

    public SolvableGroebnerBaseSeqPairParallel(int n) {
        this(n, Executors.newFixedThreadPool(n));
    }

    public SolvableGroebnerBaseSeqPairParallel(int n, ExecutorService executorService) {
        this(n, executorService, new SolvableReductionPar());
    }

    public SolvableGroebnerBaseSeqPairParallel(int n, SolvableReduction<C> solvableReduction) {
        this(n, Executors.newFixedThreadPool(n), solvableReduction);
    }

    public SolvableGroebnerBaseSeqPairParallel(int n, ExecutorService executorService, SolvableReduction<C> solvableReduction) {
        super(solvableReduction);
        if (!(solvableReduction instanceof SolvableReductionPar)) {
            logger.warn("parallel GB should use parallel aware reduction");
        }
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.pool = executorService;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.shutdown();
        try {
            while (!this.pool.isTerminated()) {
                boolean bl = this.pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        logger.info("{}", (Object)this.pool);
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int n = this.pool.shutdownNow().size();
        logger.info("{}", (Object)this.pool);
        return n;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int n, List<GenSolvablePolynomial<C>> list) {
        List<GenSolvablePolynomial<C>> list2 = new ArrayList<GenSolvablePolynomial<C>>();
        CriticalPairList criticalPairList = null;
        int n2 = list.size();
        ListIterator<GenSolvablePolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GenPolynomial genPolynomial = listIterator.next();
            if (genPolynomial.length() > 0) {
                if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                    list2.clear();
                    list2.add((GenSolvablePolynomial<C>)genPolynomial);
                    return list2;
                }
                list2.add((GenSolvablePolynomial<C>)genPolynomial);
                if (criticalPairList == null) {
                    criticalPairList = new CriticalPairList(n, ((GenSolvablePolynomial)genPolynomial).ring);
                    if (!((GenSolvablePolynomial)genPolynomial).ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                criticalPairList.put(genPolynomial);
                continue;
            }
            --n2;
        }
        if (n2 <= 1) {
            return list2;
        }
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            LeftSolvableReducerSeqPair<C> leftSolvableReducerSeqPair = new LeftSolvableReducerSeqPair<C>(terminator, list2, criticalPairList);
            this.pool.execute(leftSolvableReducerSeqPair);
        }
        terminator.waitDone();
        logger.debug("#parallel list = {}", (Object)list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("{}", criticalPairList);
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial<C> genSolvablePolynomial;
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list.size());
        ListIterator<GenSolvablePolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genSolvablePolynomial = listIterator.next();
            if (genSolvablePolynomial.length() == 0) continue;
            arrayList.add(genSolvablePolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenSolvablePolynomial<Object> genSolvablePolynomial2;
            genSolvablePolynomial = arrayList.remove(0);
            ExpVector expVector2 = genSolvablePolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                expVector = genSolvablePolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial2 = listIterator.next();
                expVector = genSolvablePolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genSolvablePolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        SolvableMiReducerSeqPair[] solvableMiReducerSeqPairArray = new SolvableMiReducerSeqPair[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genSolvablePolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            solvableMiReducerSeqPairArray[n] = new SolvableMiReducerSeqPair(arrayList3, genSolvablePolynomial);
            this.pool.execute(solvableMiReducerSeqPairArray[n]);
            ++n;
            arrayList2.add(genSolvablePolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < solvableMiReducerSeqPairArray.length; ++n) {
            genSolvablePolynomial = solvableMiReducerSeqPairArray[n].getNF();
            arrayList2.add(genSolvablePolynomial);
        }
        return arrayList2;
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(int n, List<GenSolvablePolynomial<C>> list) {
        throw new UnsupportedOperationException("parallel extLeftGB not implemented");
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int n, List<GenSolvablePolynomial<C>> list) {
        GenPolynomial genPolynomial;
        if (list == null || list.size() == 0) {
            return new ArrayList<GenSolvablePolynomial<C>>();
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        List list2 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators(n));
        logger.info("right multipliers = {}", list2);
        ArrayList arrayList = new ArrayList(list.size() * (1 + list2.size()));
        arrayList.addAll(list);
        for (int i = 0; i < arrayList.size(); ++i) {
            genPolynomial = (GenSolvablePolynomial)arrayList.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                GenSolvablePolynomial genSolvablePolynomial = list2.get(j);
                if (genSolvablePolynomial.isONE()) continue;
                GenSolvablePolynomial genSolvablePolynomial2 = ((GenSolvablePolynomial)genPolynomial).multiply(genSolvablePolynomial);
                if ((genSolvablePolynomial2 = this.sred.leftNormalform(arrayList, genSolvablePolynomial2)).isZERO()) continue;
                arrayList.add(genSolvablePolynomial2);
            }
        }
        List<GenSolvablePolynomial<C>> list3 = new ArrayList<GenSolvablePolynomial<C>>();
        CriticalPairList criticalPairList = null;
        int n2 = arrayList.size();
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = (GenSolvablePolynomial)listIterator.next();
            if (genPolynomial.length() > 0) {
                if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                    list3.clear();
                    list3.add((GenSolvablePolynomial<C>)genPolynomial);
                    return list3;
                }
                list3.add((GenSolvablePolynomial<C>)genPolynomial);
                if (criticalPairList == null) {
                    criticalPairList = new CriticalPairList(n, ((GenSolvablePolynomial)genPolynomial).ring);
                    if (!((GenSolvablePolynomial)genPolynomial).ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                criticalPairList.put(genPolynomial);
                continue;
            }
            --n2;
        }
        if (n2 <= 1) {
            return list3;
        }
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            TwosidedSolvableReducerSeqPair twosidedSolvableReducerSeqPair = new TwosidedSolvableReducerSeqPair(terminator, list2, list3, criticalPairList);
            this.pool.execute(twosidedSolvableReducerSeqPair);
        }
        terminator.waitDone();
        logger.debug("#parallel list = {}", (Object)list3.size());
        list3 = this.leftMinimalGB(list3);
        logger.info("{}", criticalPairList);
        return list3;
    }
}

