/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gbufd.GroebnerBasePseudoRecParallel;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.QuotientRing;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GroebnerBasePseudoRecParTest
extends TestCase {
    GenPolynomialRing<GenPolynomial<BigInteger>> fac;
    List<GenPolynomial<GenPolynomial<BigInteger>>> L;
    PolynomialList<GenPolynomial<BigInteger>> F;
    List<GenPolynomial<GenPolynomial<BigInteger>>> G;
    GroebnerBaseAbstract<GenPolynomial<BigInteger>> bb;
    GroebnerBaseAbstract<GenPolynomial<BigRational>> bbr;
    GenPolynomial<GenPolynomial<BigInteger>> a;
    GenPolynomial<GenPolynomial<BigInteger>> b;
    GenPolynomial<GenPolynomial<BigInteger>> c;
    GenPolynomial<GenPolynomial<BigInteger>> d;
    GenPolynomial<GenPolynomial<BigInteger>> e;
    int rl = 2;
    int kl = 2;
    int ll = 5;
    int el = 4;
    float q = 0.3f;
    int threads = 3;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GroebnerBasePseudoRecParTest.suite());
        ComputerThreads.terminate();
    }

    public GroebnerBasePseudoRecParTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GroebnerBasePseudoRecParTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigInteger bigInteger = new BigInteger(9L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, 1);
        this.fac = new GenPolynomialRing<BigInteger>(genPolynomialRing, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new GroebnerBasePseudoRecParallel<BigInteger>(this.threads, genPolynomialRing);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb.terminate();
        this.bb = null;
    }

    public void testRecParallelGBase() {
        this.L = new ArrayList<GenPolynomial<GenPolynomial<BigInteger>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.getZERO();
        this.e = this.c;
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        if (this.bb.commonZeroTest(this.L) < 0) {
            this.L.clear();
        }
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testHawes2GBase() {
        String string = "IntFunc(a, c, b) (y2, y1, z1, z2, x) G(( x + 2 y1 z1 + { 3 a } y1^2 + 5 y1^4 + { 2 c } y1 ),( x + 2 y2 z2 + { 3 a } y2^2 + 5 y2^4 + { 2 c } y2 ),( 2 z2 + { 6 a } y2 + 20 y2^3 + { 2 c } ),( 3 z1^2 + y1^2 + { b } ),( 3 z2^2 + y2^2 + { b } ))";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            GroebnerBasePseudoRecParTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            GroebnerBasePseudoRecParTest.fail((String)("" + iOException));
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)polynomialList.ring.coFac;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        this.fac = new GenPolynomialRing<BigInteger>(genPolynomialRing2, polynomialList.ring);
        this.L = PolyUfdUtil.integerFromRationalCoefficients(this.fac, polynomialList.list);
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.L);
        l = System.currentTimeMillis() - l;
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( GB(Hawes2) )", (boolean)this.bb.isGB(this.G));
        GroebnerBasePseudoRecParTest.assertEquals((String)"#GB(Hawes2) == 8", (int)8, (int)this.G.size());
        this.G = OrderedPolynomialList.sort(this.G);
        PolynomialList<GenPolynomial<BigInteger>> polynomialList2 = new PolynomialList<GenPolynomial<BigInteger>>(this.fac, this.G);
        GroebnerBasePseudoRecParTest.assertTrue((String)"nonsense ", (!polynomialList2.getList().isEmpty() ? 1 : 0) != 0);
        GenPolynomialRing genPolynomialRing3 = (GenPolynomialRing)polynomialList.ring.coFac;
        List list = polynomialList.list;
        this.bbr = new GroebnerBasePseudoRecParallel<BigRational>(this.threads, genPolynomialRing3);
        long l2 = System.currentTimeMillis();
        List list2 = this.bbr.GB(list);
        l2 = System.currentTimeMillis() - l2;
        list2 = PolyUtil.monicRec(list2);
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( GB(Hawes2) )", (boolean)this.bbr.isGB(list2));
        GroebnerBasePseudoRecParTest.assertEquals((String)"#GB(Hawes2) == 8", (int)8, (int)list2.size());
        list2 = OrderedPolynomialList.sort(list2);
        PolynomialList polynomialList3 = new PolynomialList(polynomialList.ring, list2);
        GroebnerBasePseudoRecParTest.assertTrue((String)"nonsense ", (!polynomialList3.getList().isEmpty() ? 1 : 0) != 0);
        this.bbr.terminate();
        List list3 = PolyUfdUtil.fromIntegerCoefficients(polynomialList.ring, this.G);
        list3 = PolyUtil.monicRec(list3);
        GroebnerBasePseudoRecParTest.assertEquals((String)"ratGB == intGB", list3, list2);
        GroebnerBasePseudoRecParTest.assertTrue((String)"nonsense ", (l2 >= 0L ? 1 : 0) != 0);
        QuotientRing quotientRing = new QuotientRing(genPolynomialRing3);
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(quotientRing, this.fac);
        List list4 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing4, list);
        list4 = PolyUtil.monic(list4);
        GroebnerBaseParallel groebnerBaseParallel = new GroebnerBaseParallel(this.threads);
        long l3 = System.currentTimeMillis();
        List list5 = groebnerBaseParallel.GB(list4);
        l3 = System.currentTimeMillis() - l3;
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( GB(Hawes2) )", (boolean)groebnerBaseParallel.isGB(list5));
        GroebnerBasePseudoRecParTest.assertEquals((String)"#GB(Hawes2) == 8", (int)8, (int)list5.size());
        list5 = OrderedPolynomialList.sort(list5);
        PolynomialList polynomialList4 = new PolynomialList(genPolynomialRing4, list5);
        GroebnerBasePseudoRecParTest.assertTrue((String)"nonsense ", (!polynomialList4.getList().isEmpty() ? 1 : 0) != 0);
        ((GroebnerBaseAbstract)groebnerBaseParallel).terminate();
        List list6 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing4, list2);
        list6 = PolyUtil.monic(list6);
        GroebnerBasePseudoRecParTest.assertEquals((String)"ratGB == quotGB", list6, list5);
        GroebnerBasePseudoRecParTest.assertTrue((String)"nonsense ", (l3 >= 0L ? 1 : 0) != 0);
        QuotientRing<BigInteger> quotientRing2 = new QuotientRing<BigInteger>(genPolynomialRing2);
        GenPolynomialRing<BigInteger> genPolynomialRing5 = new GenPolynomialRing<BigInteger>(quotientRing2, this.fac);
        List list7 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing5, this.L);
        list7 = PolyUtil.monic(list7);
        GroebnerBaseParallel groebnerBaseParallel2 = new GroebnerBaseParallel(this.threads);
        long l4 = System.currentTimeMillis();
        List list8 = groebnerBaseParallel2.GB(list7);
        l4 = System.currentTimeMillis() - l4;
        GroebnerBasePseudoRecParTest.assertTrue((String)"isGB( GB(Hawes2) )", (boolean)groebnerBaseParallel2.isGB(list8));
        GroebnerBasePseudoRecParTest.assertEquals((String)"#GB(Hawes2) == 8", (int)8, (int)list8.size());
        list8 = OrderedPolynomialList.sort(list8);
        PolynomialList<BigInteger> polynomialList5 = new PolynomialList<BigInteger>(genPolynomialRing5, list8);
        GroebnerBasePseudoRecParTest.assertTrue((String)"nonsense ", (!polynomialList5.getList().isEmpty() ? 1 : 0) != 0);
        ((GroebnerBaseAbstract)groebnerBaseParallel2).terminate();
        List list9 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing5, this.G);
        list9 = PolyUtil.monic(list9);
        GroebnerBasePseudoRecParTest.assertEquals((String)"quotRatGB == quotIntGB", list8, list9);
        GroebnerBasePseudoRecParTest.assertTrue((String)"nonsense ", (l4 >= 0L ? 1 : 0) != 0);
        GroebnerBasePseudoRecParTest.assertTrue((String)"positive times ", (l2 >= 0L && l >= 0L && l3 >= 0L && l4 >= 0L ? 1 : 0) != 0);
    }
}

