/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordGroebnerBaseSeq;
import edu.jas.gbufd.GBFactory;
import edu.jas.gbufd.SGBFactory;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.WordMonomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolyGBUtil {
    private static final Logger logger = LogManager.getLogger(PolyGBUtil.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> boolean isResultant(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3) {
        if (genPolynomial3 == null || genPolynomial3.isZERO()) {
            return true;
        }
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(genPolynomial3.ring.coFac);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genPolynomial);
        arrayList.add(genPolynomial2);
        List list = groebnerBaseAbstract.GB(arrayList);
        GenPolynomial genPolynomial4 = groebnerBaseAbstract.red.normalform(list, genPolynomial3);
        return genPolynomial4.isZERO();
    }

    public static <C extends RingElem<C>> GenPolynomial<C> topPseudoRemainder(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return genPolynomial.monic();
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        if (genPolynomialRing.nvar <= 1) {
            GenPolynomial<C> genPolynomial2 = PolyUtil.baseSparsePseudoRemainder(genPolynomial, list.get(0));
            return genPolynomial2.monic();
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial<C> genPolynomial3 = list.get(0);
        GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing2, genPolynomial3);
        GenPolynomial genPolynomial5 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        if (genPolynomial4.isONE()) {
            return genPolynomial.ring.getZERO();
        }
        GenPolynomial<GenPolynomial<Object>> genPolynomial6 = genPolynomial4.degree(0) > 0L ? PolyUtil.recursiveSparsePseudoRemainder(genPolynomial5, genPolynomial4) : genPolynomial5;
        if (genPolynomial6.degree(0) > 0L) {
            GenPolynomial genPolynomial7 = PolyUtil.distribute(genPolynomialRing, genPolynomial6);
            return genPolynomial7.monic();
        }
        List<GenPolynomial<C>> list2 = PolyGBUtil.zeroDegrees(list);
        GenPolynomial genPolynomial8 = PolyGBUtil.topPseudoRemainder(list2, genPolynomial6.leadingBaseCoefficient());
        genPolynomial8 = genPolynomial8.extend(genPolynomialRing, 0, 0L);
        return genPolynomial8.monic();
    }

    public static <C extends RingElem<C>> GenPolynomial<C> topCoefficientPseudoRemainder(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return genPolynomial.monic();
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = list.get((int)0).ring;
        if (genPolynomialRing2.nvar <= 1) {
            GenPolynomial<C> genPolynomial2 = list.get(0);
            GenPolynomialRing genPolynomialRing3 = genPolynomialRing.recursive(genPolynomialRing.nvar - 1);
            GenPolynomial genPolynomial3 = PolyUtil.recursive(genPolynomialRing3, genPolynomial);
            GenPolynomial genPolynomial4 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial3, genPolynomial2);
            GenPolynomial genPolynomial5 = PolyUtil.distribute(genPolynomialRing, genPolynomial4);
            return genPolynomial5.monic();
        }
        GenPolynomialRing genPolynomialRing4 = genPolynomialRing2.recursive(1);
        int n = genPolynomialRing.nvar - genPolynomialRing2.nvar;
        GenPolynomialRing genPolynomialRing5 = genPolynomialRing.recursive(1 + n);
        GenPolynomialRing genPolynomialRing6 = genPolynomialRing5.recursive(n);
        if (debug) {
            logger.info("rfac = {}", genPolynomialRing5);
        }
        GenPolynomial genPolynomial6 = PolyUtil.recursive(genPolynomialRing5, genPolynomial);
        GenPolynomial genPolynomial7 = PolyUtil.recursive(genPolynomialRing6, genPolynomial6);
        GenPolynomial<C> genPolynomial8 = list.get(0);
        GenPolynomial genPolynomial9 = PolyUtil.recursive(genPolynomialRing4, genPolynomial8);
        if (genPolynomial9.isONE()) {
            return genPolynomial.ring.getZERO();
        }
        GenPolynomial<GenPolynomial<Object>> genPolynomial10 = genPolynomial9.degree(0) > 0L ? PolyGBUtil.coefficientPseudoRemainder(genPolynomial7, genPolynomial9) : genPolynomial7;
        List<GenPolynomial<C>> list2 = PolyGBUtil.zeroDegrees(list);
        GenPolynomial genPolynomial11 = PolyUtil.distribute(genPolynomialRing5, genPolynomial10);
        GenPolynomial genPolynomial12 = PolyUtil.distribute(genPolynomialRing, genPolynomial11);
        genPolynomial12 = PolyGBUtil.topCoefficientPseudoRemainder(list2, genPolynomial12);
        return genPolynomial12.monic();
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<GenPolynomial<C>>> coefficientPseudoRemainder(GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial.ring.getZERO();
        }
        if (genPolynomial.isZERO() || genPolynomial.isONE()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>> genPolynomial3 = genPolynomial;
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomial.leadingBaseCoefficient();
        long l = genPolynomial4.degree(0);
        long l2 = genPolynomial2.degree(0);
        GenPolynomial<C> genPolynomial5 = genPolynomial2.leadingBaseCoefficient();
        GenPolynomial<GenPolynomial<C>> genPolynomial6 = ((GenPolynomial)genPolynomialRing2.getZERO()).sum(genPolynomial5);
        ExpVector expVector = genPolynomial2.leadingExpVector();
        for (long i = l; i >= l2; --i) {
            if (genPolynomial3.isZERO()) {
                return genPolynomial3;
            }
            GenPolynomial<GenPolynomial<C>> genPolynomial7 = genPolynomial3.leadingBaseCoefficient();
            ExpVector expVector2 = genPolynomial3.leadingExpVector();
            long l3 = genPolynomial7.degree(0);
            if (i == l3) {
                GenPolynomial<C> genPolynomial8 = genPolynomial7.leadingBaseCoefficient();
                ExpVector expVector3 = genPolynomial7.leadingExpVector();
                expVector3 = expVector3.subtract(expVector);
                genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)genPolynomial6);
                GenPolynomial<GenPolynomial<C>> genPolynomial9 = genPolynomial2.multiply(genPolynomial8, expVector3);
                GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial10 = new GenPolynomial<GenPolynomial<GenPolynomial<C>>>(genPolynomialRing, genPolynomial9, expVector2);
                genPolynomial3 = genPolynomial3.subtract((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)genPolynomial10);
                continue;
            }
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>>)genPolynomial6);
        }
        if (genPolynomial3.degree(0) < genPolynomial.degree(0)) {
            genPolynomial3 = PolyGBUtil.coefficientPseudoRemainder(genPolynomial3, genPolynomial2);
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> coefficientPseudoRemainderBase(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new ArithmeticException(genPolynomial + " division by zero " + genPolynomial2);
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial.ring.getZERO();
        }
        if (genPolynomial.isZERO() || genPolynomial.isONE()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomial2.ring;
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial3 = genPolynomial;
        GenPolynomial<C> genPolynomial4 = genPolynomial.leadingBaseCoefficient();
        long l = genPolynomial4.degree(0);
        long l2 = genPolynomial2.degree(0);
        C c = genPolynomial2.leadingBaseCoefficient();
        GenPolynomial<C> genPolynomial5 = ((GenPolynomial)genPolynomialRing2.getZERO()).sum(c);
        ExpVector expVector = genPolynomial2.leadingExpVector();
        for (long i = l; i >= l2; --i) {
            if (genPolynomial3.isZERO()) {
                return genPolynomial3;
            }
            GenPolynomial<C> genPolynomial6 = genPolynomial3.leadingBaseCoefficient();
            ExpVector expVector2 = genPolynomial3.leadingExpVector();
            long l3 = genPolynomial6.degree(0);
            if (i == l3) {
                C c2 = genPolynomial6.leadingBaseCoefficient();
                ExpVector expVector3 = genPolynomial6.leadingExpVector();
                expVector3 = expVector3.subtract(expVector);
                genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial5);
                GenPolynomial<C> genPolynomial7 = genPolynomial2.multiply(c2, expVector3);
                GenPolynomial<GenPolynomial<C>> genPolynomial8 = new GenPolynomial<GenPolynomial<C>>(genPolynomialRing, genPolynomial7, expVector2);
                genPolynomial3 = genPolynomial3.subtract(genPolynomial8);
                continue;
            }
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial5);
        }
        if (genPolynomial3.degree(0) < genPolynomial.degree(0)) {
            genPolynomial3 = PolyGBUtil.coefficientPseudoRemainderBase(genPolynomial3, genPolynomial2);
        }
        return genPolynomial3;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> zeroDegrees(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial = list.get(i);
            GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
            if (genPolynomial2.degree(0) != 0L) continue;
            arrayList.add(genPolynomial2.leadingBaseCoefficient());
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<C>> intersect(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2) {
        Iterable<Monomial<C>> iterable;
        Iterable<Monomial<C>> iterable22;
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        int n = list.size() + list2.size();
        ArrayList arrayList = new ArrayList(n);
        GenPolynomialRing<C> genPolynomialRing2 = genPolynomialRing.extend(1);
        for (Iterable<Monomial<C>> iterable22 : list) {
            iterable22 = iterable22.extend(genPolynomialRing2, 0, 1L);
            arrayList.add(iterable22);
        }
        for (Iterable<Monomial<C>> iterable22 : list2) {
            iterable = iterable22.extend(genPolynomialRing2, 0, 1L);
            GenPolynomial<GenPolynomial<C>> genPolynomial = iterable22.extend(genPolynomialRing2, 0, 0L);
            iterable22 = genPolynomial.subtract((GenPolynomial<C>)iterable);
            arrayList.add(iterable22);
        }
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing2.coFac);
        logger.warn("intersect computing GB");
        iterable22 = groebnerBaseAbstract.GB(arrayList);
        if (debug) {
            logger.debug("intersect GB = {}", iterable22);
        }
        iterable = PolyUtil.intersect(genPolynomialRing, iterable22);
        return iterable;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<C>> intersect(GenSolvablePolynomialRing<C> genSolvablePolynomialRing, List<GenSolvablePolynomial<C>> list, List<GenSolvablePolynomial<C>> list2) {
        Iterable iterable;
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        int n = list.size() + list2.size();
        ArrayList arrayList = new ArrayList(n);
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.extend(1);
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
            GenSolvablePolynomial iterable22 = (GenSolvablePolynomial)genSolvablePolynomial.extend(genPolynomialRing, 0, 1L);
            arrayList.add(iterable22);
        }
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list2) {
            iterable = (GenSolvablePolynomial)genSolvablePolynomial.extend(genPolynomialRing, 0, 1L);
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial.extend(genPolynomialRing, 0, 0L);
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial2.subtract(iterable);
            arrayList.add(genSolvablePolynomial3);
        }
        SolvableGroebnerBaseAbstract solvableGroebnerBaseAbstract = SGBFactory.getImplementation(((GenSolvablePolynomialRing)genPolynomialRing).coFac);
        logger.warn("intersect computing GB");
        List list3 = solvableGroebnerBaseAbstract.leftGB(arrayList);
        if (debug) {
            logger.debug("intersect GB = {}", list3);
        }
        iterable = PolyUtil.intersect(genSolvablePolynomialRing, list3);
        return iterable;
    }

    public static <C extends GcdRingElem<C>> List<GenWordPolynomial<C>> intersect(GenWordPolynomialRing<C> genWordPolynomialRing, List<GenWordPolynomial<C>> list, List<GenWordPolynomial<C>> list2) {
        Iterable<WordMonomial<GenWordPolynomial<C>>> iterable;
        if (list == null || list.isEmpty()) {
            return list2;
        }
        if (list2 == null || list2.isEmpty()) {
            return list;
        }
        int n = list.size() + list2.size();
        ArrayList arrayList = new ArrayList(n);
        GenWordPolynomialRing<C> genWordPolynomialRing2 = genWordPolynomialRing.extend(1);
        List<GenWordPolynomial<C>> list3 = genWordPolynomialRing2.univariateList();
        GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial = list3.get(list3.size() - 1);
        for (GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<C>>> iterable22 : list3) {
            if (genWordPolynomial == iterable22) continue;
            iterable = genWordPolynomial.multiply(iterable22).subtract((GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<C>>>)iterable22.multiply(genWordPolynomial));
            arrayList.add(iterable);
        }
        for (GenWordPolynomial<C> genWordPolynomial2 : list) {
            GenWordPolynomial<GenWordPolynomial<C>> genWordPolynomial3 = genWordPolynomialRing2.valueOf(genWordPolynomial2).multiply(genWordPolynomial);
            arrayList.add(genWordPolynomial3);
        }
        for (GenWordPolynomial<C> genWordPolynomial4 : list2) {
            iterable = genWordPolynomialRing2.valueOf(genWordPolynomial4).multiply(genWordPolynomial);
            GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<C>>>> genWordPolynomial5 = genWordPolynomialRing2.valueOf(genWordPolynomial4);
            GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<C>>>> genWordPolynomial6 = genWordPolynomial5.subtract((GenWordPolynomial<GenWordPolynomial<GenWordPolynomial<C>>>)iterable);
            arrayList.add(genWordPolynomial6);
        }
        WordGroebnerBaseSeq wordGroebnerBaseSeq = new WordGroebnerBaseSeq();
        logger.warn("intersect computing GB");
        List list4 = ((WordGroebnerBaseAbstract)wordGroebnerBaseSeq).GB(arrayList);
        if (debug) {
            logger.debug("intersect GB = {}", list4);
        }
        iterable = PolyUtil.intersect(genWordPolynomialRing, list4);
        return iterable;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] quotientRemainder(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        GenSolvablePolynomial[] genSolvablePolynomialArray = new GenSolvablePolynomial[2];
        if (genSolvablePolynomial2.isZERO()) {
            throw new RuntimeException("division by zero: " + genSolvablePolynomial + "/" + genSolvablePolynomial2);
        }
        if (genSolvablePolynomial.isZERO()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomial;
            return genSolvablePolynomialArray;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = genSolvablePolynomial.ring;
        if (genSolvablePolynomial2.isONE()) {
            genSolvablePolynomialArray[0] = genSolvablePolynomial;
            genSolvablePolynomialArray[1] = genSolvablePolynomialRing.getZERO();
            return genSolvablePolynomialArray;
        }
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(genSolvablePolynomialRing.getZERO());
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(genSolvablePolynomial2);
        SolvableReductionSeq solvableReductionSeq = new SolvableReductionSeq();
        genSolvablePolynomialArray[1] = solvableReductionSeq.rightNormalform(arrayList, arrayList2, genSolvablePolynomial);
        genSolvablePolynomialArray[0] = (GenSolvablePolynomial)arrayList.get(0);
        return genSolvablePolynomialArray;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<C>> subRing(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        logger.debug("pfac = {}", genPolynomialRing);
        int n = genPolynomialRing.nvar;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> iterable22 : list) {
            if (iterable22 == null || iterable22.isZERO() || iterable22.isONE()) continue;
            arrayList.add(iterable22);
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.extendLower(n2);
        logger.debug("rfac = {}", genPolynomialRing2);
        assert (genPolynomialRing2.nvar == n + n2) : "rfac.nvar == n+k";
        ArrayList arrayList2 = new ArrayList();
        int n3 = 0;
        for (GenPolynomial genPolynomial : arrayList) {
            GenPolynomial genPolynomial2 = genPolynomial.extendLower(genPolynomialRing2, 0, 0L);
            genPolynomial2 = genPolynomial2.subtract(((GenPolynomial)genPolynomialRing.getONE()).extendLower(genPolynomialRing2, n3++, 1L));
            arrayList2.add(genPolynomial2);
        }
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing.coFac);
        List list2 = groebnerBaseAbstract.GB(arrayList2);
        return list2;
    }

    public static <C extends GcdRingElem<C>> boolean subRingMember(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        boolean bl;
        if (list == null || list.isEmpty()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        GenPolynomial genPolynomial2 = genPolynomial;
        if (genPolynomialRing.nvar == genPolynomial.ring.nvar) {
            throw new IllegalArgumentException("g must be extended: " + genPolynomialRing.nvar + " == " + genPolynomial.ring.nvar + " did you mean method subRingAndMember()?");
        }
        genPolynomial2 = genPolynomial2.extendLower(genPolynomialRing, 0, 0L);
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing.coFac);
        GenPolynomial genPolynomial3 = groebnerBaseAbstract.red.normalform(list, genPolynomial2);
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.contract(genPolynomial.ring.nvar);
        logger.debug("cfac = {}", genPolynomialRing2);
        Map map = genPolynomial3.contract(genPolynomialRing2);
        boolean bl2 = bl = map.size() == 1 && map.keySet().contains(genPolynomial.ring.evzero);
        if (!bl) {
            System.out.println("false: map = " + map);
        }
        return bl;
    }

    public static <C extends GcdRingElem<C>> boolean subRingAndMember(List<GenPolynomial<C>> list, GenPolynomial<C> genPolynomial) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        List<GenPolynomial<C>> list2 = PolyGBUtil.subRing(list);
        return PolyGBUtil.subRingMember(list2, genPolynomial);
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> chineseRemainderTheorem(List<List<GenPolynomial<C>>> list, List<GenPolynomial<C>> list2) {
        List list3;
        GenPolynomial genPolynomial;
        List<GenPolynomial<C>> list42;
        if (list == null || list.isEmpty() || list2 == null || list2.isEmpty()) {
            throw new IllegalArgumentException("F and A may not be empty or null");
        }
        int n = list.size();
        if (n != list2.size()) {
            throw new IllegalArgumentException("size(F) and size(A) must be equal");
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        logger.debug("pfac = {}", genPolynomialRing);
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.extend(n);
        logger.debug("rfac = {}", genPolynomialRing2);
        GenPolynomial genPolynomial2 = genPolynomialRing2.getONE();
        GenPolynomial genPolynomial3 = genPolynomialRing2.getZERO();
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        for (List<GenPolynomial<C>> list42 : list) {
            genPolynomial = ((GenPolynomial)genPolynomialRing.getONE()).extend(genPolynomialRing2, n2, 1L);
            genPolynomial2 = genPolynomial2.subtract(genPolynomial);
            list3 = new ArrayList(list42.size());
            for (GenPolynomial genPolynomial4 : list42) {
                GenPolynomial<C> genPolynomial5 = genPolynomial4.extend(genPolynomialRing2, n2, 1L);
                list3.add(genPolynomial5);
            }
            arrayList.addAll(list3);
            GenPolynomial<C> genPolynomial6 = list2.get(n2);
            genPolynomial3 = genPolynomial3.sum(genPolynomial6.extend(genPolynomialRing2, n2, 1L));
            ++n2;
        }
        arrayList.add(genPolynomial2);
        GroebnerBaseAbstract groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing.coFac);
        list42 = groebnerBaseAbstract.GB(arrayList);
        genPolynomial = groebnerBaseAbstract.red.normalform(list42, genPolynomial3);
        list3 = new ArrayList();
        list3.add(genPolynomial);
        list3 = PolyUtil.intersect(genPolynomialRing, list3);
        if (list3.isEmpty()) {
            return null;
        }
        return list3.get(0);
    }

    public static <C extends GcdRingElem<C>> boolean isChineseRemainder(List<List<GenPolynomial<C>>> list, List<GenPolynomial<C>> list2, GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            return false;
        }
        if (list == null || list.isEmpty() || list2 == null || list2.isEmpty()) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (!genPolynomialRing.coFac.isField()) {
            logger.error("only for field coefficients: {}", genPolynomialRing);
        }
        GroebnerBaseAbstract<C> groebnerBaseAbstract = GBFactory.getImplementation(genPolynomialRing.coFac);
        int n = 0;
        for (List<GenPolynomial<C>> list3 : list) {
            GenPolynomial<C> genPolynomial2;
            List list4 = groebnerBaseAbstract.GB(list3);
            GenPolynomial<GenPolynomial<C>> genPolynomial3 = groebnerBaseAbstract.red.normalform(list4, genPolynomial.subtract((GenPolynomial<GenPolynomial<C>>)(genPolynomial2 = list2.get(n))));
            if (!genPolynomial3.isZERO()) {
                logger.info("h-a = {}, fi  = {}", genPolynomial.subtract((GenPolynomial<GenPolynomial<C>>)genPolynomial2), genPolynomial3);
                return false;
            }
            ++n;
        }
        return true;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<C> CRTInterpolation(GenPolynomialRing<C> genPolynomialRing, List<List<C>> list, List<C> list2) {
        if (list == null || list.isEmpty() || list2 == null || list2.isEmpty()) {
            throw new IllegalArgumentException("E and V may not be empty or null");
        }
        int n = list.size();
        if (n != list2.size()) {
            throw new IllegalArgumentException("size(E) and size(V) must be equal");
        }
        ArrayList<List<GenPolynomial<C>>> arrayList = new ArrayList<List<GenPolynomial<C>>>(list.size());
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(list2.size());
        List<GenPolynomial<C>> list3 = genPolynomialRing.univariateList();
        int n2 = 0;
        for (List<C> list4 : list) {
            RingElem ringElem2;
            ArrayList<GenPolynomial<GenPolynomial<GcdRingElem>>> arrayList3 = new ArrayList<GenPolynomial<GenPolynomial<GcdRingElem>>>();
            int n3 = 0;
            for (RingElem ringElem2 : list4) {
                GenPolynomial<GenPolynomial<GcdRingElem>> genPolynomial = list3.get(n3);
                genPolynomial = genPolynomial.subtract(genPolynomialRing.valueOf((GcdRingElem)ringElem2));
                arrayList3.add(genPolynomial);
                ++n3;
            }
            arrayList.add(arrayList3);
            String string = " " + list2.get(n2);
            ringElem2 = (GenPolynomial)genPolynomialRing.valueOf(string);
            arrayList2.add((GenPolynomial<C>)ringElem2);
            ++n2;
        }
        GenPolynomial<C> genPolynomial = PolyGBUtil.chineseRemainderTheorem(arrayList, arrayList2);
        return genPolynomial;
    }
}

