/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gbufd.PseudoReductionEntry;
import edu.jas.gbufd.PseudoReductionSeq;
import edu.jas.gbufd.RPseudoReductionSeq;
import edu.jas.gbufd.RReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ReductionTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    int rl = 4;
    int kl = 10;
    int ll = 11;
    int el = 5;
    float q = 0.6f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ReductionTest.suite());
    }

    public ReductionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ReductionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(0L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testRationalRReduction() {
        BigRational bigRational = new BigRational(0L);
        ProductRing<BigRational> productRing = new ProductRing<BigRational>(bigRational, 3);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(productRing, this.rl);
        RReductionSeq<BigRational> rReductionSeq = new RReductionSeq<BigRational>();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<RingElem<BigRational>> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        while (genPolynomial2.isZERO()) {
            genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<RingElem<BigRational>> genPolynomial3 = rReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rReductionSeq.isNormalform(arrayList, genPolynomial3));
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = rReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rReductionSeq.isNormalform(arrayList, genPolynomial3));
        GenPolynomial<BigRational> genPolynomial4 = genPolynomialRing.getONE();
        genPolynomial = genPolynomial.sum((BigRational)((Object)genPolynomial4));
        genPolynomial3 = rReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rReductionSeq.isNormalform(arrayList, genPolynomial3));
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)rReductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)rReductionSeq.isReducible(arrayList, genPolynomial));
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)rReductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)rReductionSeq.isReducible(arrayList, genPolynomial2));
        genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = rReductionSeq.normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rReductionSeq.isNormalform(arrayList, genPolynomial3));
        genPolynomial4 = rReductionSeq.booleanClosure(genPolynomial);
        ReductionTest.assertTrue((String)"isBC( c )", (boolean)rReductionSeq.isBooleanClosed(genPolynomial4));
        genPolynomial2 = genPolynomial.subtract((BigRational)((Object)genPolynomial4));
        GenPolynomial<BigRational> genPolynomial5 = rReductionSeq.booleanRemainder(genPolynomial);
        ReductionTest.assertEquals((String)"a-BC(a)=BR(a)", genPolynomial2, genPolynomial5);
        genPolynomial3 = genPolynomial4.sum((BigRational)((Object)genPolynomial5));
        ReductionTest.assertEquals((String)"a==BC(a)+BR(a)", genPolynomial, genPolynomial3);
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        List list = rReductionSeq.booleanClosure(arrayList);
        List list2 = rReductionSeq.reducedBooleanClosure(arrayList);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rReductionSeq.isBooleanClosed(list));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rReductionSeq.isReducedBooleanClosed(list2));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rReductionSeq.isBooleanClosed(list2));
        arrayList.add(genPolynomial2);
        list = rReductionSeq.booleanClosure(arrayList);
        list2 = rReductionSeq.reducedBooleanClosure(arrayList);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rReductionSeq.isBooleanClosed(list));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rReductionSeq.isReducedBooleanClosed(list2));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rReductionSeq.isBooleanClosed(list2));
        while (genPolynomial4.isZERO()) {
            genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        arrayList.add(genPolynomial4);
        list = rReductionSeq.booleanClosure(arrayList);
        list2 = rReductionSeq.reducedBooleanClosure(arrayList);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rReductionSeq.isBooleanClosed(list));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rReductionSeq.isReducedBooleanClosed(list2));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rReductionSeq.isBooleanClosed(list2));
        while (genPolynomial5.isZERO()) {
            genPolynomial5 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        arrayList.add(genPolynomial5);
        list = rReductionSeq.booleanClosure(arrayList);
        list2 = rReductionSeq.reducedBooleanClosure(arrayList);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rReductionSeq.isBooleanClosed(list));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rReductionSeq.isReducedBooleanClosed(list2));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rReductionSeq.isBooleanClosed(list2));
    }

    public void testRatRReductionRecording() {
        int n;
        BigRational bigRational = new BigRational(0L);
        ProductRing<BigRational> productRing = new ProductRing<BigRational>(bigRational, 3);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(productRing, this.rl);
        RReductionSeq<BigRational> rReductionSeq = new RReductionSeq<BigRational>();
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        while (genPolynomial2.isZERO()) {
            genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        GenPolynomial<BigRational> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigRational> genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        ArrayList arrayList = null;
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(genPolynomial);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        GenPolynomial<BigRational> genPolynomial5 = rReductionSeq.normalform(arrayList, arrayList2, genPolynomial);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial, genPolynomial5));
        arrayList2.add(genPolynomial2);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        genPolynomial5 = rReductionSeq.normalform(arrayList, arrayList2, genPolynomial2);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial2, genPolynomial5));
        arrayList2.add(genPolynomial3);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        genPolynomial5 = rReductionSeq.normalform(arrayList, arrayList2, genPolynomial3);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial3, genPolynomial5));
        arrayList2.add(genPolynomial4);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        genPolynomial5 = rReductionSeq.normalform(arrayList, arrayList2, genPolynomial4);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial4, genPolynomial5));
    }

    public void testIntegerPseudoReduction() {
        BigInteger bigInteger = new BigInteger(0L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        PseudoReductionSeq<BigInteger> pseudoReductionSeq = new PseudoReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        if (genPolynomial.isZERO() || genPolynomial2.isZERO()) {
            return;
        }
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<BigInteger> genPolynomial3 = pseudoReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial3.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = pseudoReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)genPolynomial3.isZERO());
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.getONE();
        genPolynomial = genPolynomial.sum((BigInteger)((Object)genPolynomial4));
        genPolynomial3 = pseudoReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isConstant( e ) some times", (boolean)genPolynomial3.isConstant());
        arrayList = new ArrayList();
        genPolynomial = genPolynomial4.multiply(bigInteger.fromInteger(4L));
        genPolynomial2 = genPolynomial4.multiply(bigInteger.fromInteger(5L));
        arrayList.add(genPolynomial);
        genPolynomial3 = pseudoReductionSeq.normalform(arrayList, genPolynomial2);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial3.isZERO());
        genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)pseudoReductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)pseudoReductionSeq.isReducible(arrayList, genPolynomial));
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)pseudoReductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)pseudoReductionSeq.isReducible(arrayList, genPolynomial2));
        genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = pseudoReductionSeq.normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)pseudoReductionSeq.isNormalform(arrayList, genPolynomial3));
    }

    public void testIntReductionRecording() {
        int n;
        BigInteger bigInteger = new BigInteger(0L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        PseudoReductionSeq<Object> pseudoReductionSeq = new PseudoReductionSeq<Object>();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        if (genPolynomial.isZERO() || genPolynomial2.isZERO()) {
            return;
        }
        GenPolynomial<BigInteger> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll, this.el + 1, this.q);
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el + 2, this.q);
        ArrayList arrayList = null;
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(genPolynomial);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        PseudoReductionEntry<BigInteger> pseudoReductionEntry = pseudoReductionSeq.normalformFactor(arrayList2, genPolynomial);
        GenPolynomial<Object> genPolynomial5 = pseudoReductionEntry.pol;
        GenPolynomial<BigInteger> genPolynomial6 = genPolynomial.multiply((BigInteger)pseudoReductionEntry.multiplicator);
        genPolynomial5 = pseudoReductionSeq.normalform(arrayList, arrayList2, genPolynomial6);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial5.isZERO());
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)pseudoReductionSeq.isNormalform(arrayList2, genPolynomial5));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)pseudoReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial6, genPolynomial5));
        arrayList2.add(genPolynomial2);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        pseudoReductionEntry = pseudoReductionSeq.normalformFactor(arrayList2, genPolynomial);
        genPolynomial5 = pseudoReductionEntry.pol;
        genPolynomial6 = genPolynomial.multiply((BigInteger)pseudoReductionEntry.multiplicator);
        genPolynomial5 = pseudoReductionSeq.normalform(arrayList, arrayList2, genPolynomial6);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)pseudoReductionSeq.isNormalform(arrayList2, genPolynomial5));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)pseudoReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial6, genPolynomial5));
        arrayList2.add(genPolynomial3);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        pseudoReductionEntry = pseudoReductionSeq.normalformFactor(arrayList2, genPolynomial);
        genPolynomial5 = pseudoReductionEntry.pol;
        genPolynomial6 = genPolynomial.multiply((BigInteger)pseudoReductionEntry.multiplicator);
        genPolynomial5 = pseudoReductionSeq.normalform(arrayList, arrayList2, genPolynomial6);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)pseudoReductionSeq.isNormalform(arrayList2, genPolynomial5));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)pseudoReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial6, genPolynomial5));
        arrayList2.add(genPolynomial4);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        pseudoReductionEntry = pseudoReductionSeq.normalformFactor(arrayList2, genPolynomial);
        genPolynomial5 = pseudoReductionEntry.pol;
        genPolynomial6 = genPolynomial.multiply((BigInteger)pseudoReductionEntry.multiplicator);
        genPolynomial5 = pseudoReductionSeq.normalform(arrayList, arrayList2, genPolynomial6);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)pseudoReductionSeq.isNormalform(arrayList2, genPolynomial5));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)pseudoReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial6, genPolynomial5));
    }

    public void testIntegerRReduction() {
        BigInteger bigInteger = new BigInteger(0L);
        ProductRing<BigInteger> productRing = new ProductRing<BigInteger>(bigInteger, 3);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(productRing, this.rl);
        RPseudoReductionSeq<BigInteger> rPseudoReductionSeq = new RPseudoReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<RingElem<BigInteger>> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        while (genPolynomial2.isZERO()) {
            genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<RingElem<BigInteger>> genPolynomial3 = ((RReductionSeq)rPseudoReductionSeq).normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rPseudoReductionSeq.isNormalform(arrayList, genPolynomial3));
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = ((RReductionSeq)rPseudoReductionSeq).normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rPseudoReductionSeq.isNormalform(arrayList, genPolynomial3));
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.getONE();
        genPolynomial = genPolynomial.sum((BigInteger)((Object)genPolynomial4));
        genPolynomial3 = ((RReductionSeq)rPseudoReductionSeq).normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rPseudoReductionSeq.isNormalform(arrayList, genPolynomial3));
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)rPseudoReductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)rPseudoReductionSeq.isReducible(arrayList, genPolynomial));
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)rPseudoReductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)rPseudoReductionSeq.isReducible(arrayList, genPolynomial2));
        genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = ((RReductionSeq)rPseudoReductionSeq).normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)rPseudoReductionSeq.isNormalform(arrayList, genPolynomial3));
        genPolynomial4 = rPseudoReductionSeq.booleanClosure(genPolynomial);
        ReductionTest.assertTrue((String)"isBC( c )", (boolean)rPseudoReductionSeq.isBooleanClosed(genPolynomial4));
        genPolynomial2 = genPolynomial.subtract((BigInteger)((Object)genPolynomial4));
        GenPolynomial<BigInteger> genPolynomial5 = rPseudoReductionSeq.booleanRemainder(genPolynomial);
        ReductionTest.assertEquals((String)"a-BC(a)=BR(a)", genPolynomial2, genPolynomial5);
        genPolynomial3 = genPolynomial4.sum((BigInteger)((Object)genPolynomial5));
        ReductionTest.assertEquals((String)"a==BC(a)+BR(a)", genPolynomial, genPolynomial3);
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        List list = rPseudoReductionSeq.booleanClosure(arrayList);
        List list2 = rPseudoReductionSeq.reducedBooleanClosure(arrayList);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rPseudoReductionSeq.isBooleanClosed(list));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rPseudoReductionSeq.isReducedBooleanClosed(list2));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rPseudoReductionSeq.isBooleanClosed(list2));
        arrayList.add(genPolynomial2);
        list = rPseudoReductionSeq.booleanClosure(arrayList);
        list2 = rPseudoReductionSeq.reducedBooleanClosure(arrayList);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rPseudoReductionSeq.isBooleanClosed(list));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rPseudoReductionSeq.isReducedBooleanClosed(list2));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rPseudoReductionSeq.isBooleanClosed(list2));
        arrayList.add(genPolynomial4);
        list = rPseudoReductionSeq.booleanClosure(arrayList);
        list2 = rPseudoReductionSeq.reducedBooleanClosure(arrayList);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rPseudoReductionSeq.isBooleanClosed(list));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rPseudoReductionSeq.isReducedBooleanClosed(list2));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rPseudoReductionSeq.isBooleanClosed(list2));
        while (genPolynomial5.isZERO()) {
            genPolynomial5 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        arrayList.add(genPolynomial5);
        list = rPseudoReductionSeq.booleanClosure(arrayList);
        list2 = rPseudoReductionSeq.reducedBooleanClosure(arrayList);
        ReductionTest.assertTrue((String)"isBC( B )", (boolean)rPseudoReductionSeq.isBooleanClosed(list));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rPseudoReductionSeq.isReducedBooleanClosed(list2));
        ReductionTest.assertTrue((String)"isBC( Br )", (boolean)rPseudoReductionSeq.isBooleanClosed(list2));
    }

    public void testIntRReductionRecording() {
        int n;
        BigInteger bigInteger = new BigInteger(0L);
        ProductRing<BigInteger> productRing = new ProductRing<BigInteger>(bigInteger, 3);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(productRing, this.rl);
        RPseudoReductionSeq<BigInteger> rPseudoReductionSeq = new RPseudoReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        while (genPolynomial2.isZERO()) {
            genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        GenPolynomial<BigInteger> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        ArrayList arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(genPolynomial);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        PseudoReductionEntry<BigInteger> pseudoReductionEntry = rPseudoReductionSeq.normalformFactor(arrayList2, genPolynomial);
        GenPolynomial<Object> genPolynomial5 = pseudoReductionEntry.pol;
        GenPolynomial<BigInteger> genPolynomial6 = genPolynomial.multiply((BigInteger)((Object)((Product)pseudoReductionEntry.multiplicator)));
        genPolynomial5 = rPseudoReductionSeq.normalform(arrayList, arrayList2, genPolynomial6);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rPseudoReductionSeq.isNormalform(arrayList2, genPolynomial5));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)rPseudoReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial6, genPolynomial5));
        arrayList2.add(genPolynomial2);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        pseudoReductionEntry = rPseudoReductionSeq.normalformFactor(arrayList2, genPolynomial);
        genPolynomial5 = pseudoReductionEntry.pol;
        genPolynomial6 = genPolynomial.multiply((BigInteger)((Object)((Product)pseudoReductionEntry.multiplicator)));
        genPolynomial5 = rPseudoReductionSeq.normalform(arrayList, arrayList2, genPolynomial6);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rPseudoReductionSeq.isNormalform(arrayList2, genPolynomial5));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)rPseudoReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial6, genPolynomial5));
        arrayList2.add(genPolynomial3);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        pseudoReductionEntry = rPseudoReductionSeq.normalformFactor(arrayList2, genPolynomial);
        genPolynomial5 = pseudoReductionEntry.pol;
        genPolynomial6 = genPolynomial.multiply((BigInteger)((Object)((Product)pseudoReductionEntry.multiplicator)));
        genPolynomial5 = rPseudoReductionSeq.normalform(arrayList, arrayList2, genPolynomial6);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rPseudoReductionSeq.isNormalform(arrayList2, genPolynomial5));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)rPseudoReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial6, genPolynomial5));
        arrayList2.add(genPolynomial4);
        arrayList = new ArrayList(arrayList2.size());
        for (n = 0; n < arrayList2.size(); ++n) {
            arrayList.add(null);
        }
        pseudoReductionEntry = rPseudoReductionSeq.normalformFactor(arrayList2, genPolynomial);
        genPolynomial5 = pseudoReductionEntry.pol;
        genPolynomial6 = genPolynomial.multiply((BigInteger)((Object)((Product)pseudoReductionEntry.multiplicator)));
        genPolynomial5 = rPseudoReductionSeq.normalform(arrayList, arrayList2, genPolynomial6);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)rPseudoReductionSeq.isNormalform(arrayList2, genPolynomial5));
        ReductionTest.assertTrue((String)"is ReductionNF ", (boolean)rPseudoReductionSeq.isReductionNF(arrayList, arrayList2, genPolynomial6, genPolynomial5));
    }
}

