/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class AlgebToCompl<C extends GcdRingElem<C>>
implements UnaryFunctor<AlgebraicNumber<C>, Complex<C>> {
    protected final ComplexRing<C> cfac;

    public AlgebToCompl(ComplexRing<C> complexRing) {
        if (complexRing == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.cfac = complexRing;
    }

    @Override
    public Complex<C> eval(AlgebraicNumber<C> algebraicNumber) {
        if (algebraicNumber == null || algebraicNumber.isZERO()) {
            return this.cfac.getZERO();
        }
        if (algebraicNumber.isONE()) {
            return this.cfac.getONE();
        }
        GenPolynomial<C> genPolynomial = algebraicNumber.getVal();
        GcdRingElem gcdRingElem = (GcdRingElem)this.cfac.ring.getZERO();
        GcdRingElem gcdRingElem2 = (GcdRingElem)this.cfac.ring.getZERO();
        for (Monomial<C> monomial : genPolynomial) {
            if (monomial.exponent().getVal(0) == 1L) {
                gcdRingElem2 = (GcdRingElem)monomial.coefficient();
                continue;
            }
            if (monomial.exponent().getVal(0) == 0L) {
                gcdRingElem = (GcdRingElem)monomial.coefficient();
                continue;
            }
            throw new IllegalArgumentException("unexpected monomial " + monomial);
        }
        return new Complex<GcdRingElem>(this.cfac, gcdRingElem, gcdRingElem2);
    }
}

