/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ComplexGenPolynomialTest
extends TestCase {
    GenPolynomialRing<BigComplex> fac;
    GenPolynomial<BigComplex> a;
    GenPolynomial<BigComplex> b;
    GenPolynomial<BigComplex> c;
    GenPolynomial<BigComplex> d;
    GenPolynomial<BigComplex> e;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ComplexGenPolynomialTest.suite());
    }

    public ComplexGenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ComplexGenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigComplex>(new BigComplex(1L), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        ComplexGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        ComplexGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ComplexGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ComplexGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        ComplexGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ComplexGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.ll);
            ComplexGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            ComplexGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ComplexGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((BigComplex)((Object)this.b));
        this.d = this.c.subtract((BigComplex)((Object)this.b));
        ComplexGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        BigComplex bigComplex = BigComplex.CRAND(this.kl);
        this.b = new GenPolynomial<BigComplex>(this.fac, bigComplex, expVector);
        this.c = this.a.sum((BigComplex)((Object)this.b));
        this.d = this.a.sum(bigComplex, expVector);
        ComplexGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigComplex)((Object)this.b));
        this.d = this.a.subtract(bigComplex, expVector);
        ComplexGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<BigComplex>(this.fac);
        this.b = new GenPolynomial<BigComplex>(this.fac, bigComplex, expVector);
        this.c = this.b.sum((BigComplex)((Object)this.a));
        this.d = this.a.sum(bigComplex, expVector);
        ComplexGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigComplex)((Object)this.b));
        this.d = this.a.subtract(bigComplex, expVector);
        ComplexGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        ComplexGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        ComplexGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((BigComplex)((Object)this.a));
        this.d = this.a.multiply((BigComplex)((Object)this.b));
        ComplexGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ComplexGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((BigComplex)((Object)this.c));
        ComplexGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ComplexGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ComplexGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((BigComplex)((Object)this.b.multiply((BigComplex)((Object)this.c))));
        this.e = this.a.multiply((BigComplex)((Object)this.b)).multiply(this.c);
        ComplexGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ComplexGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        BigComplex bigComplex = this.a.leadingBaseCoefficient().inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply(bigComplex);
        ComplexGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        BigComplex bigComplex2 = this.b.leadingBaseCoefficient().inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply(bigComplex2);
        ComplexGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = new GenPolynomial<BigComplex>(this.fac, bigComplex2);
        this.d = this.b.multiply((BigComplex)((Object)this.e));
        ComplexGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.d = this.e.multiply((BigComplex)((Object)this.b));
        ComplexGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b) (0))*b", this.c, this.d);
    }

    public void testAbsNorm() {
        this.a = ((GenPolynomial)this.fac.getONE()).negate();
        BigComplex bigComplex = PolyUtil.absNorm(this.a);
        ComplexGenPolynomialTest.assertTrue((String)"isONE( absNorm(-1) )", (boolean)bigComplex.isONE());
        this.a = this.fac.random(this.kl * 2, this.ll + 2, this.el, this.q);
        bigComplex = PolyUtil.absNorm(this.a);
        ComplexGenPolynomialTest.assertTrue((String)" not isZERO( absNorm(a) )", (!bigComplex.isZERO() || this.a.isZERO() ? 1 : 0) != 0);
    }
}

