/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.Interval;
import edu.jas.root.Rectangle;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RootUtil {
    private static final Logger logger = LogManager.getLogger(RootUtil.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static <C extends RingElem<C>> long signVar(List<C> list) {
        long l = 0L;
        if (list == null || list.isEmpty()) {
            return l;
        }
        RingElem ringElem = (RingElem)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            RingElem ringElem2 = (RingElem)list.get(i);
            while (ringElem2 == null || ringElem2.signum() == 0) {
                if (++i >= list.size()) {
                    return l;
                }
                ringElem2 = (RingElem)list.get(i);
            }
            if (ringElem.signum() * ringElem2.signum() < 0) {
                ++l;
            }
            ringElem = ringElem2;
        }
        return l;
    }

    public static <C extends RingElem<C> & Rational> Interval<C> parseInterval(RingFactory<C> ringFactory, String string) {
        int n = string.length();
        int n2 = string.indexOf("[");
        if (n2 >= 0) {
            int n3 = string.indexOf("]");
            if (n3 > 0) {
                n = n3;
            }
        } else {
            n2 = -1;
        }
        String string2 = string.substring(n2 + 1, n).trim();
        int n4 = string2.indexOf(",");
        if (n4 < 0) {
            n4 = string.indexOf(" ");
        }
        if (n4 < 0) {
            RingElem ringElem = (RingElem)ringFactory.parse(string2);
            return new Interval<RingElem>(ringElem);
        }
        String string3 = string2.substring(0, n4).trim();
        String string4 = string2.substring(n4 + 1, string2.length()).trim();
        RingElem ringElem = (RingElem)ringFactory.parse(string3);
        RingElem ringElem2 = (RingElem)ringFactory.parse(string4);
        logger.debug("Interval: left = {}, right = {}", (Object)ringElem, (Object)ringElem2);
        return new Interval<RingElem>(ringElem, ringElem2);
    }

    public static <C extends RingElem<C> & Rational> Rectangle<C> parseRectangle(RingFactory<Complex<C>> ringFactory, String string) {
        Complex<BigRational> complex;
        Complex<BigRational> complex2;
        int n = string.length();
        int n2 = string.indexOf("[");
        if (n2 >= 0) {
            int n3 = string.indexOf("]");
            if (n3 > 0) {
                n = n3;
            }
        } else {
            n2 = -1;
        }
        String string2 = string.substring(n2 + 1, n).trim();
        int n4 = string2.indexOf(",");
        if (n4 < 0) {
            n4 = string.indexOf(" ");
        }
        if (n4 < 0) {
            Complex complex3 = (Complex)ringFactory.parse(string2);
            return new Rectangle(complex3);
        }
        String string3 = string2.substring(0, n4).trim();
        String string4 = string2.substring(n4 + 1, string2.length()).trim();
        Object c = ringFactory.parse(string3);
        Object c2 = ringFactory.parse(string4);
        if (c instanceof Complex) {
            complex2 = (Complex)c;
            complex = (Complex<BigRational>)c2;
        } else if (c instanceof ComplexAlgebraicNumber) {
            ComplexAlgebraicNumber complexAlgebraicNumber = (ComplexAlgebraicNumber)c;
            ComplexAlgebraicNumber complexAlgebraicNumber2 = (ComplexAlgebraicNumber)c2;
            complex2 = complexAlgebraicNumber.magnitude();
            complex = complexAlgebraicNumber2.magnitude();
        } else {
            complex2 = ((Complex)ringFactory.getONE()).negate();
            complex = (Complex)ringFactory.getONE();
        }
        logger.debug("Rectangle: sw = {}, ne = {}", (Object)complex2, (Object)complex);
        return new Rectangle<BigRational>(complex2, complex);
    }
}

