/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.SquarefreeAbstract;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SquarefreeFieldChar0<C extends GcdRingElem<C>>
extends SquarefreeAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SquarefreeFieldChar0.class);
    protected final RingFactory<C> coFac;

    public SquarefreeFieldChar0(RingFactory<C> ringFactory) {
        super(GCDFactory.getProxy(ringFactory));
        if (!ringFactory.isField()) {
            throw new IllegalArgumentException("fac must be a field");
        }
        if (ringFactory.characteristic().signum() != 0) {
            throw new IllegalArgumentException("characterisic(fac) must be zero");
        }
        this.coFac = ringFactory;
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.engine + " over " + this.coFac;
    }

    @Override
    public GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial.monic();
        if (genPolynomial2.isConstant()) {
            return genPolynomial2;
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        genPolynomial3 = genPolynomial3.monic();
        GenPolynomial<C> genPolynomial4 = this.engine.baseGcd(genPolynomial2, genPolynomial3);
        genPolynomial4 = genPolynomial4.monic();
        GenPolynomial<C> genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial2, genPolynomial4);
        genPolynomial5 = genPolynomial5.monic();
        return genPolynomial5;
    }

    public boolean isBaseSquarefree(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<C> genPolynomial2 = genPolynomial.monic();
        if (genPolynomial2.isConstant()) {
            return true;
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        GenPolynomial<C> genPolynomial4 = this.engine.baseGcd(genPolynomial2, genPolynomial3 = genPolynomial3.monic());
        return genPolynomial4.degree(0) == 0L;
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> genPolynomial) {
        GenPolynomial genPolynomial2;
        AbelianGroupElem<ExpVector> abelianGroupElem;
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isConstant()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
        if (!gcdRingElem.isONE()) {
            genPolynomial = genPolynomial.divide((Object)gcdRingElem);
            abelianGroupElem = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem);
            treeMap.put((GenPolynomial<C>)abelianGroupElem, 1L);
            gcdRingElem = (GcdRingElem)genPolynomialRing.coFac.getONE();
        }
        if (!((ExpVector)(abelianGroupElem = genPolynomial.trailingExpVector())).isZERO()) {
            genPolynomial2 = genPolynomialRing.valueOf((ExpVector)abelianGroupElem);
            logger.info("trailing term = {}", genPolynomial2);
            genPolynomial = PolyUtil.basePseudoDivide(genPolynomial, genPolynomial2);
            long l = ((ExpVector)abelianGroupElem).getVal(0);
            abelianGroupElem = ((ExpVector)abelianGroupElem).subst(0, 1L);
            genPolynomial2 = genPolynomialRing.valueOf((ExpVector)abelianGroupElem);
            logger.info("tr, ep = {}, {}", genPolynomial2, (Object)l);
            treeMap.put(genPolynomial2, l);
            if (genPolynomial.length() == 1) {
                return treeMap;
            }
        }
        genPolynomial2 = genPolynomial;
        GenPolynomial<Object> genPolynomial3 = null;
        GenPolynomial<Object> genPolynomial4 = null;
        long l = 0L;
        boolean bl = true;
        while (true) {
            if (bl) {
                if (genPolynomial2.isConstant() || genPolynomial2.isZERO()) break;
                GenPolynomial<Object> genPolynomial5 = PolyUtil.baseDeriviative(genPolynomial2);
                genPolynomial3 = this.engine.baseGcd(genPolynomial2, genPolynomial5);
                genPolynomial3 = genPolynomial3.monic();
                genPolynomial4 = PolyUtil.basePseudoDivide(genPolynomial2, genPolynomial3);
                l = 0L;
                bl = false;
            }
            if (genPolynomial4.isConstant()) break;
            ++l;
            GenPolynomial genPolynomial6 = this.engine.baseGcd(genPolynomial3, genPolynomial4);
            genPolynomial6 = genPolynomial6.monic();
            GenPolynomial genPolynomial7 = PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial6);
            genPolynomial4 = genPolynomial6;
            genPolynomial3 = PolyUtil.basePseudoDivide(genPolynomial3, genPolynomial4);
            if (genPolynomial7.degree(0) <= 0L) continue;
            if (gcdRingElem.isONE() && !((GcdRingElem)genPolynomial7.leadingBaseCoefficient()).isONE()) {
                genPolynomial7 = genPolynomial7.monic();
            }
            logger.info("z, k = {}, {}", genPolynomial7, (Object)l);
            treeMap.put(genPolynomial7, l);
        }
        return this.normalizeFactorization(treeMap);
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate recursive polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = genPolynomial;
        GenPolynomial<C> genPolynomial3 = this.engine.recursiveContent(genPolynomial);
        if (!genPolynomial3.isONE()) {
            genPolynomial2 = PolyUtil.coefficientPseudoDivide(genPolynomial2, genPolynomial3);
        }
        if (genPolynomial2.leadingExpVector().getVal(0) < 1L) {
            return genPolynomial2.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = PolyUtil.recursiveDeriviative(genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial4);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial6 = PolyUtil.recursivePseudoDivide(genPolynomial2, genPolynomial5);
        return genPolynomial6.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial3);
    }

    public boolean isRecursiveUnivariateSquarefree(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate recursive polynomials");
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = genPolynomial;
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = PolyUtil.recursiveDeriviative(genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = this.engine.recursiveUnivariateGcd(genPolynomial2, genPolynomial3);
        logger.info("gcd = {}", genPolynomial4);
        return genPolynomial4.degree(0) == 0L;
    }

    @Override
    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        Comparable<Long> comparable;
        GenPolynomial genPolynomial2;
        Object object2;
        Object object3;
        GenPolynomial genPolynomial3;
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> treeMap = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        GcdRingElem gcdRingElem = (GcdRingElem)((Object)genPolynomial.leadingBaseCoefficient().leadingBaseCoefficient());
        if (!gcdRingElem.isONE()) {
            genPolynomial3 = ((GenPolynomial)genPolynomialRing2.getONE()).multiply(gcdRingElem);
            object3 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial3);
            treeMap.put((GenPolynomial<GenPolynomial<C>>)object3, 1L);
            object2 = (GcdRingElem)gcdRingElem.inverse();
            genPolynomial = genPolynomial.multiply((GenPolynomial<GenPolynomial<GcdRingElem>>)((GenPolynomial)genPolynomialRing2.getONE()).multiply(object2));
            gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient().leadingBaseCoefficient();
        }
        genPolynomial3 = this.engine.recursiveContent(genPolynomial);
        logger.info("recursiveContent = {}", genPolynomial3);
        genPolynomial3 = genPolynomial3.monic();
        if (!genPolynomial3.isONE()) {
            genPolynomial = PolyUtil.coefficientPseudoDivide(genPolynomial, genPolynomial3);
        }
        object3 = this.squarefreeFactors((C)genPolynomial3);
        logger.info("squarefreeFactors = {}", object3);
        for (Map.Entry object4 : object3.entrySet()) {
            GenPolynomial genPolynomial4 = (GenPolynomial)object4.getKey();
            if (genPolynomial4.isONE()) continue;
            genPolynomial2 = ((GenPolynomial)genPolynomialRing.getONE()).multiply(genPolynomial4);
            comparable = (Long)object4.getValue();
            treeMap.put(genPolynomial2, (Long)comparable);
        }
        object2 = genPolynomial.trailingExpVector();
        if (!((ExpVector)object2).isZERO()) {
            GenPolynomial genPolynomial5 = genPolynomialRing.valueOf((ExpVector)object2);
            logger.info("trailing term = {}", genPolynomial5);
            genPolynomial = PolyUtil.recursivePseudoDivide(genPolynomial, genPolynomial5);
            long l = ((ExpVector)object2).getVal(0);
            object2 = ((ExpVector)object2).subst(0, 1L);
            GenPolynomial genPolynomial6 = genPolynomialRing.valueOf((ExpVector)object2);
            treeMap.put(genPolynomial6, l);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GcdRingElem>>> genPolynomial7 = genPolynomial;
        genPolynomial2 = null;
        comparable = null;
        long l = 0L;
        boolean bl = true;
        while (true) {
            if (bl) {
                if (genPolynomial7.isConstant() || genPolynomial7.isZERO()) break;
                GenPolynomial genPolynomial8 = PolyUtil.recursiveDeriviative(genPolynomial7);
                genPolynomial2 = this.engine.recursiveUnivariateGcd(genPolynomial7, genPolynomial8);
                genPolynomial2 = PolyUtil.monic(genPolynomial2);
                comparable = PolyUtil.recursivePseudoDivide(genPolynomial7, genPolynomial2);
                l = 0L;
                bl = false;
            }
            if (((GenPolynomial)comparable).isConstant()) break;
            ++l;
            GenPolynomial genPolynomial9 = this.engine.recursiveUnivariateGcd(genPolynomial2, comparable);
            genPolynomial9 = PolyUtil.monic(genPolynomial9);
            GenPolynomial genPolynomial10 = PolyUtil.recursivePseudoDivide(comparable, genPolynomial9);
            comparable = genPolynomial9;
            genPolynomial2 = PolyUtil.recursivePseudoDivide(genPolynomial2, comparable);
            if (genPolynomial10.isONE() || genPolynomial10.isZERO()) continue;
            if (gcdRingElem.isONE()) {
                genPolynomial10 = PolyUtil.monic(genPolynomial10);
                logger.info("z,monic = {}", genPolynomial10);
            }
            treeMap.put(genPolynomial10, l);
        }
        return treeMap;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseSquarefreePart(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        GenPolynomial genPolynomial3 = this.engine.recursiveContent(genPolynomial2);
        genPolynomial2 = PolyUtil.coefficientPseudoDivide(genPolynomial2, genPolynomial3);
        GenPolynomial genPolynomial4 = this.squarefreePart(genPolynomial3);
        logger.info("content = {}, squarefreePart = {}", genPolynomial3, genPolynomial4);
        GenPolynomial genPolynomial5 = this.recursiveUnivariateSquarefreePart(genPolynomial2);
        GenPolynomial genPolynomial6 = genPolynomial5.multiply(genPolynomial4);
        GenPolynomial genPolynomial7 = PolyUtil.distribute(genPolynomialRing, genPolynomial6);
        logger.info("univRec = {}, squarefreePart = {}", genPolynomial2, genPolynomial5);
        return genPolynomial7;
    }

    @Override
    public boolean isSquarefree(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return true;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.isBaseSquarefree(genPolynomial);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        return this.isRecursiveUnivariateSquarefree(genPolynomial2);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.normalizeFactorization(this.baseSquarefreeFactors(genPolynomial));
        }
        TreeMap treeMap = new TreeMap();
        if (genPolynomial.isZERO()) {
            return this.normalizeFactorization(treeMap);
        }
        if (genPolynomial.isONE()) {
            treeMap.put(genPolynomial, 1L);
            return this.normalizeFactorization(treeMap);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        SortedMap sortedMap = this.recursiveUnivariateSquarefreeFactors(genPolynomial2);
        for (Map.Entry entry : sortedMap.entrySet()) {
            Long l = entry.getValue();
            GenPolynomial genPolynomial3 = entry.getKey();
            GenPolynomial genPolynomial4 = PolyUtil.distribute(genPolynomialRing, genPolynomial3);
            treeMap.put(genPolynomial4, l);
        }
        logger.info("squarefreeFactors({}) = {}", genPolynomial, treeMap);
        return this.normalizeFactorization(treeMap);
    }

    @Override
    public SortedMap<C, Long> squarefreeFactors(C c) {
        throw new UnsupportedOperationException("method not implemented");
    }
}

