/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class CartesianProductIterator<E>
implements Iterator<List<E>> {
    final List<Iterable<E>> comps;
    final List<Iterator<E>> compit;
    List<E> current;
    boolean empty;

    public CartesianProductIterator(List<Iterable<E>> list) {
        if (list == null) {
            throw new IllegalArgumentException("null comps not allowed");
        }
        this.comps = list;
        this.current = new ArrayList(list.size());
        this.compit = new ArrayList<Iterator<E>>(list.size());
        this.empty = false;
        for (Iterable<Iterable<E>> iterable : list) {
            Iterator<Iterable<E>> iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                this.empty = true;
                this.current.clear();
                break;
            }
            this.current.add(iterator.next());
            this.compit.add(iterator);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.empty;
    }

    @Override
    public synchronized List<E> next() {
        Iterator<E> iterator;
        int n;
        Iterator<E> iterator2;
        int n2;
        if (this.empty) {
            throw new NoSuchElementException("invalid call of next()");
        }
        ArrayList<E> arrayList = new ArrayList<E>(this.current);
        for (n2 = this.compit.size() - 1; n2 >= 0 && !(iterator2 = this.compit.get(n2)).hasNext(); --n2) {
        }
        if (n2 < 0) {
            this.empty = true;
            return arrayList;
        }
        for (n = n2 + 1; n < this.compit.size(); ++n) {
            iterator = this.comps.get(n).iterator();
            this.compit.set(n, iterator);
        }
        for (n = n2; n < this.compit.size(); ++n) {
            iterator = this.compit.get(n);
            E e = iterator.next();
            this.current.set(n, e);
        }
        return arrayList;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove tuples");
    }
}

