/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueSolvablePolynomialRing;
import edu.jas.application.SolvableResidue;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.GcdRingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResidueSolvablePolynomial<C extends GcdRingElem<C>>
extends GenSolvablePolynomial<SolvableResidue<C>> {
    public final ResidueSolvablePolynomialRing<C> ring;
    private static final Logger logger = LogManager.getLogger(ResidueSolvablePolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing) {
        super(residueSolvablePolynomialRing);
        this.ring = residueSolvablePolynomialRing;
    }

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing, ExpVector expVector) {
        this(residueSolvablePolynomialRing);
        this.val.put(expVector, (SolvableResidue)this.ring.getONECoefficient());
    }

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing, SolvableResidue<C> solvableResidue, ExpVector expVector) {
        this(residueSolvablePolynomialRing);
        if (solvableResidue != null && !solvableResidue.isZERO()) {
            this.val.put(expVector, solvableResidue);
        }
    }

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing, SolvableResidue<C> solvableResidue) {
        this(residueSolvablePolynomialRing, solvableResidue, residueSolvablePolynomialRing.evzero);
    }

    public ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing, GenSolvablePolynomial<SolvableResidue<C>> genSolvablePolynomial) {
        this(residueSolvablePolynomialRing, genSolvablePolynomial.getMap());
    }

    protected ResidueSolvablePolynomial(ResidueSolvablePolynomialRing<C> residueSolvablePolynomialRing, SortedMap<ExpVector, SolvableResidue<C>> sortedMap) {
        this(residueSolvablePolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public ResidueSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public ResidueSolvablePolynomial<C> copy() {
        return new ResidueSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ResidueSolvablePolynomial)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(ResidueSolvablePolynomial<C> residueSolvablePolynomial) {
        if (residueSolvablePolynomial == null || residueSolvablePolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == residueSolvablePolynomial.ring.nvar);
        logger.debug("ring = {}", this.ring);
        ExpVector expVector = this.ring.evzero;
        GenSolvablePolynomial genSolvablePolynomial = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial genSolvablePolynomial2 = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        SolvableResidue solvableResidue = (SolvableResidue)this.ring.getONECoefficient();
        SortedMap sortedMap = this.val;
        SortedMap sortedMap2 = residueSolvablePolynomial.val;
        Set set = sortedMap2.entrySet();
        for (Map.Entry entry : sortedMap.entrySet()) {
            SolvableResidue solvableResidue2 = (SolvableResidue)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            if (debug) {
                logger.info("e = {}, a = {}", (Object)expVector2, (Object)solvableResidue2);
            }
            for (Map.Entry entry2 : set) {
                GenSolvablePolynomial genSolvablePolynomial3;
                GenSolvablePolynomial genSolvablePolynomial4;
                GenSolvablePolynomial genSolvablePolynomial5;
                SolvableResidue solvableResidue3 = (SolvableResidue)entry2.getValue();
                ExpVector expVector3 = (ExpVector)entry2.getKey();
                if (debug) {
                    logger.info("f = {}, b = {}", (Object)expVector3, (Object)solvableResidue3);
                }
                int[] nArray = expVector3.dependencyOnVariables();
                int n = 0;
                if (nArray.length > 0) {
                    n = nArray[nArray.length - 1];
                }
                int n2 = this.ring.nvar + 1 - n;
                ResidueSolvablePolynomial<C> residueSolvablePolynomial2 = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
                if (this.ring.polCoeff.coeffTable.isEmpty() || solvableResidue3.isConstant() || expVector2.isZERO()) {
                    residueSolvablePolynomial2 = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue3, expVector2);
                    if (debug) {
                        logger.info("symmetric coeff: b = {}, e = {}", (Object)solvableResidue3, (Object)expVector2);
                    }
                } else {
                    if (debug) {
                        logger.info("unsymmetric coeff: b = {}, e = {}", (Object)solvableResidue3, (Object)expVector2);
                    }
                    genSolvablePolynomial5 = new RecSolvablePolynomial(this.ring.polCoeff, expVector2);
                    genSolvablePolynomial4 = new RecSolvablePolynomial(this.ring.polCoeff, solvableResidue3.val);
                    genSolvablePolynomial3 = ((RecSolvablePolynomial)genSolvablePolynomial5).multiply(genSolvablePolynomial4);
                    residueSolvablePolynomial2 = this.ring.fromPolyCoefficients(genSolvablePolynomial3);
                }
                if (debug) {
                    logger.info("coeff-poly: Cps = {}", residueSolvablePolynomial2);
                }
                genSolvablePolynomial5 = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
                genSolvablePolynomial4 = null;
                if (this.ring.table.isEmpty() || residueSolvablePolynomial2.isConstant() || expVector3.isZERO()) {
                    if (debug) {
                        logger.info("symmetric poly: b = {}, e = {}", (Object)solvableResidue3, (Object)expVector2);
                    }
                    ExpVector expVector4 = expVector2.sum(expVector3);
                    genSolvablePolynomial4 = residueSolvablePolynomial2.isConstant() ? new ResidueSolvablePolynomial<C>(this.ring, (SolvableResidue)residueSolvablePolynomial2.leadingBaseCoefficient(), expVector4) : residueSolvablePolynomial2.shift(expVector3);
                } else {
                    if (debug) {
                        logger.info("unsymmetric poly: Cps = {}, f = {}", residueSolvablePolynomial2, (Object)expVector3);
                    }
                    for (Map.Entry entry3 : residueSolvablePolynomial2.val.entrySet()) {
                        int n3;
                        SolvableResidue solvableResidue4 = (SolvableResidue)entry3.getValue();
                        ExpVector expVector5 = (ExpVector)entry3.getKey();
                        if (debug) {
                            logger.info("g = {}, c = {}", (Object)expVector5, (Object)solvableResidue4);
                        }
                        int[] nArray2 = expVector5.dependencyOnVariables();
                        int n4 = this.ring.nvar + 1;
                        if (nArray2.length > 0) {
                            n4 = nArray2[0];
                        }
                        if ((n3 = this.ring.nvar + 1 - n4) <= n2) {
                            var32_32 = expVector5.sum(expVector3);
                            if (debug) {
                                logger.info("disjoint poly: g = {}, f = {}, h = {}", (Object)expVector5, (Object)expVector3, (Object)var32_32);
                            }
                            genSolvablePolynomial4 = (ResidueSolvablePolynomial)genSolvablePolynomial2.sum(solvableResidue, var32_32);
                        } else {
                            ResidueSolvablePolynomial<C> residueSolvablePolynomial3;
                            var32_32 = expVector5.subst(n4, 0L);
                            ExpVector expVector6 = expVector.subst(n4, expVector5.getVal(n4));
                            ExpVector expVector7 = expVector3.subst(n, 0L);
                            ExpVector expVector8 = expVector.subst(n, expVector3.getVal(n));
                            if (debug) {
                                logger.info("poly, g1 = {}, f1 = {}, Dps = {}", (Object)var32_32, (Object)expVector7, (Object)genSolvablePolynomial5);
                            }
                            if (debug) {
                                logger.info("poly, g2 = {}, f2 = {}", (Object)expVector6, (Object)expVector8);
                            }
                            TableRelation tableRelation = this.ring.table.lookup(expVector6, expVector8);
                            if (debug) {
                                logger.info("poly, g  = {}, f  = {}, rel = {}", (Object)expVector5, (Object)expVector3, tableRelation);
                            }
                            genSolvablePolynomial4 = new ResidueSolvablePolynomial<C>(this.ring, tableRelation.p);
                            if (tableRelation.f != null) {
                                residueSolvablePolynomial3 = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, tableRelation.f);
                                genSolvablePolynomial4 = ((ResidueSolvablePolynomial)genSolvablePolynomial4).multiply(residueSolvablePolynomial3);
                                ExpVector expVector9 = tableRelation.e == null ? expVector6 : expVector6.subtract(tableRelation.e);
                                this.ring.table.update(expVector9, expVector8, genSolvablePolynomial4);
                            }
                            if (tableRelation.e != null) {
                                genSolvablePolynomial3 = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, tableRelation.e);
                                genSolvablePolynomial4 = ((ResidueSolvablePolynomial)genSolvablePolynomial3).multiply((ResidueSolvablePolynomial<C>)genSolvablePolynomial4);
                                this.ring.table.update(expVector6, expVector8, genSolvablePolynomial4);
                            }
                            if (!expVector7.isZERO()) {
                                residueSolvablePolynomial3 = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, expVector7);
                                genSolvablePolynomial4 = ((ResidueSolvablePolynomial)genSolvablePolynomial4).multiply(residueSolvablePolynomial3);
                            }
                            if (!var32_32.isZERO()) {
                                genSolvablePolynomial3 = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, var32_32);
                                genSolvablePolynomial4 = ((ResidueSolvablePolynomial)genSolvablePolynomial3).multiply((ResidueSolvablePolynomial<C>)genSolvablePolynomial4);
                            }
                        }
                        genSolvablePolynomial4 = ((ResidueSolvablePolynomial)genSolvablePolynomial4).multiplyLeft(solvableResidue4);
                        genSolvablePolynomial5 = (ResidueSolvablePolynomial)genSolvablePolynomial5.sum(genSolvablePolynomial4);
                    }
                    genSolvablePolynomial4 = genSolvablePolynomial5;
                }
                genSolvablePolynomial4 = ((ResidueSolvablePolynomial)genSolvablePolynomial4).multiplyLeft(solvableResidue2);
                logger.debug("Ds = {}", (Object)genSolvablePolynomial4);
                genSolvablePolynomial = (ResidueSolvablePolynomial)genSolvablePolynomial.sum(genSolvablePolynomial4);
            }
        }
        return genSolvablePolynomial;
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(ResidueSolvablePolynomial<C> residueSolvablePolynomial, ResidueSolvablePolynomial<C> residueSolvablePolynomial2) {
        if (residueSolvablePolynomial.isZERO() || residueSolvablePolynomial2.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (residueSolvablePolynomial.isONE()) {
            return this.multiply(residueSolvablePolynomial2);
        }
        if (residueSolvablePolynomial2.isONE()) {
            return residueSolvablePolynomial.multiply(this);
        }
        return residueSolvablePolynomial.multiply(this).multiply(residueSolvablePolynomial2);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(SolvableResidue<C> solvableResidue) {
        ResidueSolvablePolynomial<C> residueSolvablePolynomial = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableResidue == null || solvableResidue.isZERO()) {
            return residueSolvablePolynomial;
        }
        residueSolvablePolynomial = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, this.ring.evzero);
        return this.multiply(residueSolvablePolynomial);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(SolvableResidue<C> solvableResidue, SolvableResidue<C> solvableResidue2) {
        GenSolvablePolynomial genSolvablePolynomial = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableResidue == null || solvableResidue.isZERO()) {
            return genSolvablePolynomial;
        }
        if (solvableResidue2 == null || solvableResidue2.isZERO()) {
            return genSolvablePolynomial;
        }
        ResidueSolvablePolynomial<C> residueSolvablePolynomial = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, this.ring.evzero);
        ResidueSolvablePolynomial<C> residueSolvablePolynomial2 = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue2, this.ring.evzero);
        return residueSolvablePolynomial.multiply(this).multiply(residueSolvablePolynomial2);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SolvableResidue solvableResidue = (SolvableResidue)this.ring.getONECoefficient();
        return this.multiply(solvableResidue, expVector);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(ExpVector expVector, ExpVector expVector2) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (expVector2 == null || expVector2.isZERO()) {
            return this;
        }
        SolvableResidue solvableResidue = (SolvableResidue)this.ring.getONECoefficient();
        return this.multiply(solvableResidue, expVector, solvableResidue, expVector2);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(SolvableResidue<C> solvableResidue, ExpVector expVector) {
        if (solvableResidue == null || solvableResidue.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvablePolynomial<C> residueSolvablePolynomial = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, expVector);
        return this.multiply(residueSolvablePolynomial);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(SolvableResidue<C> solvableResidue, ExpVector expVector, SolvableResidue<C> solvableResidue2, ExpVector expVector2) {
        if (solvableResidue == null || solvableResidue.isZERO()) {
            return this.ring.getZERO();
        }
        if (solvableResidue2 == null || solvableResidue2.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvablePolynomial<C> residueSolvablePolynomial = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, expVector);
        ResidueSolvablePolynomial<C> residueSolvablePolynomial2 = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue2, expVector2);
        return this.multiply(residueSolvablePolynomial, residueSolvablePolynomial2);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiplyLeft(SolvableResidue<C> solvableResidue, ExpVector expVector) {
        if (solvableResidue == null || solvableResidue.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvablePolynomial<C> residueSolvablePolynomial = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, expVector);
        return residueSolvablePolynomial.multiply(this);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiplyLeft(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SolvableResidue solvableResidue = (SolvableResidue)this.ring.getONECoefficient();
        ResidueSolvablePolynomial<C> residueSolvablePolynomial = new ResidueSolvablePolynomial<C>(this.ring, solvableResidue, expVector);
        return residueSolvablePolynomial.multiply(this);
    }

    @Override
    public ResidueSolvablePolynomial<C> multiplyLeft(SolvableResidue<C> solvableResidue) {
        GenSolvablePolynomial genSolvablePolynomial = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        if (solvableResidue == null || solvableResidue.isZERO()) {
            return genSolvablePolynomial;
        }
        SortedMap sortedMap = ((ResidueSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            SolvableResidue solvableResidue2 = (SolvableResidue)entry.getValue();
            SolvableResidue<SolvableResidue> solvableResidue3 = solvableResidue.multiply(solvableResidue2);
            if (solvableResidue3.isZERO()) continue;
            sortedMap.put(expVector, solvableResidue3);
        }
        return genSolvablePolynomial;
    }

    @Override
    public ResidueSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, SolvableResidue<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(entry.getValue(), entry.getKey());
    }

    @Override
    public ResidueSolvablePolynomial<C> multiply(Map.Entry<ExpVector, SolvableResidue<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply(entry.getValue(), entry.getKey());
    }

    protected ResidueSolvablePolynomial<C> shift(ExpVector expVector) {
        GenSolvablePolynomial genSolvablePolynomial = ((ResidueSolvablePolynomial)this.ring.getZERO()).copy();
        if (this.isZERO()) {
            return genSolvablePolynomial;
        }
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SortedMap sortedMap = ((ResidueSolvablePolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            SolvableResidue solvableResidue = (SolvableResidue)entry.getValue();
            ExpVector expVector3 = expVector2.sum(expVector);
            if (solvableResidue.isZERO()) continue;
            sortedMap.put(expVector3, solvableResidue);
        }
        return genSolvablePolynomial;
    }
}

