/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigQuaternionTest
extends TestCase {
    BigQuaternion a;
    BigQuaternion b;
    BigQuaternion c;
    BigQuaternion d;
    BigQuaternion e;
    BigQuaternion f;
    BigQuaternionRing fac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BigQuaternionTest.suite());
    }

    public BigQuaternionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(BigQuaternionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new BigQuaternionRing();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstants() {
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        this.c = this.b.subtract(this.b);
        BigQuaternionTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        BigQuaternionTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigQuaternionTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        this.c = this.b.subtract(this.b);
        BigQuaternionTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
    }

    public void testBitLength() {
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        this.c = this.fac.random(100);
        BigQuaternionTest.assertEquals((String)"len(0) = 12", (long)12L, (long)this.a.bitLength());
        BigQuaternionTest.assertEquals((String)"len(1) = 13", (long)13L, (long)this.b.bitLength());
        BigQuaternionTest.assertEquals((String)"len(-1) = 13", (long)13L, (long)this.b.negate().bitLength());
        BigQuaternionTest.assertTrue((String)"len(random) >= 12", (12L <= this.c.bitLength() ? 1 : 0) != 0);
        this.d = this.fac.I;
        BigQuaternionTest.assertEquals((String)"len(i) = 13", (long)13L, (long)this.d.bitLength());
        BigQuaternionTest.assertEquals((String)"len(-i) = 13", (long)13L, (long)this.d.negate().bitLength());
        this.d = this.fac.J;
        BigQuaternionTest.assertEquals((String)"len(j) = 13", (long)13L, (long)this.d.bitLength());
        BigQuaternionTest.assertEquals((String)"len(-j) = 13", (long)13L, (long)this.d.negate().bitLength());
        this.d = this.fac.K;
        BigQuaternionTest.assertEquals((String)"len(k) = 13", (long)13L, (long)this.d.bitLength());
        BigQuaternionTest.assertEquals((String)"len(-k) = 13", (long)13L, (long)this.d.negate().bitLength());
    }

    public void testConstructor() {
        this.a = new BigQuaternion(this.fac, "6/8");
        this.b = new BigQuaternion(this.fac, "3/4");
        BigQuaternionTest.assertEquals((String)"6/8 = 3/4", (Object)this.a, (Object)this.b);
        this.a = new BigQuaternion(this.fac, "3/4 i 4/5 j 1/5 k 2/5");
        this.b = new BigQuaternion(this.fac, "-3/4 i -4/5 j -1/5 k -2/5");
        BigQuaternionTest.assertEquals((String)"3/4 + i 4/5 + j 1/5 + k 2/5", (Object)this.a, (Object)this.b.negate());
        String string = "6/1111111111111111111111111111111111111111111";
        this.a = new BigQuaternion(this.fac, string);
        String string2 = this.a.toString();
        BigQuaternionTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
        this.a = new BigQuaternion(this.fac, 1L);
        this.b = new BigQuaternion(this.fac, -1L);
        this.c = this.b.sum(this.a);
        BigQuaternionTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigQuaternionTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)this.fac.getZERO());
    }

    public void testRandom() {
        this.a = this.fac.random(50);
        this.b = new BigQuaternion(this.fac, this.a.getRe(), this.a.getIm(), this.a.getJm(), this.a.getKm());
        this.c = this.b.subtract(this.a);
        BigQuaternionTest.assertEquals((String)"a-b = 0", (Object)this.fac.getZERO(), (Object)this.c);
        this.d = new BigQuaternion(this.fac, this.b.getRe(), this.b.getIm(), this.b.getJm(), this.b.getKm());
        BigQuaternionTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.a = this.fac.random(10);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        BigQuaternionTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        BigQuaternionTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.sum(this.fac.getZERO());
        BigQuaternionTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.fac.getZERO());
        BigQuaternionTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.a);
        BigQuaternionTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)this.fac.getZERO());
    }

    public void testMultiplication() {
        this.a = this.fac.random(10);
        this.b = this.a.multiply(this.a);
        this.c = this.b.divide(this.a);
        BigQuaternionTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        BigQuaternionTest.assertEquals((String)"a*a/a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.multiply(this.fac.getONE());
        BigQuaternionTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(this.fac.getONE());
        BigQuaternionTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = this.fac.random(10);
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        BigQuaternionTest.assertTrue((String)"a*1/a = 1", (boolean)this.c.isONE());
        this.c = this.b.multiply(this.a);
        BigQuaternionTest.assertTrue((String)"1/a*a = 1", (boolean)this.c.isONE());
        this.b = this.a.abs();
        this.c = this.b.inverse();
        this.d = this.b.multiply(this.c);
        BigQuaternionTest.assertTrue((String)"abs(a)*1/abs(a) = 1", (boolean)this.d.isONE());
        this.b = this.a.norm();
        this.d = this.a.multiply(this.a.conjugate());
        BigQuaternionTest.assertEquals((String)"norm() = a a^", (Object)this.b, (Object)this.d);
        this.d = this.a.abs();
        this.e = this.d.multiply(this.d);
        BigRational bigRational = this.e.re.subtract(this.b.re).abs().divide(this.e.re.abs().sum(this.b.re.abs()));
        BigRational bigRational2 = (BigRational)new BigRational(1L, 10L).power(BigDecimal.DEFAULT_PRECISION - 1);
        BigQuaternionTest.assertTrue((String)("abs()*abs() == norm(): " + bigRational), (bigRational.compareTo(bigRational2) <= 0 ? 1 : 0) != 0);
        this.b = this.fac.random(10);
        this.c = this.a.inverse();
        this.d = this.c.multiply(this.b);
        this.e = this.a.multiply(this.d);
        BigQuaternionTest.assertEquals((String)"a*(1/a)*b = b", (Object)this.b, (Object)this.e);
        this.d = this.b.multiply(this.c);
        this.e = this.d.multiply(this.a);
        BigQuaternionTest.assertEquals((String)"b*(1/a)*a = b", (Object)this.b, (Object)this.e);
    }

    public void testMultiplicationAxioms() {
        this.a = this.fac.random(10);
        this.b = this.fac.random(10);
        this.c = this.a.multiply(this.b);
        this.d = this.b.multiply(this.a);
        BigQuaternionTest.assertFalse((String)"a*b != b*a", (boolean)this.c.equals(this.d));
        this.c = this.fac.random(10);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        BigQuaternionTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.e.equals(this.d));
    }

    public void testDistributive() {
        this.a = this.fac.random(20);
        this.b = this.fac.random(20);
        this.c = this.fac.random(20);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigQuaternionTest.assertEquals((String)"a(b+c) = ab+ac", (Object)this.d, (Object)this.e);
    }
}

