/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.arith.BigRational;
import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.fd.GreatestCommonDivisorPrimitive;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.fd.QuotSolvablePolynomialRing;
import edu.jas.fd.SolvableQuotientRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.poly.WeylRelationsIterated;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDPrimitiveTest
extends TestCase {
    GreatestCommonDivisorAbstract<BigRational> fd;
    GreatestCommonDivisorAbstract<BigRational> fds;
    TermOrder to = TermOrderByName.INVLEX;
    GenSolvablePolynomialRing<BigRational> dfac;
    RecSolvablePolynomialRing<BigRational> rfac;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> a0;
    GenSolvablePolynomial<BigRational> b0;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    GenSolvablePolynomial<BigRational> a1;
    GenSolvablePolynomial<BigRational> b1;
    GenSolvablePolynomial<GenPolynomial<BigRational>> ar;
    GenSolvablePolynomial<GenPolynomial<BigRational>> br;
    GenSolvablePolynomial<GenPolynomial<BigRational>> ar0;
    GenSolvablePolynomial<GenPolynomial<BigRational>> br0;
    GenSolvablePolynomial<GenPolynomial<BigRational>> cr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> dr;
    GenSolvablePolynomial<GenPolynomial<BigRational>> er;
    GenSolvablePolynomial<GenPolynomial<BigRational>> sr;
    int rl = 4;
    int kl = 2;
    int ll = 2;
    int el = 3;
    float q = 0.25f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDPrimitiveTest.suite());
        ComputerThreads.terminate();
    }

    public GCDPrimitiveTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDPrimitiveTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        BigRational bigRational = new BigRational(1L);
        this.fd = new GreatestCommonDivisorPrimitive<BigRational>(bigRational);
        this.fds = new GreatestCommonDivisorSimple<BigRational>(bigRational);
        this.dfac = new GenSolvablePolynomialRing<BigRational>(bigRational, this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.fd = null;
        this.dfac = null;
        this.rfac = null;
    }

    public void testBaseGcdPrimitive() {
        String[] stringArray = new String[]{"x"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        for (int i = 0; i < 5; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2, this.el + 2, this.q);
            this.c = this.c.multiply((BigRational)((Object)this.dfac.univariate(0)));
            if (this.c.isZERO()) continue;
            this.c = (GenSolvablePolynomial)this.fd.leftBasePrimitivePart(this.c).abs();
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            this.d = this.fd.leftBaseGcd(this.a, this.b);
            this.e = (GenSolvablePolynomial)PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
            GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc): " + this.e), (boolean)this.e.isZERO());
            this.e = (GenSolvablePolynomial)PolyUtil.baseSparsePseudoRemainder(this.a, this.d);
            GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | a: " + this.e), (boolean)this.e.isZERO());
            this.e = (GenSolvablePolynomial)PolyUtil.baseSparsePseudoRemainder(this.b, this.d);
            GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testRecursiveLeftGCDPrimitive() {
        String[] stringArray = new String[]{"a", "b"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing = this.rfac;
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing2 = this.rfac;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = new QuotSolvablePolynomialRing(solvableQuotientRing, recSolvablePolynomialRing2);
        List list = recSolvablePolynomialRing.coeffTable.relationList();
        List list2 = PolynomialList.castToList(list);
        quotSolvablePolynomialRing.polCoeff.coeffTable.addRelations(list2);
        this.el = 2;
        this.ar = this.rfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = (RecSolvablePolynomial)PolyUtil.monic(this.cr);
        if (this.br.isZERO() || this.cr.isZERO()) {
            this.br = this.rfac.parse("( -1/2 ) b + 3 a");
            this.cr = this.rfac.parse("a * b - 5 b");
        }
        this.ar = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
        this.br = this.br.multiply((GenPolynomial<BigRational>)this.cr);
        long l = System.currentTimeMillis();
        this.sr = this.fds.leftRecursiveUnivariateGcd(this.ar, this.br);
        l = System.currentTimeMillis() - l;
        long l2 = System.currentTimeMillis();
        this.dr = this.fd.leftRecursiveUnivariateGcd(this.ar, this.br);
        l2 = System.currentTimeMillis() - l2;
        GCDPrimitiveTest.assertTrue((String)("time: ts = " + l + ", tp = " + l2), (l + l2 >= 0L ? 1 : 0) != 0);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
        GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc): " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.ar, this.dr);
        GCDPrimitiveTest.assertTrue((String)("gcd(ac,bc) | ac: " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.br, this.dr);
        GCDPrimitiveTest.assertTrue((String)("gcd(ac,bc) | bc: " + this.er), (boolean)this.er.isZERO());
        GenSolvablePolynomial genSolvablePolynomial = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.ar);
        GenSolvablePolynomial genSolvablePolynomial2 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.br);
        GenSolvablePolynomial genSolvablePolynomial3 = FDUtil.quotientFromIntegralCoefficients(quotSolvablePolynomialRing, this.dr);
        GreatestCommonDivisorPrimitive greatestCommonDivisorPrimitive = new GreatestCommonDivisorPrimitive(solvableQuotientRing);
        GenSolvablePolynomial genSolvablePolynomial4 = ((GreatestCommonDivisorAbstract)greatestCommonDivisorPrimitive).leftBaseGcd(genSolvablePolynomial, genSolvablePolynomial2);
        GenSolvablePolynomial genSolvablePolynomial5 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial4, genSolvablePolynomial3);
        GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc): " + genSolvablePolynomial5), (boolean)genSolvablePolynomial5.isZERO());
        genSolvablePolynomial5 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial, genSolvablePolynomial4);
        GCDPrimitiveTest.assertTrue((String)("gcd(ac,bc)| ac): " + genSolvablePolynomial5), (boolean)genSolvablePolynomial5.isZERO());
        genSolvablePolynomial5 = FDUtil.leftBaseSparsePseudoRemainder(genSolvablePolynomial2, genSolvablePolynomial4);
        GCDPrimitiveTest.assertTrue((String)("gcd(ac,bc)| bc): " + genSolvablePolynomial5), (boolean)genSolvablePolynomial5.isZERO());
    }

    public void testRecursiveRightGCDPrimitive() {
        String[] stringArray = new String[]{"a", "b"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = (RecSolvablePolynomialRing)this.dfac.recursive(1);
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing = this.rfac;
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing2 = this.rfac;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)this.rfac.coFac;
        SolvableQuotientRing solvableQuotientRing = new SolvableQuotientRing(genSolvablePolynomialRing);
        QuotSolvablePolynomialRing quotSolvablePolynomialRing = new QuotSolvablePolynomialRing(solvableQuotientRing, recSolvablePolynomialRing2);
        List list = recSolvablePolynomialRing.coeffTable.relationList();
        List list2 = PolynomialList.castToList(list);
        quotSolvablePolynomialRing.polCoeff.coeffTable.addRelations(list2);
        this.el = 3;
        this.ar = this.rfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = (RecSolvablePolynomial)PolyUtil.monic(this.cr);
        if (this.br.isZERO() || this.cr.isZERO()) {
            this.br = this.rfac.parse("( -1/2 ) b + 3 a");
            this.cr = this.rfac.parse("a * b - 5 b");
        }
        this.ar = this.cr.multiply((GenPolynomial<BigRational>)this.ar);
        this.br = this.cr.multiply((GenPolynomial<BigRational>)this.br);
        long l = System.currentTimeMillis();
        this.sr = this.fds.rightRecursiveUnivariateGcd(this.ar, this.br);
        l = System.currentTimeMillis() - l;
        long l2 = System.currentTimeMillis();
        this.dr = this.fd.rightRecursiveUnivariateGcd(this.ar, this.br);
        l2 = System.currentTimeMillis() - l2;
        GCDPrimitiveTest.assertTrue((String)("time: ts = " + l + ", tp = " + l2), (l + l2 >= 0L ? 1 : 0) != 0);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.dr, this.cr);
        GCDPrimitiveTest.assertTrue((String)("c | gcd(ca,cb): " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.ar, this.dr);
        GCDPrimitiveTest.assertTrue((String)("gcd(ca,cb) | ca: " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.br, this.dr);
        GCDPrimitiveTest.assertTrue((String)("gcd(ca,cb) | cb: " + this.er), (boolean)this.er.isZERO());
    }

    public void testArbitraryRecursiveGCDPrimitive() {
        String[] stringArray = new String[]{"a", "b"};
        String[] stringArray2 = new String[]{"c"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.rfac = new RecSolvablePolynomialRing(this.dfac, this.to, stringArray2);
        this.el = 2;
        this.ar0 = this.rfac.random(this.kl, this.ll, this.el + 1, this.q);
        this.br0 = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = (RecSolvablePolynomial)this.cr.monic();
        if (this.cr.isZERO()) {
            this.cr = this.rfac.getONE();
        }
        this.ar = this.ar0.multiply((GenPolynomial<BigRational>)this.cr);
        this.br = this.br0.multiply((GenPolynomial<BigRational>)this.cr);
        this.dr = this.fd.leftRecursiveGcd(this.ar, this.br);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
        GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc): " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.ar, this.dr);
        GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | a: " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveSparsePseudoRemainder(this.br, this.dr);
        GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | b: " + this.er), (boolean)this.er.isZERO());
        this.ar = this.cr.multiply((GenPolynomial<BigRational>)this.ar0);
        this.br = this.cr.multiply((GenPolynomial<BigRational>)this.br0);
        this.dr = this.fd.rightRecursiveGcd(this.ar, this.br);
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.dr, this.cr);
        GCDPrimitiveTest.assertTrue((String)("c | gcd(ca,cb) " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.ar, this.dr);
        GCDPrimitiveTest.assertTrue((String)("gcd(ca,cb) | ca " + this.er), (boolean)this.er.isZERO());
        this.er = (RecSolvablePolynomial)FDUtil.recursiveRightSparsePseudoRemainder(this.br, this.dr);
        GCDPrimitiveTest.assertTrue((String)("gcd(ca,cb) | cb " + this.er), (boolean)this.er.isZERO());
    }

    public void testGCDPrimitive() {
        String[] stringArray = new String[]{"a", "b", "c", "d"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.ll = 4;
        this.el = 4;
        this.a = this.dfac.parse("1/3 b^3 - 1/6 + d");
        this.b = this.dfac.parse("( -1/2 ) b + 3 a^2 + d");
        this.c = this.dfac.parse("(a - b) + c");
        this.c = this.c.monic();
        if (this.c.isZERO()) {
            this.c = this.dfac.getONE();
        }
        this.a0 = this.a;
        this.b0 = this.b;
        this.a = this.a0.multiply((BigRational)((Object)this.c));
        this.b = this.b0.multiply((BigRational)((Object)this.c));
        this.d = this.fd.leftGcd(this.a, this.b);
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.d, this.c);
        GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.c);
        GCDPrimitiveTest.assertTrue((String)("c | ac " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.a, this.d);
        GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.c);
        GCDPrimitiveTest.assertTrue((String)("c | bc " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.leftBaseSparsePseudoRemainder(this.b, this.d);
        GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
        this.a = this.c.multiply((BigRational)((Object)this.a0));
        this.b = this.c.multiply((BigRational)((Object)this.b0));
        this.d = this.fd.rightGcd(this.a, this.b);
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.d, this.c);
        GCDPrimitiveTest.assertTrue((String)("c | gcd(ac,bc): " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.a, this.c);
        GCDPrimitiveTest.assertTrue((String)("c | ac: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.b, this.c);
        GCDPrimitiveTest.assertTrue((String)("c | bc: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.a, this.d);
        GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | a: " + this.e), (boolean)this.e.isZERO());
        this.e = FDUtil.rightBaseSparsePseudoRemainder(this.b, this.d);
        GCDPrimitiveTest.assertTrue((String)("gcd(a,b) | b: " + this.e), (boolean)this.e.isZERO());
    }

    public void testRatCofactors() {
        do {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.a.isConstant());
        do {
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q / 2.0f);
        } while (this.b.isZERO() || this.b.isConstant());
        do {
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q / 2.0f);
        } while (this.c.isZERO() || this.c.isConstant());
        this.c = this.c.monic();
        this.d = this.c.multiply((BigRational)((Object)this.a));
        this.e = this.c.multiply((BigRational)((Object)this.b));
        GenSolvablePolynomial<BigRational>[] genSolvablePolynomialArray = this.fd.leftGcdCofactors(this.dfac, this.d, this.e);
        GenSolvablePolynomial<GenSolvablePolynomial<BigRational>> genSolvablePolynomial = genSolvablePolynomialArray[0].multiply((BigRational)((Object)genSolvablePolynomialArray[1]));
        GenSolvablePolynomial<GenSolvablePolynomial<BigRational>> genSolvablePolynomial2 = genSolvablePolynomialArray[0].multiply((BigRational)((Object)genSolvablePolynomialArray[2]));
        GCDPrimitiveTest.assertEquals((String)"ca = c*a: ", genSolvablePolynomial, this.d);
        GCDPrimitiveTest.assertEquals((String)"cb = c*b: ", genSolvablePolynomial2, this.e);
        this.d = this.a.multiply((BigRational)((Object)this.c));
        this.e = this.b.multiply((BigRational)((Object)this.c));
        genSolvablePolynomialArray = this.fd.rightGcdCofactors(this.dfac, this.d, this.e);
        GenSolvablePolynomial<GenSolvablePolynomial<BigRational>> genSolvablePolynomial3 = genSolvablePolynomialArray[1].multiply((BigRational)((Object)genSolvablePolynomialArray[0]));
        GenSolvablePolynomial<GenSolvablePolynomial<BigRational>> genSolvablePolynomial4 = genSolvablePolynomialArray[2].multiply((BigRational)((Object)genSolvablePolynomialArray[0]));
        GCDPrimitiveTest.assertEquals((String)"ac = a*c: ", genSolvablePolynomial3, this.d);
        GCDPrimitiveTest.assertEquals((String)"bc = b*c: ", genSolvablePolynomial4, this.e);
    }

    public void testCoPrime() {
        String[] stringArray = new String[]{"a", "b"};
        this.dfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.to, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        this.dfac.addRelations(weylRelationsIterated);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        GCDPrimitiveTest.assertTrue((String)"length( a ) <> 0", (this.a.length() > 0 ? 1 : 0) != 0);
        this.d = this.a.multiply((BigRational)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        ArrayList arrayList = new ArrayList(5);
        arrayList.add(this.d);
        arrayList.add(this.a);
        arrayList.add(this.b);
        arrayList.add(this.c);
        arrayList.add(this.e);
        List<GenSolvablePolynomial<Object>> list = this.fd.leftCoPrime(arrayList);
        GCDPrimitiveTest.assertTrue((String)"is co-prime ", (boolean)this.fd.isLeftCoPrime(list));
        GCDPrimitiveTest.assertTrue((String)"is co-prime of ", (boolean)this.fd.isLeftCoPrime(list, arrayList));
        list = this.fd.leftCoPrimeRec(arrayList);
        GCDPrimitiveTest.assertTrue((String)"is co-prime ", (boolean)this.fd.isLeftCoPrime(list));
        GCDPrimitiveTest.assertTrue((String)"is co-prime of ", (boolean)this.fd.isLeftCoPrime(list, arrayList));
    }
}

