/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseSigSeqIter;
import edu.jas.gb.SigPair;
import edu.jas.gb.SigPoly;
import edu.jas.gb.SigReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseArriSigSeqIter<C extends RingElem<C>>
extends GroebnerBaseSigSeqIter<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseArriSigSeqIter.class);

    public GroebnerBaseArriSigSeqIter() {
        this(new SigReductionSeq());
    }

    public GroebnerBaseArriSigSeqIter(SigReductionSeq<C> sigReductionSeq) {
        super(sigReductionSeq);
    }

    @Override
    GenPolynomial<C> SPolynomial(SigPair<C> sigPair) {
        return sigPair.pi.poly;
    }

    @Override
    SigPair<C> newPair(SigPoly<C> sigPoly, SigPoly<C> sigPoly2, List<SigPoly<C>> list) {
        ExpVector expVector = sigPoly.poly.leadingExpVector().lcm(sigPoly2.poly.leadingExpVector()).subtract(sigPoly.poly.leadingExpVector());
        GenPolynomial<C> genPolynomial = this.SPolynomial(sigPoly, sigPoly2);
        GenPolynomial genPolynomial2 = genPolynomial.ring.valueOf(expVector);
        return new SigPair(genPolynomial2, new SigPoly(genPolynomial2, genPolynomial), sigPoly2, list);
    }

    @Override
    SigPair<C> newPair(GenPolynomial<C> genPolynomial, SigPoly<C> sigPoly, SigPoly<C> sigPoly2, List<SigPoly<C>> list) {
        GenPolynomial<C> genPolynomial2 = this.SPolynomial(sigPoly, sigPoly2);
        return new SigPair<C>(genPolynomial, new SigPoly<C>(genPolynomial, genPolynomial2), sigPoly2, list);
    }

    @Override
    SigPoly<C> sigNormalform(List<GenPolynomial<C>> list, List<SigPoly<C>> list2, SigPoly<C> sigPoly) {
        return this.sred.sigSemiNormalform(list, list2, sigPoly);
    }

    @Override
    List<SigPair<C>> pruneP(List<SigPair<C>> list, List<ExpVector> list2) {
        ArrayList<SigPair<C>> arrayList = new ArrayList<SigPair<C>>(list.size());
        for (SigPair<C> sigPair : list) {
            ExpVector expVector = sigPair.sigma.leadingExpVector();
            if (expVector == null) continue;
            boolean bl = false;
            for (ExpVector expVector2 : list2) {
                if (!expVector.multipleOf(expVector2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(sigPair);
        }
        return arrayList;
    }

    @Override
    List<SigPair<C>> pruneS(List<SigPair<C>> list, List<ExpVector> list2, List<SigPoly<C>> list3, List<SigPoly<C>> list4) {
        ArrayList<SigPair<C>> arrayList = new ArrayList<SigPair<C>>(list.size());
        for (SigPair<C> sigPair : list) {
            ExpVector expVector = sigPair.sigma.leadingExpVector();
            if (expVector == null) continue;
            boolean bl = false;
            for (ExpVector expVector2 : list2) {
                if (!expVector.multipleOf(expVector2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            bl = false;
            for (SigPair sigPair2 : list) {
                if (!sigPair.sigma.equals(sigPair2.sigma) || sigPair.pi.poly.compareTo(sigPair2.pi.poly) <= 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            bl = false;
            for (SigPoly sigPoly : list3) {
                ExpVector expVector3 = sigPoly.sigma.leadingExpVector();
                if (expVector3 == null || !expVector.multipleOf(expVector3)) continue;
                ExpVector expVector4 = expVector.subtract(expVector3);
                ExpVector expVector5 = expVector4.sum(sigPoly.poly.leadingExpVector());
                ExpVector expVector6 = sigPair.pi.poly.leadingExpVector();
                if (expVector6 == null || expVector5.compareTo(expVector6) >= 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(sigPair);
            logger.debug("added p = {}", sigPair.sigma);
        }
        return arrayList;
    }

    @Override
    List<ExpVector> initializeSyz(List<GenPolynomial<C>> list, List<SigPoly<C>> list2) {
        ArrayList<ExpVector> arrayList = new ArrayList<ExpVector>();
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isZERO()) continue;
            arrayList.add(genPolynomial.leadingExpVector());
        }
        return arrayList;
    }

    @Override
    void updateSyz(List<ExpVector> list, SigPoly<C> sigPoly) {
        if (sigPoly.poly.isZERO() && !sigPoly.sigma.isZERO()) {
            list.add(sigPoly.sigma.leadingExpVector());
        }
    }
}

