/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPairList;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducerServerSeqPair;
import edu.jas.gb.ReducerClientSeqPair;
import edu.jas.gb.ReducerServerSeqPair;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import edu.jas.util.SocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class GroebnerBaseSeqPairDistributed<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseSeqPairDistributed.class);
    protected final int threads;
    protected static final int DEFAULT_THREADS = 2;
    protected final transient ExecutorService pool;
    protected static final int DEFAULT_PORT = 4711;
    protected final int port;

    public GroebnerBaseSeqPairDistributed() {
        this(2, 4711);
    }

    public GroebnerBaseSeqPairDistributed(int n) {
        this(n, Executors.newFixedThreadPool(n), 4711);
    }

    public GroebnerBaseSeqPairDistributed(int n, Reduction<C> reduction) {
        this(n, Executors.newFixedThreadPool(n), 4711, reduction);
    }

    public GroebnerBaseSeqPairDistributed(int n, int n2, Reduction<C> reduction) {
        this(n, Executors.newFixedThreadPool(n), n2, reduction);
    }

    public GroebnerBaseSeqPairDistributed(int n, int n2) {
        this(n, Executors.newFixedThreadPool(n), n2);
    }

    public GroebnerBaseSeqPairDistributed(int n, ExecutorService executorService, int n2) {
        this(n, executorService, n2, new ReductionPar());
    }

    public GroebnerBaseSeqPairDistributed(int n, ExecutorService executorService, int n2, Reduction<C> reduction) {
        super(reduction);
        if (!(reduction instanceof ReductionPar)) {
            logger.warn("parallel GB should use parallel aware reduction");
        }
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.pool = executorService;
        this.port = n2;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.shutdown();
        try {
            while (!this.pool.isTerminated()) {
                boolean bl = this.pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        int n2;
        GenPolynomial genPolynomial;
        int n3 = this.port + 100;
        ChannelFactory channelFactory = new ChannelFactory(this.port);
        channelFactory.init();
        DistHashTableServer distHashTableServer = new DistHashTableServer(n3);
        distHashTableServer.init();
        logger.debug("dist-list server running");
        CriticalPairList<C> criticalPairList = null;
        boolean bl = false;
        ListIterator<GenPolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            int n4;
            GenPolynomial<C> genPolynomial2 = listIterator.next();
            if (genPolynomial2.length() <= 0) continue;
            if ((genPolynomial2 = genPolynomial2.monic()).isONE()) {
                bl = true;
            }
            if (criticalPairList == null) {
                criticalPairList = new CriticalPairList<C>(n, genPolynomial2.ring);
            }
            if (genPolynomial2.isONE()) {
                n4 = criticalPairList.putOne();
                continue;
            }
            n4 = criticalPairList.put(genPolynomial2);
        }
        logger.debug("looking for clients");
        DistHashTable distHashTable = new DistHashTable("localhost", n3);
        distHashTable.init();
        List list2 = criticalPairList.getList();
        for (int i = 0; i < list2.size(); ++i) {
            genPolynomial = distHashTable.put(i, list2.get(i));
            if (genPolynomial == null) continue;
            logger.info("double polynomials {}, nn = {}, G(i) = {}", (Object)i, genPolynomial, list2.get(i));
        }
        Terminator terminator = new Terminator(this.threads);
        for (n2 = 0; n2 < this.threads; ++n2) {
            genPolynomial = new ReducerServerSeqPair(terminator, channelFactory, distHashTable, criticalPairList);
            this.pool.execute((Runnable)((Object)genPolynomial));
        }
        logger.debug("main loop waiting");
        terminator.waitDone();
        n2 = distHashTable.size();
        list2 = criticalPairList.getList();
        if (n2 != list2.size()) {
            logger.info("#distributed list = {} #pairlist list = {}", (Object)distHashTable.size(), (Object)list2.size());
        }
        long l = System.currentTimeMillis();
        List list3 = this.minimalGB(list2);
        l = System.currentTimeMillis() - l;
        logger.info("parallel gbmi = {}", (Object)l);
        list2 = list3;
        channelFactory.terminate();
        logger.info("theList.terminate()");
        distHashTable.terminate();
        logger.info("dls.terminate()");
        distHashTableServer.terminate();
        logger.info("{}", criticalPairList);
        return list2;
    }

    public void clientPart(String string) throws IOException {
        ChannelFactory channelFactory = new ChannelFactory(this.port + 10);
        channelFactory.init();
        SocketChannel socketChannel = channelFactory.getChannel(string, this.port);
        int n = this.port + 100;
        DistHashTable distHashTable = new DistHashTable(string, n);
        distHashTable.init();
        ReducerClientSeqPair reducerClientSeqPair = new ReducerClientSeqPair(socketChannel, distHashTable);
        reducerClientSeqPair.run();
        socketChannel.close();
        distHashTable.terminate();
        channelFactory.terminate();
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial<C> genPolynomial;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        ListIterator<GenPolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = listIterator.next();
            if (genPolynomial.length() == 0) continue;
            arrayList.add(genPolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenPolynomial<Object> genPolynomial2;
            genPolynomial = arrayList.remove(0);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        Collections.reverse(arrayList);
        MiReducerServerSeqPair[] miReducerServerSeqPairArray = new MiReducerServerSeqPair[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genPolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            miReducerServerSeqPairArray[n] = new MiReducerServerSeqPair(arrayList3, genPolynomial);
            this.pool.execute(miReducerServerSeqPairArray[n]);
            ++n;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < miReducerServerSeqPairArray.length; ++n) {
            genPolynomial = miReducerServerSeqPairArray[n].getNF();
            arrayList2.add(genPolynomial);
        }
        return arrayList2;
    }
}

