/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PreemptingException;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SGBProxy<C extends GcdRingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SGBProxy.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final SolvableGroebnerBaseAbstract<C> e1;
    public final SolvableGroebnerBaseAbstract<C> e2;
    protected transient ExecutorService pool;

    public SGBProxy(SolvableGroebnerBaseAbstract<C> solvableGroebnerBaseAbstract, SolvableGroebnerBaseAbstract<C> solvableGroebnerBaseAbstract2) {
        this.e1 = solvableGroebnerBaseAbstract;
        this.e2 = solvableGroebnerBaseAbstract2;
        this.pool = ComputerThreads.getPool();
    }

    public String toString() {
        return "SGBProxy[ " + this.e1.toString() + ", " + this.e2.toString() + " ]";
    }

    @Override
    public void terminate() {
        this.e1.terminate();
        this.e2.terminate();
    }

    @Override
    public int cancel() {
        int n = this.e1.cancel();
        return n += this.e2.cancel();
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(final int n, final List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        List list2 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<List<GenSolvablePolynomial<C>>>(){

            @Override
            public List<GenSolvablePolynomial<C>> call() {
                try {
                    List list2 = SGBProxy.this.e1.leftGB(n, list);
                    if (debug) {
                        logger.info("SGBProxy done e1 {}", (Object)SGBProxy.this.e1.getClass().getName());
                    }
                    return list2;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGBProxy e1 preempted " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGBProxy e1 {}", (Throwable)exception);
                    logger.info("Exception SGBProxy F = {}", (Object)list);
                    throw new RuntimeException("SGBProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<List<GenSolvablePolynomial<C>>>(){

            @Override
            public List<GenSolvablePolynomial<C>> call() {
                try {
                    List list2 = SGBProxy.this.e2.leftGB(n, list);
                    if (debug) {
                        logger.info("SGBProxy done e2 {}", (Object)SGBProxy.this.e2.getClass().getName());
                    }
                    return list2;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGBProxy e2 preempted " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGBProxy e2 {}", (Throwable)exception);
                    logger.info("Exception SGBProxy F = {}", (Object)list);
                    throw new RuntimeException("SGBProxy e2 " + exception);
                }
            }
        });
        try {
            list2 = (List)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(final int n, final List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        List list2 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<List<GenSolvablePolynomial<C>>>(){

            @Override
            public List<GenSolvablePolynomial<C>> call() {
                try {
                    List list2 = SGBProxy.this.e1.rightGB(n, list);
                    if (debug) {
                        logger.info("SGBProxy done e1 {}", (Object)SGBProxy.this.e1.getClass().getName());
                    }
                    return list2;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGBProxy e1 preempted " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGBProxy e1 {}", (Throwable)exception);
                    logger.info("Exception SGBProxy F = {}", (Object)list);
                    throw new RuntimeException("SGBProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<List<GenSolvablePolynomial<C>>>(){

            @Override
            public List<GenSolvablePolynomial<C>> call() {
                try {
                    List list2 = SGBProxy.this.e2.rightGB(n, list);
                    if (debug) {
                        logger.info("SGBProxy done e2 {}", (Object)SGBProxy.this.e2.getClass().getName());
                    }
                    return list2;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGBProxy e2 preempted " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGBProxy e2 {}", (Throwable)exception);
                    logger.info("Exception SGBProxy F = {}", (Object)list);
                    throw new RuntimeException("SGBProxy e2 " + exception);
                }
            }
        });
        try {
            list2 = (List)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(final int n, final List<GenSolvablePolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        List list2 = null;
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Callable<List<GenSolvablePolynomial<C>>>(){

            @Override
            public List<GenSolvablePolynomial<C>> call() {
                try {
                    List list2 = SGBProxy.this.e1.twosidedGB(n, list);
                    if (debug) {
                        logger.info("SGBProxy done e1 {}", (Object)SGBProxy.this.e1.getClass().getName());
                    }
                    return list2;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGBProxy e1 preempted " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGBProxy e1 {}", (Throwable)exception);
                    logger.info("Exception SGBProxy F = {}", (Object)list);
                    throw new RuntimeException("SGBProxy e1 " + exception);
                }
            }
        });
        arrayList.add(new Callable<List<GenSolvablePolynomial<C>>>(){

            @Override
            public List<GenSolvablePolynomial<C>> call() {
                try {
                    List list2 = SGBProxy.this.e2.twosidedGB(n, list);
                    if (debug) {
                        logger.info("SGBProxy done e2 {}", (Object)SGBProxy.this.e2.getClass().getName());
                    }
                    return list2;
                }
                catch (PreemptingException preemptingException) {
                    throw new RuntimeException("SGBProxy e2 preempted " + preemptingException);
                }
                catch (Exception exception) {
                    logger.info("SGBProxy e2 {}", (Throwable)exception);
                    logger.info("Exception SGBProxy F = {}", (Object)list);
                    throw new RuntimeException("SGBProxy e2 " + exception);
                }
            }
        });
        try {
            list2 = (List)this.pool.invokeAny(arrayList);
        }
        catch (InterruptedException interruptedException) {
            logger.info("InterruptedException {}", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            logger.info("ExecutionException {}", (Throwable)executionException);
            Thread.currentThread().interrupt();
        }
        return list2;
    }
}

