/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gbufd.SolvablePseudoReduction;
import edu.jas.gbufd.SolvablePseudoReductionSeq;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.QLRSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorFake;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolvableGroebnerBasePseudoSeq<C extends GcdRingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SolvableGroebnerBasePseudoSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final SolvablePseudoReduction<C> sred;
    protected final RingFactory<C> cofac;

    public SolvableGroebnerBasePseudoSeq(RingFactory<C> ringFactory) {
        this(new SolvablePseudoReductionSeq(), ringFactory, new OrderedPairlist());
    }

    public SolvableGroebnerBasePseudoSeq(RingFactory<C> ringFactory, PairList<C> pairList) {
        this(new SolvablePseudoReductionSeq(), ringFactory, pairList);
    }

    public SolvableGroebnerBasePseudoSeq(SolvablePseudoReduction<C> solvablePseudoReduction, RingFactory<C> ringFactory, PairList<C> pairList) {
        super(solvablePseudoReduction, pairList);
        this.sred = solvablePseudoReduction;
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)pairList.getRing();
        this.cofac = ringFactory;
        if (!this.cofac.isCommutative()) {
            logger.warn("right reduction not correct for {}", this.cofac);
            this.engine = new GreatestCommonDivisorFake();
        } else if (genSolvablePolynomialRing instanceof QLRSolvablePolynomialRing) {
            QLRSolvablePolynomialRing qLRSolvablePolynomialRing = (QLRSolvablePolynomialRing)genSolvablePolynomialRing;
            RecSolvablePolynomialRing recSolvablePolynomialRing = qLRSolvablePolynomialRing.polCoeff;
            if (!recSolvablePolynomialRing.coeffTable.isEmpty()) {
                logger.warn("right reduction not correct for {}", recSolvablePolynomialRing.coeffTable);
                this.engine = new GreatestCommonDivisorFake();
            } else {
                this.engine = GCDFactory.getImplementation(this.cofac);
            }
        } else {
            this.engine = GCDFactory.getProxy(this.cofac);
        }
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int n, List<GenSolvablePolynomial<C>> list) {
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(this.engine.basePrimitivePart(PolynomialList.castToList(list2)))).size() <= 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (genSolvablePolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        while (pairList.hasNext()) {
            GenSolvablePolynomial genSolvablePolynomial;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)pair.pj;
            if (debug) {
                logger.debug("pi    = {}", (Object)genSolvablePolynomial2);
                logger.debug("pj    = {}", (Object)genSolvablePolynomial3);
            }
            if ((genSolvablePolynomial = this.sred.leftSPolynomial(genSolvablePolynomial2, genSolvablePolynomial3)).isZERO()) {
                pair.setZero();
                continue;
            }
            logger.debug("ht(S) = {}", (Object)genSolvablePolynomial.leadingExpVector());
            GenSolvablePolynomial genSolvablePolynomial4 = this.sred.leftNormalform(list2, genSolvablePolynomial);
            if (genSolvablePolynomial4.isZERO()) {
                pair.setZero();
                continue;
            }
            logger.debug("ht(H) = {}", (Object)genSolvablePolynomial4.leadingExpVector());
            genSolvablePolynomial4 = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial4);
            genSolvablePolynomial4 = (GenSolvablePolynomial)genSolvablePolynomial4.abs();
            if (genSolvablePolynomial4.isConstant()) {
                list2.clear();
                list2.add(genSolvablePolynomial4);
                return list2;
            }
            logger.debug("H = {}", (Object)genSolvablePolynomial4);
            if (genSolvablePolynomial4.length() <= 0) continue;
            list2.add(genSolvablePolynomial4);
            pairList.put(genSolvablePolynomial4);
        }
        logger.debug("#sequential list = {}", (Object)list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("{}", pairList);
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftMinimalGB(List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial genSolvablePolynomial;
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list2.size());
        while (list2.size() > 0) {
            genSolvablePolynomial = list2.remove(0);
            if (this.sred.isTopReducible(list2, genSolvablePolynomial) || this.sred.isTopReducible(arrayList, genSolvablePolynomial)) {
                if (!debug) continue;
                System.out.println("dropped " + genSolvablePolynomial);
                ArrayList<GenSolvablePolynomial<C>> arrayList2 = new ArrayList<GenSolvablePolynomial<C>>(list2);
                arrayList2.addAll(arrayList);
                if ((genSolvablePolynomial = this.sred.leftNormalform(arrayList2, genSolvablePolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genSolvablePolynomial);
                continue;
            }
            arrayList.add(genSolvablePolynomial);
        }
        list2 = arrayList;
        if (list2.size() <= 1) {
            return list2;
        }
        Collections.reverse(list2);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            genSolvablePolynomial = list2.remove(0);
            genSolvablePolynomial = this.sred.leftNormalform(list2, genSolvablePolynomial);
            genSolvablePolynomial = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial);
            genSolvablePolynomial = (GenSolvablePolynomial)genSolvablePolynomial.abs();
            list2.add(genSolvablePolynomial);
        }
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int n, List<GenSolvablePolynomial<C>> list) {
        GenSolvablePolynomial genSolvablePolynomial;
        GenSolvablePolynomial genSolvablePolynomial2;
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(this.engine.basePrimitivePart(PolynomialList.castToList(list2)))).size() < 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (genSolvablePolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        List list3 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators(n));
        logger.info("right multipliers = {}", list3);
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list2.size() * (1 + list3.size()));
        arrayList.addAll(list2);
        logger.info("right multipy: F = {}", arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            genSolvablePolynomial2 = (GenSolvablePolynomial)arrayList.get(i);
            for (int j = 0; j < list3.size(); ++j) {
                genSolvablePolynomial = list3.get(j);
                GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial2.multiply(genSolvablePolynomial);
                logger.info("right multipy: p = {}, x = {}, q = {}", (Object)genSolvablePolynomial2, genSolvablePolynomial, genSolvablePolynomial3);
                genSolvablePolynomial3 = this.sred.leftNormalform(arrayList, genSolvablePolynomial3);
                if (genSolvablePolynomial3.isZERO()) continue;
                genSolvablePolynomial3 = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial3);
                genSolvablePolynomial3 = (GenSolvablePolynomial)genSolvablePolynomial3.abs();
                logger.info("right multipy: red(q) = {}", (Object)genSolvablePolynomial3);
                arrayList.add(genSolvablePolynomial3);
            }
        }
        list2 = arrayList;
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        while (pairList.hasNext()) {
            GenSolvablePolynomial genSolvablePolynomial4;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)pair.pj;
            if (debug) {
                logger.debug("pi    = {}", (Object)genSolvablePolynomial5);
                logger.debug("pj    = {}", (Object)genSolvablePolynomial6);
            }
            if ((genSolvablePolynomial4 = this.sred.leftSPolynomial(genSolvablePolynomial5, genSolvablePolynomial6)).isZERO()) {
                pair.setZero();
                continue;
            }
            logger.debug("ht(S) = {}", (Object)genSolvablePolynomial4.leadingExpVector());
            GenSolvablePolynomial genSolvablePolynomial7 = this.sred.leftNormalform(list2, genSolvablePolynomial4);
            if (genSolvablePolynomial7.isZERO()) {
                pair.setZero();
                continue;
            }
            logger.debug("ht(H) = {}", (Object)genSolvablePolynomial7.leadingExpVector());
            genSolvablePolynomial7 = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial7);
            genSolvablePolynomial7 = (GenSolvablePolynomial)genSolvablePolynomial7.abs();
            if (genSolvablePolynomial7.isONE()) {
                list2.clear();
                list2.add(genSolvablePolynomial7);
                return list2;
            }
            logger.debug("H = {}", (Object)genSolvablePolynomial7);
            if (genSolvablePolynomial7.length() <= 0) continue;
            list2.add(genSolvablePolynomial7);
            pairList.put(genSolvablePolynomial7);
            for (int i = 0; i < list3.size(); ++i) {
                genSolvablePolynomial = list3.get(i);
                genSolvablePolynomial2 = genSolvablePolynomial7.multiply(genSolvablePolynomial);
                if ((genSolvablePolynomial2 = this.sred.leftNormalform(list2, genSolvablePolynomial2)).isZERO()) continue;
                genSolvablePolynomial2 = (GenSolvablePolynomial)this.engine.basePrimitivePart(genSolvablePolynomial2);
                if ((genSolvablePolynomial2 = (GenSolvablePolynomial)genSolvablePolynomial2.abs()).isONE()) {
                    list2.clear();
                    list2.add(genSolvablePolynomial2);
                    return list2;
                }
                list2.add(genSolvablePolynomial2);
                pairList.put(genSolvablePolynomial2);
            }
        }
        logger.debug("#sequential list = {}", (Object)list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("{}", pairList);
        return list2;
    }
}

