/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.OrderedWordPairlist;
import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordPair;
import edu.jas.gb.WordPairList;
import edu.jas.gbufd.WordPseudoReductionSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WordGroebnerBasePseudoSeq<C extends GcdRingElem<C>>
extends WordGroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(WordGroebnerBasePseudoSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final RingFactory<C> cofac;

    public WordGroebnerBasePseudoSeq(RingFactory<C> ringFactory) {
        this(ringFactory, new WordPseudoReductionSeq());
    }

    public WordGroebnerBasePseudoSeq(RingFactory<C> ringFactory, WordPseudoReductionSeq<C> wordPseudoReductionSeq) {
        this(ringFactory, wordPseudoReductionSeq, new OrderedWordPairlist());
    }

    public WordGroebnerBasePseudoSeq(RingFactory<C> ringFactory, WordPseudoReductionSeq<C> wordPseudoReductionSeq, WordPairList<C> wordPairList) {
        super(wordPseudoReductionSeq, wordPairList);
        this.cofac = ringFactory;
        if (!this.cofac.isCommutative()) {
            logger.warn("reduction not correct for {}", this.cofac);
        }
    }

    @Override
    public List<GenWordPolynomial<C>> GB(List<GenWordPolynomial<C>> list) {
        List<GenWordPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = this.basePrimitivePart(list2)).size() <= 1) {
            return list2;
        }
        GenWordPolynomialRing genWordPolynomialRing = list2.get((int)0).ring;
        if (!genWordPolynomialRing.coFac.isCommutative()) {
            throw new IllegalArgumentException("coefficient ring not commutative");
        }
        OrderedWordPairlist orderedWordPairlist = (OrderedWordPairlist)this.strategy.create(genWordPolynomialRing);
        orderedWordPairlist.put(list2);
        logger.info("start {}", (Object)orderedWordPairlist);
        while (orderedWordPairlist.hasNext()) {
            List list3;
            WordPair wordPair = orderedWordPairlist.removeNext();
            if (wordPair == null) continue;
            GenWordPolynomial genWordPolynomial = wordPair.pi;
            GenWordPolynomial genWordPolynomial2 = wordPair.pj;
            if (debug) {
                logger.info("pi = {}, pj = {}", genWordPolynomial, genWordPolynomial2);
            }
            if ((list3 = this.red.SPolynomials(genWordPolynomial, genWordPolynomial2)).isEmpty()) continue;
            for (GenWordPolynomial genWordPolynomial3 : list3) {
                if (genWordPolynomial3.isZERO()) continue;
                if (debug) {
                    logger.info("ht(S) = {}", (Object)genWordPolynomial3.leadingWord());
                }
                boolean bl = orderedWordPairlist.criterion3(wordPair.i, wordPair.j, genWordPolynomial3.leadingWord());
                AbelianGroupElem<GenWordPolynomial<C>> abelianGroupElem = this.red.normalform(list2, genWordPolynomial3);
                if (debug) {
                    logger.info("ht(H) = {}", ((GenWordPolynomial)abelianGroupElem).monic());
                }
                if (((GenWordPolynomial)abelianGroupElem).isZERO()) continue;
                if (!bl) {
                    logger.info("criterion3({},{}) wrong: {} --> {}", (Object)wordPair.i, (Object)wordPair.j, (Object)genWordPolynomial3.leadingWord(), (Object)((GenWordPolynomial)abelianGroupElem).leadingWord());
                }
                abelianGroupElem = this.basePrimitivePart((GenWordPolynomial<C>)abelianGroupElem);
                abelianGroupElem = ((GenWordPolynomial)abelianGroupElem).abs();
                if (debug) {
                    logger.info("ht(H) = {}", (Object)((GenWordPolynomial)abelianGroupElem).leadingWord());
                }
                if (((GenWordPolynomial)abelianGroupElem).isONE()) {
                    list2.clear();
                    list2.add((GenWordPolynomial<C>)abelianGroupElem);
                    return list2;
                }
                if (debug) {
                    logger.info("H = {}", abelianGroupElem);
                }
                if (((GenWordPolynomial)abelianGroupElem).length() <= 0) continue;
                list2.add((GenWordPolynomial<C>)abelianGroupElem);
                orderedWordPairlist.put(abelianGroupElem);
            }
        }
        list2 = this.minimalGB(list2);
        logger.info("{}", (Object)orderedWordPairlist);
        return list2;
    }

    public C baseContent(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genWordPolynomial.isZERO()) {
            return (C)((GcdRingElem)genWordPolynomial.ring.getZEROCoefficient());
        }
        AbelianGroupElem abelianGroupElem = null;
        for (GcdRingElem gcdRingElem : genWordPolynomial.getMap().values()) {
            if (!(abelianGroupElem = abelianGroupElem == null ? gcdRingElem : abelianGroupElem.gcd(gcdRingElem)).isONE()) continue;
            return (C)abelianGroupElem;
        }
        if (abelianGroupElem.signum() < 0) {
            abelianGroupElem = (GcdRingElem)abelianGroupElem.negate();
        }
        return (C)abelianGroupElem;
    }

    public GenWordPolynomial<C> basePrimitivePart(GenWordPolynomial<C> genWordPolynomial) {
        GenWordPolynomial<C> genWordPolynomial2;
        if (genWordPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genWordPolynomial.isZERO()) {
            return genWordPolynomial;
        }
        C c = this.baseContent(genWordPolynomial);
        if (c.isONE()) {
            return genWordPolynomial;
        }
        GenWordPolynomial<C> genWordPolynomial3 = genWordPolynomial.divide(c);
        if (debug && !(genWordPolynomial2 = genWordPolynomial3.multiply(c)).equals(genWordPolynomial)) {
            throw new ArithmeticException("pp(p)*cont(p) != p: ");
        }
        return genWordPolynomial3;
    }

    public List<GenWordPolynomial<C>> basePrimitivePart(List<GenWordPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<GenWordPolynomial<C>> arrayList = new ArrayList<GenWordPolynomial<C>>(list.size());
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            GenWordPolynomial<C> genWordPolynomial2 = this.basePrimitivePart(genWordPolynomial);
            arrayList.add(genWordPolynomial2);
        }
        return arrayList;
    }
}

