/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.List;

public class LogIntegral<C extends GcdRingElem<C>>
implements Serializable {
    public final GenPolynomial<C> num;
    public final GenPolynomial<C> den;
    public final List<C> cfactors;
    public final List<GenPolynomial<C>> cdenom;
    public final List<AlgebraicNumber<C>> afactors;
    public final List<GenPolynomial<AlgebraicNumber<C>>> adenom;

    public LogIntegral(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, List<C> list, List<GenPolynomial<C>> list2, List<AlgebraicNumber<C>> list3, List<GenPolynomial<AlgebraicNumber<C>>> list4) {
        this.num = genPolynomial;
        this.den = genPolynomial2;
        this.cfactors = list;
        this.cdenom = list2;
        this.afactors = list3;
        this.adenom = list4;
    }

    public String toString() {
        Serializable serializable;
        AlgebraicNumber<C> algebraicNumber;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (n = 0; n < this.cfactors.size(); ++n) {
            algebraicNumber = (AlgebraicNumber<C>)this.cfactors.get(n);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" + ");
            }
            stringBuffer.append("(" + ((Object)algebraicNumber).toString() + ")");
            serializable = this.cdenom.get(n);
            stringBuffer.append(" log( " + ((GenPolynomial)serializable).toString() + ")");
        }
        if (!bl && this.afactors.size() > 0) {
            stringBuffer.append(" + ");
        }
        bl = true;
        for (n = 0; n < this.afactors.size(); ++n) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" + ");
            }
            algebraicNumber = this.afactors.get(n);
            serializable = algebraicNumber.factory();
            GenPolynomial<AlgebraicNumber<C>> genPolynomial = this.adenom.get(n);
            if (genPolynomial.degree(0) < ((AlgebraicNumberRing)serializable).modul.degree(0) && ((AlgebraicNumberRing)serializable).modul.degree(0) > 2L) {
                stringBuffer.append("sum_(" + ((AlgebraicNumberRing)serializable).getGenerator() + " in ");
                stringBuffer.append("rootOf(" + ((AlgebraicNumberRing)serializable).modul + ") ) ");
            }
            stringBuffer.append("(" + algebraicNumber.toString() + ")");
            stringBuffer.append(" log( " + genPolynomial.toString() + ")");
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.num.toScript());
        stringBuffer.append(" / ");
        stringBuffer.append(this.den.toScript());
        stringBuffer.append(" = ");
        boolean bl = true;
        for (GcdRingElem ringElem : this.cfactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ringElem.toScript());
        }
        if (!bl) {
            stringBuffer.append(" linear denominators: ");
        }
        bl = true;
        for (GenPolynomial genPolynomial : this.cdenom) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(genPolynomial.toScript());
        }
        if (!bl) {
            stringBuffer.append(", ");
        }
        bl = true;
        for (AlgebraicNumber algebraicNumber : this.afactors) {
            if (bl) {
                bl = false;
            }
            stringBuffer.append(algebraicNumber.toScript());
            stringBuffer.append(" ## over " + algebraicNumber.toScriptFactory() + "\n");
        }
        stringBuffer.append(" denominators: ");
        bl = true;
        for (GenPolynomial genPolynomial : this.adenom) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(genPolynomial.toScript());
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = this.num.hashCode();
        n = n * 37 + this.den.hashCode();
        n = n * 37 + this.cfactors.hashCode();
        n = n * 37 + this.cdenom.hashCode();
        n = n * 37 + this.afactors.hashCode();
        n = n * 37 + this.adenom.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        if (!(object instanceof LogIntegral)) {
            return false;
        }
        LogIntegral logIntegral = (LogIntegral)object;
        boolean bl2 = bl = this.num.equals(logIntegral.num) && this.den.equals(logIntegral.den);
        if (!bl) {
            return bl;
        }
        bl = this.cfactors.equals(logIntegral.cfactors);
        if (!bl) {
            return bl;
        }
        bl = this.cdenom.equals(logIntegral.cdenom);
        if (!bl) {
            return bl;
        }
        bl = this.afactors.equals(logIntegral.afactors);
        if (!bl) {
            return bl;
        }
        bl = this.adenom.equals(logIntegral.adenom);
        return bl;
    }
}

