/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Quotient;
import edu.jas.poly.QuotientRing;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuotientTest
extends TestCase {
    QuotientRing<BigInteger> fac;
    GenPolynomialRing<BigInteger> pfac;
    QuotientRing<GenPolynomial<BigInteger>> mfac;
    Quotient<BigInteger> a;
    Quotient<BigInteger> b;
    Quotient<BigInteger> c;
    Quotient<BigInteger> d;
    Quotient<BigInteger> e;
    Quotient<GenPolynomial<BigInteger>> ap;
    Quotient<GenPolynomial<BigInteger>> bp;
    Quotient<GenPolynomial<BigInteger>> cp;
    Quotient<GenPolynomial<BigInteger>> dp;
    Quotient<GenPolynomial<BigInteger>> ep;
    int rl = 2;
    int kl = 17;
    int ll = 3;
    int el = 2;
    float q = 0.4f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)QuotientTest.suite());
    }

    public QuotientTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(QuotientTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        this.fac = new QuotientRing<BigInteger>(new BigInteger(1L));
        this.pfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), 1);
        this.mfac = new QuotientRing<BigInteger>(this.pfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ep = null;
        this.dp = null;
        this.cp = null;
        this.bp = null;
        this.ap = null;
        this.fac = null;
        this.pfac = null;
        this.mfac = null;
    }

    public void testIntRing() {
        QuotientTest.assertFalse((String)"#ring infinite", (boolean)this.fac.isFinite());
        QuotientTest.assertTrue((String)"associative ring", (boolean)this.fac.isAssociative());
        QuotientTest.assertTrue((String)"commutative ring", (boolean)this.fac.isCommutative());
        QuotientTest.assertTrue((String)"characteristic p", (this.fac.characteristic().signum() == 0 ? 1 : 0) != 0);
        QuotientTest.assertTrue((String)"no field", (boolean)this.fac.isField());
    }

    public void testPolyRing() {
        QuotientTest.assertFalse((String)"#ring infinite", (boolean)this.mfac.isFinite());
        QuotientTest.assertTrue((String)"associative ring", (boolean)this.mfac.isAssociative());
        QuotientTest.assertTrue((String)"commutative ring", (boolean)this.mfac.isCommutative());
        QuotientTest.assertTrue((String)"characteristic zero", (this.mfac.characteristic().signum() == 0 ? 1 : 0) != 0);
        QuotientTest.assertTrue((String)"no field", (boolean)this.mfac.isField());
    }

    public void testIntConstruction() {
        this.c = this.fac.getONE();
        QuotientTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuotientTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        QuotientTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuotientTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        List<Quotient<BigInteger>> list = this.fac.generators();
        QuotientTest.assertTrue((String)"#gens == 1: ", (list.size() == 1 ? 1 : 0) != 0);
        for (Quotient<BigInteger> quotient : list) {
            this.a = this.fac.parse(quotient.toString());
            QuotientTest.assertEquals((String)"a == v", this.a, quotient);
        }
    }

    public void testPolyConstruction() {
        this.cp = this.mfac.getONE();
        QuotientTest.assertTrue((String)"isZERO( cp )", (!this.cp.isZERO() ? 1 : 0) != 0);
        QuotientTest.assertTrue((String)"isONE( cp )", (boolean)this.cp.isONE());
        this.dp = this.mfac.getZERO();
        QuotientTest.assertTrue((String)"isZERO( dp )", (boolean)this.dp.isZERO());
        QuotientTest.assertTrue((String)"isONE( dp )", (!this.dp.isONE() ? 1 : 0) != 0);
        List<Quotient<GenPolynomial<BigInteger>>> list = this.mfac.generators();
        QuotientTest.assertTrue((String)"#gens == 3: ", (list.size() == 3 ? 1 : 0) != 0);
        for (Quotient<GenPolynomial<BigInteger>> quotient : list) {
            this.ap = this.mfac.parse(quotient.toString());
            QuotientTest.assertEquals((String)"ap == v", this.ap, quotient);
        }
    }

    public void testIntRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.kl * (i + 1));
            QuotientTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuotientTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testPolyRandom() {
        for (int i = 0; i < 7; ++i) {
            this.ap = this.mfac.random(this.kl + i);
            QuotientTest.assertTrue((String)(" not isZERO( ap" + i + " )"), (!this.ap.isZERO() ? 1 : 0) != 0);
            QuotientTest.assertTrue((String)(" not isONE( ap" + i + " )"), (!this.ap.isONE() ? 1 : 0) != 0);
        }
    }

    public void testIntAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        QuotientTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        QuotientTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        QuotientTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Quotient<BigInteger>)this.fac.getZERO());
        this.d = this.a.subtract((Quotient<BigInteger>)this.fac.getZERO());
        QuotientTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Quotient)this.fac.getZERO()).sum(this.a);
        this.d = ((Quotient)this.fac.getZERO()).subtract(this.a.negate());
        QuotientTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testPolyAddition() {
        this.ap = this.mfac.random(this.kl);
        this.bp = this.mfac.random(this.kl);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.cp.subtract(this.bp);
        QuotientTest.assertEquals((String)"a+b-b = a", this.ap, this.dp);
        this.cp = this.ap.sum(this.bp);
        this.dp = this.bp.sum(this.ap);
        QuotientTest.assertEquals((String)"a+b = b+a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl);
        this.dp = this.cp.sum(this.ap.sum(this.bp));
        this.ep = this.cp.sum(this.ap).sum(this.bp);
        QuotientTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.dp, this.ep);
        this.cp = this.ap.sum((Quotient<GenPolynomial<BigInteger>>)this.mfac.getZERO());
        this.dp = this.ap.subtract((Quotient<GenPolynomial<BigInteger>>)this.mfac.getZERO());
        QuotientTest.assertEquals((String)"a+0 = a-0", this.cp, this.dp);
        this.cp = ((Quotient)this.mfac.getZERO()).sum(this.ap);
        this.dp = ((Quotient)this.mfac.getZERO()).subtract(this.ap.negate());
        QuotientTest.assertEquals((String)"0+a = 0+(-a)", this.cp, this.dp);
    }

    public void testIntMultiplication() {
        this.a = this.fac.random(this.kl);
        QuotientTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        QuotientTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        QuotientTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuotientTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract(this.c);
        QuotientTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        QuotientTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        QuotientTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        QuotientTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        QuotientTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((Quotient<BigInteger>)this.fac.getONE());
        this.d = ((Quotient)this.fac.getONE()).multiply(this.a);
        QuotientTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply(this.a);
            QuotientTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
        this.c = this.b.multiply(this.a);
        Quotient<BigInteger>[] quotientArray = this.c.quotientRemainder(this.a);
        QuotientTest.assertEquals((String)"b*a / a == b", quotientArray[0], this.b);
        QuotientTest.assertTrue((String)"b*a rem a == 0", (boolean)quotientArray[1].isZERO());
    }

    public void testPolyMultiplication() {
        this.ap = this.mfac.random(this.kl);
        QuotientTest.assertTrue((String)"not isZERO( a )", (!this.ap.isZERO() ? 1 : 0) != 0);
        this.bp = this.mfac.random(this.kl);
        QuotientTest.assertTrue((String)"not isZERO( b )", (!this.bp.isZERO() ? 1 : 0) != 0);
        this.cp = this.bp.multiply(this.ap);
        this.dp = this.ap.multiply(this.bp);
        QuotientTest.assertTrue((String)"not isZERO( c )", (!this.cp.isZERO() ? 1 : 0) != 0);
        QuotientTest.assertTrue((String)"not isZERO( d )", (!this.dp.isZERO() ? 1 : 0) != 0);
        this.ep = this.dp.subtract(this.cp);
        QuotientTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.ep), (boolean)this.ep.isZERO());
        QuotientTest.assertTrue((String)"a*b = b*a", (boolean)this.cp.equals(this.dp));
        QuotientTest.assertEquals((String)"a*b = b*a", this.cp, this.dp);
        this.cp = this.mfac.random(this.kl);
        this.dp = this.ap.multiply(this.bp.multiply(this.cp));
        this.ep = this.ap.multiply(this.bp).multiply(this.cp);
        QuotientTest.assertEquals((String)"a(bc) = (ab)c", this.dp, this.ep);
        QuotientTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.dp.equals(this.ep));
        this.cp = this.ap.multiply((Quotient<GenPolynomial<BigInteger>>)this.mfac.getONE());
        this.dp = ((Quotient)this.mfac.getONE()).multiply(this.ap);
        QuotientTest.assertEquals((String)"a*1 = 1*a", this.cp, this.dp);
        if (this.ap.isUnit()) {
            this.cp = this.ap.inverse();
            this.dp = this.cp.multiply(this.ap);
            QuotientTest.assertTrue((String)"a*1/a = 1", (boolean)this.dp.isONE());
        }
        this.cp = this.bp.multiply(this.ap);
        Quotient<GenPolynomial<BigInteger>>[] quotientArray = this.cp.quotientRemainder(this.ap);
        QuotientTest.assertEquals((String)"b*a / a == b", quotientArray[0], this.bp);
        QuotientTest.assertTrue((String)"b*a rem a == 0", (boolean)quotientArray[1].isZERO());
    }
}

