/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.root.AlgFromRealCoeff;
import edu.jas.root.CoeffToComplex;
import edu.jas.root.CoeffToComplexFromComplex;
import edu.jas.root.CoeffToReAlg;
import edu.jas.root.CoeffToReal;
import edu.jas.root.CoeffToRecReAlg;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.PolyToReAlg;
import edu.jas.root.RealAlgebraicNumber;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.RealFromAlgCoeff;
import edu.jas.structure.GcdRingElem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolyUtilRoot {
    private static final Logger logger = LogManager.getLogger(PolyUtilRoot.class);
    private static final boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        if (debug) {
            logger.info("afac = {}", (Object)realAlgebraicRing);
        }
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToReAlg(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToRecAlgebraicCoefficients(int n, GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToRecReAlg(n, realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertRecursiveToAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new PolyToReAlg(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<AlgebraicNumber<C>> algebraicFromRealCoefficients(GenPolynomialRing<AlgebraicNumber<C>> genPolynomialRing, GenPolynomial<RealAlgebraicNumber<C>> genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new AlgFromRealCoeff(algebraicNumberRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> realFromAlgebraicCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<AlgebraicNumber<C>> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RealFromAlgCoeff(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<RealAlgebraicNumber<C>> convertToRealCoefficients(GenPolynomialRing<RealAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToReal(realAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<ComplexAlgebraicNumber<C>> convertToComplexCoefficients(GenPolynomialRing<ComplexAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<C> genPolynomial) {
        ComplexAlgebraicRing complexAlgebraicRing = (ComplexAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToComplex(complexAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<ComplexAlgebraicNumber<C>> convertToComplexCoefficientsFromComplex(GenPolynomialRing<ComplexAlgebraicNumber<C>> genPolynomialRing, GenPolynomial<Complex<C>> genPolynomial) {
        ComplexAlgebraicRing complexAlgebraicRing = (ComplexAlgebraicRing)genPolynomialRing.coFac;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToComplexFromComplex(complexAlgebraicRing));
    }

    public static <C extends GcdRingElem<C> & Rational> GenPolynomial<Complex<C>> complexFromAny(GenPolynomial<C> genPolynomial) {
        if (genPolynomial.ring.coFac instanceof ComplexRing) {
            throw new IllegalArgumentException("f already has ComplexRing coefficients " + genPolynomial.ring);
        }
        if (genPolynomial.ring.coFac instanceof ComplexAlgebraicRing) {
            throw new UnsupportedOperationException("unsupported ComplexAlgebraicRing coefficients " + genPolynomial.ring);
        }
        ComplexRing complexRing = new ComplexRing(genPolynomial.ring.coFac);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complexRing, genPolynomial.ring);
        GenPolynomial genPolynomial2 = PolyUtil.complexFromAny(genPolynomialRing, genPolynomial);
        return genPolynomial2;
    }
}

