/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.JASConfig;
import edu.jas.kern.TimeStatus;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrderByName;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Factorization;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FactorAbstract<C extends GcdRingElem<C>>
implements Factorization<C> {
    private static final Logger logger = LogManager.getLogger(FactorAbstract.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final SquarefreeAbstract<C> sengine;

    protected FactorAbstract() {
        throw new IllegalArgumentException("don't use this constructor");
    }

    public FactorAbstract(RingFactory<C> ringFactory) {
        this.engine = GCDFactory.getProxy(ringFactory);
        this.sengine = SquarefreeFactory.getImplementation(ringFactory);
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean isIrreducible(GenPolynomial<C> genPolynomial) {
        if (!this.isSquarefree(genPolynomial)) {
            return false;
        }
        List<GenPolynomial<C>> list = this.factorsSquarefree(genPolynomial);
        if (list.size() == 1) {
            return true;
        }
        if (list.size() > 2) {
            return false;
        }
        boolean bl = false;
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (!genPolynomial2.isConstant()) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isReducible(GenPolynomial<C> genPolynomial) {
        return !this.isIrreducible(genPolynomial);
    }

    @Override
    public boolean isSquarefree(GenPolynomial<C> genPolynomial) {
        return this.sengine.isSquarefree(genPolynomial);
    }

    public List<GenPolynomial<C>> factorsSquarefreeOptimize(GenPolynomial<C> genPolynomial) {
        Iterable iterable;
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseFactorsSquarefree(genPolynomial);
        }
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(genPolynomial);
        OptimizedPolynomialList optimizedPolynomialList = TermOrderOptimization.optimizeTermOrder(genPolynomialRing, arrayList);
        genPolynomial = (GenPolynomial)optimizedPolynomialList.list.get(0);
        logger.info("optimized polynomial: {}", (Object)genPolynomial);
        List<Integer> list = TermOrderOptimization.inversePermutation(optimizedPolynomialList.perm);
        logger.info("optimize perm: {}, de-optimize perm: {}", optimizedPolynomialList.perm, list);
        ExpVector expVector = genPolynomial.degreeVector();
        int[] nArray = expVector.dependencyOnVariables();
        List<GenPolynomial<C>> list2 = null;
        if (expVector.length() == nArray.length) {
            logger.info("do.full factorsSquarefreeKronecker: {}", (Object)genPolynomial);
            list2 = this.factorsSquarefreeKronecker(genPolynomial);
        } else {
            iterable = PolyUtil.removeUnusedUpperVariables(genPolynomial);
            logger.info("do.sparse factorsSquarefreeKronecker: {}", iterable);
            list2 = this.factorsSquarefreeKronecker((GenPolynomial<C>)iterable);
            ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(list2.size());
            GenPolynomialRing genPolynomialRing2 = genPolynomial.ring;
            for (GenPolynomial genPolynomial2 : list2) {
                GenPolynomial<C> genPolynomial3 = genPolynomial2.extend(genPolynomialRing2, 0, 0L);
                arrayList2.add(genPolynomial3);
            }
            list2 = arrayList2;
        }
        iterable = TermOrderOptimization.permutation(list, genPolynomialRing, list2);
        logger.info("de-optimized polynomials: {}", iterable);
        list2 = this.normalizeFactorization((List<GenPolynomial<C>>)iterable);
        return list2;
    }

    @Override
    public List<GenPolynomial<C>> factorsSquarefree(GenPolynomial<C> genPolynomial) {
        if (genPolynomial != null && genPolynomial.ring.nvar > 1) {
            logger.warn("no multivariate factorization for {}: falling back to Kronecker algorithm in {}", genPolynomial, (Object)genPolynomial.ring.toScript());
        }
        return this.factorsSquarefreeKronecker(genPolynomial);
    }

    public List<GenPolynomial<C>> factorsSquarefreeKronecker(GenPolynomial<C> genPolynomial) {
        long l;
        GenPolynomial<C> genPolynomial2;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar == 1) {
            return this.baseFactorsSquarefree(genPolynomial);
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.degreeVector().totalDeg() <= 1L) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        long l2 = genPolynomial.degree() + 1L;
        GenPolynomial<C> genPolynomial3 = PolyUfdUtil.substituteKronecker(genPolynomial, l2);
        GenPolynomialRing genPolynomialRing2 = genPolynomial3.ring;
        genPolynomialRing2.setVars(genPolynomialRing2.newVars("zz"));
        logger.info("deg(subs(P,d={})) = {}, original degrees: {}", (Object)l2, (Object)genPolynomial3.degree(0), (Object)genPolynomial.degreeVector());
        if (debug) {
            logger.info("subs(P,d={}) = {}", (Object)l2, genPolynomial3);
        }
        if (genPolynomial3.degree(0) > 100L) {
            logger.warn("Kronecker substitution has too high degree {}", (Object)genPolynomial3.degree(0));
            TimeStatus.checkTime("degree > 100");
        }
        if (JASConfig.MAX_DEGREE_KRONECKER_FACTORIZATION > 0 && (long)JASConfig.MAX_DEGREE_KRONECKER_FACTORIZATION < genPolynomial3.degree(0)) {
            throw new ArithmeticException("Kronecker substitution maximum degree (see JASConfig) exceeded: " + genPolynomial3.degree(0));
        }
        List list = new ArrayList<GenPolynomial<C>>();
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.baseFactors(genPolynomial3);
        if (debug && !this.isFactorization(genPolynomial3, sortedMap)) {
            logger.warn("kr    = {}", genPolynomial3);
            logger.warn("slist = {}", sortedMap);
            throw new ArithmeticException("no factorization");
        }
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            genPolynomial2 = entry.getKey();
            l = entry.getValue();
            int n = 0;
            while ((long)n < l) {
                list.add(genPolynomial2);
                ++n;
            }
        }
        if (list.size() == 1 && ((GenPolynomial)list.get(0)).degree() == genPolynomial.degree()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        logger.info("ulist = {}", list);
        int n = list.size() - 1;
        int n2 = 0;
        genPolynomial2 = genPolynomial;
        l = (genPolynomial2.degree() + 1L) / 2L;
        ExpVector expVector = genPolynomial2.leadingExpVector();
        ExpVector expVector2 = genPolynomial2.trailingExpVector();
        block2: for (int i = 1; i <= n; ++i) {
            KsubSet ksubSet = new KsubSet(list, i);
            for (List list2 : ksubSet) {
                GenPolynomial<C> genPolynomial4;
                GenPolynomial<GenPolynomial> genPolynomial5 = genPolynomialRing2.getONE();
                for (int j = 0; j < list2.size(); ++j) {
                    genPolynomial5 = genPolynomial5.multiply((GenPolynomial)list2.get(j));
                }
                GenPolynomial genPolynomial6 = PolyUfdUtil.backSubstituteKronecker(genPolynomialRing, genPolynomial5, l2);
                if (++n2 % 2000 == 0) {
                    logger.warn("ti({})", (Object)n2);
                    TimeStatus.checkTime(n2 + " % 2000 == 0");
                }
                if (JASConfig.MAX_ITERATIONS_KRONECKER_FACTORIZATION > 0 && JASConfig.MAX_ITERATIONS_KRONECKER_FACTORIZATION < n2) {
                    throw new ArithmeticException("Kronecker substitution iteration limit (see JASConfig) exceeeded: " + n2);
                }
                if (!expVector.multipleOf(genPolynomial6.leadingExpVector()) || !expVector2.multipleOf(genPolynomial6.trailingExpVector()) || genPolynomial6.degree() > l || genPolynomial6.isConstant()) continue;
                genPolynomial6 = genPolynomial6.monic();
                if (n2 % 15000 == 0) {
                    logger.warn("ndl   = {}, deg(u) = {}", (Object)n, (Object)l);
                    logger.warn("ulist = {}", list);
                    logger.warn("kr    = {}", genPolynomial3);
                    logger.warn("u     = {}", genPolynomial2);
                    logger.warn("trial = {}", genPolynomial6);
                }
                if (!(genPolynomial4 = PolyUtil.baseSparsePseudoRemainder(genPolynomial2, genPolynomial6)).isZERO()) continue;
                logger.info("trial = {}", genPolynomial6);
                arrayList.add(genPolynomial6);
                genPolynomial2 = PolyUtil.basePseudoDivide(genPolynomial2, genPolynomial6);
                expVector = genPolynomial2.leadingExpVector();
                expVector2 = genPolynomial2.trailingExpVector();
                if (genPolynomial2.isConstant()) {
                    i = n + 1;
                    continue block2;
                }
                list = FactorAbstract.removeOnce(list, list2);
                n = (list.size() + 1) / 2;
                i = 0;
                continue block2;
            }
        }
        if (!genPolynomial2.isONE() && !genPolynomial2.equals(genPolynomial)) {
            logger.info("rest u = {}", genPolynomial2);
            arrayList.add(genPolynomial2);
        }
        if (arrayList.size() == 0) {
            logger.info("irred P = {}", genPolynomial);
            arrayList.add(genPolynomial);
        }
        return this.normalizeFactorization(arrayList);
    }

    static <T> List<T> removeOnce(List<T> list, List<T> list2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(list);
        for (T t : list2) {
            boolean bl = arrayList.remove(t);
        }
        return arrayList;
    }

    public List<GenPolynomial<C>> baseFactorsRadical(GenPolynomial<C> genPolynomial) {
        return new ArrayList<GenPolynomial<C>>(this.baseFactors(genPolynomial).keySet());
    }

    public SortedMap<GenPolynomial<C>, Long> baseFactors(GenPolynomial<C> genPolynomial) {
        TreeMap treeMap;
        GcdRingElem gcdRingElem;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        TreeMap<GenPolynomial<C>, Long> treeMap2 = new TreeMap<GenPolynomial<C>, Long>(genPolynomialRing.getComparator());
        if (genPolynomial.isZERO()) {
            return treeMap2;
        }
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (genPolynomial.isConstant()) {
            treeMap2.put(genPolynomial, 1L);
            return treeMap2;
        }
        if (genPolynomialRing.coFac.isField()) {
            gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
        } else {
            gcdRingElem = this.engine.baseContent(genPolynomial);
            if (genPolynomial.signum() < 0 && gcdRingElem.signum() > 0) {
                gcdRingElem = (GcdRingElem)gcdRingElem.negate();
            }
        }
        if (!gcdRingElem.isONE()) {
            treeMap = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem);
            treeMap2.put((GenPolynomial<C>)((Object)treeMap), 1L);
            genPolynomial = genPolynomial.divide(gcdRingElem);
        }
        logger.info("base facs for P = {}", genPolynomial);
        treeMap = this.sengine.baseSquarefreeFactors(genPolynomial);
        if (treeMap == null || treeMap.size() == 0) {
            treeMap = new TreeMap();
            treeMap.put(genPolynomial, 1L);
        }
        if (logger.isInfoEnabled() && (treeMap.size() > 1 || treeMap.size() == 1 && (Long)treeMap.get(treeMap.firstKey()) > 1L)) {
            logger.info("squarefree facs   = {}", treeMap);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            GenPolynomial genPolynomial2 = (GenPolynomial)entry.getKey();
            Long l = (Long)entry.getValue();
            if (genPolynomialRing.coFac.isField() && !((GcdRingElem)genPolynomial2.leadingBaseCoefficient()).isONE()) {
                genPolynomial2 = genPolynomial2.monic();
                logger.warn("squarefree facs mon = {}", genPolynomial2);
            }
            if (genPolynomial2.degree(0) <= 1L) {
                if (genPolynomial2.isONE()) continue;
                treeMap2.put(genPolynomial2, l);
                continue;
            }
            List list = this.baseFactorsSquarefree(genPolynomial2);
            if (debug) {
                logger.info("factors of squarefree = {}", list);
            }
            for (GenPolynomial genPolynomial3 : list) {
                Long l2 = (Long)treeMap2.get(genPolynomial3);
                if (l2 != null) {
                    l = l + l2;
                }
                if (genPolynomial3.isONE()) continue;
                treeMap2.put(genPolynomial3, l);
            }
        }
        return treeMap2;
    }

    public abstract List<GenPolynomial<C>> baseFactorsSquarefree(GenPolynomial<C> var1);

    @Override
    public List<GenPolynomial<C>> factorsRadical(GenPolynomial<C> genPolynomial) {
        return new ArrayList<GenPolynomial<C>>(this.factors(genPolynomial).keySet());
    }

    @Override
    public List<GenPolynomial<C>> factorsRadical(List<GenPolynomial<C>> list) {
        TreeSet<GenPolynomial<C>> treeSet = new TreeSet<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list) {
            List<GenPolynomial<C>> list2 = this.factorsRadical(genPolynomial);
            treeSet.addAll(list2);
        }
        return new ArrayList<GenPolynomial<C>>(treeSet);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> factors(GenPolynomial<C> genPolynomial) {
        Iterable<Monomial<Object>> iterable;
        Long l;
        GenPolynomial<Object> genPolynomial2;
        SortedMap<GenPolynomial<Object>, Long> sortedMap;
        GenPolynomial<Object>[] genPolynomialArray;
        Object gcdRingElem;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar == 1) {
            return this.baseFactors(genPolynomial);
        }
        TreeMap<GenPolynomial<C>, Long> treeMap = new TreeMap<GenPolynomial<C>, Long>(genPolynomialRing.getComparator());
        if (genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isConstant()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        if (!genPolynomialRing.tord.equals(TermOrderByName.INVLEX)) {
            logger.warn("wrong term order {}, factorization may not be correct, better use {}", (Object)genPolynomialRing.tord, (Object)TermOrderByName.INVLEX);
        }
        if (genPolynomialRing.coFac.isField()) {
            gcdRingElem = (GcdRingElem)genPolynomial.leadingBaseCoefficient();
        } else {
            gcdRingElem = this.engine.baseContent(genPolynomial);
            if (genPolynomial.signum() < 0 && gcdRingElem.signum() > 0) {
                gcdRingElem = (GcdRingElem)gcdRingElem.negate();
            }
        }
        if (!gcdRingElem.isONE()) {
            genPolynomialArray = ((GenPolynomial)genPolynomialRing.getONE()).multiply(gcdRingElem);
            treeMap.put((GenPolynomial<C>)genPolynomialArray, 1L);
            genPolynomial = genPolynomial.divide(gcdRingElem);
        }
        logger.info("base primitive part P = {}", genPolynomial);
        genPolynomialArray = this.engine.contentPrimitivePart(genPolynomial);
        GenPolynomial<Object> genPolynomial3 = genPolynomialArray[0];
        if (!genPolynomial3.isONE()) {
            sortedMap = this.factors(genPolynomial3);
            for (Map.Entry<GenPolynomial<Object>, Long> entry : sortedMap.entrySet()) {
                genPolynomial2 = entry.getKey();
                l = entry.getValue();
                iterable = genPolynomial2.extend(genPolynomialRing, 0, 0L);
                treeMap.put((GenPolynomial<C>)iterable, l);
            }
            logger.info("content factors = {}", treeMap);
        }
        genPolynomial = genPolynomialArray[1];
        logger.info("primitive part P = {}", genPolynomial);
        if (genPolynomial.isONE()) {
            return treeMap;
        }
        sortedMap = this.sengine.squarefreeFactors(genPolynomial);
        if (sortedMap == null || sortedMap.size() == 0) {
            sortedMap = new TreeMap<GenPolynomial<Object>, Long>();
            sortedMap.put(genPolynomial, 1L);
            throw new RuntimeException("this should not happen, facs is empty: " + sortedMap);
        }
        if (logger.isInfoEnabled()) {
            if (sortedMap.size() > 1) {
                logger.info("squarefree mfacs      = {}", sortedMap);
            } else if (sortedMap.size() == 1 && (Long)sortedMap.get(sortedMap.firstKey()) > 1L) {
                logger.info("squarefree #mfacs 1-n = {}", sortedMap);
            } else {
                logger.info("squarefree #mfacs 1-1 = {}", sortedMap);
            }
        }
        for (Map.Entry<GenPolynomial<Object>, Long> entry : sortedMap.entrySet()) {
            genPolynomial2 = entry.getKey();
            if (genPolynomial2.isONE()) continue;
            l = entry.getValue();
            iterable = this.factorsSquarefree(genPolynomial2);
            logger.info("factors of squarefree ^{} = {}", (Object)l, iterable);
            for (GenPolynomial genPolynomial4 : iterable) {
                long l2 = l;
                Long l3 = (Long)treeMap.get(genPolynomial4);
                if (l3 != null) {
                    l2 += l3.longValue();
                }
                treeMap.put(genPolynomial4, l2);
            }
        }
        return treeMap;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> genPolynomial) {
        return this.sengine.squarefreePart(genPolynomial);
    }

    public GenPolynomial<C> primitivePart(GenPolynomial<C> genPolynomial) {
        return this.engine.primitivePart(genPolynomial);
    }

    public GenPolynomial<C> basePrimitivePart(GenPolynomial<C> genPolynomial) {
        return this.engine.basePrimitivePart(genPolynomial);
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> genPolynomial) {
        return this.sengine.squarefreeFactors(genPolynomial);
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        return this.sengine.isFactorization(genPolynomial, list);
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> genPolynomial, SortedMap<GenPolynomial<C>, Long> sortedMap) {
        return this.sengine.isFactorization(genPolynomial, sortedMap);
    }

    public long factorsDegree(SortedMap<GenPolynomial<C>, Long> sortedMap) {
        long l = 0L;
        for (Map.Entry<GenPolynomial<C>, Long> entry : sortedMap.entrySet()) {
            GenPolynomial<C> genPolynomial = entry.getKey();
            long l2 = entry.getValue();
            l += genPolynomial.degree() * l2;
        }
        return l;
    }

    public boolean isRecursiveFactorization(GenPolynomial<GenPolynomial<C>> genPolynomial, SortedMap<GenPolynomial<GenPolynomial<C>>, Long> sortedMap) {
        return this.sengine.isRecursiveFactorization(genPolynomial, sortedMap);
    }

    public List<GenPolynomial<GenPolynomial<C>>> recursiveFactorsSquarefree(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        Iterable<GenPolynomial<GenPolynomial<GcdRingElem>>> iterable;
        GenPolynomialRing genPolynomialRing;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        if (genPolynomial.isONE()) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.getVars());
        GenPolynomial genPolynomial2 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            genPolynomial2 = genPolynomial2.monic();
        }
        List list = this.factorsSquarefree(genPolynomial2);
        logger.info("ifacts = {}", list);
        if (list.size() <= 1) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            iterable = list.get(0);
            list.remove(iterable);
            iterable = ((GenPolynomial)iterable).multiply((GcdRingElem)gcdRingElem);
            list.add(0, iterable);
        }
        iterable = PolyUtil.recursive(genPolynomialRing, list);
        if (logger.isDebugEnabled()) {
            logger.info("recfacts = {}", iterable);
        }
        arrayList.addAll((Collection<GenPolynomial<GenPolynomial<C>>>)iterable);
        return arrayList;
    }

    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveFactors(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> treeMap = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>(genPolynomialRing.getComparator());
        if (genPolynomial.isZERO()) {
            return treeMap;
        }
        if (genPolynomial.isONE()) {
            treeMap.put(genPolynomial, 1L);
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.getVars());
        GenPolynomial genPolynomial2 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomial2.leadingBaseCoefficient();
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            genPolynomial2 = genPolynomial2.monic();
        }
        SortedMap sortedMap = this.factors(genPolynomial2);
        logger.info("dfacts = {}", sortedMap);
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            GenPolynomial<GcdRingElem> genPolynomial3 = sortedMap.firstKey();
            Long object = (Long)sortedMap.remove(genPolynomial3);
            genPolynomial3 = genPolynomial3.multiply(gcdRingElem);
            sortedMap.put(genPolynomial3, object);
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getKey();
            Long l = (Long)entry.getValue();
            GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing, genPolynomial3);
            treeMap.put(genPolynomial4, l);
        }
        logger.info("recursive factors = {}", treeMap);
        return treeMap;
    }

    public List<GenPolynomial<C>> normalizeFactorization(List<GenPolynomial<C>> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem2 = list.get(i);
            if (abelianGroupElem2.signum() < 0) {
                abelianGroupElem2 = abelianGroupElem2.negate();
                abelianGroupElem = abelianGroupElem.negate();
            }
            if (abelianGroupElem2.isONE()) continue;
            arrayList.add((GenPolynomial<C>)abelianGroupElem2);
        }
        if (!abelianGroupElem.isONE()) {
            arrayList.add(0, (GenPolynomial<C>)abelianGroupElem);
        }
        return arrayList;
    }
}

