/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbsolute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactorModular<MOD extends GcdRingElem<MOD> & Modular>
extends FactorAbsolute<MOD> {
    private static final Logger logger = LogManager.getLogger(FactorModular.class);
    private static final boolean debug = logger.isDebugEnabled();

    private FactorModular() {
        this(new ModLongRing(13L, true));
    }

    public FactorModular(RingFactory<MOD> ringFactory) {
        super(ringFactory);
    }

    public SortedMap<Long, GenPolynomial<MOD>> baseDistinctDegreeFactors(GenPolynomial<MOD> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        TreeMap<Long, GenPolynomial<MOD>> treeMap = new TreeMap<Long, GenPolynomial<MOD>>();
        if (genPolynomial.isZERO()) {
            return treeMap;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        ModularRingFactory modularRingFactory = (ModularRingFactory)genPolynomialRing.coFac;
        java.math.BigInteger bigInteger = modularRingFactory.getIntegerModul().getVal();
        GenPolynomial genPolynomial2 = genPolynomialRing.univariate(0);
        GenPolynomial<Object> genPolynomial3 = genPolynomial2;
        GenPolynomial<Object> genPolynomial4 = genPolynomial;
        Power<GenPolynomial<MOD>> power = new Power<GenPolynomial<MOD>>(genPolynomialRing);
        long l = 0L;
        while (l + 1L <= genPolynomial4.degree(0) / 2L) {
            ++l;
            GenPolynomial genPolynomial5 = this.engine.gcd((genPolynomial3 = power.modPower(genPolynomial3, bigInteger, genPolynomial4)).subtract((Object)genPolynomial2), genPolynomial4);
            if (genPolynomial5.isONE()) continue;
            treeMap.put(l, genPolynomial5);
            genPolynomial4 = genPolynomial4.divide(genPolynomial5);
        }
        if (!genPolynomial4.isONE()) {
            l = genPolynomial4.degree(0);
            treeMap.put(l, genPolynomial4);
        }
        return treeMap;
    }

    public List<GenPolynomial<MOD>> baseEqualDegreeFactors(GenPolynomial<MOD> genPolynomial, long l) {
        GenPolynomial<Object> genPolynomial2;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        ArrayList<GenPolynomial<MOD>> arrayList = new ArrayList<GenPolynomial<MOD>>();
        if (genPolynomial.isZERO()) {
            return arrayList;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (genPolynomial.degree(0) == l) {
            arrayList.add(genPolynomial);
            return arrayList;
        }
        ModularRingFactory modularRingFactory = (ModularRingFactory)genPolynomialRing.coFac;
        java.math.BigInteger bigInteger = modularRingFactory.getIntegerModul().getVal();
        boolean bl = false;
        if (bigInteger.equals(java.math.BigInteger.valueOf(2L))) {
            bl = true;
        }
        MonoidElem monoidElem = genPolynomialRing.getONE();
        GenPolynomial genPolynomial3 = genPolynomialRing.univariate(0, 1L);
        GenPolynomial<Object> genPolynomial4 = genPolynomial;
        Power<GenPolynomial<MOD>> power = new Power<GenPolynomial<MOD>>(genPolynomialRing);
        GenPolynomial<Object> genPolynomial5 = null;
        int n = (int)l;
        BigInteger bigInteger2 = (BigInteger)new BigInteger(bigInteger).power(l);
        java.math.BigInteger bigInteger3 = bigInteger2.getVal();
        bigInteger3 = bigInteger3.shiftRight(1);
        do {
            if (bl) {
                genPolynomial2 = genPolynomial3;
                for (int i = 1; i < n; ++i) {
                    genPolynomial2 = genPolynomial3.sum(genPolynomial2.multiply((Object)genPolynomial2));
                    genPolynomial2 = genPolynomial2.remainder(genPolynomial4);
                }
                genPolynomial3 = genPolynomial3.multiply(genPolynomialRing.univariate(0, 2L));
                continue;
            }
            GenPolynomial<MOD> genPolynomial6 = genPolynomialRing.random(17, n, 2 * n, 1.0f);
            if (genPolynomial6.degree(0) >= genPolynomial4.degree(0)) {
                genPolynomial6 = genPolynomial6.remainder(genPolynomial4);
            }
            genPolynomial6 = genPolynomial6.monic();
            genPolynomial2 = power.modPower(genPolynomial6, bigInteger3, genPolynomial4).subtract(monoidElem);
            ++n;
        } while ((genPolynomial5 = this.engine.gcd(genPolynomial2, genPolynomial4)).degree(0) == 0L || genPolynomial5.degree(0) == genPolynomial4.degree(0));
        genPolynomial4 = genPolynomial4.divide(genPolynomial5);
        arrayList.addAll(this.baseEqualDegreeFactors(genPolynomial4, l));
        arrayList.addAll(this.baseEqualDegreeFactors(genPolynomial5, l));
        return arrayList;
    }

    @Override
    public List<GenPolynomial<MOD>> baseFactorsSquarefree(GenPolynomial<MOD> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        List<GenPolynomial<MOD>> list = new ArrayList();
        if (genPolynomial.isZERO()) {
            return list;
        }
        if (genPolynomial.isONE()) {
            list.add(genPolynomial);
            return list;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (!((GcdRingElem)genPolynomial.leadingBaseCoefficient()).isONE()) {
            throw new IllegalArgumentException("ldcf(P) != 1: " + genPolynomial);
        }
        SortedMap<Long, GenPolynomial<MOD>> sortedMap = this.baseDistinctDegreeFactors(genPolynomial);
        if (debug) {
            logger.info("dfacs    = {}", sortedMap);
        }
        for (Map.Entry<Long, GenPolynomial<MOD>> entry : sortedMap.entrySet()) {
            Long l = entry.getKey();
            GenPolynomial<MOD> genPolynomial2 = entry.getValue();
            List<GenPolynomial<MOD>> list2 = this.baseEqualDegreeFactors(genPolynomial2, l);
            if (debug) {
                logger.info("efacs {} = {}", (Object)l, list2);
            }
            list.addAll(list2);
        }
        list = PolyUtil.monic(list);
        TreeSet treeSet = new TreeSet(list);
        list.clear();
        list.addAll(treeSet);
        return list;
    }
}

