/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorModEval;
import edu.jas.ufd.GreatestCommonDivisorModular;
import edu.jas.ufd.GreatestCommonDivisorPrimitive;
import edu.jas.ufd.GreatestCommonDivisorSimple;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDFactoryTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigInteger> dfac;
    GenPolynomialRing<BigInteger> cfac;
    GenPolynomialRing<GenPolynomial<BigInteger>> rfac;
    GenPolynomial<BigInteger> a;
    GenPolynomial<BigInteger> b;
    GenPolynomial<BigInteger> c;
    GenPolynomial<BigInteger> d;
    GenPolynomial<BigInteger> e;
    int rl = 5;
    int kl = 4;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDFactoryTest.suite());
    }

    public GCDFactoryTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDFactoryTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.dfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl, this.to);
        this.cfac = new GenPolynomialRing<BigInteger>(new BigInteger(1L), this.rl - 1, this.to);
        this.rfac = new GenPolynomialRing<BigInteger>(this.cfac, 1, this.to);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testBigInteger() {
        BigInteger bigInteger = new BigInteger();
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigInteger);
        GCDFactoryTest.assertTrue((String)("ufd = Modular " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorModular));
    }

    public void testModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GreatestCommonDivisorAbstract<ModInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(modIntegerRing);
        GCDFactoryTest.assertTrue((String)("ufd != ModEval " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorModEval));
        modIntegerRing = new ModIntegerRing(30L);
        greatestCommonDivisorAbstract = GCDFactory.getImplementation(modIntegerRing);
        GCDFactoryTest.assertTrue((String)("ufd != Subres " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSubres));
    }

    public void testBigRational() {
        BigRational bigRational = new BigRational();
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigRational);
        GCDFactoryTest.assertTrue((String)("ufd = Primitive " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorPrimitive));
    }

    public void testBigComplex() {
        BigComplex bigComplex = new BigComplex();
        GreatestCommonDivisorAbstract<BigComplex> greatestCommonDivisorAbstract = GCDFactory.getImplementation(bigComplex);
        GCDFactoryTest.assertTrue((String)("ufd != Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
    }

    public void testAlgebraicNumberBigRational() {
        BigRational bigRational = new BigRational();
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO() || genPolynomial.isONE() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial);
        GreatestCommonDivisorAbstract<BigRational> greatestCommonDivisorAbstract = GCDFactory.getImplementation(algebraicNumberRing);
        GCDFactoryTest.assertTrue((String)("ufd = Subres " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSubres));
        genPolynomial = genPolynomialRing.univariate(0).subtract((BigRational)genPolynomialRing.getONE());
        algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        greatestCommonDivisorAbstract = GCDFactory.getImplementation(algebraicNumberRing);
        GCDFactoryTest.assertTrue((String)("ufd = Simple " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSimple));
    }

    public void testAlgebraicNumberModInteger() {
        ModIntegerRing modIntegerRing = new ModIntegerRing(19L, true);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        while (genPolynomial.isZERO() || genPolynomial.isONE() || genPolynomial.isConstant()) {
            genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        }
        AlgebraicNumberRing<ModInteger> algebraicNumberRing = new AlgebraicNumberRing<ModInteger>(genPolynomial);
        MonoidElem monoidElem = algebraicNumberRing.getONE();
        GCDFactoryTest.assertTrue((String)("a == 1 " + (AlgebraicNumber)monoidElem), (boolean)((AlgebraicNumber)monoidElem).isONE());
        GreatestCommonDivisorAbstract<ModInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(algebraicNumberRing);
        GCDFactoryTest.assertTrue((String)("ufd = Subres " + greatestCommonDivisorAbstract), (boolean)(greatestCommonDivisorAbstract instanceof GreatestCommonDivisorSubres));
    }
}

