/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GCDSubresRatTest
extends TestCase {
    GreatestCommonDivisorSubres<BigRational> ufd;
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<BigRational> dfac;
    GenPolynomialRing<BigRational> cfac;
    GenPolynomialRing<GenPolynomial<BigRational>> rfac;
    BigRational mi;
    BigRational ai;
    BigRational bi;
    BigRational ci;
    BigRational di;
    BigRational ei;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    GenPolynomial<GenPolynomial<BigRational>> ar;
    GenPolynomial<GenPolynomial<BigRational>> br;
    GenPolynomial<GenPolynomial<BigRational>> cr;
    GenPolynomial<GenPolynomial<BigRational>> dr;
    GenPolynomial<GenPolynomial<BigRational>> er;
    int rl = 3;
    int kl = 2;
    int ll = 3;
    int el = 3;
    float q = 0.25f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GCDSubresRatTest.suite());
    }

    public GCDSubresRatTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GCDSubresRatTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = new BigRational(1L);
        this.ufd = new GreatestCommonDivisorSubres();
        String[] stringArray = ExpVector.STDVARS(this.rl);
        String[] stringArray2 = ExpVector.STDVARS(this.rl - 1);
        String[] stringArray3 = new String[]{stringArray[this.rl - 1]};
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, this.rl, this.to, stringArray);
        this.cfac = new GenPolynomialRing<BigRational>(this.mi, this.rl - 1, this.to, stringArray2);
        this.rfac = new GenPolynomialRing<BigRational>(this.cfac, 1, this.to, stringArray3);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ei = null;
        this.di = null;
        this.ci = null;
        this.bi = null;
        this.ai = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
        this.mi = null;
        this.ufd = null;
        this.dfac = null;
        this.cfac = null;
        this.rfac = null;
    }

    public void testGcd() {
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 0 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 0 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 0 * i, this.q);
            this.c = this.c.multiply((BigRational)((Object)this.dfac.univariate(0)));
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            this.d = this.ufd.gcd(this.a, this.b);
            this.c = this.ufd.basePrimitivePart(this.c).abs();
            this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
            GCDSubresRatTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.baseSparsePseudoRemainder(this.a, this.d);
            GCDSubresRatTest.assertTrue((String)("gcd(a,b) | a" + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.baseSparsePseudoRemainder(this.b, this.d);
            GCDSubresRatTest.assertTrue((String)("gcd(a,b) | b" + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testBaseQR() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        for (int i = 0; i < 3; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            do {
                this.ci = this.mi.random(this.kl * (i + 2));
                this.ci = this.ci.sum(this.mi.getONE());
            } while (this.ci.isZERO());
            if (this.a.isZERO() || this.c.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.b = this.a.multiply((BigRational)((Object)this.c));
            this.d = PolyUtil.baseSparsePseudoRemainder(this.b, this.c);
            GCDSubresRatTest.assertTrue((String)"rem(ac,c) == 0", (boolean)this.d.isZERO());
            this.b = this.a.multiply(this.ci);
            this.d = this.b.divide(this.ci);
            GCDSubresRatTest.assertEquals((String)"a == ac/c", this.a, this.d);
            this.b = this.a.multiply((BigRational)((Object)this.c));
            this.d = PolyUtil.basePseudoDivide(this.b, this.c);
            GCDSubresRatTest.assertEquals((String)"a == ac/c", this.a, this.d);
        }
    }

    public void testBaseContentPP() {
        for (int i = 0; i < 9; ++i) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            this.c = this.c.multiply(this.mi.random(this.kl * (i + 2)));
            if (this.c.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.ci = this.ufd.baseContent(this.c);
            this.d = this.ufd.basePrimitivePart(this.c);
            this.a = this.d.multiply(this.ci);
            GCDSubresRatTest.assertEquals((String)"c == cont(c)pp(c)", this.c, this.a);
        }
    }

    public void testDiscriminant() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        for (int i = 0; i < 5; ++i) {
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q * 2.0f);
            if (this.c.isZERO()) continue;
            this.c = this.c.multiply((BigRational)((Object)this.c));
            this.d = this.ufd.baseDiscriminant(this.c);
            GCDSubresRatTest.assertTrue((String)"disc(c^2) == 0", (boolean)this.d.isZERO());
        }
    }

    public void testBaseGcd() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        for (int i = 0; i < 3; ++i) {
            this.a = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.b = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + 2 * i, this.q);
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            this.d = this.ufd.baseGcd(this.a, this.b);
            this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
            GCDSubresRatTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testRecursiveQR() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<BigRational>(this.cfac, 1, this.to);
        for (int i = 0; i < 3; ++i) {
            this.a = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + i, this.q);
            this.a = this.ufd.basePrimitivePart(this.a).abs();
            this.c = this.dfac.random(this.kl * (i + 1), this.ll + i, this.el + i, this.q);
            this.c = this.ufd.basePrimitivePart(this.a).abs();
            this.cr = PolyUtil.recursive(this.rfac, this.c);
            this.c = this.cfac.random(this.kl * (i + 1), this.ll + 2 * i, this.el + 2 * i, this.q);
            this.c = this.ufd.basePrimitivePart(this.c).abs();
            this.ar = PolyUtil.recursive(this.rfac, this.a);
            if (this.cr.isZERO() || this.c.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.br = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
            this.dr = PolyUtil.recursiveSparsePseudoRemainder(this.br, this.cr);
            this.d = PolyUtil.distribute(this.dfac, this.dr);
            GCDSubresRatTest.assertTrue((String)"rem(ac,c) == 0", (boolean)this.d.isZERO());
            this.br = this.ar.multiply(this.c);
            this.dr = PolyUtil.recursiveDivide(this.br, this.c);
            this.d = PolyUtil.distribute(this.dfac, this.dr);
            GCDSubresRatTest.assertEquals((String)"a == ac/c", this.a, this.d);
        }
    }

    public void testRecursiveContentPP() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<BigRational>(this.cfac, 1, this.to);
        for (int i = 0; i < 3; ++i) {
            this.cr = this.rfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            GCDSubresRatTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.c = this.ufd.recursiveContent(this.cr);
            this.dr = this.ufd.recursivePrimitivePart(this.cr);
            this.ar = this.dr.multiply(this.c);
            GCDSubresRatTest.assertEquals((String)"c == cont(c)pp(c)", this.cr, this.ar);
        }
    }

    public void testRecursiveGCD() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<BigRational>(this.cfac, 1, this.to);
        for (int i = 0; i < 2; ++i) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.ar = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
            this.br = this.br.multiply((GenPolynomial<BigRational>)this.cr);
            this.dr = this.ufd.recursiveUnivariateGcd(this.ar, this.br);
            this.er = PolyUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
            GCDSubresRatTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        }
    }

    public void testArbitraryRecursiveGCD() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 2, this.to);
        this.cfac = new GenPolynomialRing<BigRational>(this.mi, 1, this.to);
        this.rfac = new GenPolynomialRing<BigRational>(this.cfac, 1, this.to);
        for (int i = 0; i < 2; ++i) {
            this.ar = this.rfac.random(this.kl, this.ll, this.el + i, this.q);
            this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
            this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
            if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( cr" + i + " ) <> 0"), (this.cr.length() > 0 ? 1 : 0) != 0);
            this.ar = this.ar.multiply((GenPolynomial<BigRational>)this.cr);
            this.br = this.br.multiply((GenPolynomial<BigRational>)this.cr);
            this.dr = this.ufd.recursiveGcd(this.ar, this.br);
            this.er = PolyUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
            GCDSubresRatTest.assertTrue((String)("c | gcd(ac,bc) " + this.er), (boolean)this.er.isZERO());
        }
    }

    public void testContentPP() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 3, this.to);
        for (int i = 0; i < 3; ++i) {
            this.c = this.dfac.random(this.kl * (i + 2), this.ll + 2 * i, this.el + i, this.q);
            GCDSubresRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.ufd.content(this.c);
            this.e = this.a.extend(this.dfac, 0, 0L);
            this.b = this.ufd.primitivePart(this.c);
            this.d = this.e.multiply((BigRational)((Object)this.b));
            GCDSubresRatTest.assertEquals((String)"c == cont(c)pp(c)", this.d, this.c);
        }
    }

    public void testGCD3() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 3, this.to);
        for (int i = 0; i < 3; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el + i, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            this.d = this.ufd.gcd(this.a, this.b);
            this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
            GCDSubresRatTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testGCD() {
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( c" + i + " ) <> 0"), (this.c.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            this.d = this.ufd.gcd(this.a, this.b);
            this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
            GCDSubresRatTest.assertTrue((String)("c | gcd(ac,bc) " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.baseSparsePseudoRemainder(this.a, this.d);
            GCDSubresRatTest.assertTrue((String)("gcd(a,b) | a " + this.e), (boolean)this.e.isZERO());
            this.e = PolyUtil.baseSparsePseudoRemainder(this.b, this.d);
            GCDSubresRatTest.assertTrue((String)("gcd(a,b) | b " + this.e), (boolean)this.e.isZERO());
        }
    }

    public void testLCM() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 3, this.to);
        for (int i = 0; i < 1; ++i) {
            this.a = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.dfac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.dfac.random(this.kl, 3, 2, this.q);
            if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) continue;
            GCDSubresRatTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() > 0 ? 1 : 0) != 0);
            this.a = this.a.multiply((BigRational)((Object)this.c));
            this.b = this.b.multiply((BigRational)((Object)this.c));
            this.c = this.ufd.gcd(this.a, this.b);
            this.d = this.ufd.lcm(this.a, this.b);
            this.e = this.c.multiply((BigRational)((Object)this.d));
            this.c = this.a.multiply((BigRational)((Object)this.b));
            GCDSubresRatTest.assertEquals((String)"ab == gcd(a,b)lcm(ab)", this.c, this.e);
        }
    }

    public void testCoPrime() {
        this.dfac = new GenPolynomialRing<BigRational>(this.mi, 3, this.to);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        GCDSubresRatTest.assertTrue((String)"length( a ) <> 0", (this.a.length() > 0 ? 1 : 0) != 0);
        this.d = this.a.multiply((BigRational)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        ArrayList arrayList = new ArrayList(5);
        arrayList.add(this.d);
        arrayList.add(this.a);
        arrayList.add(this.b);
        arrayList.add(this.c);
        arrayList.add(this.e);
        List list = this.ufd.coPrime(arrayList);
        GCDSubresRatTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(list));
        GCDSubresRatTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(list, arrayList));
        list = this.ufd.coPrimeRec(arrayList);
        GCDSubresRatTest.assertTrue((String)"is co-prime ", (boolean)this.ufd.isCoPrime(list));
        GCDSubresRatTest.assertTrue((String)"is co-prime of ", (boolean)this.ufd.isCoPrime(list, arrayList));
    }
}

