/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import edu.jas.ufd.QuotientRing;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Quotient<C extends GcdRingElem<C>>
implements GcdRingElem<Quotient<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = LogManager.getLogger(Quotient.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final QuotientRing<C> ring;
    public final GenPolynomial<C> num;
    public final GenPolynomial<C> den;

    public Quotient(QuotientRing<C> quotientRing) {
        this(quotientRing, (GenPolynomial<C>)quotientRing.ring.getZERO());
    }

    public Quotient(QuotientRing<C> quotientRing, GenPolynomial<C> genPolynomial) {
        this(quotientRing, genPolynomial, (GenPolynomial<C>)quotientRing.ring.getONE(), true);
    }

    public Quotient(QuotientRing<C> quotientRing, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        this(quotientRing, genPolynomial, genPolynomial2, false);
    }

    protected Quotient(QuotientRing<C> quotientRing, GenPolynomial<C> abelianGroupElem, GenPolynomial<C> abelianGroupElem2, boolean bl) {
        if (abelianGroupElem2 == null || ((GenPolynomial)abelianGroupElem2).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = quotientRing;
        if (((GenPolynomial)abelianGroupElem2).signum() < 0) {
            abelianGroupElem = ((GenPolynomial)abelianGroupElem).negate();
            abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).negate();
        }
        if (!bl) {
            ringElem = this.ring.gcd((GenPolynomial<GenPolynomial<C>>)abelianGroupElem, (GenPolynomial<GenPolynomial<C>>)abelianGroupElem2);
            if (debug) {
                logger.debug("gcd = {}", ringElem);
            }
            if (!((GenPolynomial)ringElem).isONE()) {
                abelianGroupElem = this.ring.divide((GenPolynomial<GenPolynomial<C>>)abelianGroupElem, (GenPolynomial<GenPolynomial<C>>)ringElem);
                abelianGroupElem2 = this.ring.divide((GenPolynomial<GenPolynomial<C>>)abelianGroupElem2, (GenPolynomial<GenPolynomial<C>>)ringElem);
            }
        }
        RingElem<GenPolynomial<C>> ringElem = switch (QuotientRing.quoNorm) {
            case QuotientRing.QuoNorm.normNumLead -> (GcdRingElem)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient();
            case QuotientRing.QuoNorm.normNumTrail -> (GcdRingElem)((GenPolynomial)abelianGroupElem).trailingBaseCoefficient();
            case QuotientRing.QuoNorm.normDenTrail -> (GcdRingElem)((GenPolynomial)abelianGroupElem2).trailingBaseCoefficient();
            default -> (GcdRingElem)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient();
        };
        if (!ringElem.isONE() && ringElem.isUnit()) {
            ringElem = (GcdRingElem)ringElem.inverse();
            abelianGroupElem = ((GenPolynomial)abelianGroupElem).multiply((GenPolynomial<RingElem<GenPolynomial<C>>>)ringElem);
            abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).multiply((GenPolynomial<RingElem<GenPolynomial<C>>>)ringElem);
        }
        this.num = abelianGroupElem;
        this.den = abelianGroupElem2;
    }

    @Override
    public QuotientRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenPolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenPolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public Quotient<C> copy() {
        return new Quotient<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        return !this.num.isZERO();
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String string = "{ " + this.num.toString(this.ring.ring.getVars());
            if (!this.den.isONE()) {
                string = string + " | " + this.den.toString(this.ring.ring.getVars());
            }
            return string + " }";
        }
        return "Quotient[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        if (this.den.length() == 1 && this.den.totalDegree() > 1L) {
            return this.num.toScript() + " / (" + this.den.toScript() + " )";
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((QuotientRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Quotient<C> quotient) {
        int n;
        if (quotient == null || quotient.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -quotient.signum();
        }
        int n2 = this.num.signum();
        int n3 = (n2 - (n = quotient.num.signum())) / 2;
        if (n3 != 0) {
            return n3;
        }
        if (this.den.compareTo(quotient.den) == 0) {
            return this.num.compareTo(quotient.num);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial = this.num.multiply(quotient.den);
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.den.multiply(quotient.num);
        return genPolynomial.compareTo((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Quotient)) {
            return false;
        }
        Quotient quotient = (Quotient)object;
        return this.compareTo(quotient) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.num.hashCode();
        n = 37 * n + this.den.hashCode();
        return n;
    }

    @Override
    public Quotient<C> abs() {
        return new Quotient<C>(this.ring, this.num.abs(), this.den, true);
    }

    @Override
    public Quotient<C> sum(Quotient<C> quotient) {
        GenPolynomial<GenPolynomial<Object>> genPolynomial;
        GenPolynomial<C> genPolynomial2;
        GenPolynomial<GenPolynomial<C>> genPolynomial3;
        if (quotient == null || quotient.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return quotient;
        }
        if (this.den.isONE() && quotient.den.isONE()) {
            GenPolynomial<GenPolynomial<C>> genPolynomial4 = this.num.sum(quotient.num);
            return new Quotient<GenPolynomial<C>>(this.ring, genPolynomial4);
        }
        if (this.den.isONE()) {
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial5 = this.num.multiply(quotient.den);
            genPolynomial5 = genPolynomial5.sum((GenPolynomial<GenPolynomial<C>>)quotient.num);
            return new Quotient<GenPolynomial<C>>(this.ring, genPolynomial5, quotient.den, false);
        }
        if (quotient.den.isONE()) {
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial6 = quotient.num.multiply(this.den);
            genPolynomial6 = genPolynomial6.sum((GenPolynomial<GenPolynomial<C>>)this.num);
            return new Quotient<GenPolynomial<C>>(this.ring, genPolynomial6, this.den, false);
        }
        if (this.den.compareTo(quotient.den) == 0) {
            GenPolynomial<GenPolynomial<C>> genPolynomial7 = this.num.sum(quotient.num);
            return new Quotient<GenPolynomial<C>>(this.ring, genPolynomial7, this.den, false);
        }
        GenPolynomial<C> genPolynomial8 = this.ring.gcd(this.den, quotient.den);
        if (genPolynomial8.isONE()) {
            genPolynomial3 = this.den;
            genPolynomial2 = quotient.den;
        } else {
            genPolynomial3 = this.ring.divide(this.den, genPolynomial8);
            genPolynomial2 = this.ring.divide(quotient.den, genPolynomial8);
        }
        GenPolynomial<GenPolynomial<Object>> genPolynomial9 = this.num.multiply(genPolynomial2);
        genPolynomial9 = genPolynomial9.sum((GenPolynomial<Object>)genPolynomial3.multiply(quotient.num));
        if (genPolynomial9.isZERO()) {
            return this.ring.getZERO();
        }
        GenPolynomial<GenPolynomial<Object>> genPolynomial10 = this.den;
        if (!genPolynomial8.isONE() && !(genPolynomial = this.ring.gcd(genPolynomial9, genPolynomial8)).isONE()) {
            genPolynomial9 = this.ring.divide(genPolynomial9, genPolynomial);
            genPolynomial10 = this.ring.divide(this.den, genPolynomial);
        }
        genPolynomial3 = genPolynomial10.multiply((GenPolynomial<Object>)genPolynomial2);
        return new Quotient<GenPolynomial<Object>>(this.ring, genPolynomial9, genPolynomial3, true);
    }

    @Override
    public Quotient<C> negate() {
        return new Quotient<C>(this.ring, this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Quotient<C> subtract(Quotient<C> quotient) {
        return this.sum((Quotient<C>)quotient.negate());
    }

    @Override
    public Quotient<C> divide(Quotient<C> quotient) {
        return this.multiply((C)quotient.inverse());
    }

    @Override
    public Quotient<C> inverse() {
        if (this.num.isZERO()) {
            throw new ArithmeticException("element not invertible " + this);
        }
        return new Quotient<C>(this.ring, this.den, this.num, true);
    }

    @Override
    public Quotient<C> remainder(Quotient<C> quotient) {
        if (quotient.isZERO()) {
            throw new ArithmeticException("element not invertible " + quotient);
        }
        return this.ring.getZERO();
    }

    public Quotient<C>[] quotientRemainder(Quotient<C> quotient) {
        return new Quotient[]{this.divide(quotient), this.remainder(quotient)};
    }

    @Override
    public Quotient<C> multiply(Quotient<C> quotient) {
        if (quotient == null || quotient.isZERO()) {
            return quotient;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (quotient.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return quotient;
        }
        if (this.den.isONE() && quotient.den.isONE()) {
            GenPolynomial<GenPolynomial<C>> genPolynomial = this.num.multiply(quotient.num);
            return new Quotient<GenPolynomial<C>>(this.ring, genPolynomial, this.den, true);
        }
        if (this.den.isONE()) {
            GenPolynomial<C> genPolynomial = this.ring.gcd(this.num, quotient.den);
            GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.ring.divide(this.num, genPolynomial);
            GenPolynomial<C> genPolynomial3 = this.ring.divide(quotient.den, genPolynomial);
            genPolynomial2 = genPolynomial2.multiply(quotient.num);
            return new Quotient<C>(this.ring, genPolynomial2, genPolynomial3, true);
        }
        if (quotient.den.isONE()) {
            GenPolynomial<C> genPolynomial = this.ring.gcd(quotient.num, this.den);
            GenPolynomial<GenPolynomial<C>> genPolynomial4 = this.ring.divide(quotient.num, genPolynomial);
            GenPolynomial<C> genPolynomial5 = this.ring.divide(this.den, genPolynomial);
            genPolynomial4 = genPolynomial4.multiply(this.num);
            return new Quotient<C>(this.ring, genPolynomial4, genPolynomial5, true);
        }
        if (this.den.compareTo(quotient.den) == 0) {
            GenPolynomial<GenPolynomial<C>> genPolynomial = this.den.multiply(this.den);
            GenPolynomial<GenPolynomial<C>> genPolynomial6 = this.num.multiply(quotient.num);
            return new Quotient<GenPolynomial<C>>(this.ring, genPolynomial6, genPolynomial, true);
        }
        GenPolynomial<C> genPolynomial = this.ring.gcd(this.num, quotient.den);
        GenPolynomial<GenPolynomial<C>> genPolynomial7 = this.ring.divide(this.num, genPolynomial);
        GenPolynomial<C> genPolynomial8 = this.ring.divide(quotient.den, genPolynomial);
        GenPolynomial<C> genPolynomial9 = this.ring.gcd(this.den, quotient.num);
        GenPolynomial<GenPolynomial<C>> genPolynomial10 = this.ring.divide(this.den, genPolynomial9);
        GenPolynomial<C> genPolynomial11 = this.ring.divide(quotient.num, genPolynomial9);
        genPolynomial7 = genPolynomial7.multiply(genPolynomial11);
        genPolynomial10 = genPolynomial10.multiply(genPolynomial8);
        return new Quotient<C>(this.ring, genPolynomial7, genPolynomial10, true);
    }

    @Override
    public Quotient<C> multiply(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (genPolynomial.isONE()) {
            return this;
        }
        GenPolynomial<C> genPolynomial2 = this.ring.gcd(genPolynomial, this.den);
        GenPolynomial<C> genPolynomial3 = this.den;
        if (!genPolynomial2.isONE()) {
            genPolynomial = this.ring.divide(genPolynomial, genPolynomial2);
            genPolynomial3 = this.ring.divide(genPolynomial3, genPolynomial2);
        }
        if (this.isONE()) {
            return new Quotient<C>(this.ring, genPolynomial, genPolynomial3, true);
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = this.num.multiply(genPolynomial);
        return new Quotient<GenPolynomial<C>>(this.ring, genPolynomial4, genPolynomial3, true);
    }

    @Override
    public Quotient<C> multiply(C c) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (c.isONE()) {
            return this;
        }
        GenPolynomial<C> genPolynomial = this.num.multiply(c);
        return new Quotient<C>(this.ring, genPolynomial, this.den, true);
    }

    public Quotient<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        GcdRingElem gcdRingElem = (GcdRingElem)this.num.leadingBaseCoefficient();
        if (!gcdRingElem.isUnit()) {
            return this;
        }
        gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
        GenPolynomial<GcdRingElem> genPolynomial = this.num.multiply(gcdRingElem);
        return new Quotient<GcdRingElem>(this.ring, genPolynomial, this.den, true);
    }

    @Override
    public Quotient<C> gcd(Quotient<C> quotient) {
        if (quotient == null || quotient.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return quotient;
        }
        if (this.equals(quotient)) {
            return this;
        }
        return this.ring.getONE();
    }

    public Quotient<C>[] egcd(Quotient<C> quotient) {
        Quotient[] quotientArray = new Quotient[]{null, null, null};
        if (quotient == null || quotient.isZERO()) {
            quotientArray[0] = this;
            return quotientArray;
        }
        if (this.isZERO()) {
            quotientArray[0] = quotient;
            return quotientArray;
        }
        Element element = this.ring.ring.fromInteger(2L);
        quotientArray[0] = this.ring.getONE();
        quotientArray[1] = this.multiply(element).inverse();
        quotientArray[2] = quotient.multiply(element).inverse();
        return quotientArray;
    }
}

