/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class SocketChannel {
    private final ObjectInputStream in;
    private final ObjectOutputStream out;
    private final Socket soc;

    public SocketChannel(Socket socket) throws IOException {
        this.soc = socket;
        this.out = new ObjectOutputStream(socket.getOutputStream());
        this.out.flush();
        this.in = new ObjectInputStream(socket.getInputStream());
    }

    public Socket getSocket() {
        return this.soc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object object) throws IOException {
        ObjectOutputStream objectOutputStream = this.out;
        synchronized (objectOutputStream) {
            this.out.writeObject(object);
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receive() throws IOException, ClassNotFoundException {
        Object object = null;
        ObjectInputStream objectInputStream = this.in;
        synchronized (objectInputStream) {
            object = this.in.readObject();
        }
        return object;
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.soc != null) {
            try {
                this.soc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "socketChannel(" + this.soc + ")";
    }
}

